/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.ClassUtils;

public class SpecificDatumReader<T>
extends GenericDatumReader<T> {
    @Deprecated
    public static final String[] SERIALIZABLE_PACKAGES;
    public static final String[] SERIALIZABLE_CLASSES;
    private static final Set<String> PRIMITIVES;
    private final List<String> trustedPackages = new ArrayList<String>();
    private final List<String> trustedClasses = new ArrayList<String>();

    private static Stream<String> streamPropertyEntries(String commaSeparatedEntries) {
        if (commaSeparatedEntries == null) {
            return Stream.empty();
        }
        return Stream.of(commaSeparatedEntries.split(",")).map(String::strip).filter(s2 -> !s2.isEmpty());
    }

    public SpecificDatumReader() {
        this(null, null, SpecificData.get());
    }

    public SpecificDatumReader(Class<T> c) {
        this(SpecificData.getForClass(c));
        this.setSchema(this.getSpecificData().getSchema(c));
    }

    public SpecificDatumReader(Schema schema) {
        this(schema, schema, SpecificData.getForSchema(schema));
    }

    public SpecificDatumReader(Schema writer, Schema reader) {
        this(writer, reader, SpecificData.getForSchema(reader));
    }

    public SpecificDatumReader(Schema writer, Schema reader, SpecificData data) {
        super(writer, reader, data);
        this.trustedPackages.addAll(Arrays.asList(SERIALIZABLE_PACKAGES));
        this.trustedClasses.addAll(Arrays.asList(SERIALIZABLE_CLASSES));
    }

    public SpecificDatumReader(SpecificData data) {
        super(data);
        this.trustedPackages.addAll(Arrays.asList(SERIALIZABLE_PACKAGES));
        this.trustedClasses.addAll(Arrays.asList(SERIALIZABLE_CLASSES));
    }

    public SpecificData getSpecificData() {
        return (SpecificData)this.getData();
    }

    @Override
    public void setSchema(Schema actual) {
        SpecificData data;
        Class c;
        if (this.getExpected() == null && actual != null && actual.getType() == Schema.Type.RECORD && (c = (data = this.getSpecificData()).getClass(actual)) != null && SpecificRecord.class.isAssignableFrom(c)) {
            this.setExpected(data.getSchema(c));
        }
        super.setSchema(actual);
    }

    @Override
    protected Class findStringClass(Schema schema) {
        Class stringClass = null;
        switch (schema.getType()) {
            case STRING: {
                stringClass = this.getPropAsClass(schema, "java-class");
                break;
            }
            case MAP: {
                stringClass = this.getPropAsClass(schema, "java-key-class");
            }
        }
        if (stringClass != null) {
            return stringClass;
        }
        return super.findStringClass(schema);
    }

    private Class getPropAsClass(Schema schema, String prop) {
        String name = schema.getProp(prop);
        if (name == null) {
            return null;
        }
        try {
            this.checkSecurity(name);
            Class<?> clazz = ClassUtils.forName(this.getData().getClassLoader(), name);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new AvroRuntimeException(e);
        }
    }

    private boolean trustAllPackages() {
        return this.trustedPackages.size() == 1 && "*".equals(this.trustedPackages.get(0));
    }

    private void checkSecurity(String className) throws ClassNotFoundException {
        if (this.trustAllPackages() || PRIMITIVES.contains(className)) {
            return;
        }
        for (String trustedClass : this.getTrustedClasses()) {
            if (!className.equals(trustedClass)) continue;
            return;
        }
        for (String trustedPackage : this.getTrustedPackages()) {
            if (!className.startsWith(trustedPackage)) continue;
            return;
        }
        throw new SecurityException("Forbidden " + className + "! This class is not trusted to be included in Avro schemas using java-class. Please set the system property org.apache.avro.SERIALIZABLE_CLASSES to the comma separated list of classes you trust. You can also set the system property org.apache.avro.SERIALIZABLE_PACKAGES to the comma separated list of the packages you trust.");
    }

    @Deprecated
    public final List<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    public final List<String> getTrustedClasses() {
        return this.trustedClasses;
    }

    @Override
    protected Object readRecord(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        SpecificRecordBase d;
        SpecificData data = this.getSpecificData();
        if (data.useCustomCoders() && (old = data.newRecord(old, expected)) instanceof SpecificRecordBase && (d = (SpecificRecordBase)old).hasCustomCoders()) {
            d.customDecode(in);
            return d;
        }
        return super.readRecord(old, expected, in);
    }

    @Override
    protected void readField(Object record, Schema.Field field, Object oldDatum, ResolvingDecoder in, Object state) throws IOException {
        if (record instanceof SpecificRecordBase) {
            Conversion<?> conversion = ((SpecificRecordBase)record).getConversion(field.pos());
            Object datum = conversion != null ? this.readWithConversion(oldDatum, field.schema(), field.schema().getLogicalType(), conversion, in) : this.readWithoutConversion(oldDatum, field.schema(), in);
            this.getData().setField(record, field.name(), field.pos(), datum);
        } else {
            super.readField(record, field, oldDatum, in, state);
        }
    }

    static {
        SERIALIZABLE_CLASSES = (String[])SpecificDatumReader.streamPropertyEntries(System.getProperty("org.apache.avro.SERIALIZABLE_CLASSES")).toArray(String[]::new);
        SERIALIZABLE_PACKAGES = (String[])SpecificDatumReader.streamPropertyEntries(System.getProperty("org.apache.avro.SERIALIZABLE_PACKAGES")).map(entry -> "*".equals(entry) ? entry : entry + ".").toArray(String[]::new);
        PRIMITIVES = new HashSet<String>(Arrays.asList(Boolean.TYPE.getName(), Character.TYPE.getName(), Byte.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Void.TYPE.getName()));
    }
}

