/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class Options {

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static interface CreateFileOptionKeys {
        public static final String FS_OPTION_CREATE_CONDITIONAL_OVERWRITE = "fs.option.create.conditional.overwrite";
        public static final String FS_OPTION_CREATE_CONDITIONAL_OVERWRITE_ETAG = "fs.option.create.conditional.overwrite.etag";
        public static final String FS_OPTION_CREATE_IN_CLOSE = "fs.option.create.in.close";
        public static final String FS_OPTION_CREATE_CONTENT_TYPE = "fs.option.create.content.type";
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static final class OpenFileOptions {
        private static final String FILESYSTEM_OPTION = "fs.option.";
        public static final String FS_OPTION_OPENFILE = "fs.option.openfile.";
        public static final String FS_OPTION_OPENFILE_LENGTH = "fs.option.openfile.length";
        public static final String FS_OPTION_OPENFILE_SPLIT_START = "fs.option.openfile.split.start";
        public static final String FS_OPTION_OPENFILE_SPLIT_END = "fs.option.openfile.split.end";
        public static final String FS_OPTION_OPENFILE_BUFFER_SIZE = "fs.option.openfile.buffer.size";
        public static final String FS_OPTION_OPENFILE_FOOTER_CACHE = "fs.option.openfile.footer.cache";
        public static final String FS_OPTION_OPENFILE_READ_POLICY = "fs.option.openfile.read.policy";
        public static final Set<String> FS_OPTION_OPENFILE_STANDARD_OPTIONS = Collections.unmodifiableSet(Stream.of("fs.option.openfile.buffer.size", "fs.option.openfile.footer.cache", "fs.option.openfile.read.policy", "fs.option.openfile.length", "fs.option.openfile.split.start", "fs.option.openfile.split.end").collect(Collectors.toSet()));
        public static final String FS_OPTION_OPENFILE_READ_POLICY_ADAPTIVE = "adaptive";
        public static final String FS_OPTION_OPENFILE_READ_POLICY_AVRO = "avro";
        public static final String FS_OPTION_OPENFILE_READ_POLICY_COLUMNAR = "columnar";
        public static final String FS_OPTION_OPENFILE_READ_POLICY_CSV = "csv";
        public static final String FS_OPTION_OPENFILE_READ_POLICY_DEFAULT = "default";
        public static final String FS_OPTION_OPENFILE_READ_POLICY_HBASE = "hbase";
        public static final String FS_OPTION_OPENFILE_READ_POLICY_JSON = "json";
        public static final String FS_OPTION_OPENFILE_READ_POLICY_ORC = "orc";
        public static final String FS_OPTION_OPENFILE_READ_POLICY_PARQUET = "parquet";
        public static final String FS_OPTION_OPENFILE_READ_POLICY_RANDOM = "random";
        public static final String FS_OPTION_OPENFILE_READ_POLICY_SEQUENTIAL = "sequential";
        public static final String FS_OPTION_OPENFILE_READ_POLICY_VECTOR = "vector";
        public static final String FS_OPTION_OPENFILE_READ_POLICY_WHOLE_FILE = "whole-file";
        public static final Set<String> FS_OPTION_OPENFILE_READ_POLICIES = Collections.unmodifiableSet(Stream.of("adaptive", "avro", "columnar", "csv", "default", "json", "orc", "parquet", "random", "sequential", "vector", "whole-file").collect(Collectors.toSet()));
        public static final String FS_OPTION_OPENFILE_EC_POLICY = "fs.option.openfile.ec.policy";

        private OpenFileOptions() {
        }
    }

    public static enum ChecksumCombineMode {
        MD5MD5CRC,
        COMPOSITE_CRC;

    }

    public static class HandleOpt {
        protected HandleOpt() {
        }

        public static Function<FileStatus, PathHandle> resolve(FileSystem fs, HandleOpt ... opt) {
            return HandleOpt.resolve(fs::getPathHandle, opt);
        }

        public static Function<FileStatus, PathHandle> resolve(BiFunction<FileStatus, HandleOpt[], PathHandle> fsr, HandleOpt ... opt) {
            return stat -> (PathHandle)fsr.apply((FileStatus)stat, opt);
        }

        public static HandleOpt[] exact() {
            return new HandleOpt[]{HandleOpt.changed(false), HandleOpt.moved(false)};
        }

        public static HandleOpt[] content() {
            return new HandleOpt[]{HandleOpt.changed(false), HandleOpt.moved(true)};
        }

        public static HandleOpt[] path() {
            return new HandleOpt[]{HandleOpt.changed(true), HandleOpt.moved(false)};
        }

        public static HandleOpt[] reference() {
            return new HandleOpt[]{HandleOpt.changed(true), HandleOpt.moved(true)};
        }

        public static Data changed(boolean allow) {
            return new Data(allow);
        }

        public static Location moved(boolean allow) {
            return new Location(allow);
        }

        public static <T extends HandleOpt> Optional<T> getOpt(Class<T> c, HandleOpt ... opt) {
            if (null == opt) {
                return Optional.empty();
            }
            HandleOpt ret = null;
            for (HandleOpt o : opt) {
                HandleOpt tmp;
                if (!c.isAssignableFrom(o.getClass())) continue;
                if (ret != null) {
                    throw new IllegalArgumentException("Duplicate option " + c.getSimpleName());
                }
                ret = tmp = o;
            }
            return Optional.ofNullable(ret);
        }

        public static class Location
        extends HandleOpt {
            private final boolean allowChanged;

            Location(boolean allowChanged) {
                this.allowChanged = allowChanged;
            }

            public boolean allowChange() {
                return this.allowChanged;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("loc(allowChange=").append(this.allowChanged).append(")");
                return sb.toString();
            }
        }

        public static class Data
        extends HandleOpt {
            private final boolean allowChanged;

            Data(boolean allowChanged) {
                this.allowChanged = allowChanged;
            }

            public boolean allowChange() {
                return this.allowChanged;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("data(allowChange=").append(this.allowChanged).append(")");
                return sb.toString();
            }
        }
    }

    public static class ChecksumOpt {
        private final DataChecksum.Type checksumType;
        private final int bytesPerChecksum;

        public ChecksumOpt() {
            this(DataChecksum.Type.DEFAULT, -1);
        }

        public ChecksumOpt(DataChecksum.Type type, int size) {
            this.checksumType = type;
            this.bytesPerChecksum = size;
        }

        public int getBytesPerChecksum() {
            return this.bytesPerChecksum;
        }

        public DataChecksum.Type getChecksumType() {
            return this.checksumType;
        }

        public String toString() {
            return (Object)((Object)this.checksumType) + ":" + this.bytesPerChecksum;
        }

        public static ChecksumOpt createDisabled() {
            return new ChecksumOpt(DataChecksum.Type.NULL, -1);
        }

        public static ChecksumOpt processChecksumOpt(ChecksumOpt defaultOpt, ChecksumOpt userOpt, int userBytesPerChecksum) {
            DataChecksum.Type type;
            boolean useDefaultType;
            if (userOpt != null && userOpt.getChecksumType() != DataChecksum.Type.DEFAULT) {
                useDefaultType = false;
                type = userOpt.getChecksumType();
            } else {
                useDefaultType = true;
                type = defaultOpt.getChecksumType();
            }
            if (userBytesPerChecksum > 0) {
                return new ChecksumOpt(type, userBytesPerChecksum);
            }
            if (userOpt != null && userOpt.getBytesPerChecksum() > 0) {
                return !useDefaultType ? userOpt : new ChecksumOpt(type, userOpt.getBytesPerChecksum());
            }
            return useDefaultType ? defaultOpt : new ChecksumOpt(type, defaultOpt.getBytesPerChecksum());
        }

        public static ChecksumOpt processChecksumOpt(ChecksumOpt defaultOpt, ChecksumOpt userOpt) {
            return ChecksumOpt.processChecksumOpt(defaultOpt, userOpt, -1);
        }
    }

    public static enum Rename {
        NONE(0),
        OVERWRITE(1),
        TO_TRASH(2);

        private final byte code;

        private Rename(byte code) {
            this.code = code;
        }

        public static Rename valueOf(byte code) {
            return code < 0 || code >= Rename.values().length ? null : Rename.values()[code];
        }

        public byte value() {
            return this.code;
        }
    }

    public static class CreateOpts {
        private CreateOpts() {
        }

        public static BlockSize blockSize(long bs) {
            return new BlockSize(bs);
        }

        public static BufferSize bufferSize(int bs) {
            return new BufferSize(bs);
        }

        public static ReplicationFactor repFac(short rf) {
            return new ReplicationFactor(rf);
        }

        public static BytesPerChecksum bytesPerChecksum(short crc) {
            return new BytesPerChecksum(crc);
        }

        public static ChecksumParam checksumParam(ChecksumOpt csumOpt) {
            return new ChecksumParam(csumOpt);
        }

        public static Progress progress(Progressable prog) {
            return new Progress(prog);
        }

        public static Perms perms(FsPermission perm) {
            return new Perms(perm);
        }

        public static CreateParent createParent() {
            return new CreateParent(true);
        }

        public static CreateParent donotCreateParent() {
            return new CreateParent(false);
        }

        static <T extends CreateOpts> T getOpt(Class<T> clazz, CreateOpts ... opts) {
            if (opts == null) {
                throw new IllegalArgumentException("Null opt");
            }
            CreateOpts result = null;
            for (int i = 0; i < opts.length; ++i) {
                CreateOpts t2;
                if (opts[i].getClass() != clazz) continue;
                if (result != null) {
                    throw new IllegalArgumentException("multiple opts varargs: " + clazz);
                }
                result = t2 = opts[i];
            }
            return (T)result;
        }

        static <T extends CreateOpts> CreateOpts[] setOpt(T newValue, CreateOpts ... opts) {
            Class<?> clazz = newValue.getClass();
            boolean alreadyInOpts = false;
            if (opts != null) {
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].getClass() != clazz) continue;
                    if (alreadyInOpts) {
                        throw new IllegalArgumentException("multiple opts varargs: " + clazz);
                    }
                    alreadyInOpts = true;
                    opts[i] = newValue;
                }
            }
            CreateOpts[] resultOpt = opts;
            if (!alreadyInOpts) {
                int oldLength = opts == null ? 0 : opts.length;
                CreateOpts[] newOpts = new CreateOpts[oldLength + 1];
                if (oldLength > 0) {
                    System.arraycopy(opts, 0, newOpts, 0, oldLength);
                }
                newOpts[oldLength] = newValue;
                resultOpt = newOpts;
            }
            return resultOpt;
        }

        public static class CreateParent
        extends CreateOpts {
            private final boolean createParent;

            protected CreateParent(boolean createPar) {
                this.createParent = createPar;
            }

            public boolean getValue() {
                return this.createParent;
            }
        }

        public static class Progress
        extends CreateOpts {
            private final Progressable progress;

            protected Progress(Progressable prog) {
                if (prog == null) {
                    throw new IllegalArgumentException("Progress must not be null");
                }
                this.progress = prog;
            }

            public Progressable getValue() {
                return this.progress;
            }
        }

        public static class Perms
        extends CreateOpts {
            private final FsPermission permissions;

            protected Perms(FsPermission perm) {
                if (perm == null) {
                    throw new IllegalArgumentException("Permissions must not be null");
                }
                this.permissions = perm;
            }

            public FsPermission getValue() {
                return this.permissions;
            }
        }

        public static class ChecksumParam
        extends CreateOpts {
            private final ChecksumOpt checksumOpt;

            protected ChecksumParam(ChecksumOpt csumOpt) {
                this.checksumOpt = csumOpt;
            }

            public ChecksumOpt getValue() {
                return this.checksumOpt;
            }
        }

        public static class BytesPerChecksum
        extends CreateOpts {
            private final int bytesPerChecksum;

            protected BytesPerChecksum(short bpc) {
                if (bpc <= 0) {
                    throw new IllegalArgumentException("Bytes per checksum must be greater than 0");
                }
                this.bytesPerChecksum = bpc;
            }

            public int getValue() {
                return this.bytesPerChecksum;
            }
        }

        public static class BufferSize
        extends CreateOpts {
            private final int bufferSize;

            protected BufferSize(int bs) {
                if (bs <= 0) {
                    throw new IllegalArgumentException("Buffer size must be greater than 0");
                }
                this.bufferSize = bs;
            }

            public int getValue() {
                return this.bufferSize;
            }
        }

        public static class ReplicationFactor
        extends CreateOpts {
            private final short replication;

            protected ReplicationFactor(short rf) {
                if (rf <= 0) {
                    throw new IllegalArgumentException("Replication must be greater than 0");
                }
                this.replication = rf;
            }

            public short getValue() {
                return this.replication;
            }
        }

        public static class BlockSize
        extends CreateOpts {
            private final long blockSize;

            protected BlockSize(long bs) {
                if (bs <= 0L) {
                    throw new IllegalArgumentException("Block size must be greater than 0");
                }
                this.blockSize = bs;
            }

            public long getValue() {
                return this.blockSize;
            }
        }
    }
}

