/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.store.audit;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.audit.CommonAuditContext;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class HttpReferrerAuditHeader {
    public static final String REFERRER_PATH_FORMAT = "/hadoop/1/%3$s/%2$s/";
    private static final Logger LOG = LoggerFactory.getLogger(HttpReferrerAuditHeader.class);
    private static final LogExactlyOnce WARN_OF_URL_CREATION = new LogExactlyOnce(LOG);
    private static final LogExactlyOnce ERROR_BUILDING_REFERRER_HEADER = new LogExactlyOnce(LOG);
    private final String contextId;
    private final String operationName;
    private final String spanId;
    private final String path1;
    private final String path2;
    private final String initialHeader;
    private final Map<String, String> attributes;
    private final Map<String, Supplier<String>> evaluated;
    private final Set<String> filter;

    private HttpReferrerAuditHeader(Builder builder) {
        this.contextId = Objects.requireNonNull(builder.contextId);
        this.evaluated = new ConcurrentHashMap<String, Supplier<String>>(builder.evaluated);
        this.filter = ImmutableSet.copyOf(builder.filter);
        this.operationName = Objects.requireNonNull(builder.operationName);
        this.path1 = builder.path1;
        this.path2 = builder.path2;
        this.spanId = Objects.requireNonNull(builder.spanId);
        this.attributes = new ConcurrentHashMap<String, String>(builder.attributes);
        this.addAttribute("op", this.operationName);
        this.addAttribute("p1", this.path1);
        this.addAttribute("p2", this.path2);
        this.addAttribute("id", this.spanId);
        Iterable globalContextValues = builder.globalContextValues;
        if (globalContextValues != null) {
            for (Map.Entry entry : globalContextValues) {
                this.attributes.putIfAbsent((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.initialHeader = this.buildHttpReferrer();
    }

    public synchronized String buildHttpReferrer() {
        String header;
        try {
            HashMap<String, String> requestAttrs = new HashMap<String, String>(this.attributes);
            this.evaluated.forEach((key, eval) -> {
                String cfr_ignored_0 = (String)requestAttrs.put((String)key, (String)eval.get());
            });
            String queries = requestAttrs.entrySet().stream().filter(e -> !this.filter.contains(e.getKey())).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
            URI uri = new URI("https", "audit.example.org", String.format(Locale.ENGLISH, REFERRER_PATH_FORMAT, this.contextId, this.spanId, this.operationName), queries, null);
            header = uri.toASCIIString();
        }
        catch (URISyntaxException e2) {
            WARN_OF_URL_CREATION.warn("Failed to build URI for auditor: " + e2, e2);
            header = "";
        }
        catch (RuntimeException e3) {
            ERROR_BUILDING_REFERRER_HEADER.warn("Failed to construct referred header {}", e3.toString());
            LOG.debug("Full stack", e3);
            header = "";
        }
        return header;
    }

    private synchronized void addAttribute(String key, String value) {
        if (StringUtils.isNotEmpty(value)) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, String value) {
        this.addAttribute(Objects.requireNonNull(key), value);
    }

    public String getContextId() {
        return this.contextId;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public String getPath1() {
        return this.path1;
    }

    public String getPath2() {
        return this.path2;
    }

    public String toString() {
        return new StringJoiner(", ", HttpReferrerAuditHeader.class.getSimpleName() + "[", "]").add(this.initialHeader).toString();
    }

    public static String escapeToPathElement(CharSequence source) {
        int len = source.length();
        StringBuilder r = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = source.charAt(i);
            String s2 = Character.toString(c);
            switch (c) {
                case '/': 
                case '@': {
                    s2 = "+";
                    break;
                }
            }
            r.append(s2);
        }
        return r.toString();
    }

    public static String maybeStripWrappedQuotes(String header) {
        String h2 = header;
        while (h2.startsWith("\"")) {
            h2 = h2.substring(1);
        }
        while (h2.endsWith("\"")) {
            h2 = h2.substring(0, h2.length() - 1);
        }
        return h2;
    }

    public static Map<String, String> extractQueryParameters(String header) throws URISyntaxException {
        URI uri = new URI(HttpReferrerAuditHeader.maybeStripWrappedQuotes(header));
        List<NameValuePair> params = URLEncodedUtils.parse(uri, StandardCharsets.UTF_8);
        HashMap<String, String> result = new HashMap<String, String>(params.size());
        for (NameValuePair param : params) {
            String name = param.getName();
            String value = param.getValue();
            if (value == null) {
                value = "";
            }
            result.put(name, value);
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String contextId;
        private String operationName;
        private String spanId;
        private String path1;
        private String path2;
        private final Map<String, String> attributes = new HashMap<String, String>();
        private final Map<String, Supplier<String>> evaluated = new HashMap<String, Supplier<String>>();
        private Iterable<Map.Entry<String, String>> globalContextValues = CommonAuditContext.getGlobalContextEntries();
        private Set<String> filter = new HashSet<String>();

        private Builder() {
        }

        public HttpReferrerAuditHeader build() {
            return new HttpReferrerAuditHeader(this);
        }

        public Builder withContextId(String value) {
            this.contextId = value;
            return this;
        }

        public Builder withOperationName(String value) {
            this.operationName = value;
            return this;
        }

        public Builder withSpanId(String value) {
            this.spanId = value;
            return this;
        }

        public Builder withPath1(String value) {
            this.path1 = value;
            return this;
        }

        public Builder withPath2(String value) {
            this.path2 = value;
            return this;
        }

        public Builder withAttributes(Map<String, String> value) {
            this.attributes.putAll(value);
            return this;
        }

        public Builder withAttribute(String key, String value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder withEvaluated(Map<String, Supplier<String>> value) {
            this.evaluated.putAll(value);
            return this;
        }

        public Builder withEvaluated(String key, Supplier<String> value) {
            this.evaluated.put(key, value);
            return this;
        }

        public Builder withGlobalContextValues(Iterable<Map.Entry<String, String>> value) {
            this.globalContextValues = value;
            return this;
        }

        public Builder withFilter(Collection<String> fields) {
            this.filter = new HashSet<String>(fields);
            return this;
        }
    }
}

