/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.RegexMountPoint;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class InodeTree<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InodeTree.class.getName());
    static final Path SlashPath = new Path("/");
    private final INode<T> root;
    private INodeLink<T> rootFallbackLink;
    private final String homedirPrefix;
    private List<MountPoint<T>> mountPoints = new ArrayList<MountPoint<T>>();
    private List<RegexMountPoint<T>> regexMountPointList = new ArrayList<RegexMountPoint<T>>();
    private final boolean isNestedMountPointSupported;

    static String[] breakIntoPathComponents(String path) {
        return path == null ? null : path.split("/");
    }

    private void createLink(String src, String target, LinkType linkType, String settings, UserGroupInformation aUgi, Configuration config) throws URISyntaxException, IOException, FileAlreadyExistsException, UnsupportedFileSystemException {
        INodeLink<T> newLink;
        String iPath;
        int i;
        Path srcPath = new Path(src);
        if (!srcPath.isAbsoluteAndSchemeAuthorityNull()) {
            throw new IOException("ViewFs: Non absolute mount name in config:" + src);
        }
        String[] srcPaths = InodeTree.breakIntoPathComponents(src);
        Preconditions.checkState(this.root.isInternalDir());
        INodeDirLink<T> curInode = this.getRootDir();
        for (i = 1; i < srcPaths.length - 1; ++i) {
            iPath = srcPaths[i];
            INode<T> nextInode = curInode.resolveInternal(iPath);
            if (nextInode == null) {
                INodeDir<T> newDir = curInode.addDir(iPath, aUgi);
                newDir.setInternalDirFs(this.getTargetFileSystem(newDir));
                nextInode = newDir;
            }
            if (!nextInode.isInternalDir()) {
                if (this.isNestedMountPointSupported) {
                    INodeDirLink<T> dirLink = new INodeDirLink<T>(nextInode.fullPath, aUgi, (INodeLink)nextInode);
                    curInode.addDirLink(iPath, dirLink);
                    curInode = dirLink;
                    continue;
                }
                throw new FileAlreadyExistsException("Path " + nextInode.fullPath + " already exists as link");
            }
            assert (nextInode.isInternalDir());
            curInode = (INodeDirLink<T>)nextInode;
        }
        iPath = srcPaths[i];
        if (curInode.resolveInternal(iPath) != null) {
            StringBuilder strB = new StringBuilder(srcPaths[0]);
            for (int j = 1; j <= i; ++j) {
                strB.append('/').append(srcPaths[j]);
            }
            throw new FileAlreadyExistsException("Path " + strB + " already exists as dir; cannot create link here");
        }
        String fullPath = curInode.fullPath + (curInode == this.root ? "" : "/") + iPath;
        switch (linkType) {
            case SINGLE: {
                newLink = new INodeLink<T>(fullPath, aUgi, this.initAndGetTargetFs(), target);
                break;
            }
            case SINGLE_FALLBACK: 
            case MERGE_SLASH: {
                throw new IllegalArgumentException("Unexpected linkType: " + (Object)((Object)linkType));
            }
            case MERGE: 
            case NFLY: {
                String[] targetUris = StringUtils.getStrings(target);
                newLink = new INodeLink<T>(fullPath, aUgi, this.getTargetFileSystem(settings, StringUtils.stringToURI(targetUris)), targetUris);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)linkType) + ": Infeasible linkType");
            }
        }
        curInode.addLink(iPath, newLink);
        this.mountPoints.add(new MountPoint<T>(src, newLink));
    }

    protected abstract Function<URI, T> initAndGetTargetFs();

    protected abstract T getTargetFileSystem(INodeDir<T> var1) throws URISyntaxException, IOException;

    protected abstract T getTargetFileSystem(String var1, URI[] var2) throws UnsupportedFileSystemException, URISyntaxException, IOException;

    private INodeDir<T> getRootDir() {
        Preconditions.checkState(this.root.isInternalDir());
        return (INodeDir)this.root;
    }

    private INodeLink<T> getRootLink() {
        Preconditions.checkState(!this.root.isInternalDir());
        return (INodeLink)this.root;
    }

    private boolean hasFallbackLink() {
        return this.rootFallbackLink != null;
    }

    public boolean isRootInternalDir() {
        return this.root.isInternalDir();
    }

    public INodeLink<T> getRootFallbackLink() {
        Preconditions.checkState(this.root.isInternalDir());
        return this.rootFallbackLink;
    }

    protected InodeTree(Configuration config, String viewName, URI theUri, boolean initingUriAsFallbackOnNoMounts) throws UnsupportedFileSystemException, URISyntaxException, FileAlreadyExistsException, IOException {
        String mountTableName = viewName;
        if (mountTableName == null) {
            mountTableName = ConfigUtil.getDefaultMountTableName(config);
        }
        this.homedirPrefix = ConfigUtil.getHomeDirValue(config, mountTableName);
        this.isNestedMountPointSupported = ConfigUtil.isNestedMountPointSupported(config);
        boolean isMergeSlashConfigured = false;
        String mergeSlashTarget = null;
        LinkedList<LinkEntry> linkEntries = new LinkedList<LinkEntry>();
        String mountTablePrefix = "fs.viewfs.mounttable." + mountTableName + ".";
        String linkPrefix = "link.";
        String linkFallbackPrefix = "linkFallback";
        String linkMergePrefix = "linkMerge.";
        String linkMergeSlashPrefix = "linkMergeSlash";
        boolean gotMountTableEntry = false;
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        for (Map.Entry<String, String> si : config) {
            LinkType linkType;
            String key = si.getKey();
            if (!key.startsWith(mountTablePrefix)) continue;
            gotMountTableEntry = true;
            String src = key.substring(mountTablePrefix.length());
            String settings = null;
            if (src.startsWith("link.")) {
                if ((src = src.substring("link.".length())).equals(SlashPath.toString())) {
                    throw new UnsupportedFileSystemException("Unexpected mount table link entry '" + key + "'. Use " + "linkMergeSlash" + " instead!");
                }
                linkType = LinkType.SINGLE;
            } else if (src.startsWith("linkFallback")) {
                this.checkMntEntryKeyEqualsTarget(src, "linkFallback");
                linkType = LinkType.SINGLE_FALLBACK;
            } else if (src.startsWith("linkMerge.")) {
                src = src.substring("linkMerge.".length());
                linkType = LinkType.MERGE;
            } else if (src.startsWith("linkMergeSlash")) {
                this.checkMntEntryKeyEqualsTarget(src, "linkMergeSlash");
                linkType = LinkType.MERGE_SLASH;
            } else if (src.startsWith("linkNfly")) {
                src = src.substring("linkNfly".length() + 1);
                settings = src.substring(0, src.indexOf(46));
                src = src.substring(settings.length() + 1);
                linkType = LinkType.NFLY;
            } else {
                if (src.startsWith("linkRegex")) {
                    linkEntries.add(this.buildLinkRegexEntry(config, ugi, src, si.getValue()));
                    continue;
                }
                if (src.startsWith("homedir")) continue;
                throw new IOException("ViewFs: Cannot initialize: Invalid entry in Mount table in config: " + src);
            }
            String target = si.getValue();
            if (linkType != LinkType.MERGE_SLASH) {
                if (isMergeSlashConfigured) {
                    throw new IOException("Mount table " + mountTableName + " has already been configured with a merge slash link. A regular link should not be added.");
                }
                linkEntries.add(new LinkEntry(src, target, linkType, settings, ugi, config));
                continue;
            }
            if (!linkEntries.isEmpty()) {
                throw new IOException("Mount table " + mountTableName + " has already been configured with regular links. A merge slash link should not be configured.");
            }
            if (isMergeSlashConfigured) {
                throw new IOException("Mount table " + mountTableName + " has already been configured with a merge slash link. Multiple merge slash links for the same mount table is not allowed.");
            }
            isMergeSlashConfigured = true;
            mergeSlashTarget = target;
        }
        if (isMergeSlashConfigured) {
            Preconditions.checkNotNull(mergeSlashTarget);
            this.root = new INodeLink<T>(mountTableName, ugi, this.initAndGetTargetFs(), mergeSlashTarget);
            this.mountPoints.add(new MountPoint("/", (INodeLink)this.root));
            this.rootFallbackLink = null;
        } else {
            this.root = new INodeDir("/", UserGroupInformation.getCurrentUser());
            this.getRootDir().setInternalDirFs(this.getTargetFileSystem(this.getRootDir()));
            this.getRootDir().setRoot(true);
            INodeLink<T> fallbackLink = null;
            block5: for (LinkEntry le : this.getLinkEntries(linkEntries)) {
                switch (le.getLinkType()) {
                    case SINGLE_FALLBACK: {
                        if (fallbackLink != null) {
                            throw new IOException("Mount table " + mountTableName + " has already been configured with a link fallback. Multiple fallback links for the same mount table is not allowed.");
                        }
                        fallbackLink = new INodeLink<T>(mountTableName, ugi, this.initAndGetTargetFs(), le.getTarget());
                        continue block5;
                    }
                    case REGEX: {
                        this.addRegexMountEntry(le);
                        continue block5;
                    }
                }
                this.createLink(le.getSrc(), le.getTarget(), le.getLinkType(), le.getSettings(), le.getUgi(), le.getConfig());
            }
            this.rootFallbackLink = fallbackLink;
            this.getRootDir().addFallbackLink(this.rootFallbackLink);
        }
        if (!gotMountTableEntry) {
            if (!initingUriAsFallbackOnNoMounts) {
                throw new IOException("ViewFs: Cannot initialize: Empty Mount table in config for " + theUri.getScheme() + "://" + mountTableName + "/");
            }
            FileSystem.LOG.info("Empty mount table detected for {} and considering itself as a linkFallback.", (Object)theUri);
            this.rootFallbackLink = new INodeLink<T>(mountTableName, ugi, this.initAndGetTargetFs(), theUri.toString());
            this.getRootDir().addFallbackLink(this.rootFallbackLink);
        }
    }

    private Collection<LinkEntry> getLinkEntries(List<LinkEntry> linkEntries) {
        TreeSet<LinkEntry> sortedLinkEntries = new TreeSet<LinkEntry>(new Comparator<LinkEntry>(){

            @Override
            public int compare(LinkEntry o1, LinkEntry o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                String src1 = o1.getSrc();
                String src2 = o2.getSrc();
                return src1.compareTo(src2);
            }
        });
        sortedLinkEntries.addAll(linkEntries);
        return sortedLinkEntries;
    }

    private void checkMntEntryKeyEqualsTarget(String mntEntryKey, String targetMntEntryKey) throws IOException {
        if (!mntEntryKey.equals(targetMntEntryKey)) {
            throw new IOException("ViewFs: Mount points initialization error. Invalid " + targetMntEntryKey + " entry in config: " + mntEntryKey);
        }
    }

    private void addRegexMountEntry(LinkEntry le) throws IOException {
        LOGGER.info("Add regex mount point:" + le.getSrc() + ", target:" + le.getTarget() + ", interceptor settings:" + le.getSettings());
        RegexMountPoint regexMountPoint = new RegexMountPoint(this, le.getSrc(), le.getTarget(), le.getSettings());
        regexMountPoint.initialize();
        this.regexMountPointList.add(regexMountPoint);
    }

    private LinkEntry buildLinkRegexEntry(Configuration config, UserGroupInformation ugi, String mntEntryStrippedKey, String mntEntryValue) {
        String linkKeyPath = null;
        String settings = null;
        String linkRegexPrefix = "linkRegex.";
        String settingsAndLinkKeyPath = mntEntryStrippedKey.substring("linkRegex.".length());
        int settingLinkKeySepIndex = settingsAndLinkKeyPath.indexOf("#.");
        if (settingLinkKeySepIndex == -1) {
            linkKeyPath = settingsAndLinkKeyPath;
            settings = null;
        } else {
            settings = settingsAndLinkKeyPath.substring(0, settingLinkKeySepIndex);
            linkKeyPath = settingsAndLinkKeyPath.substring(settings.length() + "#.".length());
        }
        return new LinkEntry(linkKeyPath, mntEntryValue, LinkType.REGEX, settings, ugi, config);
    }

    public ResolveResult<T> resolve(String p, boolean resolveLastComponent) throws IOException {
        Path remainingPath;
        int i;
        ResolveResult<T> resolveResult = null;
        String[] path = InodeTree.breakIntoPathComponents(p);
        if (path.length <= 1) {
            T targetFs = this.root.isInternalDir() ? this.getRootDir().getInternalDirFs() : this.getRootLink().getTargetFileSystem();
            resolveResult = new ResolveResult<T>(ResultKind.INTERNAL_DIR, targetFs, this.root.fullPath, SlashPath, false);
            return resolveResult;
        }
        if (!this.root.isInternalDir()) {
            StringBuilder remainingPathStr = new StringBuilder();
            for (int i2 = 1; i2 < path.length; ++i2) {
                remainingPathStr.append("/").append(path[i2]);
            }
            Path remainingPath2 = new Path(remainingPathStr.toString());
            resolveResult = new ResolveResult<T>(ResultKind.EXTERNAL_DIR, this.getRootLink().getTargetFileSystem(), this.root.fullPath, remainingPath2, true);
            return resolveResult;
        }
        Preconditions.checkState(this.root.isInternalDir());
        INodeDir curInode = this.getRootDir();
        resolveResult = this.tryResolveInRegexMountpoint(p, resolveLastComponent);
        if (resolveResult != null) {
            return resolveResult;
        }
        INodeDirLink lastResolvedDirLink = null;
        int lastResolvedDirLinkIndex = -1;
        for (i = 1; i < path.length - (resolveLastComponent ? 0 : 1); ++i) {
            INode<T> nextInode = curInode.resolveInternal(path[i]);
            if (nextInode == null) {
                if (this.isNestedMountPointSupported && lastResolvedDirLink != null) {
                    return new ResolveResult(ResultKind.EXTERNAL_DIR, lastResolvedDirLink.getLink().getTargetFileSystem(), lastResolvedDirLink.fullPath, this.getRemainingPath(path, i), true);
                }
                if (this.hasFallbackLink()) {
                    resolveResult = new ResolveResult<T>(ResultKind.EXTERNAL_DIR, this.getRootFallbackLink().getTargetFileSystem(), this.root.fullPath, new Path(p), false);
                    return resolveResult;
                }
                StringBuilder failedAt = new StringBuilder(path[0]);
                for (int j = 1; j <= i; ++j) {
                    failedAt.append('/').append(path[j]);
                }
                throw new FileNotFoundException("File/Directory does not exist: " + failedAt.toString());
            }
            if (!nextInode.isInternalDir()) {
                INodeLink link = (INodeLink)nextInode;
                Path remainingPath3 = this.getRemainingPath(path, i + 1);
                resolveResult = new ResolveResult(ResultKind.EXTERNAL_DIR, link.getTargetFileSystem(), nextInode.fullPath, remainingPath3, true);
                return resolveResult;
            }
            curInode = (INodeDir)nextInode;
            if (!this.isNestedMountPointSupported || !nextInode.isLink()) continue;
            lastResolvedDirLink = (INodeDirLink)nextInode;
            lastResolvedDirLinkIndex = i;
        }
        if (this.isNestedMountPointSupported && lastResolvedDirLink != null) {
            remainingPath = this.getRemainingPath(path, lastResolvedDirLinkIndex + 1);
            resolveResult = new ResolveResult(ResultKind.EXTERNAL_DIR, lastResolvedDirLink.getLink().getTargetFileSystem(), lastResolvedDirLink.fullPath, remainingPath, true);
        } else {
            remainingPath = resolveLastComponent ? SlashPath : this.getRemainingPath(path, i);
            resolveResult = new ResolveResult<T>(ResultKind.INTERNAL_DIR, curInode.getInternalDirFs(), curInode.fullPath, remainingPath, false);
        }
        return resolveResult;
    }

    private Path getRemainingPath(String[] path, int startIndex) {
        Path remainingPath;
        if (startIndex >= path.length) {
            remainingPath = SlashPath;
        } else {
            StringBuilder remainingPathStr = new StringBuilder();
            for (int j = startIndex; j < path.length; ++j) {
                remainingPathStr.append("/").append(path[j]);
            }
            remainingPath = new Path(remainingPathStr.toString());
        }
        return remainingPath;
    }

    protected ResolveResult<T> tryResolveInRegexMountpoint(String srcPath, boolean resolveLastComponent) {
        for (RegexMountPoint<T> regexMountPoint : this.regexMountPointList) {
            ResolveResult<T> resolveResult = regexMountPoint.resolve(srcPath, resolveLastComponent);
            if (resolveResult == null) continue;
            return resolveResult;
        }
        return null;
    }

    protected ResolveResult<T> buildResolveResultForRegexMountPoint(ResultKind resultKind, String resolvedPathStr, String targetOfResolvedPathStr, Path remainingPath) {
        try {
            T targetFs = this.initAndGetTargetFs().apply(new URI(targetOfResolvedPathStr));
            if (targetFs == null) {
                LOGGER.error(String.format("Not able to initialize target file system. ResultKind:%s, resolvedPathStr:%s, targetOfResolvedPathStr:%s, remainingPath:%s, will return null.", new Object[]{resultKind, resolvedPathStr, targetOfResolvedPathStr, remainingPath}));
                return null;
            }
            return new ResolveResult<T>(resultKind, targetFs, resolvedPathStr, remainingPath, true);
        }
        catch (URISyntaxException uex) {
            LOGGER.error(String.format("Got Exception while build resolve result. ResultKind:%s, resolvedPathStr:%s, targetOfResolvedPathStr:%s, remainingPath:%s, will return null.", new Object[]{resultKind, resolvedPathStr, targetOfResolvedPathStr, remainingPath}), uex);
            return null;
        }
    }

    public List<MountPoint<T>> getMountPoints() {
        return this.mountPoints;
    }

    public String getHomeDirPrefixValue() {
        return this.homedirPrefix;
    }

    public static class ResolveResult<T> {
        final ResultKind kind;
        final T targetFileSystem;
        final String resolvedPath;
        final Path remainingPath;
        private final boolean isLastInternalDirLink;

        ResolveResult(ResultKind k, T targetFs, String resolveP, Path remainingP, boolean isLastIntenalDirLink) {
            this.kind = k;
            this.targetFileSystem = targetFs;
            this.resolvedPath = resolveP;
            this.remainingPath = remainingP;
            this.isLastInternalDirLink = isLastIntenalDirLink;
        }

        boolean isInternalDir() {
            return this.kind == ResultKind.INTERNAL_DIR;
        }

        boolean isLastInternalDirLink() {
            return this.isLastInternalDirLink;
        }
    }

    private static class LinkEntry {
        private final String src;
        private final String target;
        private final LinkType linkType;
        private final String settings;
        private final UserGroupInformation ugi;
        private final Configuration config;

        LinkEntry(String src, String target, LinkType linkType, String settings, UserGroupInformation ugi, Configuration config) {
            this.src = src;
            this.target = target;
            this.linkType = linkType;
            this.settings = settings;
            this.ugi = ugi;
            this.config = config;
        }

        String getSrc() {
            return this.src;
        }

        String getTarget() {
            return this.target;
        }

        LinkType getLinkType() {
            return this.linkType;
        }

        boolean isLinkType(LinkType type) {
            return this.linkType == type;
        }

        String getSettings() {
            return this.settings;
        }

        UserGroupInformation getUgi() {
            return this.ugi;
        }

        Configuration getConfig() {
            return this.config;
        }
    }

    public static class INodeLink<T>
    extends INode<T> {
        final String[] targetDirLinkList;
        private T targetFileSystem;
        private Function<URI, T> fileSystemInitMethod;
        private final Object lock = new Object();

        INodeLink(String pathToNode, UserGroupInformation aUgi, T targetMergeFs, String[] aTargetDirLinkList) {
            super(pathToNode, aUgi);
            this.targetFileSystem = targetMergeFs;
            this.targetDirLinkList = aTargetDirLinkList;
        }

        INodeLink(String pathToNode, UserGroupInformation aUgi, Function<URI, T> createFileSystemMethod, String aTargetDirLink) throws URISyntaxException {
            super(pathToNode, aUgi);
            this.targetFileSystem = null;
            this.targetDirLinkList = new String[1];
            this.targetDirLinkList[0] = new URI(aTargetDirLink).toString();
            this.fileSystemInitMethod = createFileSystemMethod;
        }

        public Path getTargetLink() {
            StringBuilder result = new StringBuilder(this.targetDirLinkList[0].toString());
            for (int i = 1; i < this.targetDirLinkList.length; ++i) {
                result.append(',').append(this.targetDirLinkList[i].toString());
            }
            return new Path(result.toString());
        }

        @Override
        boolean isInternalDir() {
            return false;
        }

        @Override
        INodeLink<T> getLink() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T getTargetFileSystem() throws IOException {
            if (this.targetFileSystem != null) {
                return this.targetFileSystem;
            }
            if (this.targetDirLinkList.length == 1) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.targetFileSystem != null) {
                        return this.targetFileSystem;
                    }
                    this.targetFileSystem = this.fileSystemInitMethod.apply(URI.create(this.targetDirLinkList[0]));
                    if (this.targetFileSystem == null) {
                        throw new IOException("Could not initialize target File System for URI : " + this.targetDirLinkList[0]);
                    }
                }
            }
            return this.targetFileSystem;
        }

        T getTargetFileSystemForClose() throws IOException {
            return this.targetFileSystem;
        }
    }

    static enum LinkType {
        SINGLE,
        SINGLE_FALLBACK,
        MERGE,
        MERGE_SLASH,
        NFLY,
        REGEX;

    }

    static class INodeDirLink<T>
    extends INodeDir<T> {
        private final INodeLink<T> link;

        INodeDirLink(String pathToNode, UserGroupInformation aUgi, INodeLink<T> link) {
            super(pathToNode, aUgi);
            this.link = link;
        }

        @Override
        INodeLink<T> getLink() {
            return this.link;
        }

        @Override
        boolean isLink() {
            return true;
        }

        @Override
        boolean isInternalDir() {
            return true;
        }
    }

    static class INodeDir<T>
    extends INode<T> {
        private final Map<String, INode<T>> children = new HashMap<String, INode<T>>();
        private T internalDirFs = null;
        private boolean isRoot = false;
        private INodeLink<T> fallbackLink = null;

        INodeDir(String pathToNode, UserGroupInformation aUgi) {
            super(pathToNode, aUgi);
        }

        @Override
        boolean isInternalDir() {
            return true;
        }

        T getInternalDirFs() {
            return this.internalDirFs;
        }

        void setInternalDirFs(T internalDirFs) {
            this.internalDirFs = internalDirFs;
        }

        void setRoot(boolean root) {
            this.isRoot = root;
        }

        boolean isRoot() {
            return this.isRoot;
        }

        INodeLink<T> getFallbackLink() {
            return this.fallbackLink;
        }

        void addFallbackLink(INodeLink<T> link) throws IOException {
            if (!this.isRoot) {
                throw new IOException("Fallback link can only be added for root");
            }
            this.fallbackLink = link;
        }

        Map<String, INode<T>> getChildren() {
            return Collections.unmodifiableMap(this.children);
        }

        INode<T> resolveInternal(String pathComponent) {
            return this.children.get(pathComponent);
        }

        INodeDir<T> addDir(String pathComponent, UserGroupInformation aUgi) throws FileAlreadyExistsException {
            if (this.children.containsKey(pathComponent)) {
                throw new FileAlreadyExistsException();
            }
            INodeDir<T> newDir = new INodeDir<T>(this.fullPath + (this.isRoot() ? "" : "/") + pathComponent, aUgi);
            this.children.put(pathComponent, newDir);
            return newDir;
        }

        void addLink(String pathComponent, INodeLink<T> link) throws FileAlreadyExistsException {
            if (this.children.containsKey(pathComponent)) {
                throw new FileAlreadyExistsException();
            }
            this.children.put(pathComponent, link);
        }

        void addDirLink(String pathComponent, INodeDirLink<T> dirLink) {
            this.children.put(pathComponent, dirLink);
        }
    }

    static abstract class INode<T> {
        final String fullPath;

        public INode(String pathToNode, UserGroupInformation aUgi) {
            this.fullPath = pathToNode;
        }

        abstract boolean isInternalDir();

        boolean isLink() {
            return !this.isInternalDir();
        }

        INodeLink<T> getLink() {
            return null;
        }
    }

    public static class MountPoint<T> {
        String src;
        INodeLink<T> target;

        MountPoint(String srcPath, INodeLink<T> mountLink) {
            this.src = srcPath;
            this.target = mountLink;
        }

        public String getSource() {
            return this.src;
        }

        public INodeLink<T> getTarget() {
            return this.target;
        }
    }

    static enum ResultKind {
        INTERNAL_DIR,
        EXTERNAL_DIR;

    }
}

