/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.util.Preconditions;

public class ZoneReencryptionStatus {
    private long id;
    private String zoneName;
    private State state;
    private String ezKeyVersionName;
    private long submissionTime;
    private long completionTime;
    private boolean canceled;
    private String lastCheckpointFile;
    private long filesReencrypted;
    private long numReencryptionFailures;

    public ZoneReencryptionStatus() {
        this.reset();
    }

    void resetMetrics() {
        this.filesReencrypted = 0L;
        this.numReencryptionFailures = 0L;
    }

    public long getId() {
        return this.id;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    void setState(State s2) {
        this.state = s2;
    }

    public State getState() {
        return this.state;
    }

    public String getEzKeyVersionName() {
        return this.ezKeyVersionName;
    }

    public long getSubmissionTime() {
        return this.submissionTime;
    }

    public long getCompletionTime() {
        return this.completionTime;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getLastCheckpointFile() {
        return this.lastCheckpointFile;
    }

    public long getFilesReencrypted() {
        return this.filesReencrypted;
    }

    public long getNumReencryptionFailures() {
        return this.numReencryptionFailures;
    }

    public void reset() {
        this.state = State.Submitted;
        this.ezKeyVersionName = null;
        this.submissionTime = 0L;
        this.completionTime = 0L;
        this.canceled = false;
        this.lastCheckpointFile = null;
        this.resetMetrics();
    }

    public void setZoneName(String name) {
        Preconditions.checkNotNull(name, "zone name cannot be null");
        this.zoneName = name;
    }

    public void cancel() {
        this.canceled = true;
    }

    void markZoneCompleted(HdfsProtos.ReencryptionInfoProto proto) {
        this.state = State.Completed;
        this.completionTime = proto.getCompletionTime();
        this.lastCheckpointFile = null;
        this.canceled = proto.getCanceled();
        this.filesReencrypted = proto.getNumReencrypted();
        this.numReencryptionFailures = proto.getNumFailures();
    }

    void markZoneSubmitted(HdfsProtos.ReencryptionInfoProto proto) {
        this.reset();
        this.state = State.Submitted;
        this.ezKeyVersionName = proto.getEzKeyVersionName();
        this.submissionTime = proto.getSubmissionTime();
        this.filesReencrypted = proto.getNumReencrypted();
        this.numReencryptionFailures = proto.getNumFailures();
    }

    void updateZoneProcess(HdfsProtos.ReencryptionInfoProto proto) {
        this.lastCheckpointFile = proto.getLastFile();
        this.filesReencrypted = proto.getNumReencrypted();
        this.numReencryptionFailures = proto.getNumFailures();
    }

    public static final class Builder {
        private long id;
        private String zoneName;
        private State state;
        private String ezKeyVersionName;
        private long submissionTime;
        private long completionTime;
        private boolean canceled;
        private String lastCheckpointFile;
        private long filesReencrypted;
        private long fileReencryptionFailures;

        public Builder id(long inodeid) {
            this.id = inodeid;
            return this;
        }

        public Builder zoneName(String ezName) {
            this.zoneName = ezName;
            return this;
        }

        public Builder state(State st) {
            this.state = st;
            return this;
        }

        public Builder ezKeyVersionName(String ezkvn) {
            this.ezKeyVersionName = ezkvn;
            return this;
        }

        public Builder submissionTime(long submission) {
            this.submissionTime = submission;
            return this;
        }

        public Builder completionTime(long completion) {
            this.completionTime = completion;
            return this;
        }

        public Builder canceled(boolean isCanceled) {
            this.canceled = isCanceled;
            return this;
        }

        public Builder lastCheckpointFile(String lastFile) {
            this.lastCheckpointFile = lastFile;
            return this;
        }

        public Builder filesReencrypted(long numReencrypted) {
            this.filesReencrypted = numReencrypted;
            return this;
        }

        public Builder fileReencryptionFailures(long numFailures) {
            this.fileReencryptionFailures = numFailures;
            return this;
        }

        public ZoneReencryptionStatus build() {
            ZoneReencryptionStatus ret = new ZoneReencryptionStatus();
            Preconditions.checkArgument(this.id != 0L, "no inode id set.");
            Preconditions.checkNotNull(this.state, "no state id set.");
            Preconditions.checkNotNull(this.ezKeyVersionName, "no keyVersionName set.");
            Preconditions.checkArgument(this.submissionTime != 0L, "no submission time set.");
            ret.id = this.id;
            ret.zoneName = this.zoneName;
            ret.state = this.state;
            ret.ezKeyVersionName = this.ezKeyVersionName;
            ret.submissionTime = this.submissionTime;
            ret.completionTime = this.completionTime;
            ret.canceled = this.canceled;
            ret.lastCheckpointFile = this.lastCheckpointFile;
            ret.filesReencrypted = this.filesReencrypted;
            ret.numReencryptionFailures = this.fileReencryptionFailures;
            return ret;
        }
    }

    public static enum State {
        Submitted,
        Processing,
        Completed;

    }
}

