/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.api.records.impl.pb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.v2.api.records.Counter;
import org.apache.hadoop.mapreduce.v2.api.records.CounterGroup;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.CounterPBImpl;
import org.apache.hadoop.mapreduce.v2.proto.MRProtos;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoBase;

public class CounterGroupPBImpl
extends ProtoBase<MRProtos.CounterGroupProto>
implements CounterGroup {
    MRProtos.CounterGroupProto proto = MRProtos.CounterGroupProto.getDefaultInstance();
    MRProtos.CounterGroupProto.Builder builder = null;
    boolean viaProto = false;
    private Map<String, Counter> counters = null;

    public CounterGroupPBImpl() {
        this.builder = MRProtos.CounterGroupProto.newBuilder();
    }

    public CounterGroupPBImpl(MRProtos.CounterGroupProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public MRProtos.CounterGroupProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.counters != null) {
            this.addContersToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = MRProtos.CounterGroupProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public String getName() {
        MRProtos.CounterGroupProtoOrBuilder p;
        MRProtos.CounterGroupProtoOrBuilder counterGroupProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasName()) {
            return null;
        }
        return p.getName();
    }

    @Override
    public void setName(String name) {
        this.maybeInitBuilder();
        if (name == null) {
            this.builder.clearName();
            return;
        }
        this.builder.setName(name);
    }

    @Override
    public String getDisplayName() {
        MRProtos.CounterGroupProtoOrBuilder p;
        MRProtos.CounterGroupProtoOrBuilder counterGroupProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasDisplayName()) {
            return null;
        }
        return p.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) {
        this.maybeInitBuilder();
        if (displayName == null) {
            this.builder.clearDisplayName();
            return;
        }
        this.builder.setDisplayName(displayName);
    }

    @Override
    public Map<String, Counter> getAllCounters() {
        this.initCounters();
        return this.counters;
    }

    @Override
    public Counter getCounter(String key) {
        this.initCounters();
        return this.counters.get(key);
    }

    private void initCounters() {
        if (this.counters != null) {
            return;
        }
        MRProtos.CounterGroupProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<MRProtos.StringCounterMapProto> list = p.getCountersList();
        this.counters = new HashMap<String, Counter>();
        for (MRProtos.StringCounterMapProto c : list) {
            this.counters.put(c.getKey(), this.convertFromProtoFormat(c.getValue()));
        }
    }

    @Override
    public void addAllCounters(Map<String, Counter> counters) {
        if (counters == null) {
            return;
        }
        this.initCounters();
        this.counters.putAll(counters);
    }

    private void addContersToProto() {
        this.maybeInitBuilder();
        this.builder.clearCounters();
        if (this.counters == null) {
            return;
        }
        Iterable<MRProtos.StringCounterMapProto> iterable = new Iterable<MRProtos.StringCounterMapProto>(){

            @Override
            public Iterator<MRProtos.StringCounterMapProto> iterator() {
                return new Iterator<MRProtos.StringCounterMapProto>(){
                    Iterator<String> keyIter;
                    {
                        this.keyIter = CounterGroupPBImpl.this.counters.keySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public MRProtos.StringCounterMapProto next() {
                        String key = this.keyIter.next();
                        return MRProtos.StringCounterMapProto.newBuilder().setKey(key).setValue(CounterGroupPBImpl.this.convertToProtoFormat((Counter)CounterGroupPBImpl.this.counters.get(key))).build();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIter.hasNext();
                    }
                };
            }
        };
        this.builder.addAllCounters((Iterable<? extends MRProtos.StringCounterMapProto>)iterable);
    }

    @Override
    public void setCounter(String key, Counter val) {
        this.initCounters();
        this.counters.put(key, val);
    }

    @Override
    public void removeCounter(String key) {
        this.initCounters();
        this.counters.remove(key);
    }

    @Override
    public void clearCounters() {
        this.initCounters();
        this.counters.clear();
    }

    private CounterPBImpl convertFromProtoFormat(MRProtos.CounterProto p) {
        return new CounterPBImpl(p);
    }

    private MRProtos.CounterProto convertToProtoFormat(Counter t2) {
        return ((CounterPBImpl)t2).getProto();
    }
}

