/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FileMonitoringTimerTask
extends TimerTask {
    static final Logger LOG = LoggerFactory.getLogger(FileMonitoringTimerTask.class);
    @VisibleForTesting
    static final String PROCESS_ERROR_MESSAGE = "Could not process file change : ";
    private final List<Path> filePaths;
    private final Consumer<Path> onFileChange;
    final Consumer<Throwable> onChangeFailure;
    private List<Long> lastProcessed;

    public FileMonitoringTimerTask(Path filePath, Consumer<Path> onFileChange, Consumer<Throwable> onChangeFailure) {
        this(Collections.singletonList(filePath), onFileChange, onChangeFailure);
    }

    public FileMonitoringTimerTask(List<Path> filePaths, Consumer<Path> onFileChange, Consumer<Throwable> onChangeFailure) {
        Preconditions.checkNotNull(filePaths, "path to monitor disk file is not set");
        Preconditions.checkNotNull(onFileChange, "action to monitor disk file is not set");
        this.filePaths = new ArrayList<Path>(filePaths);
        this.lastProcessed = new ArrayList<Long>();
        this.filePaths.forEach(path -> this.lastProcessed.add(path.toFile().lastModified()));
        this.onFileChange = onFileChange;
        this.onChangeFailure = onChangeFailure;
    }

    @Override
    public void run() {
        int modified = -1;
        for (int i = 0; i < this.filePaths.size() && modified < 0; ++i) {
            if (this.lastProcessed.get(i).longValue() == this.filePaths.get(i).toFile().lastModified()) continue;
            modified = i;
        }
        if (modified > -1) {
            Path filePath = this.filePaths.get(modified);
            try {
                this.onFileChange.accept(filePath);
            }
            catch (Throwable t2) {
                if (this.onChangeFailure != null) {
                    this.onChangeFailure.accept(t2);
                }
                LOG.error(PROCESS_ERROR_MESSAGE + filePath.toString(), t2);
            }
            this.lastProcessed.set(modified, filePath.toFile().lastModified());
        }
    }
}

