/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.UnmarshalException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.RemoteExceptionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
@Singleton
@Provider
public class GenericExceptionHandler
implements ExceptionMapper<Exception> {
    public static final Logger LOG = LoggerFactory.getLogger(GenericExceptionHandler.class);
    @Context
    private HttpServletResponse response;

    @Override
    public Response toResponse(Exception e) {
        Response.Status s2;
        if (LOG.isTraceEnabled()) {
            LOG.trace("GOT EXCEPTION", e);
        }
        if (e instanceof com.sun.jersey.api.NotFoundException) {
            return ((com.sun.jersey.api.NotFoundException)e).getResponse();
        }
        this.response.setContentType(null);
        if (e instanceof RemoteException) {
            e = ((RemoteException)e).unwrapRemoteException();
        }
        if (e instanceof SecurityException) {
            s2 = Response.Status.UNAUTHORIZED;
        } else if (e instanceof AuthorizationException) {
            s2 = Response.Status.UNAUTHORIZED;
        } else if (e instanceof FileNotFoundException) {
            s2 = Response.Status.NOT_FOUND;
        } else if (e instanceof NotFoundException) {
            s2 = Response.Status.NOT_FOUND;
        } else if (e instanceof IOException) {
            s2 = Response.Status.NOT_FOUND;
        } else if (e instanceof ForbiddenException) {
            s2 = Response.Status.FORBIDDEN;
        } else if (e instanceof UnsupportedOperationException) {
            s2 = Response.Status.BAD_REQUEST;
        } else if (e instanceof IllegalArgumentException) {
            s2 = Response.Status.BAD_REQUEST;
        } else if (e instanceof BadRequestException) {
            s2 = Response.Status.BAD_REQUEST;
        } else if (e instanceof WebApplicationException && e.getCause() instanceof UnmarshalException) {
            s2 = Response.Status.BAD_REQUEST;
        } else {
            LOG.warn("SERVICE_UNAVAILABLE", e);
            s2 = Response.Status.SERVICE_UNAVAILABLE;
        }
        RemoteExceptionData exception = new RemoteExceptionData(e.getClass().getSimpleName(), e.getMessage(), e.getClass().getName());
        return Response.status(s2).entity(exception).build();
    }
}

