/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.app.event.EventHandlerUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.InputBase;
import org.apache.velocity.runtime.directive.MacroParseException;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringUtils;

public class Parse
extends InputBase {
    private int maxDepth;
    public boolean strictRef = false;

    @Override
    public String getName() {
        return "parse";
    }

    @Override
    public String getScopeName() {
        return "template";
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
        super.init(rs, context, node);
        this.maxDepth = this.rsvc.getInt("directive.parse.max_depth", 10);
        this.strictRef = this.rsvc.getBoolean("runtime.strict_mode.enable", false);
    }

    @Override
    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        String[] templateStack;
        if (node.jjtGetNumChildren() == 0) {
            throw new VelocityException("#" + this.getName() + "(): argument missing at " + StringUtils.formatFileString(this), null, this.rsvc.getLogContext().getStackTrace());
        }
        Object value = node.jjtGetChild(0).value(context);
        if (value == null) {
            this.log.debug("#" + this.getName() + "(): null argument at {}", (Object)StringUtils.formatFileString(this));
        }
        String sourcearg = value == null ? null : value.toString();
        String arg = EventHandlerUtil.includeEvent(this.rsvc, context, sourcearg, context.getCurrentTemplateName(), this.getName());
        if (this.strictRef && value == null && arg == null) {
            throw new VelocityException("The argument to #" + this.getName() + " returned null at " + StringUtils.formatFileString(this), null, this.rsvc.getLogContext().getStackTrace());
        }
        if (arg == null) {
            return true;
        }
        if (this.maxDepth > 0 && (templateStack = context.getTemplateNameStack()).length >= this.maxDepth) {
            StringBuilder path = new StringBuilder();
            for (String aTemplateStack : templateStack) {
                path.append(" > ").append(aTemplateStack);
            }
            this.log.error("Max recursion depth reached ({}). File stack: {}", (Object)templateStack.length, (Object)path);
            return false;
        }
        Template t2 = null;
        try {
            t2 = this.getTemplate(arg, this.getInputEncoding(context));
        }
        catch (ResourceNotFoundException rnfe) {
            this.log.error("#" + this.getName() + "(): cannot find template '{}', called at {}", (Object)arg, (Object)StringUtils.formatFileString(this));
            throw rnfe;
        }
        catch (ParseErrorException pee) {
            this.log.error("#" + this.getName() + "(): syntax error in #" + this.getName() + "()-ed template '{}', called at {}", (Object)arg, (Object)StringUtils.formatFileString(this));
            throw pee;
        }
        catch (RuntimeException e) {
            this.log.error("Exception rendering #" + this.getName() + "({}) at {}", (Object)arg, (Object)StringUtils.formatFileString(this));
            throw e;
        }
        catch (Exception e) {
            String msg = "Exception rendering #" + this.getName() + "(" + arg + ") at " + StringUtils.formatFileString(this);
            this.log.error(msg, e);
            throw new VelocityException(msg, e, this.rsvc.getLogContext().getStackTrace());
        }
        List<Template> macroLibraries = context.getMacroLibraries();
        if (macroLibraries == null) {
            macroLibraries = new ArrayList<Template>();
        }
        context.setMacroLibraries(macroLibraries);
        macroLibraries.add(t2);
        try {
            this.preRender(context);
            context.pushCurrentTemplateName(arg);
            ((SimpleNode)t2.getData()).render(context, writer);
        }
        catch (StopCommand stop) {
            if (!stop.isFor(this)) {
                throw stop;
            }
        }
        catch (RuntimeException e) {
            this.log.error("Exception rendering #" + this.getName() + "({}) at {}", (Object)arg, (Object)StringUtils.formatFileString(this));
            throw e;
        }
        catch (Exception e) {
            String msg = "Exception rendering #" + this.getName() + "(" + arg + ") at " + StringUtils.formatFileString(this);
            this.log.error(msg, e);
            throw new VelocityException(msg, e, this.rsvc.getLogContext().getStackTrace());
        }
        finally {
            context.popCurrentTemplateName();
            this.postRender(context);
        }
        return true;
    }

    @Override
    public void checkArgs(ArrayList<Integer> argtypes, Token t2, String templateName) throws ParseException {
        if (argtypes.size() != 1) {
            throw new MacroParseException("The #" + this.getName() + " directive requires one argument", templateName, t2);
        }
        if (argtypes.get(0) == 11) {
            throw new MacroParseException("The argument to #" + this.getName() + " is of the wrong type", templateName, t2);
        }
    }

    protected Template getTemplate(String path, String encoding) throws ResourceNotFoundException {
        return this.rsvc.getTemplate(path, encoding);
    }
}

