/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.app.event.EventHandlerUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTExpression;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTText;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.parser.node.StandardParserVisitor;
import org.apache.velocity.util.introspection.Info;

public class ASTSetDirective
extends SimpleNode {
    private String leftReference = "";
    private Node right = null;
    private ASTReference left = null;
    private boolean isInitialized;
    private String prefix = "";
    private String postfix = "";
    private String morePrefix = "";
    protected Info uberInfo;
    protected boolean strictRef = false;

    public ASTSetDirective(int id) {
        super(id);
    }

    public ASTSetDirective(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(StandardParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public synchronized Object init(InternalContextAdapter context, Object data) throws TemplateInitException {
        if (!this.isInitialized) {
            super.init(context, data);
            Token t2 = this.getFirstToken();
            int pos = -1;
            while (t2 != null && (pos = t2.image.lastIndexOf(this.rsvc.getParserConfiguration().getHashChar())) == -1) {
                t2 = t2.next;
            }
            if (t2 != null && pos > 0) {
                this.morePrefix = t2.image.substring(0, pos);
            }
            this.uberInfo = new Info(this.getTemplateName(), this.getLine(), this.getColumn());
            this.right = this.getRightHandSide();
            this.left = this.getLeftHandSide();
            this.strictRef = this.rsvc.getBoolean("runtime.strict_mode.enable", false);
            this.leftReference = this.left.firstImage.substring(1);
            if (this.rsvc.getSpaceGobbling() == RuntimeConstants.SpaceGobbling.BC) {
                Node node;
                Node previousNode = null;
                for (int brother = 0; brother < this.parent.jjtGetNumChildren() && (node = this.parent.jjtGetChild(brother)) != this; ++brother) {
                    previousNode = node;
                }
                if (previousNode == null) {
                    this.prefix = "";
                } else if (previousNode instanceof ASTText) {
                    ASTText text = (ASTText)previousNode;
                    if (text.getCtext().matches("[ \t]*")) {
                        text.setCtext("");
                    }
                } else {
                    this.prefix = "";
                }
            }
            this.isInitialized = true;
            this.cleanupParserAndTokens();
        }
        return data;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(InternalContextAdapter context, Writer writer) throws IOException, MethodInvocationException {
        try {
            this.rsvc.getLogContext().pushLogContext(this, this.uberInfo);
            RuntimeConstants.SpaceGobbling spaceGobbling = this.rsvc.getSpaceGobbling();
            if (this.morePrefix.length() > 0 || spaceGobbling.compareTo(RuntimeConstants.SpaceGobbling.LINES) < 0) {
                writer.write(this.prefix);
            }
            writer.write(this.morePrefix);
            Object value = this.right.value(context);
            if (value == null && !this.strictRef) {
                String rightReference = null;
                if (this.right instanceof ASTExpression) {
                    rightReference = ((ASTExpression)this.right).lastImage;
                }
                EventHandlerUtil.invalidSetMethod(this.rsvc, context, this.leftReference, rightReference, this.uberInfo);
            }
            if (this.morePrefix.length() > 0 || spaceGobbling == RuntimeConstants.SpaceGobbling.NONE) {
                writer.write(this.postfix);
            }
            boolean bl = this.left.setValue(context, value);
            return bl;
        }
        finally {
            this.rsvc.getLogContext().popLogContext();
        }
    }

    @Override
    public String literal() {
        if (this.literal != null) {
            return this.literal;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("#set(").append(this.left.literal()).append(" = ...)");
        this.literal = builder.toString();
        return this.literal;
    }

    private ASTReference getLeftHandSide() {
        return (ASTReference)this.jjtGetChild(0);
    }

    private Node getRightHandSide() {
        return this.jjtGetChild(1);
    }
}

