/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import org.apache.velocity.util.introspection.AbstractChainableUberspector;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.Introspector;
import org.apache.velocity.util.introspection.Uberspect;
import org.apache.velocity.util.introspection.VelMethod;
import org.apache.velocity.util.introspection.VelPropertyGet;
import org.apache.velocity.util.introspection.VelPropertySet;

public class DeprecatedCheckUberspector
extends AbstractChainableUberspector
implements Uberspect {
    @Override
    public void init() {
        super.init();
        this.introspector = new Introspector(this.log);
    }

    @Override
    public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) {
        Method m4;
        VelMethod method = super.getMethod(obj, methodName, args, i);
        if (method != null && (m4 = this.introspector.getMethod(obj.getClass(), method.getMethodName(), args)) != null && (m4.isAnnotationPresent(Deprecated.class) || m4.getDeclaringClass().isAnnotationPresent(Deprecated.class) || obj.getClass().isAnnotationPresent(Deprecated.class))) {
            this.logWarning("method", obj, method.getMethodName(), i);
        }
        return method;
    }

    @Override
    public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) {
        Method m4;
        VelPropertyGet method = super.getPropertyGet(obj, identifier, i);
        if (method != null && (m4 = this.introspector.getMethod(obj.getClass(), method.getMethodName(), new Object[0])) != null && (m4.isAnnotationPresent(Deprecated.class) || m4.getDeclaringClass().isAnnotationPresent(Deprecated.class) || obj.getClass().isAnnotationPresent(Deprecated.class))) {
            this.logWarning("getter", obj, method.getMethodName(), i);
        }
        return method;
    }

    @Override
    public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i) {
        Method m4;
        VelPropertySet method = super.getPropertySet(obj, identifier, arg, i);
        if (method != null && (m4 = this.introspector.getMethod(obj.getClass(), method.getMethodName(), new Object[]{arg})) != null && (m4.isAnnotationPresent(Deprecated.class) || m4.getDeclaringClass().isAnnotationPresent(Deprecated.class) || obj.getClass().isAnnotationPresent(Deprecated.class))) {
            this.logWarning("setter", obj, method.getMethodName(), i);
        }
        return method;
    }

    private void logWarning(String deprecationType, Object object, String methodName, Info info) {
        this.log.warn("Deprecated usage of {} [{}] in {}@{},{}", deprecationType, object.getClass().getCanonicalName() + "." + methodName, info.getTemplateName(), info.getLine(), info.getColumn());
    }
}

