/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.dnssec;

import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;
import org.xbill.DNS.dnssec.JustifiedSecStatus;
import org.xbill.DNS.dnssec.R;
import org.xbill.DNS.dnssec.SRRset;
import org.xbill.DNS.dnssec.SecurityStatus;

final class KeyEntry
extends SRRset {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyEntry.class);
    private final List<Integer> algo;
    private int edeReason = -1;
    private String badReason;
    private boolean isEmpty;

    private KeyEntry(SRRset rrset) {
        this(rrset, null);
    }

    private KeyEntry(SRRset rrset, List<Integer> sigalg) {
        super(rrset);
        this.algo = sigalg;
    }

    private KeyEntry(Name name, int dclass, long ttl, boolean isBad) {
        super(new SRRset(Record.newRecord(name, 48, dclass, ttl)));
        this.isEmpty = true;
        this.algo = null;
        if (isBad) {
            this.setSecurityStatus(SecurityStatus.BOGUS);
        }
    }

    public static KeyEntry newKeyEntry(SRRset rrset) {
        return new KeyEntry(rrset);
    }

    public static KeyEntry newKeyEntry(SRRset rrset, List<Integer> sigalg) {
        return new KeyEntry(rrset, sigalg);
    }

    public static KeyEntry newNullKeyEntry(Name n, int dclass, long ttl) {
        return new KeyEntry(n, dclass, ttl, false);
    }

    public static KeyEntry newBadKeyEntry(Name n, int dclass, long ttl) {
        return new KeyEntry(n, dclass, ttl, true);
    }

    public boolean isNull() {
        return this.isEmpty && this.getSecurityStatus() == SecurityStatus.UNCHECKED;
    }

    public boolean isBad() {
        return this.isEmpty && this.getSecurityStatus() == SecurityStatus.BOGUS;
    }

    public boolean isGood() {
        return !this.isEmpty && this.getSecurityStatus() == SecurityStatus.SECURE;
    }

    public void setBadReason(int edeReason, String reason) {
        this.edeReason = edeReason;
        this.badReason = reason;
    }

    JustifiedSecStatus validateKeyFor(SRRset set) {
        Name signerName = set.getSignerName();
        if (signerName == null) {
            if (set.getType() == 5 && set.getSecurityStatus() == SecurityStatus.SECURE) {
                return new JustifiedSecStatus(set.getSecurityStatus(), -1, null);
            }
            log.debug("No signerName for <{}/{}/{}>", set.getName(), DClass.string(set.getDClass()), Type.string(set.getType()));
            if (this.isNull()) {
                String reason = this.badReason;
                if (reason == null) {
                    reason = R.get("validate.insecure_unsigned", new Object[0]);
                }
                return new JustifiedSecStatus(SecurityStatus.INSECURE, this.edeReason, reason);
            }
            if (this.isGood()) {
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 10, R.get("validate.bogus.missingsig", new Object[0]));
            }
            return new JustifiedSecStatus(SecurityStatus.BOGUS, this.edeReason, R.get("validate.bogus", this.badReason));
        }
        if (this.isBad()) {
            return new JustifiedSecStatus(SecurityStatus.BOGUS, this.edeReason, R.get("validate.bogus.badkey", this.getName(), this.badReason));
        }
        if (this.isNull()) {
            String reason = this.badReason;
            if (reason == null) {
                reason = R.get("validate.insecure", new Object[0]);
            }
            return new JustifiedSecStatus(SecurityStatus.INSECURE, this.edeReason, reason);
        }
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyEntry)) {
            return false;
        }
        KeyEntry other = (KeyEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.edeReason != other.edeReason) {
            return false;
        }
        if (this.isEmpty != other.isEmpty) {
            return false;
        }
        String this$badReason = this.badReason;
        String other$badReason = other.badReason;
        return !(this$badReason == null ? other$badReason != null : !this$badReason.equals(other$badReason));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyEntry;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.edeReason;
        result = result * 59 + (this.isEmpty ? 79 : 97);
        String $badReason = this.badReason;
        result = result * 59 + ($badReason == null ? 43 : $badReason.hashCode());
        return result;
    }

    @Generated
    public List<Integer> getAlgo() {
        return this.algo;
    }
}

