/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.codahale;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.codahale.CodahaleOpStatsLogger;

public class CodahaleStatsLogger
implements StatsLogger {
    protected final String basename;
    final MetricRegistry metrics;

    CodahaleStatsLogger(MetricRegistry metrics, String basename) {
        this.metrics = metrics;
        this.basename = basename;
    }

    public OpStatsLogger getOpStatsLogger(String statName) {
        Timer success = this.metrics.timer(MetricRegistry.name((String)this.basename, (String[])new String[]{statName}));
        Timer failure = this.metrics.timer(MetricRegistry.name((String)this.basename, (String[])new String[]{statName + "-fail"}));
        return new CodahaleOpStatsLogger(success, failure);
    }

    public Counter getCounter(String statName) {
        final com.codahale.metrics.Counter c = this.metrics.counter(MetricRegistry.name((String)this.basename, (String[])new String[]{statName}));
        return new Counter(){

            public synchronized void clear() {
                long cur = c.getCount();
                c.dec(cur);
            }

            public Long get() {
                return c.getCount();
            }

            public void inc() {
                c.inc();
            }

            public void dec() {
                c.dec();
            }

            public void add(long delta) {
                c.inc(delta);
            }
        };
    }

    public <T extends Number> void registerGauge(String statName, final Gauge<T> gauge) {
        String metricName = MetricRegistry.name((String)this.basename, (String[])new String[]{statName});
        this.metrics.remove(metricName);
        this.metrics.register(metricName, (Metric)new com.codahale.metrics.Gauge<T>(){

            public T getValue() {
                return gauge.getSample();
            }
        });
    }

    public <T extends Number> void unregisterGauge(String statName, Gauge<T> gauge) {
    }

    public StatsLogger scope(String scope) {
        String scopeName = this.basename == null || 0 == this.basename.length() ? scope : MetricRegistry.name((String)this.basename, (String[])new String[]{scope});
        return new CodahaleStatsLogger(this.metrics, scopeName);
    }

    public void removeScope(String name, StatsLogger statsLogger) {
    }
}

