/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.InternalConfigSelector;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.Metadata;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsChannelFactory;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsNameResolverProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

final class XdsNameResolver
extends NameResolver {
    static final CallOptions.Key<String> CLUSTER_SELECTION_KEY = CallOptions.Key.create((String)"io.grpc.xds.CLUSTER_SELECTION_KEY");
    @VisibleForTesting
    static boolean enableTimeout = Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_TIMEOUT"));
    private final XdsLogger logger;
    private final String authority;
    private final NameResolver.ServiceConfigParser serviceConfigParser;
    private final SynchronizationContext syncContext;
    private final Bootstrapper bootstrapper;
    private final XdsChannelFactory channelFactory;
    private final XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory;
    private final ThreadSafeRandom random;
    private final ConcurrentMap<String, AtomicInteger> clusterRefs = new ConcurrentHashMap<String, AtomicInteger>();
    private final ConfigSelector configSelector = new ConfigSelector();
    private volatile List<EnvoyProtoData.Route> routes = Collections.emptyList();
    private NameResolver.Listener2 listener;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;

    XdsNameResolver(String name, NameResolver.ServiceConfigParser serviceConfigParser, SynchronizationContext syncContext, XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory) {
        this(name, serviceConfigParser, syncContext, Bootstrapper.getInstance(), XdsChannelFactory.getInstance(), xdsClientPoolFactory, ThreadSafeRandom.ThreadSafeRandomImpl.instance);
    }

    @VisibleForTesting
    XdsNameResolver(String name, NameResolver.ServiceConfigParser serviceConfigParser, SynchronizationContext syncContext, Bootstrapper bootstrapper, XdsChannelFactory channelFactory, XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory, ThreadSafeRandom random) {
        this.authority = GrpcUtil.checkAuthority((String)((String)Preconditions.checkNotNull((Object)name, (Object)"name")));
        this.serviceConfigParser = (NameResolver.ServiceConfigParser)Preconditions.checkNotNull((Object)serviceConfigParser, (Object)"serviceConfigParser");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.bootstrapper = (Bootstrapper)Preconditions.checkNotNull((Object)bootstrapper, (Object)"bootstrapper");
        this.channelFactory = (XdsChannelFactory)Preconditions.checkNotNull((Object)channelFactory, (Object)"channelFactory");
        this.xdsClientPoolFactory = (XdsNameResolverProvider.XdsClientPoolFactory)Preconditions.checkNotNull((Object)xdsClientPoolFactory, (Object)"xdsClientPoolFactory");
        this.random = (ThreadSafeRandom)Preconditions.checkNotNull((Object)random, (Object)"random");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"xds-resolver", (String)name));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created resolver for {0}", name);
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    public void start(NameResolver.Listener2 listener) {
        XdsClient.XdsChannel channel;
        Bootstrapper.BootstrapInfo bootstrapInfo;
        this.listener = (NameResolver.Listener2)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        try {
            bootstrapInfo = this.bootstrapper.readBootstrap();
            channel = this.channelFactory.createChannel(bootstrapInfo.getServers());
        }
        catch (Exception e) {
            listener.onError(Status.UNAVAILABLE.withDescription("Failed to initialize xDS").withCause((Throwable)e));
            return;
        }
        this.xdsClientPool = this.xdsClientPoolFactory.newXdsClientObjectPool(bootstrapInfo, channel);
        this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        this.xdsClient.watchConfigData(this.authority, new ConfigWatcherImpl());
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        if (this.xdsClient != null) {
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    @VisibleForTesting
    static Map<String, ?> generateServiceConfigWithMethodTimeoutConfig(long timeoutNano) {
        String timeout = (double)timeoutNano / 1.0E9 + "s";
        HashMap<String, Object> methodConfig = new HashMap<String, Object>();
        methodConfig.put("name", Collections.singletonList(Collections.emptyMap()));
        methodConfig.put("timeout", timeout);
        return Collections.singletonMap("methodConfig", Collections.singletonList(Collections.unmodifiableMap(methodConfig)));
    }

    @VisibleForTesting
    static Map<String, ?> generateServiceConfigWithLoadBalancingConfig(Collection<String> clusters) {
        HashMap<String, Map<String, List<Map<String, Map<String, String>>>>> childPolicy = new HashMap<String, Map<String, List<Map<String, Map<String, String>>>>>();
        for (String cluster : clusters) {
            List<Map<String, Map<String, String>>> lbPolicy = Collections.singletonList(Collections.singletonMap("cds_experimental", Collections.singletonMap("cluster", cluster)));
            childPolicy.put(cluster, Collections.singletonMap("lbPolicy", lbPolicy));
        }
        return Collections.singletonMap("loadBalancingConfig", Collections.singletonList(Collections.singletonMap("cluster_manager_experimental", Collections.singletonMap("childPolicy", Collections.unmodifiableMap(childPolicy)))));
    }

    @VisibleForTesting
    XdsClient getXdsClient() {
        return this.xdsClient;
    }

    private void updateResolutionResult() {
        Map<String, ?> rawServiceConfig = XdsNameResolver.generateServiceConfigWithLoadBalancingConfig(this.clusterRefs.keySet());
        if (this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Generated service config:\n{0}", new Gson().toJson(rawServiceConfig));
        }
        NameResolver.ConfigOrError parsedServiceConfig = this.serviceConfigParser.parseServiceConfig(rawServiceConfig);
        Attributes attrs = Attributes.newBuilder().set(XdsAttributes.XDS_CLIENT_POOL, this.xdsClientPool).set(InternalConfigSelector.KEY, (Object)this.configSelector).build();
        NameResolver.ResolutionResult result = NameResolver.ResolutionResult.newBuilder().setAttributes(attrs).setServiceConfig(parsedServiceConfig).build();
        this.listener.onResult(result);
    }

    private class ConfigWatcherImpl
    implements XdsClient.ConfigWatcher {
        private Set<String> existingClusters;

        private ConfigWatcherImpl() {
        }

        @Override
        public void onConfigChanged(XdsClient.ConfigUpdate update) {
            Sets.SetView clusters = new HashSet();
            for (EnvoyProtoData.Route route : update.getRoutes()) {
                EnvoyProtoData.RouteAction action = route.getRouteAction();
                if (action.getCluster() != null) {
                    clusters.add(action.getCluster());
                    continue;
                }
                if (action.getWeightedCluster() == null) continue;
                for (EnvoyProtoData.ClusterWeight weighedCluster : action.getWeightedCluster()) {
                    clusters.add(weighedCluster.getName());
                }
            }
            Sets.SetView addedClusters = this.existingClusters == null ? clusters : Sets.difference(clusters, this.existingClusters);
            Sets.SetView deletedClusters = this.existingClusters == null ? Collections.emptySet() : Sets.difference(this.existingClusters, (Set)clusters);
            this.existingClusters = clusters;
            boolean shouldUpdateResult = false;
            for (String cluster : addedClusters) {
                if (XdsNameResolver.this.clusterRefs.containsKey(cluster)) {
                    ((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).incrementAndGet();
                    continue;
                }
                XdsNameResolver.this.clusterRefs.put(cluster, new AtomicInteger(1));
                shouldUpdateResult = true;
            }
            if (shouldUpdateResult) {
                XdsNameResolver.this.updateResolutionResult();
            }
            XdsNameResolver.this.routes = update.getRoutes();
            shouldUpdateResult = false;
            for (String cluster : deletedClusters) {
                int count = ((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).decrementAndGet();
                if (count != 0) continue;
                XdsNameResolver.this.clusterRefs.remove(cluster);
                shouldUpdateResult = true;
            }
            if (shouldUpdateResult) {
                XdsNameResolver.this.updateResolutionResult();
            }
        }

        @Override
        public void onResourceDoesNotExist(String resourceName) {
            XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Resource {0} is unavailable", resourceName);
            NameResolver.ConfigOrError parsedServiceConfig = XdsNameResolver.this.serviceConfigParser.parseServiceConfig(Collections.emptyMap());
            NameResolver.ResolutionResult result = NameResolver.ResolutionResult.newBuilder().setServiceConfig(parsedServiceConfig).build();
            XdsNameResolver.this.listener.onResult(result);
        }

        @Override
        public void onError(Status error) {
            XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}", XdsNameResolver.this.xdsClient, error.getDescription());
            XdsNameResolver.this.listener.onError(error);
        }
    }

    private final class ConfigSelector
    extends InternalConfigSelector {
        private ConfigSelector() {
        }

        public InternalConfigSelector.Result selectConfig(LoadBalancer.PickSubchannelArgs args) {
            NameResolver.ConfigOrError parsedServiceConfig;
            Object config;
            HashMap<String, Iterable<String>> asciiHeaders = new HashMap<String, Iterable<String>>();
            Metadata headers = args.getHeaders();
            for (String headerName : headers.keys()) {
                if (headerName.endsWith("-bin")) continue;
                Metadata.Key key = Metadata.Key.of((String)headerName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                asciiHeaders.put(headerName, headers.getAll(key));
            }
            String cluster = null;
            EnvoyProtoData.Route selectedRoute = null;
            block1: do {
                for (EnvoyProtoData.Route route : XdsNameResolver.this.routes) {
                    if (!route.getRouteMatch().matches("/" + args.getMethodDescriptor().getFullMethodName(), asciiHeaders)) continue;
                    selectedRoute = route;
                    break;
                }
                if (selectedRoute == null) {
                    return InternalConfigSelector.Result.forError((Status)Status.UNAVAILABLE.withDescription("Could not find xDS route matching RPC"));
                }
                EnvoyProtoData.RouteAction action = selectedRoute.getRouteAction();
                if (action.getCluster() != null) {
                    cluster = action.getCluster();
                    continue;
                }
                if (action.getWeightedCluster() == null) continue;
                int totalWeight = 0;
                for (EnvoyProtoData.ClusterWeight weightedCluster : action.getWeightedCluster()) {
                    totalWeight += weightedCluster.getWeight();
                }
                int select = XdsNameResolver.this.random.nextInt(totalWeight);
                int accumulator = 0;
                for (EnvoyProtoData.ClusterWeight weightedCluster : action.getWeightedCluster()) {
                    if (select >= (accumulator += weightedCluster.getWeight())) continue;
                    cluster = weightedCluster.getName();
                    continue block1;
                }
            } while (!this.retainCluster(cluster));
            Map<Object, Object> rawServiceConfig = Collections.emptyMap();
            if (enableTimeout) {
                rawServiceConfig = XdsNameResolver.generateServiceConfigWithMethodTimeoutConfig(selectedRoute.getRouteAction().getTimeoutNano());
            }
            if ((config = (parsedServiceConfig = XdsNameResolver.this.serviceConfigParser.parseServiceConfig(rawServiceConfig)).getConfig()) == null) {
                this.releaseCluster(cluster);
                return InternalConfigSelector.Result.forError((Status)parsedServiceConfig.getError().augmentDescription("Failed to parse service config (method config)"));
            }
            final String finalCluster = cluster;
            class SelectionCompleted
            implements Runnable {
                SelectionCompleted() {
                }

                @Override
                public void run() {
                    ConfigSelector.this.releaseCluster(finalCluster);
                }
            }
            return InternalConfigSelector.Result.newBuilder().setCallOptions(args.getCallOptions().withOption(CLUSTER_SELECTION_KEY, (Object)cluster)).setConfig(config).setCommittedCallback((Runnable)new SelectionCompleted()).build();
        }

        private boolean retainCluster(String cluster) {
            int count;
            AtomicInteger refCount = (AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster);
            if (refCount == null) {
                return false;
            }
            do {
                if ((count = refCount.get()) != 0) continue;
                return false;
            } while (!refCount.compareAndSet(count, count + 1));
            return true;
        }

        private void releaseCluster(final String cluster) {
            int count = ((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).decrementAndGet();
            if (count == 0) {
                XdsNameResolver.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).get() == 0) {
                            XdsNameResolver.this.clusterRefs.remove(cluster);
                            XdsNameResolver.this.updateResolutionResult();
                        }
                    }
                });
            }
        }
    }
}

