/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector.http;

import com.google.common.annotations.Beta;
import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.effector.AddEffector;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.collections.Jsonya;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.http.auth.Credentials;
import org.apache.brooklyn.util.http.auth.UsernamePassword;
import org.apache.brooklyn.util.http.executor.HttpConfig;
import org.apache.brooklyn.util.http.executor.HttpExecutor;
import org.apache.brooklyn.util.http.executor.HttpRequest;
import org.apache.brooklyn.util.http.executor.HttpResponse;
import org.apache.brooklyn.util.http.executor.apacheclient.HttpExecutorImpl;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class HttpCommandEffector
extends AddEffector {
    private static final Logger LOG = LoggerFactory.getLogger(HttpCommandEffector.class);
    public static final ConfigKey<String> EFFECTOR_URI = ConfigKeys.newStringConfigKey("uri");
    public static final ConfigKey<String> EFFECTOR_HTTP_VERB = ConfigKeys.newStringConfigKey("httpVerb");
    public static final ConfigKey<String> EFFECTOR_HTTP_USERNAME = ConfigKeys.newStringConfigKey("httpUsername");
    public static final ConfigKey<String> EFFECTOR_HTTP_PASSWORD = ConfigKeys.newStringConfigKey("httpPassword");
    public static final ConfigKey<Map<String, String>> EFFECTOR_HTTP_HEADERS = new MapConfigKey<String>(String.class, "headers");
    public static final ConfigKey<Object> EFFECTOR_HTTP_PAYLOAD = ConfigKeys.newConfigKey(Object.class, "httpPayload");
    public static final ConfigKey<String> JSON_PATH = ConfigKeys.newStringConfigKey("jsonPath", "JSON path to select in HTTP response");
    public static final ConfigKey<Map<String, String>> JSON_PATHS_AND_SENSORS = new MapConfigKey<String>(String.class, "jsonPathAndSensors", "json path selector and corresponding sensor name that will publish the json path extracted value");
    @Deprecated
    public static final ConfigKey<String> PUBLISH_SENSOR = ConfigKeys.newStringConfigKey("publishSensor", "Sensor name where to store json path extracted value");
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_X_WWW_FORM_URLENCODE = "application/x-www-form-urlencoded";

    public HttpCommandEffector(ConfigBag params) {
        super(HttpCommandEffector.newEffectorBuilder(params).build());
    }

    public static Effectors.EffectorBuilder<String> newEffectorBuilder(ConfigBag params) {
        Effectors.EffectorBuilder<String> eff = AddEffector.newEffectorBuilder(String.class, params);
        eff.impl(new Body(eff.buildAbstract(), params));
        return eff;
    }

    protected static class Body
    extends EffectorBody<String> {
        private final Effector<?> effector;
        private final ConfigBag params;

        public Body(Effector<?> eff, ConfigBag params) {
            this.effector = eff;
            Preconditions.checkNotNull((Object)params.getAllConfigRaw().get(EFFECTOR_URI.getName()), (Object)"uri must be supplied when defining this effector");
            Preconditions.checkNotNull((Object)params.getAllConfigRaw().get(EFFECTOR_HTTP_VERB.getName()), (Object)"HTTP verb must be supplied when defining this effector");
            this.params = params;
        }

        @Override
        public String call(ConfigBag params) {
            ConfigBag allConfig = ConfigBag.newInstanceCopying(this.params).putAll(params);
            URI uri = this.convertToURI(EntityInitializers.resolve(allConfig, EFFECTOR_URI));
            String httpVerb = this.isValidHttpVerb(EntityInitializers.resolve(allConfig, EFFECTOR_HTTP_VERB));
            String httpUsername = EntityInitializers.resolve(allConfig, EFFECTOR_HTTP_USERNAME);
            String httpPassword = EntityInitializers.resolve(allConfig, EFFECTOR_HTTP_PASSWORD);
            Map<String, String> headers = EntityInitializers.resolve(allConfig, EFFECTOR_HTTP_HEADERS);
            Object payload = EntityInitializers.resolve(allConfig, EFFECTOR_HTTP_PAYLOAD);
            String jsonPath = EntityInitializers.resolve(allConfig, JSON_PATH);
            String publishSensor = EntityInitializers.resolve(allConfig, PUBLISH_SENSOR);
            Map<String, String> pathsAndSensors = EntityInitializers.resolve(allConfig, JSON_PATHS_AND_SENSORS);
            if (!Strings.isEmpty((CharSequence)jsonPath) && !pathsAndSensors.isEmpty()) {
                throw new IllegalArgumentException("Both jsonPath and pathsAndSensors are defined, please pick just one to resolve the ambiguity");
            }
            HttpExecutorImpl httpExecutor = HttpExecutorImpl.newInstance();
            HttpRequest request = this.buildHttpRequest(httpVerb, uri, headers, httpUsername, httpPassword, payload);
            Task<Object> t = Tasks.builder().displayName(this.effector.getName()).body(new Callable<Object>((HttpExecutor)httpExecutor, request){
                final /* synthetic */ HttpExecutor val$httpExecutor;
                final /* synthetic */ HttpRequest val$request;
                {
                    this.val$httpExecutor = httpExecutor;
                    this.val$request = httpRequest;
                }

                @Override
                public Object call() throws Exception {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try {
                        HttpResponse response = this.val$httpExecutor.execute(this.val$request);
                        this.validateResponse(response);
                        ByteStreams.copy((InputStream)response.getContent(), (OutputStream)out);
                        return new String(out.toByteArray());
                    }
                    catch (IOException e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }
            }).build();
            String responseBody = (String)this.queue(t).getUnchecked();
            if (jsonPath != null) {
                String extractedValue = (String)JsonPath.parse((String)responseBody).read(jsonPath, String.class, new Predicate[0]);
                if (publishSensor != null) {
                    LOG.warn("`publishSensor` configuration key is deprecated. PLease prefer `pathsAndSensors`, instead");
                    this.entity().sensors().set(Sensors.newStringSensor(publishSensor), extractedValue);
                }
                return extractedValue;
            }
            if (!pathsAndSensors.isEmpty()) {
                for (String path : pathsAndSensors.keySet()) {
                    String jsonPathValue = (String)JsonPath.parse((String)responseBody).read(path, String.class, new Predicate[0]);
                    this.entity().sensors().set(Sensors.newStringSensor(pathsAndSensors.get(path)), jsonPathValue);
                }
            }
            return responseBody;
        }

        private URI convertToURI(String url) {
            try {
                return new URL(url).toURI();
            }
            catch (MalformedURLException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            catch (URISyntaxException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        private void validateResponse(HttpResponse response) {
            int statusCode = response.code();
            if (statusCode == 401) {
                throw new RuntimeException("Authorization exception");
            }
            if (statusCode == 404) {
                throw new RuntimeException("Resource not found");
            }
            if (statusCode >= 500) {
                throw new RuntimeException("Server error");
            }
        }

        private HttpRequest buildHttpRequest(String httpVerb, URI uri, Map<String, String> headers, String httpUsername, String httpPassword, Object payload) {
            HttpRequest.Builder httpRequestBuilder = new HttpRequest.Builder().uri(uri).method(httpVerb).config(HttpConfig.builder().trustSelfSigned(true).trustAll(true).laxRedirect(true).build());
            if (headers != null) {
                httpRequestBuilder.headers(headers);
            }
            if (payload != null) {
                String body = "";
                String contentType = headers.get("Content-Type");
                if (contentType == null || contentType.equalsIgnoreCase(HttpCommandEffector.APPLICATION_JSON)) {
                    LOG.warn("Content-Type not specified. Using {}, as default (continuing)", (Object)HttpCommandEffector.APPLICATION_JSON);
                    body = this.toJsonString(payload);
                } else if (contentType.equalsIgnoreCase(HttpCommandEffector.APPLICATION_X_WWW_FORM_URLENCODE)) {
                    if (payload instanceof Map) {
                        for (Map.Entry entry : ((Map)payload).entrySet()) {
                            try {
                                if (!body.equals("")) {
                                    body = body + "&";
                                }
                                body = body + URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8.toString()) + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8.toString());
                            }
                            catch (UnsupportedEncodingException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                    }
                } else if (!contentType.equalsIgnoreCase(HttpCommandEffector.APPLICATION_X_WWW_FORM_URLENCODE) && !contentType.equalsIgnoreCase(HttpCommandEffector.APPLICATION_JSON)) {
                    LOG.warn("the http request may fail with payload {} and 'Content-Type= {}, (continuing)", payload, (Object)contentType);
                    body = payload.toString();
                }
                httpRequestBuilder.body(body.getBytes());
            }
            if (httpUsername != null && httpPassword != null) {
                httpRequestBuilder.credentials((Credentials)new UsernamePassword(httpUsername, httpPassword));
            }
            return httpRequestBuilder.build();
        }

        private String isValidHttpVerb(String httpVerb) {
            Optional state = Enums.getIfPresent(HttpVerb.class, (String)httpVerb.toUpperCase());
            Preconditions.checkArgument((boolean)state.isPresent(), (String)"Expected one of %s but was %s", (Object[])new Object[]{Joiner.on((char)',').join((Object[])HttpVerb.values()), httpVerb});
            return httpVerb;
        }

        private String toJsonString(Object payload) {
            return Jsonya.newInstance().add(payload, new Object[0]).toString();
        }
    }

    private static enum HttpVerb {
        GET,
        HEAD,
        POST,
        PUT,
        PATCH,
        DELETE,
        OPTIONS,
        TRACE;

    }
}

