/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1;

import com.google.common.annotations.Beta;
import com.google.inject.Provides;
import java.io.Closeable;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.location.Region;
import org.jclouds.location.functions.RegionToEndpoint;
import org.jclouds.openstack.swift.v1.features.AccountApi;
import org.jclouds.openstack.swift.v1.features.BulkApi;
import org.jclouds.openstack.swift.v1.features.ContainerApi;
import org.jclouds.openstack.swift.v1.features.DynamicLargeObjectApi;
import org.jclouds.openstack.swift.v1.features.ObjectApi;
import org.jclouds.openstack.swift.v1.features.StaticLargeObjectApi;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.EndpointParam;

@Beta
public interface SwiftApi
extends Closeable {
    @Provides
    @Region
    public Set<String> getConfiguredRegions();

    @Delegate
    public AccountApi getAccountApi(@EndpointParam(parser=RegionToEndpoint.class) String var1);

    @Delegate
    public BulkApi getBulkApi(@EndpointParam(parser=RegionToEndpoint.class) String var1);

    @Delegate
    public ContainerApi getContainerApi(@EndpointParam(parser=RegionToEndpoint.class) String var1);

    @Delegate
    @Path(value="/{containerName}")
    public ObjectApi getObjectApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="containerName") String var2);

    @Delegate
    @Path(value="/{containerName}")
    public StaticLargeObjectApi getStaticLargeObjectApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="containerName") String var2);

    @Delegate
    @Path(value="/{containerName}")
    public DynamicLargeObjectApi getDynamicLargeObjectApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="containerName") String var2);
}

