/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderTokenIssuer;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsCreateModes;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSOpsCountStatistics;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.HdfsKMSUtil;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.web.ByteRangeInputStream;
import org.apache.hadoop.hdfs.web.JsonUtilClient;
import org.apache.hadoop.hdfs.web.TokenAspect;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.hdfs.web.resources.AccessTimeParam;
import org.apache.hadoop.hdfs.web.resources.AclPermissionParam;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.ConcatSourcesParam;
import org.apache.hadoop.hdfs.web.resources.CreateFlagParam;
import org.apache.hadoop.hdfs.web.resources.CreateParentParam;
import org.apache.hadoop.hdfs.web.resources.DelegationParam;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.DestinationParam;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.ECPolicyParam;
import org.apache.hadoop.hdfs.web.resources.ExcludeDatanodesParam;
import org.apache.hadoop.hdfs.web.resources.FsActionParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.GroupParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.ModificationTimeParam;
import org.apache.hadoop.hdfs.web.resources.NewLengthParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OldSnapshotNameParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.OwnerParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RecursiveParam;
import org.apache.hadoop.hdfs.web.resources.RenameOptionSetParam;
import org.apache.hadoop.hdfs.web.resources.RenewerParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.SnapshotNameParam;
import org.apache.hadoop.hdfs.web.resources.StartAfterParam;
import org.apache.hadoop.hdfs.web.resources.StoragePolicyParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.hdfs.web.resources.UnmaskedPermissionParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.hdfs.web.resources.XAttrEncodingParam;
import org.apache.hadoop.hdfs.web.resources.XAttrNameParam;
import org.apache.hadoop.hdfs.web.resources.XAttrSetFlagParam;
import org.apache.hadoop.hdfs.web.resources.XAttrValueParam;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.DelegationTokenIssuer;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Charsets;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.javax.ws.rs.core.MediaType;
import org.apache.hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.shaded.org.apache.commons.io.input.BoundedInputStream;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.hadoop.util.KMSUtil;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHdfsFileSystem
extends FileSystem
implements DelegationTokenRenewer.Renewable,
TokenAspect.TokenManagementDelegator,
KeyProviderTokenIssuer {
    public static final Logger LOG = LoggerFactory.getLogger(WebHdfsFileSystem.class);
    public static final int VERSION = 1;
    public static final String PATH_PREFIX = "/webhdfs/v1";
    public static final String EZ_HEADER = "X-Hadoop-Accept-EZ";
    public static final String FEFINFO_HEADER = "X-Hadoop-feInfo";
    protected URLConnectionFactory connectionFactory;
    @VisibleForTesting
    public static final String CANT_FALLBACK_TO_INSECURE_MSG = "The client is configured to only allow connecting to secure cluster";
    private boolean canRefreshDelegationToken;
    private UserGroupInformation ugi;
    private URI uri;
    private Token<?> delegationToken;
    protected Text tokenServiceName;
    private RetryPolicy retryPolicy = null;
    private Path workingDir;
    private Path cachedHomeDirectory;
    private InetSocketAddress[] nnAddrs;
    private int currentNNAddrIndex;
    private boolean disallowFallbackToInsecureCluster;
    private String restCsrfCustomHeader;
    private Set<String> restCsrfMethodsToIgnore;
    private DFSOpsCountStatistics storageStatistics;
    private KeyProvider testProvider;
    TokenSelector<DelegationTokenIdentifier> tokenSelector = new AbstractDelegationTokenSelector<DelegationTokenIdentifier>(this.getTokenKind()){};
    private static final String OFFSET_PARAM_PREFIX = "offset=";
    private static final byte[] EMPTY_ARRAY = new byte[0];

    @Override
    public String getScheme() {
        return "webhdfs";
    }

    protected String getTransportScheme() {
        return "http";
    }

    protected Text getTokenKind() {
        return WebHdfsConstants.WEBHDFS_TOKEN_KIND;
    }

    @Override
    public synchronized void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        UserParam.setUserPattern(conf.get("dfs.webhdfs.user.provider.user.pattern", "^[A-Za-z_][A-Za-z0-9._-]*[$]?$"));
        AclPermissionParam.setAclPermissionPattern(conf.get("dfs.webhdfs.acl.provider.permission.pattern", "^(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?(,(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?)*$"));
        int connectTimeout = (int)conf.getTimeDuration("dfs.webhdfs.socket.connect-timeout", 60000L, TimeUnit.MILLISECONDS);
        int readTimeout = (int)conf.getTimeDuration("dfs.webhdfs.socket.read-timeout", 60000L, TimeUnit.MILLISECONDS);
        boolean isOAuth = conf.getBoolean("dfs.webhdfs.oauth2.enabled", false);
        if (isOAuth) {
            LOG.debug("Enabling OAuth2 in WebHDFS");
            this.connectionFactory = URLConnectionFactory.newOAuth2URLConnectionFactory(connectTimeout, readTimeout, conf);
        } else {
            LOG.debug("Not enabling OAuth2 in WebHDFS");
            this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory(connectTimeout, readTimeout, conf);
        }
        this.ugi = UserGroupInformation.getCurrentUser();
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.nnAddrs = this.resolveNNAddr();
        boolean isHA = HAUtilClient.isClientFailoverConfigured(conf, this.uri);
        boolean isLogicalUri = isHA && HAUtilClient.isLogicalUri(conf, this.uri);
        Text text = this.tokenServiceName = isLogicalUri ? HAUtilClient.buildTokenServiceForLogicalUri(uri, this.getScheme()) : SecurityUtil.buildTokenService(this.getCanonicalUri());
        if (!isHA) {
            this.retryPolicy = RetryUtils.getDefaultRetryPolicy(conf, "dfs.http.client.retry.policy.enabled", false, "dfs.http.client.retry.policy.spec", "10000,6,60000,10", "org.apache.hadoop.hdfs.server.namenode.SafeModeException");
        } else {
            int maxFailoverAttempts = conf.getInt("dfs.http.client.failover.max.attempts", 15);
            int maxRetryAttempts = conf.getInt("dfs.http.client.retry.max.attempts", 10);
            int failoverSleepBaseMillis = conf.getInt("dfs.http.client.failover.sleep.base.millis", 500);
            int failoverSleepMaxMillis = conf.getInt("dfs.http.client.failover.sleep.max.millis", 15000);
            this.retryPolicy = RetryPolicies.failoverOnNetworkException(RetryPolicies.TRY_ONCE_THEN_FAIL, maxFailoverAttempts, maxRetryAttempts, failoverSleepBaseMillis, failoverSleepMaxMillis);
        }
        this.workingDir = this.makeQualified(new Path(WebHdfsFileSystem.getHomeDirectoryString(this.ugi)));
        this.canRefreshDelegationToken = UserGroupInformation.isSecurityEnabled();
        this.disallowFallbackToInsecureCluster = !conf.getBoolean("ipc.client.fallback-to-simple-auth-allowed", false);
        this.initializeRestCsrf(conf);
        this.delegationToken = null;
        this.storageStatistics = (DFSOpsCountStatistics)GlobalStorageStatistics.INSTANCE.put("DFSOpsCountStatistics", new GlobalStorageStatistics.StorageStatisticsProvider(){

            @Override
            public StorageStatistics provide() {
                return new DFSOpsCountStatistics();
            }
        });
    }

    private void initializeRestCsrf(Configuration conf) {
        if (conf.getBoolean("dfs.webhdfs.rest-csrf.enabled", false)) {
            this.restCsrfCustomHeader = conf.getTrimmed("dfs.webhdfs.rest-csrf.custom-header", "X-XSRF-HEADER");
            this.restCsrfMethodsToIgnore = new HashSet<String>();
            this.restCsrfMethodsToIgnore.addAll(WebHdfsFileSystem.getTrimmedStringList(conf, "dfs.webhdfs.rest-csrf.methods-to-ignore", "GET,OPTIONS,HEAD,TRACE"));
        } else {
            this.restCsrfCustomHeader = null;
            this.restCsrfMethodsToIgnore = null;
        }
    }

    private static List<String> getTrimmedStringList(Configuration conf, String name, String defaultValue) {
        String valueString = conf.get(name, defaultValue);
        if (valueString == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(StringUtils.getTrimmedStringCollection(valueString));
    }

    @Override
    public URI getCanonicalUri() {
        return super.getCanonicalUri();
    }

    protected synchronized Token<?> getDelegationToken() throws IOException {
        if (this.delegationToken == null) {
            Token<DelegationTokenIdentifier> token = this.tokenSelector.selectToken(new Text(this.getCanonicalServiceName()), this.ugi.getTokens());
            if (token != null) {
                LOG.debug("Using UGI token: {}", token);
                this.canRefreshDelegationToken = false;
            } else if (this.canRefreshDelegationToken) {
                token = this.getDelegationToken(null);
                if (token != null) {
                    LOG.debug("Fetched new token: {}", token);
                } else {
                    this.canRefreshDelegationToken = false;
                }
            }
            this.setDelegationToken(token);
        }
        return this.delegationToken;
    }

    @VisibleForTesting
    synchronized boolean replaceExpiredDelegationToken() throws IOException {
        boolean replaced = false;
        if (this.canRefreshDelegationToken) {
            Token<DelegationTokenIdentifier> token = this.getDelegationToken(null);
            LOG.debug("Replaced expired token: {}", token);
            this.setDelegationToken(token);
            replaced = token != null;
        }
        return replaced;
    }

    @Override
    protected int getDefaultPort() {
        return 9870;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    protected URI canonicalizeUri(URI uri) {
        return NetUtils.getCanonicalUri(uri, this.getDefaultPort());
    }

    @Deprecated
    public static String getHomeDirectoryString(UserGroupInformation ugi) {
        return "/user/" + ugi.getShortUserName();
    }

    @Override
    public Path getHomeDirectory() {
        if (this.cachedHomeDirectory == null) {
            GetOpParam.Op op = GetOpParam.Op.GETHOMEDIRECTORY;
            try {
                String pathFromDelegatedFS = (String)new FsPathResponseRunner<String>((HttpOpParam.Op)op, null, new Param[]{new UserParam(this.ugi)}){

                    @Override
                    String decodeResponse(Map<?, ?> json) throws IOException {
                        return JsonUtilClient.getPath(json);
                    }
                }.run();
                this.cachedHomeDirectory = new Path(pathFromDelegatedFS).makeQualified(this.getUri(), null);
            }
            catch (IOException e) {
                LOG.error("Unable to get HomeDirectory from original File System", (Throwable)e);
                this.cachedHomeDirectory = new Path("/user/" + this.ugi.getShortUserName()).makeQualified(this.getUri(), null);
            }
        }
        return this.cachedHomeDirectory;
    }

    @Override
    public synchronized Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public synchronized void setWorkingDirectory(Path dir) {
        Path absolutePath = this.makeAbsolute(dir);
        String result = absolutePath.toUri().getPath();
        if (!DFSUtilClient.isValidName(result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = absolutePath;
    }

    private Path makeAbsolute(Path f) {
        return f.isAbsolute() ? f : new Path(this.workingDir, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<?, ?> jsonParse(HttpURLConnection c, boolean useErrorStream) throws IOException {
        InputStream in;
        if (c.getContentLength() == 0) {
            return null;
        }
        InputStream inputStream = in = useErrorStream ? c.getErrorStream() : c.getInputStream();
        if (in == null) {
            throw new IOException("The " + (useErrorStream ? "error" : "input") + " stream is null.");
        }
        try {
            MediaType parsed;
            String contentType = c.getContentType();
            if (contentType != null && !MediaType.APPLICATION_JSON_TYPE.isCompatible(parsed = MediaType.valueOf((String)contentType))) {
                throw new IOException("Content-Type \"" + contentType + "\" is incompatible with \"" + "application/json" + "\" (parsed=\"" + parsed + "\")");
            }
            Map map = (Map)JsonSerialization.mapReader().readValue(in);
            return map;
        }
        finally {
            in.close();
        }
    }

    private static Map<?, ?> validateResponse(HttpOpParam.Op op, HttpURLConnection conn, boolean unwrapException) throws IOException {
        int code = conn.getResponseCode();
        if (code == 401) {
            throw new AccessControlException(conn.getResponseMessage());
        }
        if (code != op.getExpectedHttpResponseCode()) {
            Map<?, ?> m;
            try {
                m = WebHdfsFileSystem.jsonParse(conn, true);
            }
            catch (Exception e) {
                throw new IOException("Unexpected HTTP response: code=" + code + " != " + op.getExpectedHttpResponseCode() + ", " + op.toQueryString() + ", message=" + conn.getResponseMessage(), e);
            }
            if (m == null) {
                throw new IOException("Unexpected HTTP response: code=" + code + " != " + op.getExpectedHttpResponseCode() + ", " + op.toQueryString() + ", message=" + conn.getResponseMessage());
            }
            if (m.get(RemoteException.class.getSimpleName()) == null) {
                return m;
            }
            IOException re = JsonUtilClient.toRemoteException(m);
            if (re.getMessage() != null && re.getMessage().endsWith(StandbyException.class.getSimpleName())) {
                LOG.trace("Detected StandbyException", (Throwable)re);
                throw new IOException(re);
            }
            if (re.getMessage() != null && re.getMessage().startsWith("Failed to obtain user group information:")) {
                String[] parts = re.getMessage().split(":\\s+", 3);
                re = new RemoteException(parts[1], parts[2]);
                re = re.unwrapRemoteException(SecretManager.InvalidToken.class);
            }
            throw unwrapException ? WebHdfsFileSystem.toIOException(re) : re;
        }
        return null;
    }

    private static IOException toIOException(Exception e) {
        if (!(e instanceof IOException)) {
            return new IOException(e);
        }
        IOException ioe = (IOException)e;
        if (!(ioe instanceof RemoteException)) {
            return ioe;
        }
        return ((RemoteException)ioe).unwrapRemoteException();
    }

    private synchronized InetSocketAddress getCurrentNNAddr() {
        return this.nnAddrs[this.currentNNAddrIndex];
    }

    private synchronized void resetStateToFailOver() {
        this.currentNNAddrIndex = (this.currentNNAddrIndex + 1) % this.nnAddrs.length;
    }

    private URL getNamenodeURL(String path, String query) throws IOException {
        InetSocketAddress nnAddr = this.getCurrentNNAddr();
        URL url = new URL(this.getTransportScheme(), nnAddr.getHostName(), nnAddr.getPort(), path + '?' + query);
        LOG.trace("url={}", (Object)url);
        return url;
    }

    Param<?, ?>[] getAuthParameters(HttpOpParam.Op op) throws IOException {
        ArrayList authParams = Lists.newArrayList();
        Token<?> token = null;
        if (!op.getRequireAuth()) {
            token = this.getDelegationToken();
        }
        if (token != null) {
            authParams.add(new DelegationParam(token.encodeToUrlString()));
        } else {
            UserGroupInformation userUgi = this.ugi;
            UserGroupInformation realUgi = userUgi.getRealUser();
            if (realUgi != null) {
                authParams.add(new DoAsParam(userUgi.getShortUserName()));
                userUgi = realUgi;
            }
            authParams.add(new UserParam(userUgi.getShortUserName()));
        }
        return authParams.toArray(new Param[0]);
    }

    URL toUrl(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
        String path = PATH_PREFIX + (fspath == null ? "/" : this.makeQualified(fspath).toUri().getRawPath());
        String query = op.toQueryString() + Param.toSortedString("&", this.getAuthParameters(op)) + Param.toSortedString("&", parameters);
        URL url = this.getNamenodeURL(path, query);
        LOG.trace("url={}", (Object)url);
        return url;
    }

    private FsPermission applyUMask(FsPermission permission) {
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        return FsCreateModes.applyUMask(permission, FsPermission.getUMask(this.getConf()));
    }

    private HdfsFileStatus getHdfsFileStatus(Path f) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETFILESTATUS;
        HdfsFileStatus status = (HdfsFileStatus)new FsPathResponseRunner<HdfsFileStatus>((HttpOpParam.Op)op, f, new Param[0]){

            @Override
            HdfsFileStatus decodeResponse(Map<?, ?> json) {
                return JsonUtilClient.toFileStatus(json, true);
            }
        }.run();
        if (status == null) {
            throw new FileNotFoundException("File does not exist: " + f);
        }
        return status;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_FILE_STATUS);
        return this.getHdfsFileStatus(f).makeQualified(this.getUri(), f);
    }

    @Override
    public AclStatus getAclStatus(Path f) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETACLSTATUS;
        AclStatus status = (AclStatus)new FsPathResponseRunner<AclStatus>((HttpOpParam.Op)op, f, new Param[0]){

            @Override
            AclStatus decodeResponse(Map<?, ?> json) {
                return JsonUtilClient.toAclStatus(json);
            }
        }.run();
        if (status == null) {
            throw new FileNotFoundException("File does not exist: " + f);
        }
        return status;
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.MKDIRS);
        PutOpParam.Op op = PutOpParam.Op.MKDIRS;
        FsPermission modes = this.applyUMask(permission);
        return (Boolean)new FsPathBooleanRunner((HttpOpParam.Op)op, f, new PermissionParam(modes.getMasked()), new UnmaskedPermissionParam(modes.getUnmasked())).run();
    }

    @Override
    public void createSymlink(Path destination, Path f, boolean createParent) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CREATE_SYM_LINK);
        PutOpParam.Op op = PutOpParam.Op.CREATESYMLINK;
        new FsPathRunner((HttpOpParam.Op)op, f, new DestinationParam(this.makeQualified(destination).toUri().getPath()), new CreateParentParam(createParent)).run();
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.RENAME);
        PutOpParam.Op op = PutOpParam.Op.RENAME;
        return (Boolean)new FsPathBooleanRunner((HttpOpParam.Op)op, src, new DestinationParam(this.makeQualified(dst).toUri().getPath())).run();
    }

    @Override
    public void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.RENAME);
        PutOpParam.Op op = PutOpParam.Op.RENAME;
        new FsPathRunner((HttpOpParam.Op)op, src, new DestinationParam(this.makeQualified(dst).toUri().getPath()), new RenameOptionSetParam(options)).run();
    }

    @Override
    public void setXAttr(Path p, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_XATTR);
        PutOpParam.Op op = PutOpParam.Op.SETXATTR;
        if (value != null) {
            new FsPathRunner((HttpOpParam.Op)op, p, new XAttrNameParam(name), new XAttrValueParam(XAttrCodec.encodeValue(value, XAttrCodec.HEX)), new XAttrSetFlagParam(flag)).run();
        } else {
            new FsPathRunner((HttpOpParam.Op)op, p, new XAttrNameParam(name), new XAttrSetFlagParam(flag)).run();
        }
    }

    @Override
    public byte[] getXAttr(Path p, String name) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_XATTR);
        GetOpParam.Op op = GetOpParam.Op.GETXATTRS;
        return (byte[])new FsPathResponseRunner<byte[]>((HttpOpParam.Op)op, p, new Param[]{new XAttrNameParam(name), new XAttrEncodingParam(XAttrCodec.HEX)}){

            @Override
            byte[] decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtilClient.getXAttr(json);
            }
        }.run();
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path p) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETXATTRS;
        return (Map)new FsPathResponseRunner<Map<String, byte[]>>((HttpOpParam.Op)op, p, new Param[]{new XAttrEncodingParam(XAttrCodec.HEX)}){

            @Override
            Map<String, byte[]> decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtilClient.toXAttrs(json);
            }
        }.run();
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path p, List<String> names) throws IOException {
        Preconditions.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (Object)"XAttr names cannot be null or empty.");
        Param[] parameters = new Param[names.size() + 1];
        for (int i = 0; i < parameters.length - 1; ++i) {
            parameters[i] = new XAttrNameParam(names.get(i));
        }
        parameters[parameters.length - 1] = new XAttrEncodingParam(XAttrCodec.HEX);
        GetOpParam.Op op = GetOpParam.Op.GETXATTRS;
        return (Map)new FsPathResponseRunner<Map<String, byte[]>>((HttpOpParam.Op)op, parameters, p){

            @Override
            Map<String, byte[]> decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtilClient.toXAttrs(json);
            }
        }.run();
    }

    @Override
    public List<String> listXAttrs(Path p) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.LISTXATTRS;
        return (List)new FsPathResponseRunner<List<String>>((HttpOpParam.Op)op, p, new Param[0]){

            @Override
            List<String> decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtilClient.toXAttrNames(json);
            }
        }.run();
    }

    @Override
    public void removeXAttr(Path p, String name) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.REMOVE_XATTR);
        PutOpParam.Op op = PutOpParam.Op.REMOVEXATTR;
        new FsPathRunner((HttpOpParam.Op)op, p, new XAttrNameParam(name)).run();
    }

    @Override
    public void setOwner(Path p, String owner, String group) throws IOException {
        if (owner == null && group == null) {
            throw new IOException("owner == null && group == null");
        }
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_OWNER);
        PutOpParam.Op op = PutOpParam.Op.SETOWNER;
        new FsPathRunner((HttpOpParam.Op)op, p, new OwnerParam(owner), new GroupParam(group)).run();
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_PERMISSION);
        PutOpParam.Op op = PutOpParam.Op.SETPERMISSION;
        new FsPathRunner((HttpOpParam.Op)op, p, new PermissionParam(permission)).run();
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.MODIFY_ACL_ENTRIES);
        PutOpParam.Op op = PutOpParam.Op.MODIFYACLENTRIES;
        new FsPathRunner((HttpOpParam.Op)op, path, new AclPermissionParam(aclSpec)).run();
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.REMOVE_ACL_ENTRIES);
        PutOpParam.Op op = PutOpParam.Op.REMOVEACLENTRIES;
        new FsPathRunner((HttpOpParam.Op)op, path, new AclPermissionParam(aclSpec)).run();
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.REMOVE_DEFAULT_ACL);
        PutOpParam.Op op = PutOpParam.Op.REMOVEDEFAULTACL;
        new FsPathRunner((HttpOpParam.Op)op, path, new Param[0]).run();
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.REMOVE_ACL);
        PutOpParam.Op op = PutOpParam.Op.REMOVEACL;
        new FsPathRunner((HttpOpParam.Op)op, path, new Param[0]).run();
    }

    @Override
    public void setAcl(Path p, List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_ACL);
        PutOpParam.Op op = PutOpParam.Op.SETACL;
        new FsPathRunner((HttpOpParam.Op)op, p, new AclPermissionParam(aclSpec)).run();
    }

    public void allowSnapshot(Path p) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.ALLOW_SNAPSHOT);
        PutOpParam.Op op = PutOpParam.Op.ALLOWSNAPSHOT;
        new FsPathRunner((HttpOpParam.Op)op, p, new Param[0]).run();
    }

    public void enableECPolicy(String policyName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.ENABLE_EC_POLICY);
        PutOpParam.Op op = PutOpParam.Op.ENABLEECPOLICY;
        new FsPathRunner((HttpOpParam.Op)op, null, new ECPolicyParam(policyName)).run();
    }

    public void disableECPolicy(String policyName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.DISABLE_EC_POLICY);
        PutOpParam.Op op = PutOpParam.Op.DISABLEECPOLICY;
        new FsPathRunner((HttpOpParam.Op)op, null, new ECPolicyParam(policyName)).run();
    }

    public void setErasureCodingPolicy(Path p, String policyName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_EC_POLICY);
        PutOpParam.Op op = PutOpParam.Op.SETECPOLICY;
        new FsPathRunner((HttpOpParam.Op)op, p, new ECPolicyParam(policyName)).run();
    }

    public void unsetErasureCodingPolicy(Path p) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.UNSET_EC_POLICY);
        PostOpParam.Op op = PostOpParam.Op.UNSETECPOLICY;
        new FsPathRunner((HttpOpParam.Op)op, p, new Param[0]).run();
    }

    public ErasureCodingPolicy getErasureCodingPolicy(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_EC_POLICY);
        GetOpParam.Op op = GetOpParam.Op.GETECPOLICY;
        return (ErasureCodingPolicy)new FsPathResponseRunner<ErasureCodingPolicy>((HttpOpParam.Op)op, p, new Param[0]){

            @Override
            ErasureCodingPolicy decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtilClient.toECPolicy(json);
            }
        }.run();
    }

    @Override
    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CREATE_SNAPSHOT);
        PutOpParam.Op op = PutOpParam.Op.CREATESNAPSHOT;
        return (Path)new FsPathResponseRunner<Path>((HttpOpParam.Op)op, path, new Param[]{new SnapshotNameParam(snapshotName)}){

            @Override
            Path decodeResponse(Map<?, ?> json) {
                return new Path((String)json.get(Path.class.getSimpleName()));
            }
        }.run();
    }

    public void disallowSnapshot(Path p) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.DISALLOW_SNAPSHOT);
        PutOpParam.Op op = PutOpParam.Op.DISALLOWSNAPSHOT;
        new FsPathRunner((HttpOpParam.Op)op, p, new Param[0]).run();
    }

    @Override
    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.DELETE_SNAPSHOT);
        DeleteOpParam.Op op = DeleteOpParam.Op.DELETESNAPSHOT;
        new FsPathRunner((HttpOpParam.Op)op, path, new SnapshotNameParam(snapshotName)).run();
    }

    @Override
    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.RENAME_SNAPSHOT);
        PutOpParam.Op op = PutOpParam.Op.RENAMESNAPSHOT;
        new FsPathRunner((HttpOpParam.Op)op, path, new OldSnapshotNameParam(snapshotOldName), new SnapshotNameParam(snapshotNewName)).run();
    }

    public SnapshotDiffReport getSnapshotDiffReport(Path snapshotDir, String fromSnapshot, String toSnapshot) throws IOException {
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_SNAPSHOT_DIFF);
        GetOpParam.Op op = GetOpParam.Op.GETSNAPSHOTDIFF;
        return (SnapshotDiffReport)new FsPathResponseRunner<SnapshotDiffReport>((HttpOpParam.Op)op, snapshotDir, new Param[]{new OldSnapshotNameParam(fromSnapshot), new SnapshotNameParam(toSnapshot)}){

            @Override
            SnapshotDiffReport decodeResponse(Map<?, ?> json) {
                return JsonUtilClient.toSnapshotDiffReport(json);
            }
        }.run();
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirectoryList() throws IOException {
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_SNAPSHOTTABLE_DIRECTORY_LIST);
        GetOpParam.Op op = GetOpParam.Op.GETSNAPSHOTTABLEDIRECTORYLIST;
        return (SnapshottableDirectoryStatus[])new FsPathResponseRunner<SnapshottableDirectoryStatus[]>((HttpOpParam.Op)op, null, new Param[0]){

            @Override
            SnapshottableDirectoryStatus[] decodeResponse(Map<?, ?> json) {
                return JsonUtilClient.toSnapshottableDirectoryList(json);
            }
        }.run();
    }

    @Override
    public boolean setReplication(Path p, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_REPLICATION);
        PutOpParam.Op op = PutOpParam.Op.SETREPLICATION;
        return (Boolean)new FsPathBooleanRunner((HttpOpParam.Op)op, p, new ReplicationParam(replication)).run();
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_TIMES);
        PutOpParam.Op op = PutOpParam.Op.SETTIMES;
        new FsPathRunner((HttpOpParam.Op)op, p, new ModificationTimeParam(mtime), new AccessTimeParam(atime)).run();
    }

    @Override
    public long getDefaultBlockSize() {
        return this.getConf().getLongBytes("dfs.blocksize", 0x8000000L);
    }

    @Override
    public short getDefaultReplication() {
        return (short)this.getConf().getInt("dfs.replication", 3);
    }

    @Override
    public void concat(Path trg, Path[] srcs) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CONCAT);
        PostOpParam.Op op = PostOpParam.Op.CONCAT;
        new FsPathRunner((HttpOpParam.Op)op, trg, new ConcatSourcesParam(srcs)).run();
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CREATE);
        FsPermission modes = this.applyUMask(permission);
        PutOpParam.Op op = PutOpParam.Op.CREATE;
        return (FSDataOutputStream)new FsPathOutputStreamRunner((HttpOpParam.Op)op, f, bufferSize, new PermissionParam(modes.getMasked()), new UnmaskedPermissionParam(modes.getUnmasked()), new OverwriteParam(overwrite), new BufferSizeParam(bufferSize), new ReplicationParam(replication), new BlockSizeParam(blockSize)).run();
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CREATE_NON_RECURSIVE);
        FsPermission modes = this.applyUMask(permission);
        PutOpParam.Op op = PutOpParam.Op.CREATE;
        return (FSDataOutputStream)new FsPathOutputStreamRunner((HttpOpParam.Op)op, f, bufferSize, new PermissionParam(modes.getMasked()), new UnmaskedPermissionParam(modes.getUnmasked()), new CreateFlagParam(flag), new CreateParentParam(false), new BufferSizeParam(bufferSize), new ReplicationParam(replication), new BlockSizeParam(blockSize)).run();
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.APPEND);
        PostOpParam.Op op = PostOpParam.Op.APPEND;
        return (FSDataOutputStream)new FsPathOutputStreamRunner((HttpOpParam.Op)op, f, bufferSize, new BufferSizeParam(bufferSize)).run();
    }

    @Override
    public boolean truncate(Path f, long newLength) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.TRUNCATE);
        PostOpParam.Op op = PostOpParam.Op.TRUNCATE;
        return (Boolean)new FsPathBooleanRunner((HttpOpParam.Op)op, f, new NewLengthParam(newLength)).run();
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.DELETE);
        DeleteOpParam.Op op = DeleteOpParam.Op.DELETE;
        return (Boolean)new FsPathBooleanRunner((HttpOpParam.Op)op, f, new RecursiveParam(recursive)).run();
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.OPEN);
        WebHdfsInputStream webfsInputStream = new WebHdfsInputStream(f, bufferSize);
        if (webfsInputStream.getFileEncryptionInfo() == null) {
            return new FSDataInputStream(webfsInputStream);
        }
        return new FSDataInputStream(webfsInputStream.createWrappedInputStream());
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.canRefreshDelegationToken && this.delegationToken != null) {
                this.cancelDelegationToken(this.delegationToken);
            }
        }
        catch (IOException ioe) {
            LOG.debug("Token cancel failed: ", (Throwable)ioe);
        }
        finally {
            if (this.connectionFactory != null) {
                this.connectionFactory.destroy();
            }
            super.close();
        }
    }

    static URL removeOffsetParam(URL url) throws MalformedURLException {
        String query = url.getQuery();
        if (query == null) {
            return url;
        }
        String lower = StringUtils.toLowerCase(query);
        if (!lower.startsWith(OFFSET_PARAM_PREFIX) && !lower.contains("&offset=")) {
            return url;
        }
        StringBuilder b = null;
        StringTokenizer st = new StringTokenizer(query, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (StringUtils.toLowerCase(token).startsWith(OFFSET_PARAM_PREFIX)) continue;
            if (b == null) {
                b = new StringBuilder("?").append(token);
                continue;
            }
            b.append('&').append(token);
        }
        query = b == null ? "" : b.toString();
        String urlStr = url.toString();
        return new URL(urlStr.substring(0, urlStr.indexOf(63)) + query);
    }

    @Override
    public FileStatus[] listStatus(final Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.LIST_STATUS);
        final URI fsUri = this.getUri();
        GetOpParam.Op op = GetOpParam.Op.LISTSTATUS;
        return (FileStatus[])new FsPathResponseRunner<FileStatus[]>((HttpOpParam.Op)op, f, new Param[0]){

            @Override
            FileStatus[] decodeResponse(Map<?, ?> json) {
                HdfsFileStatus[] hdfsStatuses = JsonUtilClient.toHdfsFileStatusArray(json);
                FileStatus[] statuses = new FileStatus[hdfsStatuses.length];
                for (int i = 0; i < hdfsStatuses.length; ++i) {
                    statuses[i] = hdfsStatuses[i].makeQualified(fsUri, f);
                }
                return statuses;
            }
        }.run();
    }

    @Override
    public FileSystem.DirectoryEntries listStatusBatch(Path f, byte[] token) throws FileNotFoundException, IOException {
        byte[] prevKey = EMPTY_ARRAY;
        if (token != null) {
            prevKey = token;
        }
        DirectoryListing listing = (DirectoryListing)new FsPathResponseRunner<DirectoryListing>((HttpOpParam.Op)GetOpParam.Op.LISTSTATUS_BATCH, f, new Param[]{new StartAfterParam(new String(prevKey, Charsets.UTF_8))}){

            @Override
            DirectoryListing decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtilClient.toDirectoryListing(json);
            }
        }.run();
        URI fsUri = this.getUri();
        HdfsFileStatus[] statuses = listing.getPartialListing();
        FileStatus[] qualified = new FileStatus[statuses.length];
        for (int i = 0; i < statuses.length; ++i) {
            qualified[i] = statuses[i].makeQualified(fsUri, f);
        }
        return new FileSystem.DirectoryEntries(qualified, listing.getLastName(), listing.hasMore());
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETDELEGATIONTOKEN;
        Token token = (Token)new FsPathResponseRunner<Token<DelegationTokenIdentifier>>((HttpOpParam.Op)op, null, new Param[]{new RenewerParam(renewer)}){

            @Override
            Token<DelegationTokenIdentifier> decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtilClient.toDelegationToken(json);
            }
        }.run();
        if (token != null) {
            token.setService(this.tokenServiceName);
        } else if (this.disallowFallbackToInsecureCluster) {
            throw new AccessControlException(CANT_FALLBACK_TO_INSECURE_MSG);
        }
        return token;
    }

    @Override
    public DelegationTokenIssuer[] getAdditionalTokenIssuers() throws IOException {
        KeyProvider keyProvider = this.getKeyProvider();
        if (keyProvider instanceof DelegationTokenIssuer) {
            return new DelegationTokenIssuer[]{(DelegationTokenIssuer)((Object)keyProvider)};
        }
        return null;
    }

    @Override
    public synchronized Token<?> getRenewToken() {
        return this.delegationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        WebHdfsFileSystem webHdfsFileSystem = this;
        synchronized (webHdfsFileSystem) {
            this.delegationToken = token;
        }
    }

    @Override
    public synchronized long renewDelegationToken(Token<?> token) throws IOException {
        PutOpParam.Op op = PutOpParam.Op.RENEWDELEGATIONTOKEN;
        return (Long)new FsPathResponseRunner<Long>((HttpOpParam.Op)op, null, new Param[]{new TokenArgumentParam(token.encodeToUrlString())}){

            @Override
            Long decodeResponse(Map<?, ?> json) throws IOException {
                return ((Number)json.get("long")).longValue();
            }
        }.run();
    }

    @Override
    public synchronized void cancelDelegationToken(Token<?> token) throws IOException {
        PutOpParam.Op op = PutOpParam.Op.CANCELDELEGATIONTOKEN;
        new FsPathRunner((HttpOpParam.Op)op, null, new TokenArgumentParam(token.encodeToUrlString())).run();
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus status, long offset, long length) throws IOException {
        if (status == null) {
            return null;
        }
        return this.getFileBlockLocations(status.getPath(), offset, length);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path p, long offset, long length) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_FILE_BLOCK_LOCATIONS);
        GetOpParam.Op op = GetOpParam.Op.GET_BLOCK_LOCATIONS;
        return (BlockLocation[])new FsPathResponseRunner<BlockLocation[]>((HttpOpParam.Op)op, p, new Param[]{new OffsetParam(offset), new LengthParam(length)}){

            @Override
            BlockLocation[] decodeResponse(Map<?, ?> json) throws IOException {
                return DFSUtilClient.locatedBlocks2Locations(JsonUtilClient.toLocatedBlocks(json));
            }
        }.run();
    }

    @Override
    public Path getTrashRoot(Path path) {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_TRASH_ROOT);
        GetOpParam.Op op = GetOpParam.Op.GETTRASHROOT;
        try {
            String strTrashPath = (String)new FsPathResponseRunner<String>((HttpOpParam.Op)op, path, new Param[0]){

                @Override
                String decodeResponse(Map<?, ?> json) throws IOException {
                    return JsonUtilClient.getPath(json);
                }
            }.run();
            return new Path(strTrashPath).makeQualified(this.getUri(), null);
        }
        catch (IOException e) {
            LOG.warn("Cannot find trash root of " + path, (Throwable)e);
            return super.getTrashRoot(path).makeQualified(this.getUri(), null);
        }
    }

    @Override
    public void access(Path path, FsAction mode) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.CHECKACCESS;
        new FsPathRunner((HttpOpParam.Op)op, path, new FsActionParam(mode)).run();
    }

    @Override
    public ContentSummary getContentSummary(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_CONTENT_SUMMARY);
        GetOpParam.Op op = GetOpParam.Op.GETCONTENTSUMMARY;
        return (ContentSummary)new FsPathResponseRunner<ContentSummary>((HttpOpParam.Op)op, p, new Param[0]){

            @Override
            ContentSummary decodeResponse(Map<?, ?> json) {
                return JsonUtilClient.toContentSummary(json);
            }
        }.run();
    }

    @Override
    public QuotaUsage getQuotaUsage(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_QUOTA_USAGE);
        GetOpParam.Op op = GetOpParam.Op.GETQUOTAUSAGE;
        return (QuotaUsage)new FsPathResponseRunner<QuotaUsage>((HttpOpParam.Op)op, p, new Param[0]){

            @Override
            QuotaUsage decodeResponse(Map<?, ?> json) {
                return JsonUtilClient.toQuotaUsage(json);
            }
        }.run();
    }

    @Override
    public MD5MD5CRC32FileChecksum getFileChecksum(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_FILE_CHECKSUM);
        GetOpParam.Op op = GetOpParam.Op.GETFILECHECKSUM;
        return (MD5MD5CRC32FileChecksum)new FsPathResponseRunner<MD5MD5CRC32FileChecksum>((HttpOpParam.Op)op, p, new Param[0]){

            @Override
            MD5MD5CRC32FileChecksum decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtilClient.toMD5MD5CRC32FileChecksum(json);
            }
        }.run();
    }

    private InetSocketAddress[] resolveNNAddr() {
        Configuration conf = this.getConf();
        String scheme = this.uri.getScheme();
        ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
        if (!HAUtilClient.isLogicalUri(conf, this.uri)) {
            InetSocketAddress addr = NetUtils.createSocketAddr(this.uri.getAuthority(), this.getDefaultPort());
            ret.add(addr);
        } else {
            Map<String, Map<String, InetSocketAddress>> addresses = DFSUtilClient.getHaNnWebHdfsAddresses(conf, scheme);
            Map<String, InetSocketAddress> addrs = addresses.get(this.uri.getHost());
            for (InetSocketAddress addr : addrs.values()) {
                ret.add(addr);
            }
        }
        InetSocketAddress[] r = new InetSocketAddress[ret.size()];
        return ret.toArray(r);
    }

    @Override
    public String getCanonicalServiceName() {
        return this.tokenServiceName == null ? super.getCanonicalServiceName() : this.tokenServiceName.toString();
    }

    @Override
    public void setStoragePolicy(Path p, String policyName) throws IOException {
        if (policyName == null) {
            throw new IOException("policyName == null");
        }
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_STORAGE_POLICY);
        PutOpParam.Op op = PutOpParam.Op.SETSTORAGEPOLICY;
        new FsPathRunner((HttpOpParam.Op)op, p, new StoragePolicyParam(policyName)).run();
    }

    public Collection<BlockStoragePolicy> getAllStoragePolicies() throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETALLSTORAGEPOLICY;
        return (Collection)new FsPathResponseRunner<Collection<BlockStoragePolicy>>((HttpOpParam.Op)op, null, new Param[0]){

            @Override
            Collection<BlockStoragePolicy> decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtilClient.getStoragePolicies(json);
            }
        }.run();
    }

    @Override
    public BlockStoragePolicy getStoragePolicy(Path src) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETSTORAGEPOLICY;
        return (BlockStoragePolicy)new FsPathResponseRunner<BlockStoragePolicy>((HttpOpParam.Op)op, src, new Param[0]){

            @Override
            BlockStoragePolicy decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtilClient.toBlockStoragePolicy((Map)json.get(BlockStoragePolicy.class.getSimpleName()));
            }
        }.run();
    }

    @Override
    public void unsetStoragePolicy(Path src) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.UNSET_STORAGE_POLICY);
        PostOpParam.Op op = PostOpParam.Op.UNSETSTORAGEPOLICY;
        new FsPathRunner((HttpOpParam.Op)op, src, new Param[0]).run();
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETSERVERDEFAULTS;
        return (FsServerDefaults)new FsPathResponseRunner<FsServerDefaults>((HttpOpParam.Op)op, null, new Param[0]){

            @Override
            FsServerDefaults decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtilClient.toFsServerDefaults(json);
            }
        }.run();
    }

    @VisibleForTesting
    InetSocketAddress[] getResolvedNNAddr() {
        return this.nnAddrs;
    }

    @VisibleForTesting
    public void setRetryPolicy(RetryPolicy rp) {
        this.retryPolicy = rp;
    }

    @Override
    public URI getKeyProviderUri() throws IOException {
        String keyProviderUri;
        block3: {
            keyProviderUri = null;
            try {
                keyProviderUri = this.getServerDefaults().getKeyProviderUri();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (RemoteException e) {
                if (e.getClassName() != null && e.getClassName().equals("java.lang.IllegalArgumentException")) break block3;
                throw e;
            }
        }
        return HdfsKMSUtil.getKeyProviderUri(this.ugi, this.getUri(), keyProviderUri, this.getConf());
    }

    @Override
    public KeyProvider getKeyProvider() throws IOException {
        if (this.testProvider != null) {
            return this.testProvider;
        }
        URI keyProviderUri = this.getKeyProviderUri();
        if (keyProviderUri == null) {
            return null;
        }
        return KMSUtil.createKeyProviderFromUri(this.getConf(), keyProviderUri);
    }

    @VisibleForTesting
    public void setTestProvider(KeyProvider kp) {
        this.testProvider = kp;
    }

    @VisibleForTesting
    protected class ReadRunner
    extends AbstractFsPathRunner<Integer> {
        private InputStream in;
        private HttpURLConnection cachedConnection;
        private byte[] readBuffer;
        private int readOffset;
        private int readLength;
        private RunnerState runnerState;
        private URL originalUrl;
        private URL resolvedUrl;
        private final Path path;
        private final int bufferSize;
        private long pos;
        private long fileLength;
        private FileEncryptionInfo feInfo;

        ReadRunner(Path p, int bs) throws IOException {
            super((HttpOpParam.Op)GetOpParam.Op.OPEN, p, new BufferSizeParam(bs));
            this.in = null;
            this.cachedConnection = null;
            this.runnerState = RunnerState.SEEK;
            this.originalUrl = null;
            this.resolvedUrl = null;
            this.pos = 0L;
            this.fileLength = 0L;
            this.feInfo = null;
            this.path = p;
            this.bufferSize = bs;
            this.getRedirectedUrl();
        }

        private void getRedirectedUrl() throws IOException {
            String location;
            URLRunner urlRunner = new URLRunner((HttpOpParam.Op)GetOpParam.Op.OPEN, null, false, false){

                @Override
                protected URL getUrl() throws IOException {
                    return WebHdfsFileSystem.this.toUrl(this.op, ReadRunner.this.path, new BufferSizeParam(ReadRunner.this.bufferSize));
                }
            };
            HttpURLConnection conn = (HttpURLConnection)urlRunner.run();
            String feInfoStr = conn.getHeaderField(WebHdfsFileSystem.FEFINFO_HEADER);
            if (feInfoStr != null) {
                Base64.Decoder decoder = Base64.getDecoder();
                byte[] decodedBytes = decoder.decode(feInfoStr.getBytes(StandardCharsets.UTF_8));
                this.feInfo = PBHelperClient.convert(HdfsProtos.FileEncryptionInfoProto.parseFrom(decodedBytes));
            }
            if ((location = conn.getHeaderField("Location")) != null) {
                this.resolvedUrl = WebHdfsFileSystem.removeOffsetParam(new URL(location));
            } else {
                this.cachedConnection = conn;
            }
            this.originalUrl = super.getUrl();
        }

        int read(byte[] b, int off, int len) throws IOException {
            if (this.runnerState == RunnerState.CLOSED) {
                throw new IOException("Stream closed");
            }
            if (len == 0) {
                return 0;
            }
            if (this.pos >= this.fileLength && this.readBuffer != null) {
                return -1;
            }
            if (this.runnerState == RunnerState.SEEK) {
                try {
                    URL rurl = new URL(this.resolvedUrl + "&" + new OffsetParam(this.pos));
                    this.cachedConnection = (HttpURLConnection)new URLRunner(GetOpParam.Op.OPEN, rurl, true, false).run();
                }
                catch (IOException ioe) {
                    this.closeInputStream(RunnerState.DISCONNECTED);
                }
            }
            this.readBuffer = b;
            this.readOffset = off;
            this.readLength = len;
            int count = -1;
            count = (Integer)this.run();
            if (count >= 0) {
                WebHdfsFileSystem.this.statistics.incrementBytesRead(count);
                this.pos += (long)count;
            } else if (this.pos < this.fileLength) {
                throw new EOFException("Premature EOF: pos=" + this.pos + " < filelength=" + this.fileLength);
            }
            return count;
        }

        void seek(long newPos) throws IOException {
            if (this.pos != newPos) {
                this.pos = newPos;
                this.closeInputStream(RunnerState.SEEK);
            }
        }

        public void close() throws IOException {
            this.closeInputStream(RunnerState.CLOSED);
        }

        @Override
        protected URL getUrl() throws IOException {
            if (this.cachedConnection == null) {
                this.updateURLParameters(new BufferSizeParam(this.bufferSize), new OffsetParam(this.pos));
                this.originalUrl = super.getUrl();
            }
            return this.originalUrl;
        }

        @Override
        protected HttpURLConnection connect(URL url) throws IOException {
            HttpURLConnection conn = this.cachedConnection;
            if (conn == null) {
                try {
                    conn = super.connect(url);
                }
                catch (IOException e) {
                    this.closeInputStream(RunnerState.DISCONNECTED);
                    throw e;
                }
            }
            return conn;
        }

        @Override
        Integer getResponse(HttpURLConnection conn) throws IOException {
            try {
                int count;
                this.cachedConnection = conn;
                if (this.in == null) {
                    this.in = this.initializeInputStream(conn);
                }
                if ((count = this.in.read(this.readBuffer, this.readOffset, this.readLength)) < 0 && this.pos < this.fileLength) {
                    throw new EOFException("Premature EOF: pos=" + this.pos + " < filelength=" + this.fileLength);
                }
                return count;
            }
            catch (IOException e) {
                String redirectHost = this.resolvedUrl.getAuthority();
                this.excludeDatanodes = this.excludeDatanodes.getValue() != null ? new ExcludeDatanodesParam(redirectHost + "," + (String)this.excludeDatanodes.getValue()) : new ExcludeDatanodesParam(redirectHost);
                this.closeInputStream(RunnerState.DISCONNECTED);
                throw e;
            }
        }

        @VisibleForTesting
        InputStream initializeInputStream(HttpURLConnection conn) throws IOException {
            this.resolvedUrl = WebHdfsFileSystem.removeOffsetParam(conn.getURL());
            String cl = conn.getHeaderField("Content-Length");
            InputStream inStream = conn.getInputStream();
            if (LOG.isDebugEnabled()) {
                LOG.debug("open file: " + conn.getURL());
            }
            if (cl != null) {
                long streamLength = Long.parseLong(cl);
                this.fileLength = this.pos + streamLength;
                inStream = new BoundedInputStream(inStream, streamLength);
            } else {
                this.fileLength = WebHdfsFileSystem.this.getHdfsFileStatus(this.path).getLen();
            }
            this.runnerState = RunnerState.OPEN;
            return new BufferedInputStream(inStream, this.bufferSize);
        }

        @VisibleForTesting
        void closeInputStream(RunnerState rs) throws IOException {
            if (this.in != null) {
                IOUtils.close((URLConnection)this.cachedConnection);
                this.in = null;
            }
            this.cachedConnection = null;
            this.runnerState = rs;
        }

        @VisibleForTesting
        protected InputStream getInputStream() {
            return this.in;
        }

        @VisibleForTesting
        protected void setInputStream(InputStream inStream) {
            this.in = inStream;
        }

        Path getPath() {
            return this.path;
        }

        int getBufferSize() {
            return this.bufferSize;
        }

        long getFileLength() {
            return this.fileLength;
        }

        void setFileLength(long len) {
            this.fileLength = len;
        }

        long getPos() {
            return this.pos;
        }

        protected FileEncryptionInfo getFileEncryptionInfo() {
            return this.feInfo;
        }
    }

    static enum RunnerState {
        DISCONNECTED,
        OPEN,
        SEEK,
        CLOSED;

    }

    @VisibleForTesting
    public class WebHdfsInputStream
    extends FSInputStream {
        private ReadRunner readRunner = null;

        WebHdfsInputStream(Path path, int buffersize) throws IOException {
            this.readRunner = new ReadRunner(path, buffersize);
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b, 0, 1) == -1 ? -1 : b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.readRunner.read(b, off, len);
        }

        @Override
        public void seek(long newPos) throws IOException {
            this.readRunner.seek(newPos);
        }

        @Override
        public long getPos() throws IOException {
            return this.readRunner.getPos();
        }

        protected int getBufferSize() throws IOException {
            return this.readRunner.getBufferSize();
        }

        protected Path getPath() throws IOException {
            return this.readRunner.getPath();
        }

        @Override
        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        @Override
        public void close() throws IOException {
            this.readRunner.close();
        }

        public void setFileLength(long len) {
            this.readRunner.setFileLength(len);
        }

        public long getFileLength() {
            return this.readRunner.getFileLength();
        }

        @VisibleForTesting
        ReadRunner getReadRunner() {
            return this.readRunner;
        }

        @VisibleForTesting
        void setReadRunner(ReadRunner rr) {
            this.readRunner = rr;
        }

        FileEncryptionInfo getFileEncryptionInfo() {
            return this.readRunner.getFileEncryptionInfo();
        }

        InputStream createWrappedInputStream() throws IOException {
            return HdfsKMSUtil.createWrappedInputStream(this, WebHdfsFileSystem.this.getKeyProvider(), this.getFileEncryptionInfo(), WebHdfsFileSystem.this.getConf());
        }
    }

    static class OffsetUrlInputStream
    extends ByteRangeInputStream {
        OffsetUrlInputStream(UnresolvedUrlOpener o, OffsetUrlOpener r) throws IOException {
            super(o, r);
        }

        @Override
        protected URL getResolvedUrl(HttpURLConnection connection) throws MalformedURLException {
            return WebHdfsFileSystem.removeOffsetParam(connection.getURL());
        }
    }

    class OffsetUrlOpener
    extends ByteRangeInputStream.URLOpener {
        OffsetUrlOpener(URL url) {
            super(url);
        }

        @Override
        protected HttpURLConnection connect(long offset, boolean resolved) throws IOException {
            URL offsetUrl = offset == 0L ? this.url : new URL(this.url + "&" + new OffsetParam(offset));
            return (HttpURLConnection)new URLRunner(GetOpParam.Op.OPEN, offsetUrl, resolved, true).run();
        }
    }

    class UnresolvedUrlOpener
    extends ByteRangeInputStream.URLOpener {
        private final FsPathConnectionRunner runner;

        UnresolvedUrlOpener(FsPathConnectionRunner runner) {
            super(null);
            this.runner = runner;
        }

        @Override
        protected HttpURLConnection connect(long offset, boolean resolved) throws IOException {
            assert (offset == 0L);
            HttpURLConnection conn = (HttpURLConnection)this.runner.run();
            this.setURL(conn.getURL());
            return conn;
        }
    }

    class URLRunner
    extends AbstractRunner<HttpURLConnection> {
        private final URL url;

        @Override
        protected URL getUrl() throws IOException {
            return this.url;
        }

        protected URLRunner(HttpOpParam.Op op, URL url, boolean redirected, boolean followRedirect) {
            super(op, redirected, followRedirect);
            this.url = url;
        }

        @Override
        HttpURLConnection getResponse(HttpURLConnection conn) throws IOException {
            return conn;
        }
    }

    class FsPathConnectionRunner
    extends AbstractFsPathRunner<HttpURLConnection> {
        FsPathConnectionRunner(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) {
            super(op, fspath, parameters);
        }

        @Override
        HttpURLConnection getResponse(HttpURLConnection conn) throws IOException {
            return conn;
        }
    }

    class FsPathOutputStreamRunner
    extends AbstractFsPathRunner<FSDataOutputStream> {
        private final int bufferSize;

        FsPathOutputStreamRunner(HttpOpParam.Op op, Path fspath, int bufferSize, Param<?, ?> ... parameters) {
            super(op, fspath, parameters);
            this.bufferSize = bufferSize;
        }

        @Override
        FSDataOutputStream getResponse(final HttpURLConnection conn) throws IOException {
            return new FSDataOutputStream(new BufferedOutputStream(conn.getOutputStream(), this.bufferSize), WebHdfsFileSystem.this.statistics){

                @Override
                public void write(int b) throws IOException {
                    try {
                        super.write(b);
                    }
                    catch (IOException e) {
                        LOG.warn("Write to output stream for file '{}' failed. Attempting to fetch the cause from the connection.", (Object)FsPathOutputStreamRunner.this.getFspath(), (Object)e);
                        WebHdfsFileSystem.validateResponse(FsPathOutputStreamRunner.this.op, conn, true);
                        throw e;
                    }
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    try {
                        super.write(b, off, len);
                    }
                    catch (IOException e) {
                        LOG.warn("Write to output stream for file '{}' failed. Attempting to fetch the cause from the connection.", (Object)FsPathOutputStreamRunner.this.getFspath(), (Object)e);
                        WebHdfsFileSystem.validateResponse(FsPathOutputStreamRunner.this.op, conn, true);
                        throw e;
                    }
                }

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        try {
                            WebHdfsFileSystem.validateResponse(FsPathOutputStreamRunner.this.op, conn, true);
                        }
                        finally {
                            conn.disconnect();
                        }
                    }
                }
            };
        }
    }

    class FsPathBooleanRunner
    extends FsPathResponseRunner<Boolean> {
        FsPathBooleanRunner(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) {
            super(op, fspath, parameters);
        }

        @Override
        Boolean decodeResponse(Map<?, ?> json) throws IOException {
            return (Boolean)json.get("boolean");
        }
    }

    abstract class FsPathResponseRunner<T>
    extends AbstractFsPathRunner<T> {
        FsPathResponseRunner(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) {
            super(op, fspath, parameters);
        }

        FsPathResponseRunner(HttpOpParam.Op op, Param<?, ?>[] parameters, Path fspath) {
            super(op, parameters, fspath);
        }

        @Override
        final T getResponse(HttpURLConnection conn) throws IOException {
            try {
                Map<?, ?> json = WebHdfsFileSystem.jsonParse(conn, false);
                if (json == null) {
                    throw new IllegalStateException("Missing response");
                }
                T t = this.decodeResponse(json);
                return t;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                IOException ioe = new IOException("Response decoding failure: " + e.toString(), e);
                LOG.debug("Response decoding failure.", (Throwable)e);
                throw ioe;
            }
            finally {
                conn.getInputStream().close();
            }
        }

        abstract T decodeResponse(Map<?, ?> var1) throws IOException;
    }

    class FsPathRunner
    extends AbstractFsPathRunner<Void> {
        FsPathRunner(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) {
            super(op, fspath, parameters);
        }

        @Override
        Void getResponse(HttpURLConnection conn) throws IOException {
            return null;
        }
    }

    abstract class AbstractFsPathRunner<T>
    extends AbstractRunner<T> {
        private final Path fspath;
        private Param<?, ?>[] parameters;

        AbstractFsPathRunner(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) {
            super(op, false);
            this.fspath = fspath;
            this.parameters = parameters;
        }

        AbstractFsPathRunner(HttpOpParam.Op op, Param<?, ?>[] parameters, Path fspath) {
            super(op, false);
            this.fspath = fspath;
            this.parameters = parameters;
        }

        protected void updateURLParameters(Param<?, ?> ... p) {
            this.parameters = p;
        }

        @Override
        protected URL getUrl() throws IOException {
            if (this.excludeDatanodes.getValue() != null) {
                Param[] tmpParam = new Param[this.parameters.length + 1];
                System.arraycopy(this.parameters, 0, tmpParam, 0, this.parameters.length);
                tmpParam[this.parameters.length] = this.excludeDatanodes;
                return WebHdfsFileSystem.this.toUrl(this.op, this.fspath, tmpParam);
            }
            return WebHdfsFileSystem.this.toUrl(this.op, this.fspath, this.parameters);
        }

        Path getFspath() {
            return this.fspath;
        }
    }

    abstract class AbstractRunner<T> {
        protected final HttpOpParam.Op op;
        private final boolean redirected;
        protected ExcludeDatanodesParam excludeDatanodes = new ExcludeDatanodesParam("");
        private boolean checkRetry;
        private String redirectHost;
        private boolean followRedirect = true;

        protected abstract URL getUrl() throws IOException;

        protected AbstractRunner(HttpOpParam.Op op, boolean redirected) {
            this.op = op;
            this.redirected = redirected;
        }

        protected AbstractRunner(HttpOpParam.Op op, boolean redirected, boolean followRedirect) {
            this(op, redirected);
            this.followRedirect = followRedirect;
        }

        T run() throws IOException {
            UserGroupInformation connectUgi = WebHdfsFileSystem.this.ugi.getRealUser();
            if (connectUgi == null) {
                connectUgi = WebHdfsFileSystem.this.ugi;
            }
            if (this.op.getRequireAuth()) {
                connectUgi.checkTGTAndReloginFromKeytab();
            }
            try {
                return connectUgi.doAs(new PrivilegedExceptionAction<T>(){

                    @Override
                    public T run() throws IOException {
                        return AbstractRunner.this.runWithRetry();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HttpURLConnection connect(URL url) throws IOException {
            this.redirectHost = null;
            if (this.op.getRedirect() && !this.redirected) {
                HttpOpParam.TemporaryRedirectOp redirectOp = HttpOpParam.TemporaryRedirectOp.valueOf(this.op);
                HttpURLConnection conn = this.connect(redirectOp, url);
                if (conn.getResponseCode() == this.op.getExpectedHttpResponseCode()) {
                    return conn;
                }
                try {
                    WebHdfsFileSystem.validateResponse(redirectOp, conn, false);
                    url = new URL(conn.getHeaderField("Location"));
                    this.redirectHost = url.getHost() + ":" + url.getPort();
                }
                finally {
                    conn.disconnect();
                }
                if (!this.followRedirect) {
                    return conn;
                }
            }
            try {
                HttpURLConnection conn = this.connect(this.op, url);
                if (!this.op.getDoOutput()) {
                    WebHdfsFileSystem.validateResponse(this.op, conn, false);
                }
                return conn;
            }
            catch (IOException ioe) {
                if (this.redirectHost != null) {
                    this.excludeDatanodes = this.excludeDatanodes.getValue() != null ? new ExcludeDatanodesParam(this.redirectHost + "," + (String)this.excludeDatanodes.getValue()) : new ExcludeDatanodesParam(this.redirectHost);
                }
                throw ioe;
            }
        }

        private HttpURLConnection connect(HttpOpParam.Op op, URL url) throws IOException {
            HttpURLConnection conn = (HttpURLConnection)WebHdfsFileSystem.this.connectionFactory.openConnection(url);
            boolean doOutput = op.getDoOutput();
            conn.setRequestMethod(op.getType().toString());
            conn.setInstanceFollowRedirects(false);
            if (WebHdfsFileSystem.this.restCsrfCustomHeader != null && !WebHdfsFileSystem.this.restCsrfMethodsToIgnore.contains(op.getType().name())) {
                conn.setRequestProperty(WebHdfsFileSystem.this.restCsrfCustomHeader, "\"\"");
            }
            conn.setRequestProperty(WebHdfsFileSystem.EZ_HEADER, "true");
            switch (op.getType()) {
                case POST: 
                case PUT: {
                    conn.setDoOutput(true);
                    if (!doOutput) {
                        conn.getOutputStream().close();
                        break;
                    }
                    conn.setRequestProperty("Content-Type", "application/octet-stream");
                    conn.setChunkedStreamingMode(32768);
                    break;
                }
                default: {
                    conn.setDoOutput(doOutput);
                }
            }
            conn.connect();
            return conn;
        }

        private T runWithRetry() throws IOException {
            int retry = 0;
            while (true) {
                this.checkRetry = !this.redirected;
                URL url = this.getUrl();
                try {
                    HttpURLConnection conn = this.connect(url);
                    return this.getResponse(conn);
                }
                catch (AccessControlException ace) {
                    throw ace;
                }
                catch (SecretManager.InvalidToken it) {
                    if (this.op.getRequireAuth() || !WebHdfsFileSystem.this.replaceExpiredDelegationToken()) {
                        throw it;
                    }
                }
                catch (IOException ioe) {
                    String node = this.redirectHost;
                    if (node == null) {
                        node = url.getAuthority();
                    }
                    try {
                        IOException newIoe = (IOException)ioe.getClass().getConstructor(String.class).newInstance(node + ": " + ioe.getMessage());
                        newIoe.initCause(ioe.getCause());
                        newIoe.setStackTrace(ioe.getStackTrace());
                        ioe = newIoe;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                        // empty catch block
                    }
                    this.shouldRetry(ioe, retry);
                }
                ++retry;
            }
        }

        private void shouldRetry(IOException ioe, int retry) throws IOException {
            InetSocketAddress nnAddr = WebHdfsFileSystem.this.getCurrentNNAddr();
            if (this.checkRetry) {
                try {
                    boolean isFailoverAndRetry;
                    RetryPolicy.RetryAction a = WebHdfsFileSystem.this.retryPolicy.shouldRetry(ioe, retry, 0, true);
                    boolean isRetry = a.action == RetryPolicy.RetryAction.RetryDecision.RETRY;
                    boolean bl = isFailoverAndRetry = a.action == RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY;
                    if (isRetry || isFailoverAndRetry) {
                        LOG.info("Retrying connect to namenode: {}. Already retried {} time(s); retry policy is {}, delay {}ms.", new Object[]{nnAddr, retry, WebHdfsFileSystem.this.retryPolicy, a.delayMillis});
                        if (isFailoverAndRetry) {
                            WebHdfsFileSystem.this.resetStateToFailOver();
                        }
                        Thread.sleep(a.delayMillis);
                        return;
                    }
                }
                catch (Exception e) {
                    LOG.warn("Original exception is ", (Throwable)ioe);
                    throw WebHdfsFileSystem.toIOException(e);
                }
            }
            throw WebHdfsFileSystem.toIOException(ioe);
        }

        abstract T getResponse(HttpURLConnection var1) throws IOException;
    }
}

