/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdfs.DFSStripedInputStream;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.StripeReader;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;

class PositionStripeReader
extends StripeReader {
    private ByteBuffer codingBuffer;

    PositionStripeReader(StripedBlockUtil.AlignedStripe alignedStripe, ErasureCodingPolicy ecPolicy, LocatedBlock[] targetBlocks, StripeReader.BlockReaderInfo[] readerInfos, DFSUtilClient.CorruptedBlocks corruptedBlocks, RawErasureDecoder decoder, DFSStripedInputStream dfsStripedInputStream) {
        super(alignedStripe, ecPolicy, targetBlocks, readerInfos, corruptedBlocks, decoder, dfsStripedInputStream);
    }

    @Override
    void prepareDecodeInputs() {
        if (this.codingBuffer == null) {
            this.decodeInputs = new ECChunk[this.dataBlkNum + this.parityBlkNum];
            this.initDecodeInputs(this.alignedStripe);
        }
    }

    @Override
    boolean prepareParityChunk(int index) {
        Preconditions.checkState((index >= this.dataBlkNum && this.alignedStripe.chunks[index] == null ? 1 : 0) != 0);
        int bufLen = (int)this.alignedStripe.getSpanInBlock();
        this.decodeInputs[index] = new ECChunk(this.codingBuffer.duplicate(), index * bufLen, bufLen);
        this.alignedStripe.chunks[index] = new StripedBlockUtil.StripingChunk(this.decodeInputs[index].getBuffer());
        return true;
    }

    @Override
    void decode() throws IOException {
        this.finalizeDecodeInputs();
        this.decodeAndFillBuffer(true);
    }

    void initDecodeInputs(StripedBlockUtil.AlignedStripe alignedStripe) {
        int i;
        int bufLen = (int)alignedStripe.getSpanInBlock();
        int bufCount = this.dataBlkNum + this.parityBlkNum;
        this.codingBuffer = this.dfsStripedInputStream.getBufferPool().getBuffer(this.useDirectBuffer(), bufLen * bufCount);
        for (i = 0; i < this.dataBlkNum; ++i) {
            ByteBuffer buffer = this.codingBuffer.duplicate();
            this.decodeInputs[i] = new ECChunk(buffer, i * bufLen, bufLen);
        }
        for (i = 0; i < this.dataBlkNum; ++i) {
            if (alignedStripe.chunks[i] != null) continue;
            alignedStripe.chunks[i] = new StripedBlockUtil.StripingChunk(this.decodeInputs[i].getBuffer());
        }
    }

    @Override
    void close() {
        if (this.decodeInputs != null) {
            for (int i = 0; i < this.decodeInputs.length; ++i) {
                this.decodeInputs[i] = null;
            }
        }
        if (this.codingBuffer != null) {
            this.dfsStripedInputStream.getBufferPool().putBuffer(this.codingBuffer);
            this.codingBuffer = null;
        }
    }
}

