/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import com.google.common.base.Throwables;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.network.buffer.NioManagedBuffer;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.OneWayMessage;
import org.apache.celeborn.common.network.protocol.RpcFailure;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.protocol.RpcResponse;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnected;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnectionError;
import org.apache.celeborn.common.rpc.netty.RemoteProcessDisconnected;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RequestMessage$;
import org.apache.celeborn.common.util.JavaUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!\u0002\b\u0010\u0001UY\u0002\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u0011A\u0002!\u0011!Q\u0001\nEBQ\u0001\u000e\u0001\u0005\u0002UBq!\u000f\u0001C\u0002\u0013%!\b\u0003\u0004J\u0001\u0001\u0006Ia\u000f\u0005\u0006\u0015\u0002!\te\u0013\u0005\u0006C\u0002!IA\u0019\u0005\u0006S\u0002!IA\u001b\u0005\u0006a\u0002!I!\u001d\u0005\u0006{\u0002!\tE \u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\t9\u0003\u0001C!\u0003SAq!!\f\u0001\t\u0003\nyCA\bOKR$\u0018P\u00159d\u0011\u0006tG\r\\3s\u0015\t\u0001\u0012#A\u0003oKR$\u0018P\u0003\u0002\u0013'\u0005\u0019!\u000f]2\u000b\u0005Q)\u0012AB2p[6|gN\u0003\u0002\u0017/\u0005A1-\u001a7fE>\u0014hN\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7c\u0001\u0001\u001dIA\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u0005\u001a\u0012a\u00028fi^|'o[\u0005\u0003Gy\u0011!CQ1tK6+7o]1hK\"\u000bg\u000e\u001a7feB\u0011Q\u0005K\u0007\u0002M)\u0011qeE\u0001\tS:$XM\u001d8bY&\u0011\u0011F\n\u0002\b\u0019><w-\u001b8h\u0003)!\u0017n\u001d9bi\u000eDWM]\u0002\u0001!\tic&D\u0001\u0010\u0013\tysB\u0001\u0006ESN\u0004\u0018\r^2iKJ\f\u0001B\\3uif,eN\u001e\t\u0003[IJ!aM\b\u0003\u00179+G\u000f^=Sa\u000e,eN^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007Y:\u0004\b\u0005\u0002.\u0001!)!f\u0001a\u0001Y!)\u0001g\u0001a\u0001c\u0005y!/Z7pi\u0016\fE\r\u001a:fgN,7/F\u0001<!\u0011a4)R#\u000e\u0003uR!AP \u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002A\u0003\u0006!Q\u000f^5m\u0015\u0005\u0011\u0015\u0001\u00026bm\u0006L!\u0001R\u001f\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002G\u000f6\t\u0011#\u0003\u0002I#\tQ!\u000b]2BI\u0012\u0014Xm]:\u0002!I,Wn\u001c;f\u0003\u0012$'/Z:tKN\u0004\u0013a\u0002:fG\u0016Lg/\u001a\u000b\u0004\u0019JK\u0006CA'Q\u001b\u0005q%\"A(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Es%\u0001B+oSRDQa\u0015\u0004A\u0002Q\u000baa\u00197jK:$\bCA+X\u001b\u00051&BA*!\u0013\tAfKA\bUe\u0006t7\u000f]8si\u000ec\u0017.\u001a8u\u0011\u0015Qf\u00011\u0001\\\u00039\u0011X-];fgRlUm]:bO\u0016\u0004\"\u0001X0\u000e\u0003uS!A\u0018\u0011\u0002\u0011A\u0014x\u000e^8d_2L!\u0001Y/\u0003\u001dI+\u0017/^3ti6+7o]1hK\u0006Q\u0001O]8dKN\u001c(\u000b]2\u0015\u00071\u001bG\rC\u0003T\u000f\u0001\u0007A\u000bC\u0003f\u000f\u0001\u0007a-A\u0001s!\tav-\u0003\u0002i;\nQ!\u000b]2SKF,Xm\u001d;\u0002)A\u0014xnY3tg>sWm^1z\u001b\u0016\u001c8/Y4f)\ra5\u000e\u001c\u0005\u0006'\"\u0001\r\u0001\u0016\u0005\u0006K\"\u0001\r!\u001c\t\u00039:L!a\\/\u0003\u001b=sWmV1z\u001b\u0016\u001c8/Y4f\u0003=Ig\u000e^3s]\u0006d'+Z2fSZ,Gc\u0001:ukB\u0011Qf]\u0005\u0003A>AQaU\u0005A\u0002QCQA^\u0005A\u0002]\fq!\\3tg\u0006<W\r\u0005\u0002yw6\t\u0011P\u0003\u0002{\u0003\u0006\u0019a.[8\n\u0005qL(A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006y1\r[3dWJ+w-[:uKJ,G\rF\u0001\u0000!\ri\u0015\u0011A\u0005\u0004\u0003\u0007q%a\u0002\"p_2,\u0017M\\\u0001\u0010Kb\u001cW\r\u001d;j_:\u001c\u0015-^4iiR)A*!\u0003\u0002&!9\u00111B\u0006A\u0002\u00055\u0011!B2bkN,\u0007\u0003BA\b\u0003?qA!!\u0005\u0002\u001c9!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018-\na\u0001\u0010:p_Rt\u0014\"A(\n\u0007\u0005ua*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00121\u0005\u0002\n)\"\u0014xn^1cY\u0016T1!!\bO\u0011\u0015\u00196\u00021\u0001U\u00035\u0019\u0007.\u00198oK2\f5\r^5wKR\u0019A*a\u000b\t\u000bMc\u0001\u0019\u0001+\u0002\u001f\rD\u0017M\u001c8fY&s\u0017m\u0019;jm\u0016$2\u0001TA\u0019\u0011\u0015\u0019V\u00021\u0001U\u0001")
public class NettyRpcHandler
extends BaseMessageHandler
implements Logging {
    private final Dispatcher dispatcher;
    private final NettyRpcEnv nettyEnv;
    private final ConcurrentHashMap<RpcAddress, RpcAddress> remoteAddresses;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        NettyRpcHandler nettyRpcHandler = this;
        synchronized (nettyRpcHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private ConcurrentHashMap<RpcAddress, RpcAddress> remoteAddresses() {
        return this.remoteAddresses;
    }

    @Override
    public void receive(TransportClient client, org.apache.celeborn.common.network.protocol.RequestMessage requestMessage) {
        org.apache.celeborn.common.network.protocol.RequestMessage requestMessage2 = requestMessage;
        if (requestMessage2 instanceof RpcRequest) {
            RpcRequest rpcRequest = (RpcRequest)requestMessage2;
            this.processRpc(client, rpcRequest);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (requestMessage2 instanceof OneWayMessage) {
            OneWayMessage oneWayMessage = (OneWayMessage)requestMessage2;
            this.processOnewayMessage(client, oneWayMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)requestMessage2);
        }
    }

    private void processRpc(TransportClient client, RpcRequest r) {
        RpcResponseCallback callback = new RpcResponseCallback(null, client, r){
            private final TransportClient client$1;
            private final RpcRequest r$1;

            public void onSuccess(ByteBuffer response) {
                this.client$1.getChannel().writeAndFlush((Object)new RpcResponse(this.r$1.requestId, new NioManagedBuffer(response)));
            }

            public void onFailure(Throwable e) {
                this.client$1.getChannel().writeAndFlush((Object)new RpcFailure(this.r$1.requestId, Throwables.getStackTraceAsString((Throwable)e)));
            }
            {
                this.client$1 = client$1;
                this.r$1 = r$1;
            }
        };
        try {
            try {
                ByteBuffer message = r.body().nioByteBuffer();
                RequestMessage messageToDispatch = this.internalReceive(client, message);
                this.dispatcher.postRemoteMessage(messageToDispatch, callback);
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Error while invoking RpcHandler#receive() on RPC id ").append(r$1.requestId).toString(), e);
                client.getChannel().writeAndFlush((Object)new RpcFailure(r.requestId, Throwables.getStackTraceAsString((Throwable)e)));
            }
        }
        finally {
            r.body().release();
        }
    }

    private void processOnewayMessage(TransportClient client, OneWayMessage r) {
        try {
            try {
                ByteBuffer message = r.body().nioByteBuffer();
                RequestMessage messageToDispatch = this.internalReceive(client, message);
                this.dispatcher.postOneWayMessage(messageToDispatch);
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while invoking RpcHandler#receive() for one-way message.", e);
            }
        }
        finally {
            r.body().release();
        }
    }

    private RequestMessage internalReceive(TransportClient client, ByteBuffer message) {
        RequestMessage requestMessage;
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        Predef$.MODULE$.assert(addr != null);
        RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
        RequestMessage requestMessage2 = RequestMessage$.MODULE$.apply(this.nettyEnv, client, message);
        if (requestMessage2.senderAddress() == null) {
            requestMessage = new RequestMessage(clientAddr, requestMessage2.receiver(), requestMessage2.content());
        } else {
            RpcAddress remoteEnvAddress = requestMessage2.senderAddress();
            if (this.remoteAddresses().putIfAbsent(clientAddr, remoteEnvAddress) == null) {
                this.dispatcher.postToAll(new RemoteProcessConnected(remoteEnvAddress));
            }
            requestMessage = requestMessage2;
        }
        return requestMessage;
    }

    @Override
    public boolean checkRegistered() {
        return this.nettyEnv.checkRegistered();
    }

    @Override
    public void exceptionCaught(Throwable cause, TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        if (addr != null) {
            RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
            this.dispatcher.postToAll(new RemoteProcessConnectionError(cause, clientAddr));
            RpcAddress remoteEnvAddress = this.remoteAddresses().get(clientAddr);
            if (remoteEnvAddress != null) {
                this.dispatcher.postToAll(new RemoteProcessConnectionError(cause, remoteEnvAddress));
            }
        } else {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception before connecting to the client", cause);
        }
    }

    @Override
    public void channelActive(TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        Predef$.MODULE$.assert(addr != null);
        RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
        this.dispatcher.postToAll(new RemoteProcessConnected(clientAddr));
    }

    @Override
    public void channelInactive(TransportClient client) {
        block1: {
            InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
            if (addr == null) break block1;
            RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
            this.nettyEnv.removeOutbox(clientAddr);
            this.dispatcher.postToAll(new RemoteProcessDisconnected(clientAddr));
            RpcAddress remoteEnvAddress = this.remoteAddresses().remove(clientAddr);
            if (remoteEnvAddress != null) {
                this.dispatcher.postToAll(new RemoteProcessDisconnected(remoteEnvAddress));
            }
        }
    }

    public NettyRpcHandler(Dispatcher dispatcher, NettyRpcEnv nettyEnv) {
        this.dispatcher = dispatcher;
        this.nettyEnv = nettyEnv;
        Logging.$init$(this);
        this.remoteAddresses = JavaUtils.newConcurrentHashMap();
    }
}

