/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import org.apache.commons.io.output.BrokenOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class BrokenOutputStreamTest {
    BrokenOutputStreamTest() {
    }

    private static BrokenOutputStream createBrokenOutputStream(Throwable exception) {
        if (exception instanceof IOException) {
            return new BrokenOutputStream((IOException)exception);
        }
        return new BrokenOutputStream(exception);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testClose(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenOutputStream stream = BrokenOutputStreamTest.createBrokenOutputStream(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> stream.close()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testFlush(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenOutputStream stream = BrokenOutputStreamTest.createBrokenOutputStream(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> stream.flush()));
    }

    @Test
    void testInstance() {
        Assertions.assertNotNull((Object)BrokenOutputStream.INSTANCE);
    }

    @Test
    void testTryWithResources() {
        IOException thrown = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (BrokenOutputStream newStream = new BrokenOutputStream();){
                newStream.write(1);
            }
        });
        Assertions.assertEquals((Object)"Broken output stream: write(int)", (Object)thrown.getMessage());
        Throwable[] suppressed = thrown.getSuppressed();
        Assertions.assertEquals((int)1, (int)suppressed.length);
        Assertions.assertEquals(IOException.class, suppressed[0].getClass());
        Assertions.assertEquals((Object)"Broken output stream: close()", (Object)suppressed[0].getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testWriteByteArray(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenOutputStream stream = BrokenOutputStreamTest.createBrokenOutputStream(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> stream.write(new byte[1])));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testWriteByteArrayIndexed(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenOutputStream stream = BrokenOutputStreamTest.createBrokenOutputStream(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> stream.write(new byte[1], 0, 1)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testWriteInt(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenOutputStream stream = BrokenOutputStreamTest.createBrokenOutputStream(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> stream.write(1)));
    }
}

