/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.optimizer.Bootstrapper;
import org.mozilla.javascript.optimizer.Codegen;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptRuntime;

class BodyCodegen {
    private static final int JAVASCRIPT_EXCEPTION = 0;
    private static final int EVALUATOR_EXCEPTION = 1;
    private static final int ECMAERROR_EXCEPTION = 2;
    private static final int THROWABLE_EXCEPTION = 3;
    private static final int FINALLY_EXCEPTION = 4;
    private static final int EXCEPTION_MAX = 5;
    private ExceptionManager exceptionManager = new ExceptionManager();
    static final int GENERATOR_TERMINATE = -1;
    static final int GENERATOR_START = 0;
    static final int GENERATOR_YIELD_START = 1;
    ClassFileWriter cfw;
    Codegen codegen;
    CompilerEnvirons compilerEnv;
    ScriptNode scriptOrFn;
    String scriptOrFnType;
    String scriptOrFnClass;
    public int scriptOrFnIndex;
    private int savedCodeOffset;
    private OptFunctionNode fnCurrent;
    private static final int MAX_LOCALS = 1024;
    private int[] locals;
    private int firstFreeLocal;
    private int localsMax;
    private int itsLineNumber;
    private boolean hasVarsInRegs;
    private int[] varRegisters;
    private boolean inDirectCallFunction;
    private boolean itsForcedObjectParameters;
    private int enterAreaStartLabel;
    private int epilogueLabel;
    private boolean inLocalBlock;
    private int variableObjectLocal;
    private int popvLocal;
    private int contextLocal;
    private int argsLocal;
    private int operationLocal;
    private int thisObjLocal;
    private int funObjLocal;
    private int itsZeroArgArray;
    private int itsOneArgArray;
    private int generatorStateLocal;
    private int savedHomeObjectLocal;
    private int newTargetLocal;
    private boolean isGenerator;
    private int generatorSwitch;
    private int maxLocals = 0;
    private int maxStack = 0;
    private Map<Node, FinallyReturnPoint> finallys;
    private ArrayList<Node> literals;
    private int unnestedYieldCount = 0;
    private IdentityHashMap<Node, String> unnestedYields = new IdentityHashMap();

    BodyCodegen() {
    }

    void generateBodyCode() {
        this.isGenerator = Codegen.isGenerator(this.scriptOrFn);
        this.initBodyGeneration();
        if (this.isGenerator) {
            this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn) + "_gen", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/JSFunction;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;ILjava/lang/Object;)Ljava/lang/Object;", (short)9);
        } else {
            this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn), this.codegen.getBodyMethodSignature(this.scriptOrFn), (short)9);
        }
        this.generatePrologue();
        Node treeTop = this.fnCurrent != null ? this.scriptOrFn.getLastChild() : this.scriptOrFn;
        this.generateStatement(treeTop);
        this.generateEpilogue();
        this.cfw.stopMethod((short)(this.localsMax + 1));
        if (this.isGenerator) {
            this.generateGenerator();
        }
        if (this.literals != null) {
            block4: for (int i = 0; i < this.literals.size(); ++i) {
                Node node = this.literals.get(i);
                int type = node.getType();
                switch (type) {
                    case 73: {
                        this.generateObjectLiteralFactory(node, i + 1);
                        continue block4;
                    }
                    case 72: {
                        this.generateArrayLiteralFactory(node, i + 1);
                        continue block4;
                    }
                    default: {
                        Kit.codeBug(Token.typeToName(type));
                    }
                }
            }
        }
    }

    private void generateGenerator() {
        this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn), this.codegen.getBodyMethodSignature(this.scriptOrFn), (short)9);
        this.initBodyGeneration();
        this.argsLocal = this.firstFreeLocal++;
        this.localsMax = this.firstFreeLocal;
        if (this.fnCurrent != null) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke(185, "org/mozilla/javascript/Function", "getDeclarationScope", "()Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
        }
        this.cfw.addALoad(this.funObjLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.argsLocal);
        this.cfw.addPush(this.scriptOrFn.isInStrictMode());
        this.cfw.addPush(this.scriptOrFn.hasRestParameter());
        this.cfw.addPush(!(this.scriptOrFn instanceof FunctionNode) || ((FunctionNode)this.scriptOrFn).requiresArgumentObject());
        this.addScriptRuntimeInvoke("createFunctionActivation", "(Lorg/mozilla/javascript/JSFunction;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;ZZZ)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
        Node paramInitBlock = ((FunctionNode)this.scriptOrFn).getGeneratorParamInitBlock();
        if (paramInitBlock != null) {
            for (Node paramInit = paramInitBlock.getFirstChild(); paramInit != null; paramInit = paramInit.getNext()) {
                this.generateStatement(paramInit);
            }
        }
        this.generateNestedFunctionInits();
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.thisObjLocal);
        this.cfw.addALoad(this.funObjLocal);
        this.cfw.addLoadConstant(this.maxLocals);
        this.cfw.addLoadConstant(this.maxStack);
        this.addOptRuntimeInvoke("createNativeGenerator", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/JSFunction;II)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.add(176);
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void generateNestedFunctionInits() {
        int functionCount = this.scriptOrFn.getFunctionCount();
        for (int i = 0; i != functionCount; ++i) {
            OptFunctionNode ofn = OptFunctionNode.get(this.scriptOrFn, i);
            if (ofn.fnode.getFunctionType() != 1) continue;
            this.visitFunction(ofn, 1);
        }
    }

    private void initBodyGeneration() {
        this.varRegisters = null;
        if (this.scriptOrFn.getType() == 124) {
            int n;
            this.fnCurrent = OptFunctionNode.get(this.scriptOrFn);
            boolean bl = this.hasVarsInRegs = !this.fnCurrent.fnode.requiresActivation();
            if (this.hasVarsInRegs && (n = this.fnCurrent.fnode.getParamAndVarCount()) != 0) {
                this.varRegisters = new int[n];
            }
            this.inDirectCallFunction = this.fnCurrent.isTargetOfDirectCall();
            if (this.inDirectCallFunction && !this.hasVarsInRegs) {
                Codegen.badTree();
            }
        } else {
            this.fnCurrent = null;
            this.hasVarsInRegs = false;
            this.inDirectCallFunction = false;
        }
        this.locals = new int[1024];
        this.contextLocal = 0;
        this.funObjLocal = 1;
        this.newTargetLocal = 2;
        this.variableObjectLocal = 3;
        this.thisObjLocal = 4;
        this.localsMax = 5;
        this.firstFreeLocal = 5;
        this.popvLocal = -1;
        this.argsLocal = -1;
        this.itsZeroArgArray = -1;
        this.itsOneArgArray = -1;
        this.epilogueLabel = -1;
        this.enterAreaStartLabel = -1;
        this.generatorStateLocal = -1;
        this.savedHomeObjectLocal = -1;
    }

    private void generatePrologue() {
        String debugVariableName;
        if (this.inDirectCallFunction) {
            int i;
            int directParameterCount = this.scriptOrFn.getParamCount();
            if (this.firstFreeLocal != 5) {
                Kit.codeBug();
            }
            for (i = 0; i != directParameterCount; ++i) {
                this.varRegisters[i] = this.firstFreeLocal;
                this.firstFreeLocal += 3;
            }
            if (!this.fnCurrent.getParameterNumberContext()) {
                this.itsForcedObjectParameters = true;
                for (i = 0; i != directParameterCount; ++i) {
                    int reg = this.varRegisters[i];
                    this.cfw.addALoad(reg);
                    this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int isObjectLabel = this.cfw.acquireLabel();
                    this.cfw.add(166, isObjectLabel);
                    this.cfw.addDLoad(reg + 1);
                    this.addDoubleWrap();
                    this.cfw.addAStore(reg);
                    this.cfw.markLabel(isObjectLabel);
                }
            }
        }
        if (this.fnCurrent != null) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke(185, "org/mozilla/javascript/Function", "getDeclarationScope", "()Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
        }
        this.argsLocal = this.firstFreeLocal++;
        this.localsMax = this.firstFreeLocal;
        if (this.isGenerator) {
            List<Node> targets;
            this.operationLocal = this.firstFreeLocal++;
            this.localsMax = this.firstFreeLocal;
            this.cfw.addILoad(this.thisObjLocal);
            this.cfw.addIStore(this.operationLocal);
            this.generatorStateLocal = this.newTargetLocal;
            this.localsMax = this.firstFreeLocal;
            this.cfw.addALoad(this.generatorStateLocal);
            this.cfw.add(192, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState");
            this.cfw.add(89);
            this.cfw.addAStore(this.generatorStateLocal);
            this.cfw.add(89);
            this.cfw.add(180, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "thisObj", "Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.thisObjLocal);
            this.cfw.add(180, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "activationFrame", "Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
            if (this.epilogueLabel == -1) {
                this.epilogueLabel = this.cfw.acquireLabel();
            }
            if ((targets = ((FunctionNode)this.scriptOrFn).getResumptionPoints()) != null) {
                this.generateGetGeneratorResumptionPoint();
                this.generatorSwitch = this.cfw.addTableSwitch(0, targets.size() + 0);
                this.generateCheckForThrowOrClose(-1, false, 0);
            }
        }
        if (this.compilerEnv.isGenerateObserverCount()) {
            this.saveCurrentCodeOffset();
        }
        if (this.isGenerator) {
            return;
        }
        if (this.hasVarsInRegs) {
            int parmCount = this.scriptOrFn.getParamCount();
            if (parmCount > 0 && !this.inDirectCallFunction) {
                if (this.scriptOrFn.hasRestParameter()) {
                    this.cfw.addALoad(this.contextLocal);
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.cfw.addALoad(this.argsLocal);
                    this.cfw.addPush(parmCount);
                    this.addScriptRuntimeInvoke("padAndRestArguments", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;I)[Ljava/lang/Object;");
                    this.cfw.addAStore(this.argsLocal);
                } else {
                    this.cfw.addALoad(this.argsLocal);
                    this.cfw.add(190);
                    this.cfw.addPush(parmCount);
                    int label = this.cfw.acquireLabel();
                    this.cfw.add(162, label);
                    this.cfw.addALoad(this.argsLocal);
                    this.cfw.addPush(parmCount);
                    this.addScriptRuntimeInvoke("padArguments", "([Ljava/lang/Object;I)[Ljava/lang/Object;");
                    this.cfw.addAStore(this.argsLocal);
                    this.cfw.markLabel(label);
                }
            }
            int paramCount = this.fnCurrent.fnode.getParamCount();
            int varCount = this.fnCurrent.fnode.getParamAndVarCount();
            boolean[] constDeclarations = this.fnCurrent.fnode.getParamAndVarConst();
            int firstUndefVar = -1;
            for (int i = 0; i != varCount; ++i) {
                int reg = -1;
                if (i < paramCount) {
                    if (!this.inDirectCallFunction) {
                        reg = this.getNewWordLocal();
                        this.cfw.addALoad(this.argsLocal);
                        this.cfw.addPush(i);
                        this.cfw.add(50);
                        this.cfw.addAStore(reg);
                    }
                } else if (this.fnCurrent.isNumberVar(i)) {
                    reg = this.getNewWordPairLocal(constDeclarations[i]);
                    this.cfw.addPush(0.0);
                    this.cfw.addDStore(reg);
                } else {
                    reg = this.getNewWordLocal(constDeclarations[i]);
                    if (firstUndefVar == -1) {
                        Codegen.pushUndefined(this.cfw);
                        firstUndefVar = reg;
                    } else {
                        this.cfw.addALoad(firstUndefVar);
                    }
                    this.cfw.addAStore(reg);
                }
                if (reg >= 0) {
                    if (constDeclarations[i]) {
                        this.cfw.addPush(0);
                        this.cfw.addIStore(reg + (this.fnCurrent.isNumberVar(i) ? 2 : 1));
                    }
                    this.varRegisters[i] = reg;
                }
                if (!this.compilerEnv.isGenerateDebugInfo()) continue;
                String name = this.fnCurrent.fnode.getParamOrVarName(i);
                String type = this.fnCurrent.isNumberVar(i) ? "D" : "Ljava/lang/Object;";
                int startPC = this.cfw.getCurrentCodeOffset();
                if (reg < 0) {
                    reg = this.varRegisters[i];
                }
                this.cfw.addVariableDescriptor(name, type, startPC, reg);
            }
            return;
        }
        boolean isArrow = false;
        if (this.scriptOrFn instanceof FunctionNode) {
            boolean bl = isArrow = ((FunctionNode)this.scriptOrFn).getFunctionType() == 4;
        }
        if (this.fnCurrent != null) {
            debugVariableName = "activation";
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.argsLocal);
            this.cfw.addPush(this.scriptOrFn.isInStrictMode());
            this.cfw.addPush(this.scriptOrFn.hasRestParameter());
            this.cfw.addPush(!(this.scriptOrFn instanceof FunctionNode) || ((FunctionNode)this.scriptOrFn).requiresArgumentObject());
            String methodName = isArrow ? "createArrowFunctionActivation" : "createFunctionActivation";
            this.addScriptRuntimeInvoke(methodName, "(Lorg/mozilla/javascript/JSFunction;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;ZZZ)Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("enterActivationFunction", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)V");
        } else {
            debugVariableName = "global";
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addPush(0);
            this.addScriptRuntimeInvoke("initScript", "(Lorg/mozilla/javascript/ScriptOrFn;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Z)V");
        }
        this.enterAreaStartLabel = this.cfw.acquireLabel();
        this.epilogueLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(this.enterAreaStartLabel);
        this.generateNestedFunctionInits();
        if (this.compilerEnv.isGenerateDebugInfo()) {
            this.cfw.addVariableDescriptor(debugVariableName, "Lorg/mozilla/javascript/Scriptable;", this.cfw.getCurrentCodeOffset(), this.variableObjectLocal);
        }
        if (this.fnCurrent == null) {
            this.popvLocal = this.getNewWordLocal();
            Codegen.pushUndefined(this.cfw);
            this.cfw.addAStore(this.popvLocal);
            int linenum = this.scriptOrFn.getEndLineno();
            if (linenum != -1) {
                this.cfw.addLineNumberEntry((short)linenum);
            }
        } else {
            if (this.fnCurrent.itsContainsCalls0) {
                this.itsZeroArgArray = this.getNewWordLocal();
                this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
                this.cfw.addAStore(this.itsZeroArgArray);
            }
            if (this.fnCurrent.itsContainsCalls1) {
                this.itsOneArgArray = this.getNewWordLocal();
                this.cfw.addPush(1);
                this.cfw.add(189, "java/lang/Object");
                this.cfw.addAStore(this.itsOneArgArray);
            }
        }
    }

    private void generateGetGeneratorResumptionPoint() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.cfw.add(180, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "resumptionPoint", "I");
    }

    private void generateSetGeneratorResumptionPoint(int nextState) {
        this.cfw.addALoad(this.generatorStateLocal);
        this.cfw.addLoadConstant(nextState);
        this.cfw.add(181, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "resumptionPoint", "I");
    }

    private void generateGetGeneratorStackState() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.addOptRuntimeInvoke("getGeneratorStackState", "(Ljava/lang/Object;)[Ljava/lang/Object;");
    }

    private void generateEpilogue() {
        if (this.compilerEnv.isGenerateObserverCount()) {
            this.addInstructionCount();
        }
        if (this.isGenerator) {
            Map<Node, int[]> liveLocals = ((FunctionNode)this.scriptOrFn).getLiveLocals();
            if (liveLocals != null) {
                List<Node> nodes = ((FunctionNode)this.scriptOrFn).getResumptionPoints();
                Iterator<Node> iterator = nodes.iterator();
                while (iterator.hasNext()) {
                    Node node = iterator.next();
                    int[] live = liveLocals.get(node);
                    if (live == null) continue;
                    this.cfw.markTableSwitchCase(this.generatorSwitch, this.getNextGeneratorState(node));
                    this.generateGetGeneratorLocalsState();
                    for (int j = 0; j < live.length; ++j) {
                        this.cfw.add(89);
                        this.cfw.addLoadConstant(j);
                        this.cfw.add(50);
                        this.cfw.addAStore(live[j]);
                    }
                    this.cfw.add(87);
                    this.cfw.add(167, this.getTargetLabel(node));
                }
            }
            if (this.finallys != null) {
                for (Map.Entry entry : this.finallys.entrySet()) {
                    if (((Node)entry.getKey()).getType() != 140) continue;
                    FinallyReturnPoint ret = (FinallyReturnPoint)entry.getValue();
                    this.cfw.markLabel(ret.tableLabel, 1);
                    int startSwitch = this.cfw.addTableSwitch(0, ret.jsrPoints.size() - 1);
                    int c = 0;
                    this.cfw.markTableSwitchDefault(startSwitch);
                    for (int i = 0; i < ret.jsrPoints.size(); ++i) {
                        this.cfw.markTableSwitchCase(startSwitch, c);
                        this.cfw.add(167, ret.jsrPoints.get(i));
                        ++c;
                    }
                }
            }
        }
        if (this.epilogueLabel != -1) {
            this.cfw.markLabel(this.epilogueLabel);
        }
        if (this.isGenerator) {
            if (((FunctionNode)this.scriptOrFn).getResumptionPoints() != null) {
                this.cfw.markTableSwitchDefault(this.generatorSwitch);
            }
            this.generateSetGeneratorResumptionPoint(-1);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.generatorStateLocal);
            this.addOptRuntimeInvoke("throwStopIteration", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            Codegen.pushUndefined(this.cfw);
            this.cfw.add(176);
        } else if (this.hasVarsInRegs) {
            this.cfw.add(176);
        } else if (this.fnCurrent == null) {
            this.cfw.addALoad(this.popvLocal);
            this.cfw.add(176);
        } else {
            this.generateActivationExit();
            this.cfw.add(176);
            int finallyHandler = this.cfw.acquireLabel();
            this.cfw.markHandler(finallyHandler);
            short exceptionObject = this.getNewWordLocal();
            this.cfw.addAStore(exceptionObject);
            this.generateActivationExit();
            this.cfw.addALoad(exceptionObject);
            this.releaseWordLocal(exceptionObject);
            this.cfw.add(191);
            this.cfw.addExceptionHandler(this.enterAreaStartLabel, this.epilogueLabel, finallyHandler, null);
        }
    }

    private void generateGetGeneratorLocalsState() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.addOptRuntimeInvoke("getGeneratorLocalsState", "(Ljava/lang/Object;)[Ljava/lang/Object;");
    }

    private void generateSetGeneratorReturnValue() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.cfw.add(95);
        this.addOptRuntimeInvoke("setGeneratorReturnValue", "(Ljava/lang/Object;Ljava/lang/Object;)V");
    }

    private void generateActivationExit() {
        if (this.fnCurrent == null || this.hasVarsInRegs) {
            throw Kit.codeBug();
        }
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("exitActivationFunction", "(Lorg/mozilla/javascript/Context;)V");
    }

    private void generateStatement(Node node) {
        this.updateLineNumber(node);
        int type = node.getType();
        Node child = node.getFirstChild();
        switch (type) {
            case 138: 
            case 143: 
            case 145: 
            case 146: 
            case 148: 
            case 152: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount(1);
                }
                while (child != null) {
                    this.generateStatement(child);
                    child = child.getNext();
                }
                break;
            }
            case 157: {
                boolean prevLocal = this.inLocalBlock;
                this.inLocalBlock = true;
                short local = this.getNewWordLocal();
                if (this.isGenerator) {
                    this.cfw.add(1);
                    this.cfw.addAStore(local);
                }
                node.putIntProp(2, local);
                while (child != null) {
                    this.generateStatement(child);
                    child = child.getNext();
                }
                this.releaseWordLocal(local);
                node.removeProp(2);
                this.inLocalBlock = prevLocal;
                break;
            }
            case 124: {
                int fnIndex = node.getExistingIntProp(1);
                OptFunctionNode ofn = OptFunctionNode.get(this.scriptOrFn, fnIndex);
                int t = ofn.fnode.getFunctionType();
                if (t == 3) {
                    this.visitFunction(ofn, t);
                    break;
                }
                if (t == 1) break;
                throw Codegen.badTree();
            }
            case 92: {
                this.visitTryCatchFinally((Jump)node, child);
                break;
            }
            case 63: {
                this.cfw.setStackTop((short)0);
                int local = BodyCodegen.getLocalBlockRegister(node);
                int scopeIndex = node.getExistingIntProp(14);
                String name = null;
                if (child.getType() == 44) {
                    name = child.getString();
                }
                child = child.getNext();
                this.generateExpression(child, node);
                if (scopeIndex == 0) {
                    this.cfw.add(1);
                } else {
                    this.cfw.addALoad(local);
                }
                if (name != null) {
                    this.cfw.addPush(name);
                } else {
                    this.cfw.add(1);
                }
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("newCatchScope", "(Ljava/lang/Throwable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
                this.cfw.addAStore(local);
                break;
            }
            case 56: {
                this.generateExpression(child, node);
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.generateThrowJavaScriptException();
                break;
            }
            case 57: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.cfw.addALoad(BodyCodegen.getLocalBlockRegister(node));
                this.cfw.add(191);
                break;
            }
            case 4: 
            case 71: {
                if (child != null) {
                    this.generateExpression(child, node);
                } else if (type == 4) {
                    Codegen.pushUndefined(this.cfw);
                } else {
                    if (this.popvLocal < 0) {
                        throw Codegen.badTree();
                    }
                    this.cfw.addALoad(this.popvLocal);
                }
                if (this.isGenerator) {
                    this.generateSetGeneratorReturnValue();
                }
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                if (this.epilogueLabel == -1) {
                    if (!this.hasVarsInRegs) {
                        throw Codegen.badTree();
                    }
                    this.epilogueLabel = this.cfw.acquireLabel();
                }
                this.cfw.add(167, this.epilogueLabel);
                break;
            }
            case 129: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.visitSwitch((Jump)node, child);
                break;
            }
            case 2: {
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("enterWith", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
                this.cfw.addAStore(this.variableObjectLocal);
                this.incReferenceWordLocal(this.variableObjectLocal);
                break;
            }
            case 3: {
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("leaveWith", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
                this.cfw.addAStore(this.variableObjectLocal);
                this.decReferenceWordLocal(this.variableObjectLocal);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                int enumType = type == 64 ? 0 : (type == 65 ? 1 : (type == 67 ? 6 : 2));
                this.cfw.addPush(enumType);
                this.addScriptRuntimeInvoke("enumInit", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                this.cfw.addAStore(BodyCodegen.getLocalBlockRegister(node));
                break;
            }
            case 149: {
                if (child.getType() == 62) {
                    this.visitSetVar(child, child.getFirstChild(), false);
                    break;
                }
                if (child.getType() == 172) {
                    this.visitSetConstVar(child, child.getFirstChild(), false);
                    break;
                }
                if (child.getType() == 79 || child.getType() == 181) {
                    this.generateYieldPoint(child, false);
                    break;
                }
                this.generateExpression(child, node);
                if (node.getIntProp(8, -1) != -1) {
                    this.cfw.add(88);
                    break;
                }
                this.cfw.add(87);
                break;
            }
            case 150: {
                this.generateExpression(child, node);
                if (this.popvLocal < 0) {
                    this.popvLocal = this.getNewWordLocal();
                }
                this.cfw.addAStore(this.popvLocal);
                break;
            }
            case 147: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                int label = this.getTargetLabel(node);
                this.cfw.markLabel(label);
                if (!this.compilerEnv.isGenerateObserverCount()) break;
                this.saveCurrentCodeOffset();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 151: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.visitGoto((Jump)node, type, child);
                break;
            }
            case 140: {
                if (!this.isGenerator) break;
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.saveCurrentCodeOffset();
                }
                this.cfw.setStackTop((short)1);
                short finallyRegister = this.getNewWordLocal();
                int finallyStart = this.cfw.acquireLabel();
                int finallyEnd = this.cfw.acquireLabel();
                this.cfw.markLabel(finallyStart);
                this.generateIntegerWrap();
                this.cfw.addAStore(finallyRegister);
                while (child != null) {
                    this.generateStatement(child);
                    child = child.getNext();
                }
                this.cfw.addALoad(finallyRegister);
                this.cfw.add(192, "java/lang/Integer");
                this.generateIntegerUnwrap();
                FinallyReturnPoint ret = this.finallys.get(node);
                ret.tableLabel = this.cfw.acquireLabel();
                this.cfw.add(167, ret.tableLabel);
                this.cfw.setStackTop((short)0);
                this.releaseWordLocal(finallyRegister);
                this.cfw.markLabel(finallyEnd);
                break;
            }
            case 176: {
                break;
            }
            default: {
                throw Codegen.badTree();
            }
        }
    }

    private void generateIntegerWrap() {
        this.cfw.addInvoke(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
    }

    private void generateIntegerUnwrap() {
        this.cfw.addInvoke(182, "java/lang/Integer", "intValue", "()I");
    }

    private void generateThrowJavaScriptException() {
        this.cfw.add(187, "org/mozilla/javascript/JavaScriptException");
        this.cfw.add(90);
        this.cfw.add(95);
        this.cfw.addPush(this.scriptOrFn.getSourceName());
        this.cfw.addPush(this.itsLineNumber);
        this.cfw.addInvoke(183, "org/mozilla/javascript/JavaScriptException", "<init>", "(Ljava/lang/Object;Ljava/lang/String;I)V");
        this.cfw.add(191);
    }

    private int getNextGeneratorState(Node node) {
        int nodeIndex = ((FunctionNode)this.scriptOrFn).getResumptionPoints().indexOf(node);
        return nodeIndex + 1;
    }

    private void generateExpression(Node node, Node parent) {
        int type = node.getType();
        block0 : switch (type) {
            case 154: {
                break;
            }
            case 124: {
                if (this.fnCurrent == null && parent.getType() == 152) break;
                int fnIndex = node.getExistingIntProp(1);
                OptFunctionNode ofn = OptFunctionNode.get(this.scriptOrFn, fnIndex);
                int t = ofn.fnode.getFunctionType();
                if (t != 2 && t != 4) {
                    throw Codegen.badTree();
                }
                this.visitFunction(ofn, t);
                break;
            }
            case 44: {
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.contextLocal);
                this.addDynamicInvoke("NAME:GET:" + node.getString(), "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 30: 
            case 43: {
                Node child;
                int specialType = node.getIntProp(10, 0);
                if (specialType == 0) {
                    OptFunctionNode target = (OptFunctionNode)node.getProp(9);
                    if (target != null) {
                        this.visitOptimizedCall(node, target, type, child);
                        break;
                    }
                    if (type == 43) {
                        this.visitStandardCall(node, child);
                        break;
                    }
                    this.visitStandardNew(node, child);
                    break;
                }
                this.visitSpecialCall(node, type, specialType, child);
                break;
            }
            case 77: {
                Node child;
                this.generateFunctionAndThisObj(child, node);
                child = child.getNext();
                this.generateCallArgArray(node, child, false);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("callRef", "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Ref;");
                break;
            }
            case 45: {
                double num = node.getDouble();
                if (node.getIntProp(8, -1) != -1) {
                    this.cfw.addPush(num);
                    break;
                }
                this.codegen.pushNumberAsObject(this.cfw, num);
                break;
            }
            case 91: {
                byte[] bytes = node.getBigInt().toByteArray();
                this.cfw.add(187, "java/math/BigInteger");
                this.cfw.add(89);
                this.cfw.addPush(bytes.length);
                this.cfw.add(188, 8);
                for (int i = 0; i < bytes.length; ++i) {
                    this.cfw.add(89);
                    this.cfw.addPush(i);
                    this.cfw.add(16, bytes[i]);
                    this.cfw.add(84);
                }
                this.cfw.addInvoke(183, "java/math/BigInteger", "<init>", "([B)V");
                break;
            }
            case 46: {
                this.cfw.addPush(node.getString());
                break;
            }
            case 49: {
                this.cfw.addALoad(this.thisObjLocal);
                break;
            }
            case 80: {
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.add(192, "org/mozilla/javascript/NativeCall");
                this.cfw.addInvoke(182, "org/mozilla/javascript/NativeCall", "getHomeObject", "()Lorg/mozilla/javascript/Scriptable;");
                int after = this.cfw.acquireLabel();
                int putPrototype = this.cfw.acquireLabel();
                this.cfw.add(89);
                this.cfw.add(199, putPrototype);
                this.cfw.add(87);
                this.cfw.add(178, "org/mozilla/javascript/Undefined", "instance", "Ljava/lang/Object;");
                this.cfw.add(167, after);
                this.cfw.markLabel(putPrototype);
                this.cfw.addInvoke(185, "org/mozilla/javascript/Scriptable", "getPrototype", "()Lorg/mozilla/javascript/Scriptable;");
                this.cfw.markLabel(after);
                break;
            }
            case 70: {
                this.cfw.addALoad(this.funObjLocal);
                break;
            }
            case 47: {
                this.cfw.add(1);
                break;
            }
            case 48: {
                Codegen.pushUndefined(this.cfw);
                break;
            }
            case 51: {
                this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                break;
            }
            case 50: {
                this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                break;
            }
            case 54: {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                int i = node.getExistingIntProp(4);
                this.cfw.add(178, this.codegen.mainClassName, this.codegen.getCompiledRegexpName(this.scriptOrFn, i), "Ljava/lang/Object;");
                this.cfw.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "wrapRegExp", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
                break;
            }
            case 100: {
                Node child;
                for (Node next = child.getNext(); next != null; next = next.getNext()) {
                    this.generateExpression(child, node);
                    this.cfw.add(87);
                    child = next;
                }
                this.generateExpression(child, node);
                break;
            }
            case 68: 
            case 69: {
                int local = BodyCodegen.getLocalBlockRegister(node);
                this.cfw.addALoad(local);
                this.cfw.addALoad(this.contextLocal);
                if (type == 68) {
                    this.addScriptRuntimeInvoke("enumNext", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Boolean;");
                    break;
                }
                this.addScriptRuntimeInvoke("enumId", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 72: {
                Node child;
                this.visitArrayLiteral(node, child, false);
                break;
            }
            case 73: {
                Node child;
                this.visitObjectLiteral(node, child, false);
                break;
            }
            case 26: {
                Node child;
                int trueTarget = this.cfw.acquireLabel();
                int falseTarget = this.cfw.acquireLabel();
                int beyond = this.cfw.acquireLabel();
                this.generateIfJump(child, node, trueTarget, falseTarget);
                this.cfw.markLabel(trueTarget);
                this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                this.cfw.add(167, beyond);
                this.cfw.markLabel(falseTarget);
                this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                this.cfw.markLabel(beyond);
                this.cfw.adjustStackTop(-1);
                break;
            }
            case 27: {
                Node child;
                this.visitBitNot(node, child);
                break;
            }
            case 141: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.add(87);
                Codegen.pushUndefined(this.cfw);
                break;
            }
            case 32: {
                Node child;
                this.generateExpression(child, node);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
                break;
            }
            case 153: {
                this.visitTypeofname(node);
                break;
            }
            case 121: 
            case 122: {
                this.visitIncDec(node);
                break;
            }
            case 119: 
            case 120: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.add(89);
                this.addDynamicInvoke("MATH:TOBOOLEAN", "(Ljava/lang/Object;)Z");
                int falseTarget = this.cfw.acquireLabel();
                if (type == 120) {
                    this.cfw.add(153, falseTarget);
                } else {
                    this.cfw.add(154, falseTarget);
                }
                this.cfw.add(87);
                this.generateExpression(child.getNext(), node);
                this.cfw.markLabel(falseTarget);
                break;
            }
            case 117: {
                Node child;
                Node ifThen = child.getNext();
                Node ifElse = ifThen.getNext();
                this.generateExpression(child, node);
                this.addDynamicInvoke("MATH:TOBOOLEAN", "(Ljava/lang/Object;)Z");
                int elseTarget = this.cfw.acquireLabel();
                this.cfw.add(153, elseTarget);
                int stack = this.cfw.getStackTop();
                this.generateExpression(ifThen, node);
                int afterHook = this.cfw.acquireLabel();
                this.cfw.add(167, afterHook);
                this.cfw.markLabel(elseTarget, stack);
                this.generateExpression(ifElse, node);
                this.cfw.markLabel(afterHook);
                break;
            }
            case 21: {
                Node child;
                this.generateExpression(child, node);
                this.generateExpression(child.getNext(), node);
                switch (node.getIntProp(8, -1)) {
                    case 0: {
                        this.cfw.add(99);
                        break block0;
                    }
                    case 1: {
                        this.cfw.addALoad(this.contextLocal);
                        this.addOptRuntimeInvoke("add", "(DLjava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                        break block0;
                    }
                    case 2: {
                        this.cfw.addALoad(this.contextLocal);
                        this.addOptRuntimeInvoke("add", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                        break block0;
                    }
                }
                this.cfw.addALoad(this.contextLocal);
                this.addDynamicInvoke("MATH:ADD", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 82: {
                Node child;
                this.generateExpression(child, node);
                this.generateExpression(child.getNext(), node);
                this.addScriptRuntimeInvoke("concat", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                Node child;
                this.visitArithmetic(node, type, child, parent);
                break;
            }
            case 83: {
                Node child;
                this.visitExponentiation(node, child, parent);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                Node child;
                this.visitBitOp(node, type, child);
                break;
            }
            case 28: {
                Node child;
                int childNumberFlag = node.getIntProp(8, -1);
                this.generateExpression(child, node);
                if (childNumberFlag != -1) break;
                this.addObjectToDouble();
                this.addDoubleWrap();
                break;
            }
            case 29: {
                Node child;
                int childNumberFlag = node.getIntProp(8, -1);
                this.generateExpression(child, node);
                if (childNumberFlag == -1) {
                    this.addObjectToNumeric();
                    this.addScriptRuntimeInvoke("negate", "(Ljava/lang/Number;)Ljava/lang/Number;");
                    break;
                }
                this.cfw.add(119);
                break;
            }
            case 166: {
                Node child;
                this.generateExpression(child, node);
                this.addObjectToDouble();
                break;
            }
            case 165: {
                Node child;
                int prop = -1;
                if (child.getType() == 45) {
                    prop = child.getIntProp(8, -1);
                }
                if (prop != -1) {
                    child.removeProp(8);
                    this.generateExpression(child, node);
                    child.putIntProp(8, prop);
                    break;
                }
                this.generateExpression(child, node);
                this.addDoubleWrap();
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 58: 
            case 59: {
                Node child;
                int trueGOTO = this.cfw.acquireLabel();
                int falseGOTO = this.cfw.acquireLabel();
                this.visitIfJumpRelOp(node, child, trueGOTO, falseGOTO);
                this.addJumpedBooleanWrap(trueGOTO, falseGOTO);
                break;
            }
            case 12: 
            case 13: 
            case 52: 
            case 53: {
                Node child;
                int trueGOTO = this.cfw.acquireLabel();
                int falseGOTO = this.cfw.acquireLabel();
                this.visitIfJumpEqOp(node, child, trueGOTO, falseGOTO);
                this.addJumpedBooleanWrap(trueGOTO, falseGOTO);
                break;
            }
            case 33: 
            case 34: {
                Node child;
                this.visitGetProp(node, child);
                break;
            }
            case 39: {
                Node child;
                this.generateExpression(child, node);
                if (node.getIntProp(30, 0) == 1) {
                    int getElem = this.cfw.acquireLabel();
                    int after = this.cfw.acquireLabel();
                    this.cfw.add(89);
                    this.addOptRuntimeInvoke("isNullOrUndefined", "(Ljava/lang/Object;)Z");
                    this.cfw.add(153, getElem);
                    this.cfw.add(87);
                    Codegen.pushUndefined(this.cfw);
                    this.cfw.add(167, after);
                    this.cfw.markLabel(getElem);
                    this.finishGetElemGeneration(node, child);
                    this.cfw.markLabel(after);
                    break;
                }
                this.finishGetElemGeneration(node, child);
                break;
            }
            case 74: {
                Node child;
                this.generateExpression(child, node);
                if (node.getIntProp(30, 0) == 1) {
                    int getRef = this.cfw.acquireLabel();
                    int after = this.cfw.acquireLabel();
                    this.cfw.add(89);
                    this.addOptRuntimeInvoke("isNullOrUndefined", "(Ljava/lang/Object;)Z");
                    this.cfw.add(153, getRef);
                    this.cfw.add(167, after);
                    this.cfw.markLabel(getRef);
                    this.cfw.add(192, "org/mozilla/javascript/Ref");
                    this.finishGetRefGeneration();
                    this.cfw.markLabel(after);
                    break;
                }
                this.finishGetRefGeneration();
                break;
            }
            case 61: {
                this.visitGetVar(node);
                break;
            }
            case 62: {
                Node child;
                this.visitSetVar(node, child, true);
                break;
            }
            case 8: {
                Node child;
                this.visitSetName(node, child);
                break;
            }
            case 81: {
                Node child;
                this.visitStrictSetName(node, child);
                break;
            }
            case 171: {
                Node child;
                this.visitSetConst(node, child);
                break;
            }
            case 172: {
                Node child;
                this.visitSetConstVar(node, child, true);
                break;
            }
            case 37: 
            case 155: {
                Node child;
                this.visitSetProp(type, node, child);
                break;
            }
            case 41: 
            case 156: {
                Node child;
                this.visitSetElem(type, node, child);
                break;
            }
            case 75: 
            case 158: {
                Node child;
                this.generateExpression(child, node);
                child = child.getNext();
                if (type == 158) {
                    this.cfw.add(89);
                    this.cfw.addALoad(this.contextLocal);
                    this.addScriptRuntimeInvoke("refGet", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                }
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("refSet", "(Lorg/mozilla/javascript/Ref;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                break;
            }
            case 76: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("refDel", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 31: {
                Node child;
                boolean isName = child.getType() == 55;
                this.generateExpression(child, node);
                child = child.getNext();
                this.generateExpression(child, node);
                if (node.getIntProp(31, 0) == 1) {
                    this.cfw.add(88);
                    this.cfw.addLoadConstant(0);
                    this.addScriptRuntimeInvoke("throwDeleteOnSuperPropertyNotAllowed", "()V");
                    break;
                }
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(isName);
                this.addScriptRuntimeInvoke("delete", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Z)Ljava/lang/Object;");
                break;
            }
            case 55: {
                Node child;
                for (child = node.getFirstChild(); child != null; child = child.getNext()) {
                    this.generateExpression(child, node);
                }
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.contextLocal);
                this.addDynamicInvoke("NAME:BIND:" + node.getString(), "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Scriptable;");
                break;
            }
            case 60: {
                this.cfw.addALoad(BodyCodegen.getLocalBlockRegister(node));
                break;
            }
            case 78: {
                Node child;
                this.generateExpression(child, node);
                if (node.getIntProp(30, 0) == 1) {
                    int getExpr = this.cfw.acquireLabel();
                    int after = this.cfw.acquireLabel();
                    this.cfw.add(89);
                    this.addOptRuntimeInvoke("isNullOrUndefined", "(Ljava/lang/Object;)Z");
                    this.cfw.add(153, getExpr);
                    this.cfw.add(87);
                    Codegen.pushUndefined(this.cfw);
                    this.cfw.add(167, after);
                    this.cfw.markLabel(getExpr);
                    this.finishRefSpecialGeneration(node);
                    this.cfw.markLabel(after);
                    break;
                }
                this.finishRefSpecialGeneration(node);
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                String signature;
                String methodName;
                Node child;
                int memberTypeFlags = node.getIntProp(16, 0);
                do {
                    this.generateExpression(child, node);
                } while ((child = child.getNext()) != null);
                this.cfw.addALoad(this.contextLocal);
                switch (type) {
                    case 87: {
                        methodName = "memberRef";
                        signature = "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;I)Lorg/mozilla/javascript/Ref;";
                        break;
                    }
                    case 88: {
                        methodName = "memberRef";
                        signature = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;I)Lorg/mozilla/javascript/Ref;";
                        break;
                    }
                    case 89: {
                        methodName = "nameRef";
                        signature = "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Lorg/mozilla/javascript/Ref;";
                        this.cfw.addALoad(this.variableObjectLocal);
                        break;
                    }
                    case 90: {
                        methodName = "nameRef";
                        signature = "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Lorg/mozilla/javascript/Ref;";
                        this.cfw.addALoad(this.variableObjectLocal);
                        break;
                    }
                    default: {
                        throw Kit.codeBug();
                    }
                }
                this.cfw.addPush(memberTypeFlags);
                this.addScriptRuntimeInvoke(methodName, signature);
                break;
            }
            case 162: {
                Node child;
                this.visitDotQuery(node, child);
                break;
            }
            case 85: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("escapeAttributeValue", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/String;");
                break;
            }
            case 86: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("escapeTextValue", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/String;");
                break;
            }
            case 84: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("setDefaultNamespace", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 79: 
            case 181: {
                this.generateYieldPoint(node, true);
                break;
            }
            case 175: {
                Node child;
                Node with = child.getNext();
                Node leaveWith = with.getNext();
                this.generateStatement(child);
                this.generateExpression(with.getFirstChild(), with);
                this.generateStatement(leaveWith);
                break;
            }
            case 173: {
                Node child;
                Node expr = child.getNext();
                this.generateStatement(child);
                this.generateExpression(expr, node);
                break;
            }
            case 182: {
                this.visitTemplateLiteral(node);
                break;
            }
            case 187: {
                Node child;
                this.generateExpression(child, node);
                int end = this.cfw.acquireLabel();
                this.cfw.add(89);
                this.addOptRuntimeInvoke("isNullOrUndefined", "(Ljava/lang/Object;)Z");
                this.cfw.add(153, end);
                this.cfw.add(87);
                this.generateExpression(child.getNext(), node);
                this.cfw.markLabel(end);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected node type " + type);
            }
        }
    }

    private void finishGetElemGeneration(Node node, Node child) {
        this.generateExpression(child.getNext(), node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (node.getIntProp(31, 0) == 1) {
            this.cfw.addALoad(this.thisObjLocal);
            this.addDynamicInvoke("PROP:GETELEMENTSUPER", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Ljava/lang/Object;");
        } else if (node.getIntProp(8, -1) != -1) {
            this.addDynamicInvoke("PROP:GETINDEX", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        } else {
            this.addDynamicInvoke("PROP:GETELEMENT", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        }
    }

    private void finishGetRefGeneration() {
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("refGet", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
    }

    private void finishRefSpecialGeneration(Node node) {
        String special = (String)node.getProp(17);
        this.cfw.addPush(special);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("specialRef", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Ref;");
    }

    private Node findNestedYield(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            if (child.getType() == 79 || child.getType() == 181) {
                return child;
            }
            Node grandchild = this.findNestedYield(child);
            if (grandchild == null) continue;
            return grandchild;
        }
        return null;
    }

    private void generateYieldPoint(Node node, boolean exprContext) {
        if (this.unnestedYields.containsKey(node)) {
            if (exprContext) {
                String name = this.unnestedYields.get(node);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addDynamicInvoke("PROP:GETNOWARN:" + name, "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            }
            return;
        }
        Node nestedYield = this.findNestedYield(node);
        if (nestedYield != null) {
            this.generateYieldPoint(nestedYield, true);
            String nn = "__nested__yield__" + this.unnestedYieldCount;
            ++this.unnestedYieldCount;
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.add(95);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addDynamicInvoke("PROP:SET:" + nn, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            this.cfw.add(87);
            this.unnestedYields.put(nestedYield, nn);
        }
        this.generateLocalYieldPoint(node, exprContext);
    }

    private void generateLocalYieldPoint(Node node, boolean exprContext) {
        Node child;
        int top = this.cfw.getStackTop();
        int n = this.maxStack = this.maxStack > top ? this.maxStack : top;
        if (top != 0) {
            this.generateGetGeneratorStackState();
            for (int i = 0; i < top; ++i) {
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addLoadConstant(i);
                this.cfw.add(95);
                this.cfw.add(83);
            }
            this.cfw.add(87);
        }
        if ((child = node.getFirstChild()) != null) {
            this.generateExpression(child, node);
        } else {
            Codegen.pushUndefined(this.cfw);
        }
        if (node.getType() == 181) {
            this.cfw.add(187, "org/mozilla/javascript/ES6Generator$YieldStarResult");
            this.cfw.add(90);
            this.cfw.add(95);
            this.cfw.addInvoke(183, "org/mozilla/javascript/ES6Generator$YieldStarResult", "<init>", "(Ljava/lang/Object;)V");
        }
        int nextState = this.getNextGeneratorState(node);
        this.generateSetGeneratorResumptionPoint(nextState);
        boolean hasLocals = this.generateSaveLocals(node);
        this.cfw.add(176);
        this.generateCheckForThrowOrClose(this.getTargetLabel(node), hasLocals, nextState);
        if (top != 0) {
            this.generateGetGeneratorStackState();
            for (int i = top - 1; i >= 0; --i) {
                this.cfw.add(89);
                this.cfw.addLoadConstant(i);
                this.cfw.add(50);
                this.cfw.add(95);
            }
            this.cfw.add(87);
        }
        if (exprContext) {
            this.cfw.addALoad(this.argsLocal);
        }
    }

    private void generateCheckForThrowOrClose(int label, boolean hasLocals, int nextState) {
        int throwLabel = this.cfw.acquireLabel();
        int closeLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(throwLabel);
        this.cfw.addALoad(this.argsLocal);
        this.generateThrowJavaScriptException();
        this.cfw.markLabel(closeLabel);
        this.cfw.addALoad(this.argsLocal);
        this.cfw.add(192, "java/lang/Throwable");
        this.cfw.add(191);
        if (label != -1) {
            this.cfw.markLabel(label);
        }
        if (!hasLocals) {
            this.cfw.markTableSwitchCase(this.generatorSwitch, nextState);
        }
        this.cfw.addILoad(this.operationLocal);
        this.cfw.addLoadConstant(2);
        this.cfw.add(159, closeLabel);
        this.cfw.addILoad(this.operationLocal);
        this.cfw.addLoadConstant(1);
        this.cfw.add(159, throwLabel);
    }

    private void visitTemplateLiteral(Node node) {
        int index = node.getExistingIntProp(27);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.add(178, this.codegen.mainClassName, this.codegen.getTemplateLiteralName(this.scriptOrFn), "[Ljava/lang/Object;");
        this.cfw.addPush(index);
        this.cfw.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "getTemplateLiteralCallSite", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;I)Lorg/mozilla/javascript/Scriptable;");
    }

    private void generateIfJump(Node node, Node parent, int trueLabel, int falseLabel) {
        int type = node.getType();
        Node child = node.getFirstChild();
        switch (type) {
            case 26: {
                this.generateIfJump(child, node, falseLabel, trueLabel);
                break;
            }
            case 119: 
            case 120: {
                int interLabel = this.cfw.acquireLabel();
                if (type == 120) {
                    this.generateIfJump(child, node, interLabel, falseLabel);
                } else {
                    this.generateIfJump(child, node, trueLabel, interLabel);
                }
                this.cfw.markLabel(interLabel);
                child = child.getNext();
                this.generateIfJump(child, node, trueLabel, falseLabel);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 58: 
            case 59: {
                this.visitIfJumpRelOp(node, child, trueLabel, falseLabel);
                break;
            }
            case 12: 
            case 13: 
            case 52: 
            case 53: {
                this.visitIfJumpEqOp(node, child, trueLabel, falseLabel);
                break;
            }
            default: {
                this.generateExpression(node, parent);
                this.addDynamicInvoke("MATH:TOBOOLEAN", "(Ljava/lang/Object;)Z");
                this.cfw.add(154, trueLabel);
                this.cfw.add(167, falseLabel);
            }
        }
    }

    private void visitFunction(OptFunctionNode ofn, int functionType) {
        int fnIndex = this.codegen.getIndex(ofn.fnode);
        this.cfw.add(187, "org.mozilla.javascript.JSFunction");
        this.cfw.add(89);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.add(178, this.cfw.getClassName(), "_descriptors", "[Lorg/mozilla/javascript/JSDescriptor;");
        this.cfw.addPush(fnIndex);
        this.cfw.add(50);
        if (functionType == 4) {
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke(182, this.scriptOrFnClass, "getHomeObject", "()Lorg/mozilla/javascript/Scriptable;");
        } else if (ofn.fnode.isMethodDefinition()) {
            this.cfw.add(1);
            this.cfw.addALoad(this.savedHomeObjectLocal);
        } else {
            this.cfw.add(1);
            this.cfw.add(1);
        }
        this.cfw.addInvoke(183, "org.mozilla.javascript.JSFunction", "<init>", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/JSDescriptor;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)V");
        if (functionType == 2 || functionType == 4) {
            return;
        }
        this.cfw.addPush(functionType);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.addOptRuntimeInvoke("initFunction", "(Lorg/mozilla/javascript/JSFunction;ILorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)V");
    }

    private int getTargetLabel(Node target) {
        int labelId = target.labelId();
        if (labelId == -1) {
            labelId = this.cfw.acquireLabel();
            target.labelId(labelId);
        }
        return labelId;
    }

    private void visitGoto(Jump node, int type, Node child) {
        Node target = node.target;
        if (type == 6 || type == 7) {
            if (child == null) {
                throw Codegen.badTree();
            }
            int targetLabel = this.getTargetLabel(target);
            int fallThruLabel = this.cfw.acquireLabel();
            if (type == 6) {
                this.generateIfJump(child, node, targetLabel, fallThruLabel);
            } else {
                this.generateIfJump(child, node, fallThruLabel, targetLabel);
            }
            this.cfw.markLabel(fallThruLabel);
        } else if (type == 151) {
            if (this.isGenerator) {
                this.addGotoWithReturn(target);
            } else {
                this.inlineFinally(target);
            }
        } else {
            this.addGoto(target, 167);
        }
    }

    private void addGotoWithReturn(Node target) {
        FinallyReturnPoint ret = this.finallys.get(target);
        this.cfw.addLoadConstant(ret.jsrPoints.size());
        this.addGoto(target, 167);
        this.cfw.add(87);
        int retLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(retLabel);
        ret.jsrPoints.add(retLabel);
    }

    private void generateArrayLiteralFactory(Node node, int count) {
        String methodName = this.codegen.getBodyMethodName(this.scriptOrFn) + "_literal" + count;
        this.initBodyGeneration();
        this.argsLocal = this.firstFreeLocal++;
        this.localsMax = this.firstFreeLocal;
        this.cfw.startMethod(methodName, "(Lorg/mozilla/javascript/Context;" + this.scriptOrFnType + "Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;", (short)10);
        this.visitArrayLiteral(node, node.getFirstChild(), true);
        this.cfw.add(176);
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void generateObjectLiteralFactory(Node node, int count) {
        String methodName = this.codegen.getBodyMethodName(this.scriptOrFn) + "_literal" + count;
        this.initBodyGeneration();
        this.argsLocal = this.firstFreeLocal++;
        this.localsMax = this.firstFreeLocal;
        this.cfw.startMethod(methodName, "(Lorg/mozilla/javascript/Context;" + this.scriptOrFnType + "Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;", (short)10);
        this.visitObjectLiteral(node, node.getFirstChild(), true);
        this.cfw.add(176);
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void visitArrayLiteral(Node node, Node child, boolean topLevel) {
        int[] skipIndexes;
        int i;
        int numberOfSpread = node.getIntProp(32, 0);
        if (numberOfSpread > 0) {
            this.visitArrayLiteralWithSpread(node, child, numberOfSpread);
            return;
        }
        int count = BodyCodegen.countArguments(child);
        if (!(topLevel || count <= 10 && this.cfw.getCurrentCodeOffset() <= 30000 || this.hasVarsInRegs || this.isGenerator || this.inLocalBlock)) {
            if (this.literals == null) {
                this.literals = new ArrayList();
            }
            this.literals.add(node);
            String methodName = this.codegen.getBodyMethodName(this.scriptOrFn) + "_literal" + this.literals.size();
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.newTargetLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.argsLocal);
            this.cfw.addInvoke(184, this.codegen.mainClassName, methodName, "(Lorg/mozilla/javascript/Context;" + this.scriptOrFnType + "Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        if (this.isGenerator) {
            for (i = 0; i != count; ++i) {
                this.generateExpression(child, node);
                child = child.getNext();
            }
            this.addNewObjectArray(count);
            for (i = 0; i != count; ++i) {
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addPush(count - i - 1);
                this.cfw.add(95);
                this.cfw.add(83);
            }
        } else {
            this.addNewObjectArray(count);
            for (i = 0; i != count; ++i) {
                this.cfw.add(89);
                this.cfw.addPush(i);
                this.generateExpression(child, node);
                this.cfw.add(83);
                child = child.getNext();
            }
        }
        if ((skipIndexes = (int[])node.getProp(11)) == null) {
            this.cfw.add(1);
            this.cfw.add(3);
        } else {
            this.cfw.addPush(OptRuntime.encodeIntArray(skipIndexes));
            this.cfw.addPush(skipIndexes.length);
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke("newArrayLiteral", "([Ljava/lang/Object;Ljava/lang/String;ILorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void visitArrayLiteralWithSpread(Node node, Node child, int numberOfSpread) {
        int count = BodyCodegen.countArguments(child);
        int[] skipIndexes = (int[])node.getProp(11);
        int[] sourcePositions = null;
        if (skipIndexes != null) {
            sourcePositions = new int[count];
            int sourcePos = 0;
            int skipIdx = 0;
            for (int i = 0; i < count; ++i) {
                while (skipIdx < skipIndexes.length && skipIndexes[skipIdx] == sourcePos) {
                    ++sourcePos;
                    ++skipIdx;
                }
                sourcePositions[i] = sourcePos++;
            }
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addLoadConstant(count - numberOfSpread);
        this.cfw.addLoadConstant(0);
        this.cfw.addInvoke(184, "org/mozilla/javascript/NewLiteralStorage", "create", "(Lorg/mozilla/javascript/Context;IZ)Lorg/mozilla/javascript/NewLiteralStorage;");
        if (skipIndexes != null) {
            this.cfw.add(89);
            this.cfw.addLoadConstant(skipIndexes.length);
            this.cfw.add(188, 10);
            for (int i = 0; i < skipIndexes.length; ++i) {
                this.cfw.add(89);
                this.cfw.addLoadConstant(i);
                this.cfw.addLoadConstant(skipIndexes[i]);
                this.cfw.add(79);
            }
            this.cfw.addInvoke(182, "org/mozilla/javascript/NewLiteralStorage", "setSkipIndexes", "([I)V");
        }
        int childIdx = 0;
        while (child != null) {
            if (child.getType() == 186) {
                this.cfw.add(89);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.generateExpression(child.getFirstChild(), node);
                if (skipIndexes != null) {
                    this.cfw.addLoadConstant(sourcePositions[childIdx]);
                } else {
                    this.cfw.addLoadConstant(0);
                }
                this.cfw.addInvoke(182, "org/mozilla/javascript/NewLiteralStorage", "spread", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;I)V");
            } else {
                this.cfw.add(89);
                this.generateExpression(child, node);
                this.cfw.addInvoke(182, "org/mozilla/javascript/NewLiteralStorage", "pushValue", "(Ljava/lang/Object;)V");
            }
            child = child.getNext();
            ++childIdx;
        }
        short storageLocal = this.getNewWordLocal();
        this.cfw.addAStore(storageLocal);
        this.cfw.addALoad(storageLocal);
        this.cfw.addInvoke(182, "org/mozilla/javascript/NewLiteralStorage", "getValues", "()[Ljava/lang/Object;");
        if (skipIndexes != null) {
            this.cfw.addALoad(storageLocal);
            this.cfw.addInvoke(182, "org/mozilla/javascript/NewLiteralStorage", "getAdjustedSkipIndexes", "()[I");
        } else {
            this.cfw.add(1);
        }
        this.releaseWordLocal(storageLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke("newArrayLiteral", "([Ljava/lang/Object;[ILorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void addLoadProperty(Node node, Node child, Object[] properties, int count) {
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addLoadConstant(count - node.getIntProp(32, 0));
        this.cfw.addLoadConstant(1);
        this.cfw.addInvoke(184, "org/mozilla/javascript/NewLiteralStorage", "create", "(Lorg/mozilla/javascript/Context;IZ)Lorg/mozilla/javascript/NewLiteralStorage;");
        if (count == 0) {
            return;
        }
        if (this.isGenerator) {
            this.cfw.add(192, "java/lang/Object");
            short local = this.getNewWordLocal();
            this.cfw.addAStore(local);
            for (int i = 0; i < count; ++i) {
                if (child.getType() == 186) {
                    this.cfw.addALoad(this.contextLocal);
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.generateExpression(child.getFirstChild(), node);
                    this.cfw.addALoad(local);
                    this.cfw.add(192, "org/mozilla/javascript/NewLiteralStorage");
                    this.cfw.add(95);
                    this.cfw.addLoadConstant(0);
                    this.addOptRuntimeInvoke("spread", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NewLiteralStorage;Ljava/lang/Object;I)V");
                } else {
                    this.addLoadPropertyId(node, properties, i);
                    this.cfw.addALoad(local);
                    this.cfw.add(192, "org/mozilla/javascript/NewLiteralStorage");
                    this.cfw.add(95);
                    this.cfw.addInvoke(182, "org/mozilla/javascript/NewLiteralStorage", "pushKey", "(Ljava/lang/Object;)V");
                    this.addLoadPropertyValue(node, child);
                    this.cfw.addALoad(local);
                    this.cfw.add(192, "org/mozilla/javascript/NewLiteralStorage");
                    this.cfw.add(95);
                    String methodName = BodyCodegen.getStoreMethodNameForLiteralProperty(child);
                    this.cfw.addInvoke(182, "org/mozilla/javascript/NewLiteralStorage", methodName, "(Ljava/lang/Object;)V");
                }
                child = child.getNext();
            }
            this.cfw.addALoad(local);
            this.cfw.add(192, "org/mozilla/javascript/NewLiteralStorage");
            this.releaseWordLocal(local);
        } else {
            for (int i = 0; i < count; ++i) {
                if (child.getType() == 186) {
                    this.cfw.add(89);
                    this.cfw.addALoad(this.contextLocal);
                    this.cfw.add(95);
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.cfw.add(95);
                    this.generateExpression(child.getFirstChild(), node);
                    this.cfw.addLoadConstant(0);
                    this.addOptRuntimeInvoke("spread", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NewLiteralStorage;Ljava/lang/Object;I)V");
                } else {
                    this.cfw.add(89);
                    this.addLoadPropertyId(node, properties, i);
                    this.cfw.addInvoke(182, "org/mozilla/javascript/NewLiteralStorage", "pushKey", "(Ljava/lang/Object;)V");
                    this.cfw.add(89);
                    this.addLoadPropertyValue(node, child);
                    String methodName = BodyCodegen.getStoreMethodNameForLiteralProperty(child);
                    this.cfw.addInvoke(182, "org/mozilla/javascript/NewLiteralStorage", methodName, "(Ljava/lang/Object;)V");
                }
                child = child.getNext();
            }
        }
    }

    private static String getStoreMethodNameForLiteralProperty(Node child) {
        switch (child.getType()) {
            case 167: {
                return "pushGetter";
            }
            case 168: {
                return "pushSetter";
            }
        }
        return "pushValue";
    }

    private void addLoadPropertyValue(Node node, Node child) {
        int childType = child.getType();
        if (childType == 167 || childType == 168 || childType == 179) {
            this.generateExpression(child.getFirstChild(), node);
        } else {
            this.generateExpression(child, node);
        }
    }

    private void addLoadPropertyId(Node node, Object[] properties, int i) {
        Object id = properties[i];
        if (id instanceof Node) {
            Node computedPropertyNode = (Node)id;
            this.generateExpression(computedPropertyNode.getFirstChild(), node);
        } else if (id instanceof String) {
            this.cfw.addPush((String)id);
        } else {
            this.cfw.addPush((Integer)id);
            this.addScriptRuntimeInvoke("wrapInt", "(I)Ljava/lang/Integer;");
        }
    }

    private void visitObjectLiteral(Node node, Node child, boolean topLevel) {
        int count;
        Object[] properties = (Object[])node.getProp(12);
        int n = count = properties == null ? 0 : properties.length;
        if (!(topLevel || count <= 10 && this.cfw.getCurrentCodeOffset() <= 30000 || this.hasVarsInRegs || this.isGenerator || this.inLocalBlock)) {
            if (this.literals == null) {
                this.literals = new ArrayList();
            }
            this.literals.add(node);
            String methodName = this.codegen.getBodyMethodName(this.scriptOrFn) + "_literal" + this.literals.size();
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.newTargetLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.argsLocal);
            this.cfw.addInvoke(184, this.codegen.mainClassName, methodName, "(Lorg/mozilla/javascript/Context;" + this.scriptOrFnType + "Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addInvoke(182, "org/mozilla/javascript/Context", "newObject", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.add(89);
        this.savedHomeObjectLocal = this.getNewWordLocal();
        this.cfw.addAStore(this.savedHomeObjectLocal);
        this.cfw.add(89);
        this.addLoadProperty(node, child, properties, count);
        this.cfw.add(89);
        this.cfw.addInvoke(182, "org/mozilla/javascript/NewLiteralStorage", "getKeys", "()[Ljava/lang/Object;");
        this.cfw.add(95);
        this.cfw.add(89);
        this.cfw.addInvoke(182, "org/mozilla/javascript/NewLiteralStorage", "getValues", "()[Ljava/lang/Object;");
        this.cfw.add(95);
        this.cfw.addInvoke(182, "org/mozilla/javascript/NewLiteralStorage", "getGetterSetters", "()[I");
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("fillObjectLiteral", "(Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;[Ljava/lang/Object;[ILorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)V");
    }

    private void visitSpecialCall(Node node, int type, int specialType, Node child) {
        if (type == 30) {
            this.visitSpecialNewCall(node, specialType, child);
        } else if (node.getIntProp(30, 0) == 1) {
            this.visitSpecialOptionalChainingCall(node, specialType, child);
        } else {
            this.visitSpecialNormalCall(node, specialType, child);
        }
    }

    private void visitSpecialNewCall(Node node, int specialType, Node child) {
        this.cfw.addALoad(this.contextLocal);
        this.generateExpression(child, node);
        child = child.getNext();
        this.generateCallArgArray(node, child, false);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(specialType);
        this.addScriptRuntimeInvoke("newSpecial", "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
    }

    private void visitSpecialNormalCall(Node node, int specialType, Node child) {
        this.cfw.addALoad(this.contextLocal);
        this.generateFunctionAndThisObj(child, node);
        child = child.getNext();
        this.generateCallArgArray(node, child, false);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.thisObjLocal);
        this.cfw.addPush(specialType);
        String sourceName = this.scriptOrFn.getSourceName();
        this.cfw.addPush(sourceName == null ? "" : sourceName);
        this.cfw.addPush(this.itsLineNumber);
        this.cfw.addPush(false);
        this.addScriptRuntimeInvoke("callSpecial", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;ILjava/lang/String;IZ)Ljava/lang/Object;");
    }

    private void visitSpecialOptionalChainingCall(Node node, int specialType, Node child) {
        this.generateLookupResult(child, node);
        int afterLabel = this.cfw.acquireLabel();
        int doCallLabel = this.cfw.acquireLabel();
        this.cfw.add(89);
        this.addOptRuntimeInvoke("isNullOrUndefined", "(Ljava/lang/Object;)Z");
        this.cfw.add(153, doCallLabel);
        this.cfw.add(87);
        Codegen.pushUndefined(this.cfw);
        this.cfw.add(167, afterLabel);
        this.cfw.markLabel(doCallLabel);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.add(95);
        this.popFunctionAndThis();
        child = child.getNext();
        this.generateCallArgArray(node, child, false);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.thisObjLocal);
        this.cfw.addPush(specialType);
        String sourceName = this.scriptOrFn.getSourceName();
        this.cfw.addPush(sourceName == null ? "" : sourceName);
        this.cfw.addPush(this.itsLineNumber);
        this.cfw.addPush(true);
        this.addScriptRuntimeInvoke("callSpecial", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;ILjava/lang/String;IZ)Ljava/lang/Object;");
        this.cfw.markLabel(afterLabel);
    }

    private void visitStandardCall(Node node, Node child) {
        assert (node.getType() == 43);
        Node firstArgChild = child.getNext();
        Integer afterLabel = null;
        this.generateLookupResult(child, node);
        if (node.getIntProp(30, 0) == 1) {
            afterLabel = this.cfw.acquireLabel();
            int doCallLabel = this.cfw.acquireLabel();
            this.cfw.add(89);
            this.addOptRuntimeInvoke("isNullOrUndefined", "(Ljava/lang/Object;)Z");
            this.cfw.add(153, doCallLabel);
            this.cfw.add(87);
            Codegen.pushUndefined(this.cfw);
            this.cfw.add(167, afterLabel);
            this.cfw.markLabel(doCallLabel);
        }
        this.generateCallArgArray(node, firstArgChild, false);
        this.cfw.addAStore(this.argsLocal);
        if (node.getIntProp(31, 0) == 1) {
            this.cfw.addInvoke(182, "org.mozilla.javascript.ScriptRuntime$LookupResult", "getCallable", "()Lorg/mozilla/javascript/Callable;");
            this.cfw.addALoad(this.thisObjLocal);
        } else {
            this.popFunctionAndThis();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.add(95);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.add(95);
        this.cfw.addALoad(this.argsLocal);
        this.cfw.addInvoke(185, "org/mozilla/javascript/Callable", "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        if (afterLabel != null) {
            this.cfw.markLabel(afterLabel);
        }
    }

    private static int countArguments(Node firstArgChild) {
        int argCount = 0;
        for (Node arg = firstArgChild; arg != null; arg = arg.getNext()) {
            ++argCount;
        }
        return argCount;
    }

    private void visitStandardNew(Node node, Node child) {
        if (node.getType() != 30) {
            throw Codegen.badTree();
        }
        Node firstArgChild = child.getNext();
        this.generateExpression(child, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.generateCallArgArray(node, firstArgChild, false);
        this.addScriptRuntimeInvoke("newObject", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void visitOptimizedCall(Node node, OptFunctionNode target, int type, Node child) {
        if (node.getIntProp(31, 0) == 1) {
            Kit.codeBug();
        }
        Node firstArgChild = child.getNext();
        String className = "org.mozilla.javascript.JSFunction";
        short thisObjLocal = 0;
        if (type == 30) {
            this.generateExpression(child, node);
        } else {
            this.generateFunctionAndThisObj(child, node);
            thisObjLocal = this.getNewWordLocal();
            this.cfw.addAStore(thisObjLocal);
        }
        int beyond = this.cfw.acquireLabel();
        int regularCall = this.cfw.acquireLabel();
        this.cfw.add(89);
        this.cfw.add(193, className);
        this.cfw.add(153, regularCall);
        this.cfw.add(192, className);
        this.cfw.add(89);
        this.cfw.addInvoke(182, className, "getDescriptor", "()Lorg/mozilla/javascript/JSDescriptor;");
        this.cfw.add(178, this.cfw.getClassName(), "_descriptors", "[Lorg/mozilla/javascript/JSDescriptor;");
        this.cfw.addPush(this.codegen.getIndex(target.fnode));
        this.cfw.add(50);
        this.cfw.add(166, regularCall);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.add(95);
        this.cfw.addALoad(this.newTargetLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (type == 30) {
            this.cfw.add(1);
        } else {
            this.cfw.addALoad(thisObjLocal);
        }
        for (Node argChild = firstArgChild; argChild != null; argChild = argChild.getNext()) {
            int dcp_register = this.nodeIsDirectCallParameter(argChild);
            if (dcp_register >= 0) {
                this.cfw.addALoad(dcp_register);
                this.cfw.addDLoad(dcp_register + 1);
                continue;
            }
            if (argChild.getIntProp(8, -1) == 0) {
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.generateExpression(argChild, node);
                continue;
            }
            this.generateExpression(argChild, node);
            this.cfw.addPush(0.0);
        }
        this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
        this.cfw.addInvoke(184, this.codegen.mainClassName, type == 30 ? this.codegen.getDirectCtorName(target.fnode) : this.codegen.getBodyMethodName(target.fnode), this.codegen.getBodyMethodSignature(target.fnode));
        this.cfw.add(167, beyond);
        this.cfw.markLabel(regularCall);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (type != 30) {
            this.cfw.addALoad(thisObjLocal);
            this.releaseWordLocal(thisObjLocal);
        }
        this.generateCallArgArray(node, firstArgChild, true);
        if (type == 30) {
            this.addScriptRuntimeInvoke("newObject", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        } else {
            this.cfw.addInvoke(185, "org/mozilla/javascript/Callable", "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        }
        this.cfw.markLabel(beyond);
    }

    private void generateCallArgArray(Node node, Node argChild, boolean directCall) {
        int argCount = BodyCodegen.countArguments(argChild);
        if (argCount == 1 && this.itsOneArgArray >= 0) {
            this.cfw.addALoad(this.itsOneArgArray);
        } else {
            this.addNewObjectArray(argCount);
        }
        for (int i = 0; i != argCount; ++i) {
            if (!this.isGenerator) {
                this.cfw.add(89);
                this.cfw.addPush(i);
            }
            if (!directCall) {
                this.generateExpression(argChild, node);
            } else {
                int dcp_register = this.nodeIsDirectCallParameter(argChild);
                if (dcp_register >= 0) {
                    this.dcpLoadAsObject(dcp_register);
                } else {
                    this.generateExpression(argChild, node);
                    int childNumberFlag = argChild.getIntProp(8, -1);
                    if (childNumberFlag == 0) {
                        this.addDoubleWrap();
                    }
                }
            }
            if (this.isGenerator) {
                short tempLocal = this.getNewWordLocal();
                this.cfw.addAStore(tempLocal);
                this.cfw.add(192, "[Ljava/lang/Object;");
                this.cfw.add(89);
                this.cfw.addPush(i);
                this.cfw.addALoad(tempLocal);
                this.releaseWordLocal(tempLocal);
            }
            this.cfw.add(83);
            argChild = argChild.getNext();
        }
    }

    private void generateFunctionAndThisObj(Node node, Node parent) {
        this.generateLookupResult(node, parent);
        this.popFunctionAndThis();
    }

    private void generateLookupResult(Node node, Node parent) {
        int type = node.getType();
        boolean isOptionalChainingCall = parent.getIntProp(30, 0) == 1;
        switch (node.getType()) {
            case 34: {
                throw Kit.codeBug();
            }
            case 33: 
            case 39: {
                Node target = node.getFirstChild();
                this.generateExpression(target, node);
                Node id = target.getNext();
                if (type == 33) {
                    String property = id.getString();
                    this.cfw.addALoad(this.contextLocal);
                    this.cfw.addALoad(this.variableObjectLocal);
                    String propAccessType = isOptionalChainingCall ? "GETWITHTHISOPTIONAL" : "GETWITHTHIS";
                    this.addDynamicInvoke("PROP:" + propAccessType + ":" + property, "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/ScriptRuntime$LookupResult;");
                    break;
                }
                this.generateExpression(id, node);
                if (node.getIntProp(8, -1) != -1) {
                    this.addDoubleWrap();
                }
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                String name = isOptionalChainingCall ? "getElemAndThisOptional" : "getElemAndThis";
                this.addScriptRuntimeInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/ScriptRuntime$LookupResult;");
                break;
            }
            case 44: {
                String name = node.getString();
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.contextLocal);
                String propAccessType = isOptionalChainingCall ? "GETWITHTHISOPTIONAL" : "GETWITHTHIS";
                this.addDynamicInvoke("NAME:" + propAccessType + ":" + name, "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/ScriptRuntime$LookupResult;");
                break;
            }
            default: {
                this.generateExpression(node, parent);
                this.cfw.addALoad(this.contextLocal);
                String name = isOptionalChainingCall ? "getValueAndThisOptional" : "getValueAndThis";
                this.addScriptRuntimeInvoke(name, "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/ScriptRuntime$LookupResult;");
                break;
            }
        }
    }

    private void popFunctionAndThis() {
        this.cfw.add(89);
        this.cfw.addInvoke(182, "org.mozilla.javascript.ScriptRuntime$LookupResult", "getCallable", "()Lorg/mozilla/javascript/Callable;");
        this.cfw.add(95);
        this.cfw.addInvoke(182, "org.mozilla.javascript.ScriptRuntime$LookupResult", "getThis", "()Lorg/mozilla/javascript/Scriptable;");
    }

    private void updateLineNumber(Node node) {
        this.itsLineNumber = node.getLineno();
        if (this.itsLineNumber == -1) {
            return;
        }
        this.cfw.addLineNumberEntry((short)this.itsLineNumber);
    }

    private void visitTryCatchFinally(Jump node, Node child) {
        short savedVariableObject = this.getNewWordLocal();
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addAStore(savedVariableObject);
        int startLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(startLabel, 0);
        Node catchTarget = node.target;
        Node finallyTarget = node.getFinally();
        int[] handlerLabels = new int[5];
        this.exceptionManager.pushExceptionInfo(node);
        if (catchTarget != null) {
            handlerLabels[0] = this.cfw.acquireLabel();
            handlerLabels[1] = this.cfw.acquireLabel();
            handlerLabels[2] = this.cfw.acquireLabel();
            Context cx = Context.getCurrentContext();
            if (cx != null && cx.hasFeature(13)) {
                handlerLabels[3] = this.cfw.acquireLabel();
            }
        }
        if (finallyTarget != null) {
            handlerLabels[4] = this.cfw.acquireLabel();
        }
        this.exceptionManager.setHandlers(handlerLabels, startLabel);
        if (this.isGenerator && finallyTarget != null) {
            FinallyReturnPoint ret = new FinallyReturnPoint();
            if (this.finallys == null) {
                this.finallys = new HashMap<Node, FinallyReturnPoint>();
            }
            this.finallys.put(finallyTarget, ret);
            this.finallys.put(finallyTarget.getNext(), ret);
        }
        while (child != null) {
            if (child == catchTarget) {
                int catchLabel = this.getTargetLabel(catchTarget);
                this.exceptionManager.removeHandler(0, catchLabel);
                this.exceptionManager.removeHandler(1, catchLabel);
                this.exceptionManager.removeHandler(2, catchLabel);
                this.exceptionManager.removeHandler(3, catchLabel);
            }
            this.generateStatement(child);
            child = child.getNext();
        }
        int realEnd = this.cfw.acquireLabel();
        this.cfw.add(167, realEnd);
        int exceptionLocal = BodyCodegen.getLocalBlockRegister(node);
        if (catchTarget != null) {
            int catchLabel = catchTarget.labelId();
            this.generateCatchBlock(0, savedVariableObject, catchLabel, exceptionLocal, handlerLabels[0]);
            this.generateCatchBlock(1, savedVariableObject, catchLabel, exceptionLocal, handlerLabels[1]);
            this.generateCatchBlock(2, savedVariableObject, catchLabel, exceptionLocal, handlerLabels[2]);
            Context cx = Context.getCurrentContext();
            if (cx != null && cx.hasFeature(13)) {
                this.generateCatchBlock(3, savedVariableObject, catchLabel, exceptionLocal, handlerLabels[3]);
            }
        }
        if (finallyTarget != null) {
            int finallyHandler = this.cfw.acquireLabel();
            int finallyEnd = this.cfw.acquireLabel();
            this.cfw.markHandler(finallyHandler);
            if (!this.isGenerator) {
                this.cfw.markLabel(handlerLabels[4]);
            }
            this.cfw.addAStore(exceptionLocal);
            this.cfw.addALoad(savedVariableObject);
            this.cfw.addAStore(this.variableObjectLocal);
            int finallyLabel = finallyTarget.labelId();
            if (this.isGenerator) {
                this.addGotoWithReturn(finallyTarget);
            } else {
                this.inlineFinally(finallyTarget, handlerLabels[4], finallyEnd);
            }
            this.cfw.addALoad(exceptionLocal);
            if (this.isGenerator) {
                this.cfw.add(192, "java/lang/Throwable");
            }
            this.cfw.add(191);
            this.cfw.markLabel(finallyEnd);
            if (this.isGenerator) {
                this.cfw.addExceptionHandler(startLabel, finallyLabel, finallyHandler, null);
            }
        }
        this.releaseWordLocal(savedVariableObject);
        this.cfw.markLabel(realEnd);
        if (!this.isGenerator) {
            this.exceptionManager.popExceptionInfo();
        }
    }

    private void generateCatchBlock(int exceptionType, short savedVariableObject, int catchLabel, int exceptionLocal, int handler) {
        if (handler == 0) {
            handler = this.cfw.acquireLabel();
        }
        this.cfw.markHandler(handler);
        this.cfw.addAStore(exceptionLocal);
        this.cfw.addALoad(savedVariableObject);
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.add(167, catchLabel);
    }

    private static String exceptionTypeToName(int exceptionType) {
        if (exceptionType == 0) {
            return "org/mozilla/javascript/JavaScriptException";
        }
        if (exceptionType == 1) {
            return "org/mozilla/javascript/EvaluatorException";
        }
        if (exceptionType == 2) {
            return "org/mozilla/javascript/EcmaError";
        }
        if (exceptionType == 3) {
            return "java/lang/Throwable";
        }
        if (exceptionType == 4) {
            return null;
        }
        throw Kit.codeBug();
    }

    private void inlineFinally(Node finallyTarget, int finallyStart, int finallyEnd) {
        Node fBlock = BodyCodegen.getFinallyAtTarget(finallyTarget);
        fBlock.resetTargets();
        this.exceptionManager.markInlineFinallyStart(fBlock, finallyStart);
        for (Node child = fBlock.getFirstChild(); child != null; child = child.getNext()) {
            this.generateStatement(child);
        }
        this.exceptionManager.markInlineFinallyEnd(fBlock, finallyEnd);
    }

    private void inlineFinally(Node finallyTarget) {
        int finallyStart = this.cfw.acquireLabel();
        int finallyEnd = this.cfw.acquireLabel();
        this.cfw.markLabel(finallyStart);
        this.inlineFinally(finallyTarget, finallyStart, finallyEnd);
        this.cfw.markLabel(finallyEnd);
    }

    private static Node getFinallyAtTarget(Node node) {
        Node fBlock;
        if (node == null) {
            return null;
        }
        if (node.getType() == 140) {
            return node;
        }
        if (node.getType() == 147 && (fBlock = node.getNext()) != null && fBlock.getType() == 140) {
            return fBlock;
        }
        throw Kit.codeBug("bad finally target");
    }

    private boolean generateSaveLocals(Node node) {
        int i;
        int count = 0;
        for (int i2 = 0; i2 < this.firstFreeLocal; ++i2) {
            if (this.locals[i2] == 0) continue;
            ++count;
        }
        if (count == 0) {
            ((FunctionNode)this.scriptOrFn).addLiveLocals(node, null);
            return false;
        }
        this.maxLocals = this.maxLocals > count ? this.maxLocals : count;
        int[] ls = new int[count];
        int s = 0;
        for (i = 0; i < this.firstFreeLocal; ++i) {
            if (this.locals[i] == 0) continue;
            ls[s] = i;
            ++s;
        }
        ((FunctionNode)this.scriptOrFn).addLiveLocals(node, ls);
        this.generateGetGeneratorLocalsState();
        for (i = 0; i < count; ++i) {
            this.cfw.add(89);
            this.cfw.addLoadConstant(i);
            this.cfw.addALoad(ls[i]);
            this.cfw.add(83);
        }
        this.cfw.add(87);
        return true;
    }

    private void visitSwitch(Jump switchNode, Node child) {
        this.generateExpression(child, switchNode);
        short selector = this.getNewWordLocal();
        this.cfw.addAStore(selector);
        for (Jump caseNode = (Jump)child.getNext(); caseNode != null; caseNode = (Jump)caseNode.getNext()) {
            if (caseNode.getType() != 130) {
                throw Codegen.badTree();
            }
            Node test = caseNode.getFirstChild();
            this.generateExpression(test, caseNode);
            this.cfw.addALoad(selector);
            this.addDynamicInvoke("MATH:SHALLOWEQ", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            this.addGoto(caseNode.target, 154);
        }
        this.releaseWordLocal(selector);
    }

    private void visitTypeofname(Node node) {
        int varIndex;
        if (this.hasVarsInRegs && (varIndex = this.fnCurrent.fnode.getIndexForNameNode(node)) >= 0) {
            if (this.fnCurrent.isNumberVar(varIndex)) {
                this.cfw.addPush("number");
            } else if (this.varIsDirectCallParameter(varIndex)) {
                int dcp_register = this.varRegisters[varIndex];
                this.cfw.addALoad(dcp_register);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int isNumberLabel = this.cfw.acquireLabel();
                this.cfw.add(165, isNumberLabel);
                int stack = this.cfw.getStackTop();
                this.cfw.addALoad(dcp_register);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
                int beyond = this.cfw.acquireLabel();
                this.cfw.add(167, beyond);
                this.cfw.markLabel(isNumberLabel, stack);
                this.cfw.addPush("number");
                this.cfw.markLabel(beyond);
            } else {
                this.cfw.addALoad(this.varRegisters[varIndex]);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
            }
            return;
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(node.getString());
        this.addScriptRuntimeInvoke("typeofName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/String;");
    }

    private void saveCurrentCodeOffset() {
        this.savedCodeOffset = this.cfw.getCurrentCodeOffset();
    }

    private void addInstructionCount() {
        int count = this.cfw.getCurrentCodeOffset() - this.savedCodeOffset;
        this.addInstructionCount(Math.max(count, 1));
    }

    private void addInstructionCount(int count) {
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(count);
        this.addScriptRuntimeInvoke("addInstructionCount", "(Lorg/mozilla/javascript/Context;I)V");
    }

    private void visitIncDec(Node node) {
        int incrDecrMask = node.getExistingIntProp(13);
        Node child = node.getFirstChild();
        if (child.getIntProp(31, 0) == 1) {
            this.visitSuperIncDec(node, child, incrDecrMask);
            return;
        }
        switch (child.getType()) {
            case 61: {
                if (!this.hasVarsInRegs) {
                    Kit.codeBug();
                }
                boolean post = (incrDecrMask & 2) != 0;
                int varIndex = this.fnCurrent.getVarIndex(child);
                int reg = this.varRegisters[varIndex];
                boolean[] constDeclarations = this.fnCurrent.fnode.getParamAndVarConst();
                if (constDeclarations[varIndex]) {
                    if (node.getIntProp(8, -1) != -1) {
                        int offset = this.varIsDirectCallParameter(varIndex) ? 1 : 0;
                        this.cfw.addDLoad(reg + offset);
                        if (post) break;
                        this.cfw.addPush(1.0);
                        if ((incrDecrMask & 1) == 0) {
                            this.cfw.add(99);
                            break;
                        }
                        this.cfw.add(103);
                        break;
                    }
                    if (this.varIsDirectCallParameter(varIndex)) {
                        this.dcpLoadAsObject(reg);
                    } else {
                        this.cfw.addALoad(reg);
                    }
                    if (post) {
                        this.cfw.add(89);
                        this.addObjectToDouble();
                        this.cfw.add(88);
                        break;
                    }
                    this.addObjectToDouble();
                    this.cfw.addPush(1.0);
                    if ((incrDecrMask & 1) == 0) {
                        this.cfw.add(99);
                    } else {
                        this.cfw.add(103);
                    }
                    this.addDoubleWrap();
                    break;
                }
                if (node.getIntProp(8, -1) != -1) {
                    int offset = this.varIsDirectCallParameter(varIndex) ? 1 : 0;
                    this.cfw.addDLoad(reg + offset);
                    if (post) {
                        this.cfw.add(92);
                    }
                    this.cfw.addPush(1.0);
                    if ((incrDecrMask & 1) == 0) {
                        this.cfw.add(99);
                    } else {
                        this.cfw.add(103);
                    }
                    if (!post) {
                        this.cfw.add(92);
                    }
                    this.cfw.addDStore(reg + offset);
                    break;
                }
                if (this.varIsDirectCallParameter(varIndex)) {
                    this.dcpLoadAsObject(reg);
                } else {
                    this.cfw.addALoad(reg);
                }
                this.addObjectToDouble();
                if (post) {
                    this.cfw.add(92);
                }
                this.cfw.addPush(1.0);
                if ((incrDecrMask & 1) == 0) {
                    this.cfw.add(99);
                } else {
                    this.cfw.add(103);
                }
                this.addDoubleWrap();
                if (!post) {
                    this.cfw.add(89);
                }
                this.cfw.addAStore(reg);
                if (!post) break;
                this.addDoubleWrap();
                break;
            }
            case 44: {
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(child.getString());
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(incrDecrMask);
                this.addScriptRuntimeInvoke("nameIncrDecr", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;I)Ljava/lang/Object;");
                break;
            }
            case 34: {
                throw Kit.codeBug();
            }
            case 33: {
                Node getPropChild = child.getFirstChild();
                this.generateExpression(getPropChild, node);
                this.generateExpression(getPropChild.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(incrDecrMask);
                this.addScriptRuntimeInvoke("propIncrDecr", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                break;
            }
            case 39: {
                Node elemChild = child.getFirstChild();
                this.generateExpression(elemChild, node);
                this.generateExpression(elemChild.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(incrDecrMask);
                if (elemChild.getNext().getIntProp(8, -1) != -1) {
                    this.addOptRuntimeInvoke("elemIncrDecr", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                    break;
                }
                this.addScriptRuntimeInvoke("elemIncrDecr", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                break;
            }
            case 74: {
                Node refChild = child.getFirstChild();
                this.generateExpression(refChild, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(incrDecrMask);
                this.addScriptRuntimeInvoke("refIncrDecr", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                break;
            }
            default: {
                Codegen.badTree();
            }
        }
    }

    private void visitSuperIncDec(Node node, Node child, int incrDecrMask) {
        Node object = child.getFirstChild();
        this.generateExpression(object, node);
        this.cfw.add(89);
        switch (child.getType()) {
            case 33: {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.thisObjLocal);
                this.cfw.addLoadConstant(0);
                this.addDynamicInvoke("PROP:GETSUPER:" + child.getFirstChild().getNext().getString(), "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Z)Ljava/lang/Object;");
                break;
            }
            case 39: {
                this.generateExpression(object.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.thisObjLocal);
                this.addDynamicInvoke("PROP:GETELEMENTSUPER", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Ljava/lang/Object;");
                break;
            }
            default: {
                Codegen.badTree();
            }
        }
        if ((incrDecrMask & 2) != 0) {
            this.cfw.add(95);
            this.cfw.add(92);
            this.cfw.add(87);
        }
        this.addObjectToDouble();
        this.cfw.addPush(1.0);
        if ((incrDecrMask & 1) == 0) {
            this.cfw.add(99);
        } else {
            this.cfw.add(103);
        }
        this.addDoubleWrap();
        switch (child.getType()) {
            case 33: {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.thisObjLocal);
                this.addDynamicInvoke("PROP:SETSUPER:" + child.getFirstChild().getNext().getString(), "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Ljava/lang/Object;");
                break;
            }
            case 39: {
                this.generateExpression(object.getNext(), node);
                this.cfw.add(95);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.thisObjLocal);
                this.addDynamicInvoke("PROP:SETELEMENTSUPER", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Ljava/lang/Object;");
            }
        }
        if ((incrDecrMask & 2) != 0) {
            this.cfw.add(87);
        }
    }

    private static boolean isArithmeticNode(Node node) {
        int type = node.getType();
        return type == 22 || type == 25 || type == 24 || type == 23;
    }

    private void visitArithmetic(Node node, int type, Node child, Node parent) {
        block15: {
            block14: {
                int childNumberFlag = node.getIntProp(8, -1);
                if (childNumberFlag == -1) break block14;
                this.generateExpression(child, node);
                this.generateExpression(child.getNext(), node);
                switch (type) {
                    case 22: {
                        this.cfw.add(103);
                        break block15;
                    }
                    case 23: {
                        this.cfw.add(107);
                        break block15;
                    }
                    case 24: {
                        this.cfw.add(111);
                        break block15;
                    }
                    case 25: {
                        this.cfw.add(115);
                        break block15;
                    }
                    default: {
                        throw Kit.codeBug(Token.typeToName(type));
                    }
                }
            }
            this.generateExpression(child, node);
            this.generateExpression(child.getNext(), node);
            if (!BodyCodegen.isArithmeticNode(child)) {
                this.cfw.add(95);
                this.addObjectToNumeric();
                this.cfw.add(95);
            }
            if (!BodyCodegen.isArithmeticNode(child.getNext())) {
                this.addObjectToNumeric();
            }
            switch (type) {
                case 22: {
                    this.addScriptRuntimeInvoke("subtract", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                    break;
                }
                case 23: {
                    this.addScriptRuntimeInvoke("multiply", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                    break;
                }
                case 24: {
                    this.addScriptRuntimeInvoke("divide", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                    break;
                }
                case 25: {
                    this.addScriptRuntimeInvoke("remainder", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                    break;
                }
                default: {
                    throw Kit.codeBug(Token.typeToName(type));
                }
            }
        }
    }

    private void visitExponentiation(Node node, Node child, Node parent) {
        int childNumberFlag = node.getIntProp(8, -1);
        if (childNumberFlag != -1) {
            this.generateExpression(child, node);
            this.generateExpression(child.getNext(), node);
            this.cfw.addInvoke(184, "java/lang/Math", "pow", "(DD)D");
        } else {
            this.generateExpression(child, node);
            this.generateExpression(child.getNext(), node);
            short reg = this.getNewWordLocal();
            this.cfw.addAStore(reg);
            this.addObjectToNumeric();
            this.cfw.addALoad(reg);
            this.addObjectToNumeric();
            this.addScriptRuntimeInvoke("exponentiate", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
        }
    }

    private void visitBitNot(Node node, Node child) {
        int childNumberFlag = node.getIntProp(8, -1);
        this.generateExpression(child, node);
        if (childNumberFlag == -1) {
            this.addObjectToNumeric();
            this.addScriptRuntimeInvoke("bitwiseNOT", "(Ljava/lang/Number;)Ljava/lang/Number;");
        } else {
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
            this.cfw.addPush(-1);
            this.cfw.add(130);
            this.cfw.add(135);
        }
    }

    private void visitBitOp(Node node, int type, Node child) {
        block16: {
            block15: {
                int childNumberFlag = node.getIntProp(8, -1);
                this.generateExpression(child, node);
                if (type == 20) {
                    this.generateExpression(child.getNext(), node);
                    this.cfw.add(95);
                    this.addDynamicInvoke("MATH:TOUINT32", "(Ljava/lang/Object;)J");
                    this.cfw.add(93);
                    this.cfw.add(88);
                    this.addDynamicInvoke("MATH:TOINT32", "(Ljava/lang/Object;)I");
                    this.cfw.addPush(31);
                    this.cfw.add(126);
                    this.cfw.add(125);
                    this.cfw.add(138);
                    this.addDoubleWrap();
                    return;
                }
                if (childNumberFlag != -1) break block15;
                this.generateExpression(child.getNext(), node);
                this.cfw.add(95);
                this.addObjectToNumeric();
                this.cfw.add(95);
                this.addObjectToNumeric();
                switch (type) {
                    case 9: {
                        this.addScriptRuntimeInvoke("bitwiseOR", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                        break block16;
                    }
                    case 10: {
                        this.addScriptRuntimeInvoke("bitwiseXOR", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                        break block16;
                    }
                    case 11: {
                        this.addScriptRuntimeInvoke("bitwiseAND", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                        break block16;
                    }
                    case 19: {
                        this.addScriptRuntimeInvoke("signedRightShift", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                        break block16;
                    }
                    case 18: {
                        this.addScriptRuntimeInvoke("leftShift", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                        break block16;
                    }
                    default: {
                        throw Kit.codeBug(Token.typeToName(type));
                    }
                }
            }
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
            this.generateExpression(child.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
            switch (type) {
                case 9: {
                    this.cfw.add(128);
                    break;
                }
                case 10: {
                    this.cfw.add(130);
                    break;
                }
                case 11: {
                    this.cfw.add(126);
                    break;
                }
                case 19: {
                    this.cfw.add(122);
                    break;
                }
                case 18: {
                    this.cfw.add(120);
                    break;
                }
                default: {
                    throw Kit.codeBug(Token.typeToName(type));
                }
            }
            this.cfw.add(135);
        }
    }

    private int nodeIsDirectCallParameter(Node node) {
        int varIndex;
        if (node.getType() == 61 && this.inDirectCallFunction && !this.itsForcedObjectParameters && this.fnCurrent.isParameter(varIndex = this.fnCurrent.getVarIndex(node))) {
            return this.varRegisters[varIndex];
        }
        return -1;
    }

    private boolean varIsDirectCallParameter(int varIndex) {
        return this.fnCurrent.isParameter(varIndex) && this.inDirectCallFunction && !this.itsForcedObjectParameters;
    }

    private void genSimpleCompare(int type, int trueGOTO, int falseGOTO) {
        if (trueGOTO == -1) {
            throw Codegen.badTree();
        }
        switch (type) {
            case 15: {
                this.cfw.add(152);
                this.cfw.add(158, trueGOTO);
                break;
            }
            case 17: {
                this.cfw.add(151);
                this.cfw.add(156, trueGOTO);
                break;
            }
            case 14: {
                this.cfw.add(152);
                this.cfw.add(155, trueGOTO);
                break;
            }
            case 16: {
                this.cfw.add(151);
                this.cfw.add(157, trueGOTO);
                break;
            }
            default: {
                throw Codegen.badTree();
            }
        }
        if (falseGOTO != -1) {
            this.cfw.add(167, falseGOTO);
        }
    }

    private void visitIfJumpRelOp(Node node, Node child, int trueGOTO, int falseGOTO) {
        if (trueGOTO == -1 || falseGOTO == -1) {
            throw Codegen.badTree();
        }
        int type = node.getType();
        Node rChild = child.getNext();
        if (type == 59 || type == 58) {
            this.generateExpression(child, node);
            this.generateExpression(rChild, node);
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke(type == 59 ? "instanceOf" : "in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Z");
            this.cfw.add(154, trueGOTO);
            this.cfw.add(167, falseGOTO);
            return;
        }
        int childNumberFlag = node.getIntProp(8, -1);
        int left_dcp_register = this.nodeIsDirectCallParameter(child);
        int right_dcp_register = this.nodeIsDirectCallParameter(rChild);
        if (childNumberFlag != -1) {
            if (childNumberFlag != 2) {
                this.generateExpression(child, node);
            } else if (left_dcp_register != -1) {
                this.dcpLoadAsNumber(left_dcp_register);
            } else {
                this.generateExpression(child, node);
                this.addObjectToDouble();
            }
            if (childNumberFlag != 1) {
                this.generateExpression(rChild, node);
            } else if (right_dcp_register != -1) {
                this.dcpLoadAsNumber(right_dcp_register);
            } else {
                this.generateExpression(rChild, node);
                this.addObjectToDouble();
            }
            this.genSimpleCompare(type, trueGOTO, falseGOTO);
        } else {
            String compareOp;
            if (left_dcp_register != -1 && right_dcp_register != -1) {
                int stack = this.cfw.getStackTop();
                int leftIsNotNumber = this.cfw.acquireLabel();
                this.cfw.addALoad(left_dcp_register);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.cfw.add(166, leftIsNotNumber);
                this.cfw.addDLoad(left_dcp_register + 1);
                this.dcpLoadAsNumber(right_dcp_register);
                this.genSimpleCompare(type, trueGOTO, falseGOTO);
                if (stack != this.cfw.getStackTop()) {
                    throw Codegen.badTree();
                }
                this.cfw.markLabel(leftIsNotNumber);
                int rightIsNotNumber = this.cfw.acquireLabel();
                this.cfw.addALoad(right_dcp_register);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.cfw.add(166, rightIsNotNumber);
                this.cfw.addALoad(left_dcp_register);
                this.addObjectToDouble();
                this.cfw.addDLoad(right_dcp_register + 1);
                this.genSimpleCompare(type, trueGOTO, falseGOTO);
                if (stack != this.cfw.getStackTop()) {
                    throw Codegen.badTree();
                }
                this.cfw.markLabel(rightIsNotNumber);
                this.cfw.addALoad(left_dcp_register);
                this.cfw.addALoad(right_dcp_register);
            } else {
                this.generateExpression(child, node);
                this.generateExpression(rChild, node);
            }
            switch (type) {
                case 16: {
                    compareOp = "MATH:COMPAREGT";
                    break;
                }
                case 14: {
                    compareOp = "MATH:COMPARELT";
                    break;
                }
                case 17: {
                    compareOp = "MATH:COMPAREGE";
                    break;
                }
                case 15: {
                    compareOp = "MATH:COMPARELE";
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
            this.addDynamicInvoke(compareOp, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            this.cfw.add(154, trueGOTO);
            this.cfw.add(167, falseGOTO);
        }
    }

    private void visitIfJumpEqOp(Node node, Node child, int trueGOTO, int falseGOTO) {
        if (trueGOTO == -1 || falseGOTO == -1) {
            throw Codegen.badTree();
        }
        int stackInitial = this.cfw.getStackTop();
        int type = node.getType();
        Node rChild = child.getNext();
        if (type != 12 && type != 13 && (child.getType() == 47 || rChild.getType() == 47)) {
            if (child.getType() == 47) {
                child = rChild;
            }
            this.generateExpression(child, node);
            int testCode = type == 52 ? 198 : 199;
            this.cfw.add(testCode, trueGOTO);
            this.cfw.add(167, falseGOTO);
        } else {
            int testCode;
            String name;
            Node convertChild;
            int child_dcp_register = this.nodeIsDirectCallParameter(child);
            if (child_dcp_register != -1 && rChild.getType() == 165 && (convertChild = rChild.getFirstChild()).getType() == 45) {
                this.cfw.addALoad(child_dcp_register);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int notNumbersLabel = this.cfw.acquireLabel();
                this.cfw.add(166, notNumbersLabel);
                this.cfw.addDLoad(child_dcp_register + 1);
                this.cfw.addPush(convertChild.getDouble());
                this.cfw.add(151);
                if (type == 12) {
                    this.cfw.add(153, trueGOTO);
                } else {
                    this.cfw.add(154, trueGOTO);
                }
                this.cfw.add(167, falseGOTO);
                this.cfw.markLabel(notNumbersLabel);
            }
            this.generateExpression(child, node);
            this.generateExpression(rChild, node);
            switch (type) {
                case 12: {
                    name = "MATH:EQ";
                    testCode = 154;
                    break;
                }
                case 13: {
                    name = "MATH:EQ";
                    testCode = 153;
                    break;
                }
                case 52: {
                    name = "MATH:SHALLOWEQ";
                    testCode = 154;
                    break;
                }
                case 53: {
                    name = "MATH:SHALLOWEQ";
                    testCode = 153;
                    break;
                }
                default: {
                    throw Codegen.badTree();
                }
            }
            this.addDynamicInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            this.cfw.add(testCode, trueGOTO);
            this.cfw.add(167, falseGOTO);
        }
        if (stackInitial != this.cfw.getStackTop()) {
            throw Codegen.badTree();
        }
    }

    private void visitSetName(Node node, Node child) {
        String name = node.getFirstChild().getString();
        while (child != null) {
            this.generateExpression(child, node);
            child = child.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addDynamicInvoke("NAME:SET:" + name, "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
    }

    private void visitStrictSetName(Node node, Node child) {
        String name = node.getFirstChild().getString();
        while (child != null) {
            this.generateExpression(child, node);
            child = child.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addDynamicInvoke("NAME:SETSTRICT:" + name, "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
    }

    private void visitSetConst(Node node, Node child) {
        String name = node.getFirstChild().getString();
        while (child != null) {
            this.generateExpression(child, node);
            child = child.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.addDynamicInvoke("NAME:SETCONST:" + name, "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
    }

    private void visitGetVar(Node node) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int varIndex = this.fnCurrent.getVarIndex(node);
        int reg = this.varRegisters[varIndex];
        if (this.varIsDirectCallParameter(varIndex)) {
            if (node.getIntProp(8, -1) != -1) {
                this.dcpLoadAsNumber(reg);
            } else {
                this.dcpLoadAsObject(reg);
            }
        } else if (this.fnCurrent.isNumberVar(varIndex)) {
            this.cfw.addDLoad(reg);
        } else {
            this.cfw.addALoad(reg);
        }
    }

    private void visitSetVar(Node node, Node child, boolean needValue) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int varIndex = this.fnCurrent.getVarIndex(node);
        this.generateExpression(child.getNext(), node);
        boolean isNumber = node.getIntProp(8, -1) != -1;
        int reg = this.varRegisters[varIndex];
        boolean[] constDeclarations = this.fnCurrent.fnode.getParamAndVarConst();
        if (constDeclarations[varIndex]) {
            if (!needValue) {
                if (isNumber) {
                    this.cfw.add(88);
                } else {
                    this.cfw.add(87);
                }
            }
        } else if (this.varIsDirectCallParameter(varIndex)) {
            if (isNumber) {
                if (needValue) {
                    this.cfw.add(92);
                }
                this.cfw.addALoad(reg);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int isNumberLabel = this.cfw.acquireLabel();
                int beyond = this.cfw.acquireLabel();
                this.cfw.add(165, isNumberLabel);
                int stack = this.cfw.getStackTop();
                this.addDoubleWrap();
                this.cfw.addAStore(reg);
                this.cfw.add(167, beyond);
                this.cfw.markLabel(isNumberLabel, stack);
                this.cfw.addDStore(reg + 1);
                this.cfw.markLabel(beyond);
            } else {
                if (needValue) {
                    this.cfw.add(89);
                }
                this.cfw.addAStore(reg);
            }
        } else {
            boolean isNumberVar = this.fnCurrent.isNumberVar(varIndex);
            if (isNumber) {
                if (isNumberVar) {
                    this.cfw.addDStore(reg);
                    if (needValue) {
                        this.cfw.addDLoad(reg);
                    }
                } else {
                    if (needValue) {
                        this.cfw.add(92);
                    }
                    this.addDoubleWrap();
                    this.cfw.addAStore(reg);
                }
            } else {
                if (isNumberVar) {
                    Kit.codeBug();
                }
                this.cfw.addAStore(reg);
                if (needValue) {
                    this.cfw.addALoad(reg);
                }
            }
        }
    }

    private void visitSetConstVar(Node node, Node child, boolean needValue) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int varIndex = this.fnCurrent.getVarIndex(node);
        this.generateExpression(child.getNext(), node);
        boolean isNumber = node.getIntProp(8, -1) != -1;
        int reg = this.varRegisters[varIndex];
        int beyond = this.cfw.acquireLabel();
        int noAssign = this.cfw.acquireLabel();
        if (isNumber) {
            this.cfw.addILoad(reg + 2);
            this.cfw.add(154, noAssign);
            int stack = this.cfw.getStackTop();
            this.cfw.addPush(1);
            this.cfw.addIStore(reg + 2);
            this.cfw.addDStore(reg);
            if (needValue) {
                this.cfw.addDLoad(reg);
                this.cfw.markLabel(noAssign, stack);
            } else {
                this.cfw.add(167, beyond);
                this.cfw.markLabel(noAssign, stack);
                this.cfw.add(88);
            }
        } else {
            this.cfw.addILoad(reg + 1);
            this.cfw.add(154, noAssign);
            int stack = this.cfw.getStackTop();
            this.cfw.addPush(1);
            this.cfw.addIStore(reg + 1);
            this.cfw.addAStore(reg);
            if (needValue) {
                this.cfw.addALoad(reg);
                this.cfw.markLabel(noAssign, stack);
            } else {
                this.cfw.add(167, beyond);
                this.cfw.markLabel(noAssign, stack);
                this.cfw.add(87);
            }
        }
        this.cfw.markLabel(beyond);
    }

    private void visitGetProp(Node node, Node child) {
        this.generateExpression(child, node);
        if (node.getIntProp(30, 0) == 1) {
            int getExpr = this.cfw.acquireLabel();
            int after = this.cfw.acquireLabel();
            this.cfw.add(89);
            this.addOptRuntimeInvoke("isNullOrUndefined", "(Ljava/lang/Object;)Z");
            this.cfw.add(153, getExpr);
            this.cfw.add(87);
            Codegen.pushUndefined(this.cfw);
            this.cfw.add(167, after);
            this.cfw.markLabel(getExpr);
            this.finishGetPropGeneration(node, child.getNext());
            this.cfw.markLabel(after);
        } else {
            this.finishGetPropGeneration(node, child.getNext());
        }
    }

    private void finishGetPropGeneration(Node node, Node nameChild) {
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (node.getIntProp(31, 0) == 1) {
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addLoadConstant(node.getType() == 34 ? 1 : 0);
            this.addDynamicInvoke("PROP:GETSUPER:" + nameChild.getString(), "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Z)Ljava/lang/Object;");
        } else if (node.getType() == 34) {
            this.addDynamicInvoke("PROP:GETNOWARN:" + nameChild.getString(), "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        } else {
            this.addDynamicInvoke("PROP:GET:" + nameChild.getString(), "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        }
    }

    private void visitSetProp(int type, Node node, Node child) {
        this.generateExpression(child, node);
        Node nameChild = child = child.getNext();
        if (type == 155) {
            this.cfw.add(89);
            this.finishGetPropGeneration(node, nameChild);
        }
        child = child.getNext();
        this.generateExpression(child, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (node.getIntProp(31, 0) == 1) {
            this.cfw.addALoad(this.thisObjLocal);
            this.addDynamicInvoke("PROP:SETSUPER:" + nameChild.getString(), "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Ljava/lang/Object;");
        } else {
            this.addDynamicInvoke("PROP:SET:" + nameChild.getString(), "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        }
    }

    private void visitSetElem(int type, Node node, Node child) {
        boolean isSuper;
        this.generateExpression(child, node);
        child = child.getNext();
        if (type == 156) {
            this.cfw.add(89);
        }
        this.generateExpression(child, node);
        child = child.getNext();
        boolean indexIsNumber = node.getIntProp(8, -1) != -1;
        boolean bl = isSuper = node.getIntProp(31, 0) == 1;
        if (type == 156) {
            if (isSuper) {
                this.cfw.add(90);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.thisObjLocal);
                this.addDynamicInvoke("PROP:GETELEMENTSUPER", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Ljava/lang/Object;");
            } else if (indexIsNumber) {
                this.cfw.add(93);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addDynamicInvoke("PROP:GETINDEX", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            } else {
                this.cfw.add(90);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addDynamicInvoke("PROP:GETELEMENT", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            }
        }
        this.generateExpression(child, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (isSuper) {
            this.cfw.addALoad(this.thisObjLocal);
            this.addDynamicInvoke("PROP:SETELEMENTSUPER", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Ljava/lang/Object;");
        } else if (indexIsNumber) {
            this.addDynamicInvoke("PROP:SETINDEX", "(Ljava/lang/Object;DLjava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        } else {
            this.addDynamicInvoke("PROP:SETELEMENT", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        }
    }

    private void visitDotQuery(Node node, Node child) {
        this.updateLineNumber(node);
        this.generateExpression(child, node);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("enterDotQuery", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.add(1);
        int queryLoopStart = this.cfw.acquireLabel();
        this.cfw.markLabel(queryLoopStart);
        this.cfw.add(87);
        this.generateExpression(child.getNext(), node);
        this.addDynamicInvoke("MATH:TOBOOLEAN", "(Ljava/lang/Object;)Z");
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("updateDotQuery", "(ZLorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        this.cfw.add(89);
        this.cfw.add(198, queryLoopStart);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("leaveDotQuery", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
    }

    private static int getLocalBlockRegister(Node node) {
        Node localBlock = (Node)node.getProp(3);
        int localSlot = localBlock.getExistingIntProp(2);
        return localSlot;
    }

    private void dcpLoadAsNumber(int dcp_register) {
        this.cfw.addALoad(dcp_register);
        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
        int isNumberLabel = this.cfw.acquireLabel();
        this.cfw.add(165, isNumberLabel);
        int stack = this.cfw.getStackTop();
        this.cfw.addALoad(dcp_register);
        this.addObjectToDouble();
        int beyond = this.cfw.acquireLabel();
        this.cfw.add(167, beyond);
        this.cfw.markLabel(isNumberLabel, stack);
        this.cfw.addDLoad(dcp_register + 1);
        this.cfw.markLabel(beyond);
    }

    private void dcpLoadAsObject(int dcp_register) {
        this.cfw.addALoad(dcp_register);
        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
        int isNumberLabel = this.cfw.acquireLabel();
        this.cfw.add(165, isNumberLabel);
        int stack = this.cfw.getStackTop();
        this.cfw.addALoad(dcp_register);
        int beyond = this.cfw.acquireLabel();
        this.cfw.add(167, beyond);
        this.cfw.markLabel(isNumberLabel, stack);
        this.cfw.addDLoad(dcp_register + 1);
        this.addDoubleWrap();
        this.cfw.markLabel(beyond);
    }

    private void addGoto(Node target, int jumpcode) {
        int targetLabel = this.getTargetLabel(target);
        this.cfw.add(jumpcode, targetLabel);
    }

    private void addObjectToDouble() {
        this.addDynamicInvoke("MATH:TONUMBER", "(Ljava/lang/Object;)D");
    }

    private void addObjectToNumeric() {
        this.addDynamicInvoke("MATH:TONUMERIC", "(Ljava/lang/Object;)Ljava/lang/Number;");
    }

    private void addNewObjectArray(int size) {
        if (size == 0) {
            if (this.itsZeroArgArray >= 0) {
                this.cfw.addALoad(this.itsZeroArgArray);
            } else {
                this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
            }
        } else {
            this.cfw.addPush(size);
            this.cfw.add(189, "java/lang/Object");
        }
    }

    private void addScriptRuntimeInvoke(String methodName, String methodSignature) {
        this.cfw.addInvoke(184, "org.mozilla.javascript.ScriptRuntime", methodName, methodSignature);
    }

    private void addOptRuntimeInvoke(String methodName, String methodSignature) {
        this.cfw.addInvoke(184, "org/mozilla/javascript/optimizer/OptRuntime", methodName, methodSignature);
    }

    private void addDynamicInvoke(String operation, String signature) {
        this.cfw.addInvokeDynamic(operation, signature, Bootstrapper.BOOTSTRAP_HANDLE, new Object[0]);
    }

    private void addJumpedBooleanWrap(int trueLabel, int falseLabel) {
        this.cfw.markLabel(falseLabel);
        int skip = this.cfw.acquireLabel();
        this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
        this.cfw.add(167, skip);
        this.cfw.markLabel(trueLabel);
        this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        this.cfw.markLabel(skip);
        this.cfw.adjustStackTop(-1);
    }

    private void addDoubleWrap() {
        this.addOptRuntimeInvoke("wrapDouble", "(D)Ljava/lang/Double;");
    }

    private short getNewWordPairLocal(boolean isConst) {
        return this.getNewWordIntern(isConst ? 3 : 2);
    }

    private short getNewWordLocal(boolean isConst) {
        return this.getNewWordIntern(isConst ? 2 : 1);
    }

    private short getNewWordLocal() {
        return this.getNewWordIntern(1);
    }

    private short getNewWordIntern(int count) {
        int i;
        assert (count >= 1 && count <= 3);
        int[] locals = this.locals;
        int result = -1;
        if (count > 1) {
            i = this.firstFreeLocal;
            block0: while (i + count <= 1024) {
                for (int j = 0; j < count; ++j) {
                    if (locals[i + j] == 0) continue;
                    i += j + 1;
                    continue block0;
                }
                result = i;
                break;
            }
        } else {
            result = this.firstFreeLocal;
        }
        if (result != -1) {
            locals[result] = 1;
            if (count > 1) {
                locals[result + 1] = 1;
            }
            if (count > 2) {
                locals[result + 2] = 1;
            }
            if (result == this.firstFreeLocal) {
                for (i = result + count; i < 1024; ++i) {
                    if (locals[i] != 0) continue;
                    this.firstFreeLocal = (short)i;
                    if (this.localsMax < this.firstFreeLocal) {
                        this.localsMax = this.firstFreeLocal;
                    }
                    return (short)result;
                }
            } else {
                return (short)result;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private void incReferenceWordLocal(int local) {
        int n = local;
        this.locals[n] = this.locals[n] + 1;
    }

    private void decReferenceWordLocal(int local) {
        int n = local;
        this.locals[n] = this.locals[n] - 1;
    }

    private void releaseWordLocal(int local) {
        if (local < this.firstFreeLocal) {
            this.firstFreeLocal = local;
        }
        this.locals[local] = 0;
    }

    private class ExceptionManager {
        private ArrayDeque<ExceptionInfo> exceptionInfo = new ArrayDeque();

        ExceptionManager() {
        }

        void pushExceptionInfo(Jump node) {
            Node fBlock = BodyCodegen.getFinallyAtTarget(node.getFinally());
            ExceptionInfo ei = new ExceptionInfo(node, fBlock);
            this.exceptionInfo.add(ei);
        }

        void addHandler(int exceptionType, int handlerLabel, int startLabel) {
            ExceptionInfo top = this.getTop();
            top.handlerLabels[exceptionType] = handlerLabel;
            top.exceptionStarts[exceptionType] = startLabel;
        }

        void setHandlers(int[] handlerLabels, int startLabel) {
            for (int i = 0; i < handlerLabels.length; ++i) {
                if (handlerLabels[i] == 0) continue;
                this.addHandler(i, handlerLabels[i], startLabel);
            }
        }

        int removeHandler(int exceptionType, int endLabel) {
            ExceptionInfo top = this.getTop();
            if (top.handlerLabels[exceptionType] != 0) {
                int handlerLabel = top.handlerLabels[exceptionType];
                this.endCatch(top, exceptionType, endLabel);
                top.handlerLabels[exceptionType] = 0;
                return handlerLabel;
            }
            return 0;
        }

        void popExceptionInfo() {
            this.exceptionInfo.removeLast();
        }

        void markInlineFinallyStart(Node finallyBlock, int finallyStart) {
            Iterator<ExceptionInfo> iter = this.exceptionInfo.descendingIterator();
            while (iter.hasNext()) {
                ExceptionInfo ei = iter.next();
                for (int i = 0; i < 5; ++i) {
                    if (ei.handlerLabels[i] == 0 || ei.currentFinally != null) continue;
                    this.endCatch(ei, i, finallyStart);
                    ei.exceptionStarts[i] = 0;
                    ei.currentFinally = finallyBlock;
                }
                if (ei.finallyBlock != finallyBlock) continue;
                break;
            }
        }

        void markInlineFinallyEnd(Node finallyBlock, int finallyEnd) {
            Iterator<ExceptionInfo> iter = this.exceptionInfo.descendingIterator();
            while (iter.hasNext()) {
                ExceptionInfo ei = iter.next();
                for (int i = 0; i < 5; ++i) {
                    if (ei.handlerLabels[i] == 0 || ei.currentFinally != finallyBlock) continue;
                    ei.exceptionStarts[i] = finallyEnd;
                    ei.currentFinally = null;
                }
                if (ei.finallyBlock != finallyBlock) continue;
                break;
            }
        }

        private void endCatch(ExceptionInfo ei, int exceptionType, int catchEnd) {
            int catchEndPC;
            if (ei.exceptionStarts[exceptionType] == 0) {
                throw new IllegalStateException("bad exception start");
            }
            int currentStart = ei.exceptionStarts[exceptionType];
            int currentStartPC = BodyCodegen.this.cfw.getLabelPC(currentStart);
            if (currentStartPC != (catchEndPC = BodyCodegen.this.cfw.getLabelPC(catchEnd))) {
                BodyCodegen.this.cfw.addExceptionHandler(ei.exceptionStarts[exceptionType], catchEnd, ei.handlerLabels[exceptionType], BodyCodegen.exceptionTypeToName(exceptionType));
            }
        }

        private ExceptionInfo getTop() {
            return this.exceptionInfo.getLast();
        }

        private class ExceptionInfo {
            Node finallyBlock;
            int[] handlerLabels;
            int[] exceptionStarts;
            Node currentFinally;

            ExceptionInfo(Jump node, Node finallyBlock) {
                this.finallyBlock = finallyBlock;
                this.handlerLabels = new int[5];
                this.exceptionStarts = new int[5];
                this.currentFinally = null;
            }
        }
    }

    static class FinallyReturnPoint {
        public List<Integer> jsrPoints = new ArrayList<Integer>();
        public int tableLabel = 0;

        FinallyReturnPoint() {
        }
    }
}

