/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.dialogs.Messages;
import org.apache.directory.studio.ldapbrowser.common.filtereditor.FilterSourceViewerConfiguration;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterParser;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FilterDialog
extends Dialog {
    private static final String DIALOG_TITLE = Messages.getString("FilterDialog.FilterEditor");
    private static final int FORMAT_BUTTON_ID = 987654321;
    private String title;
    private IBrowserConnection browserConnection;
    private SourceViewer sourceViewer;
    private FilterSourceViewerConfiguration configuration;
    private LdapFilterParser parser;
    private String filter;

    public FilterDialog(Shell parentShell, String title, String filter, IBrowserConnection brwoserConnection) {
        super(parentShell);
        this.title = title;
        this.filter = filter;
        this.browserConnection = brwoserConnection;
        this.parser = new LdapFilterParser();
        this.setShellStyle(67696);
    }

    public String getFilter() {
        return this.filter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title != null ? this.title : DIALOG_TITLE);
        newShell.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/filtereditor.gif"));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.parser.parse(this.sourceViewer.getDocument().get());
            this.filter = this.parser.getModel().toString();
        } else if (buttonId == 987654321) {
            Region region = new Region(0, this.sourceViewer.getDocument().getLength());
            this.configuration.getContentFormatter((ISourceViewer)this.sourceViewer).format(this.sourceViewer.getDocument(), (IRegion)region);
        }
        super.buttonPressed(buttonId);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        super.createButton(composite, 987654321, Messages.getString("FilterDialog.Format"), false);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd.heightHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)gd);
        this.sourceViewer = new SourceViewer(composite, (IVerticalRuler)new VerticalRuler(0), 768);
        this.sourceViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.configuration = new FilterSourceViewerConfiguration(this.parser, this.browserConnection);
        this.sourceViewer.configure((SourceViewerConfiguration)this.configuration);
        Document document = new Document(this.filter);
        this.sourceViewer.setDocument((IDocument)document);
        Region region = new Region(0, this.sourceViewer.getDocument().getLength());
        this.configuration.getContentFormatter((ISourceViewer)this.sourceViewer).format(this.sourceViewer.getDocument(), (IRegion)region);
        this.sourceViewer.getTextWidget().setFocus();
        return composite;
    }
}

