/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphKeyCredentialInner;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryApplicationImpl;
import com.azure.resourcemanager.authorization.implementation.HasCredential;
import com.azure.resourcemanager.authorization.implementation.ServicePrincipalImpl;
import com.azure.resourcemanager.authorization.models.CertificateCredential;
import com.azure.resourcemanager.authorization.models.CertificateType;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Base64;
import reactor.core.publisher.Mono;

class CertificateCredentialImpl<T extends HasCredential<T>>
extends IndexableRefreshableWrapperImpl<CertificateCredential, MicrosoftGraphKeyCredentialInner>
implements CertificateCredential,
CertificateCredential.Definition<T> {
    private String name;
    private HasCredential<T> parent;
    private OutputStream authFile;
    private String privateKeyPath;
    private String privateKeyPassword;
    private final ClientLogger logger = new ClientLogger(CertificateCredentialImpl.class);

    CertificateCredentialImpl(MicrosoftGraphKeyCredentialInner keyCredential) {
        super((Object)keyCredential);
        this.name = keyCredential.displayName() != null ? keyCredential.displayName() : keyCredential.keyId().toString();
    }

    CertificateCredentialImpl(String name, HasCredential<T> parent) {
        super((Object)new MicrosoftGraphKeyCredentialInner().withUsage("Verify").withDisplayName(name).withStartDateTime(OffsetDateTime.now()).withEndDateTime(OffsetDateTime.now().plusYears(1L)));
        this.name = name;
        this.parent = parent;
    }

    public Mono<CertificateCredential> refreshAsync() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot refresh credentials."));
    }

    protected Mono<MicrosoftGraphKeyCredentialInner> getInnerAsync() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot refresh credentials."));
    }

    @Override
    public OffsetDateTime startDate() {
        return ((MicrosoftGraphKeyCredentialInner)this.innerModel()).startDateTime();
    }

    @Override
    public OffsetDateTime endDate() {
        return ((MicrosoftGraphKeyCredentialInner)this.innerModel()).endDateTime();
    }

    @Override
    public String value() {
        return Base64.getEncoder().encodeToString(((MicrosoftGraphKeyCredentialInner)this.innerModel()).key());
    }

    public T attach() {
        return this.parent.withCertificateCredential(this);
    }

    @Override
    public CertificateCredentialImpl<T> withStartDate(OffsetDateTime startDate) {
        OffsetDateTime original = this.startDate();
        ((MicrosoftGraphKeyCredentialInner)this.innerModel()).withStartDateTime(startDate);
        this.withDuration(Duration.between(original, this.endDate()));
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withDuration(Duration duration) {
        ((MicrosoftGraphKeyCredentialInner)this.innerModel()).withEndDateTime(this.startDate().plus(duration));
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withAsymmetricX509Certificate() {
        ((MicrosoftGraphKeyCredentialInner)this.innerModel()).withType(CertificateType.ASYMMETRIC_X509_CERT.toString());
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withSymmetricEncryption() {
        ((MicrosoftGraphKeyCredentialInner)this.innerModel()).withType(CertificateType.SYMMETRIC.toString());
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withPublicKey(byte[] certificate) {
        ((MicrosoftGraphKeyCredentialInner)this.innerModel()).withKey(certificate);
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withSecretKey(byte[] secret) {
        ((MicrosoftGraphKeyCredentialInner)this.innerModel()).withKey(secret);
        return this;
    }

    void exportAuthFile(ServicePrincipalImpl servicePrincipal) {
        this.exportAuthFile(servicePrincipal.manager().environment(), servicePrincipal.applicationId(), servicePrincipal.manager().tenantId(), servicePrincipal.assignedSubscription);
    }

    void exportAuthFile(ActiveDirectoryApplicationImpl activeDirectoryApplication) {
        this.exportAuthFile(activeDirectoryApplication.manager().environment(), activeDirectoryApplication.applicationId(), activeDirectoryApplication.manager().tenantId(), null);
    }

    void exportAuthFile(AzureEnvironment environment, String clientId, String tenantId, String subscriptionId) {
        if (this.authFile == null) {
            return;
        }
        StringBuilder builder = new StringBuilder("{\n");
        builder.append("  ").append(String.format("\"clientId\": \"%s\",", clientId)).append("\n");
        builder.append("  ").append(String.format("\"clientCertificate\": \"%s\",", this.privateKeyPath.replace("\\", "\\\\"))).append("\n");
        builder.append("  ").append(String.format("\"clientCertificatePassword\": \"%s\",", this.privateKeyPassword)).append("\n");
        builder.append("  ").append(String.format("\"tenantId\": \"%s\",", tenantId)).append("\n");
        builder.append("  ").append(String.format("\"subscriptionId\": \"%s\",", subscriptionId)).append("\n");
        builder.append("  ").append(String.format("\"activeDirectoryEndpointUrl\": \"%s\",", environment.getActiveDirectoryEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"resourceManagerEndpointUrl\": \"%s\",", environment.getResourceManagerEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"activeDirectoryGraphResourceId\": \"%s\",", environment.getGraphEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"%s\": \"%s\",", AzureEnvironment.Endpoint.MICROSOFT_GRAPH.identifier(), environment.getMicrosoftGraphEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"managementEndpointUrl\": \"%s\"", environment.getManagementEndpoint())).append("\n");
        builder.append("}");
        try {
            this.authFile.write(builder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    public CertificateCredentialImpl<T> withAuthFileToExport(OutputStream outputStream) {
        this.authFile = outputStream;
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withPrivateKeyFile(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public String id() {
        return ((MicrosoftGraphKeyCredentialInner)this.innerModel()).keyId().toString();
    }

    public String name() {
        return this.name;
    }
}

