/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.options;

import com.azure.core.http.HttpAuthorization;
import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.PageBlobRequestConditions;
import com.azure.storage.blob.models.PageRange;

public final class PageBlobUploadPagesFromUrlOptions {
    private final PageRange range;
    private final String sourceUrl;
    private Long sourceOffset;
    private byte[] sourceContentMd5;
    private PageBlobRequestConditions destinationRequestConditions;
    private BlobRequestConditions sourceRequestConditions;
    private HttpAuthorization sourceAuthorization;

    public PageBlobUploadPagesFromUrlOptions(PageRange range, String sourceUrl) {
        this.range = range;
        this.sourceUrl = sourceUrl;
    }

    public PageRange getRange() {
        return this.range;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public Long getSourceOffset() {
        return this.sourceOffset;
    }

    public PageBlobUploadPagesFromUrlOptions setSourceOffset(Long sourceOffset) {
        this.sourceOffset = sourceOffset;
        return this;
    }

    public byte[] getSourceContentMd5() {
        return CoreUtils.clone((byte[])this.sourceContentMd5);
    }

    public PageBlobUploadPagesFromUrlOptions setSourceContentMd5(byte[] sourceContentMd5) {
        this.sourceContentMd5 = CoreUtils.clone((byte[])sourceContentMd5);
        return this;
    }

    public PageBlobRequestConditions getDestinationRequestConditions() {
        return this.destinationRequestConditions;
    }

    public PageBlobUploadPagesFromUrlOptions setDestinationRequestConditions(PageBlobRequestConditions destinationRequestConditions) {
        this.destinationRequestConditions = destinationRequestConditions;
        return this;
    }

    public BlobRequestConditions getSourceRequestConditions() {
        return this.sourceRequestConditions;
    }

    public PageBlobUploadPagesFromUrlOptions setSourceRequestConditions(BlobRequestConditions sourceRequestConditions) {
        this.sourceRequestConditions = sourceRequestConditions;
        return this;
    }

    public HttpAuthorization getSourceAuthorization() {
        return this.sourceAuthorization;
    }

    public PageBlobUploadPagesFromUrlOptions setSourceAuthorization(HttpAuthorization sourceAuthorization) {
        this.sourceAuthorization = sourceAuthorization;
        return this;
    }
}

