/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.task.executor.worker;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.TaskExecutorState;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorFailedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorKilledLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorPausedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorSuccessLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.worker.ITaskExecutorWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskExecutorWorker
implements ITaskExecutorWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTaskExecutorWorker.class);

    protected void trackTaskExecutorState(ITaskExecutor taskExecutor) {
        Preconditions.checkNotNull((Object)taskExecutor, (Object)"taskExecutor is null");
        TaskExecutorState taskExecutorState = taskExecutor.trackTaskExecutorState();
        switch (taskExecutorState) {
            case SUCCEEDED: {
                this.onTaskExecutorSuccess(taskExecutor);
                break;
            }
            case FAILED: {
                this.onTaskExecutorFailed(taskExecutor);
                break;
            }
            case KILLED: {
                this.onTaskExecutorKilled(taskExecutor);
                break;
            }
            case PAUSED: {
                this.onTaskExecutorPaused(taskExecutor);
                break;
            }
            case RUNNING: {
                log.debug("TaskExecutor(id={}) is running", (Object)taskExecutor.getId());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected TaskExecutorState: " + (Object)((Object)taskExecutorState) + " for taskExecutor(id=" + taskExecutor.getId() + ")");
            }
        }
    }

    protected void onTaskExecutorSuccess(ITaskExecutor taskExecutor) {
        taskExecutor.getTaskExecutionContext().setEndTime(System.currentTimeMillis());
        taskExecutor.getTaskExecutorEventBus().publish(TaskExecutorSuccessLifecycleEvent.of(taskExecutor));
        this.onTaskExecutorFinished(taskExecutor);
    }

    protected void onTaskExecutorKilled(ITaskExecutor taskExecutor) {
        taskExecutor.getTaskExecutionContext().setEndTime(System.currentTimeMillis());
        taskExecutor.getTaskExecutorEventBus().publish(TaskExecutorKilledLifecycleEvent.of(taskExecutor));
        this.onTaskExecutorFinished(taskExecutor);
    }

    protected void onTaskExecutorPaused(ITaskExecutor taskExecutor) {
        taskExecutor.getTaskExecutionContext().setEndTime(System.currentTimeMillis());
        taskExecutor.getTaskExecutorEventBus().publish(TaskExecutorPausedLifecycleEvent.of(taskExecutor));
        this.onTaskExecutorFinished(taskExecutor);
    }

    protected void onTaskExecutorFailed(ITaskExecutor taskExecutor) {
        taskExecutor.getTaskExecutionContext().setEndTime(System.currentTimeMillis());
        taskExecutor.getTaskExecutorEventBus().publish(TaskExecutorFailedLifecycleEvent.of(taskExecutor));
        this.onTaskExecutorFinished(taskExecutor);
    }

    protected void onTaskExecutorFinished(ITaskExecutor taskExecutor) {
        this.unFireTaskExecutor(taskExecutor);
    }
}

