/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.BackupRestoreOperationType;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class RestoreRequestProperties {
    @JsonProperty(value="storageAccountUrl", required=true)
    private String storageAccountUrl;
    @JsonProperty(value="blobName")
    private String blobName;
    @JsonProperty(value="overwrite", required=true)
    private boolean overwrite;
    @JsonProperty(value="siteName")
    private String siteName;
    @JsonProperty(value="databases")
    private List<DatabaseBackupSetting> databases;
    @JsonProperty(value="ignoreConflictingHostNames")
    private Boolean ignoreConflictingHostNames;
    @JsonProperty(value="ignoreDatabases")
    private Boolean ignoreDatabases;
    @JsonProperty(value="appServicePlan")
    private String appServicePlan;
    @JsonProperty(value="operationType")
    private BackupRestoreOperationType operationType;
    @JsonProperty(value="adjustConnectionStrings")
    private Boolean adjustConnectionStrings;
    @JsonProperty(value="hostingEnvironment")
    private String hostingEnvironment;
    private static final ClientLogger LOGGER = new ClientLogger(RestoreRequestProperties.class);

    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    public RestoreRequestProperties withStorageAccountUrl(String storageAccountUrl) {
        this.storageAccountUrl = storageAccountUrl;
        return this;
    }

    public String blobName() {
        return this.blobName;
    }

    public RestoreRequestProperties withBlobName(String blobName) {
        this.blobName = blobName;
        return this;
    }

    public boolean overwrite() {
        return this.overwrite;
    }

    public RestoreRequestProperties withOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public String siteName() {
        return this.siteName;
    }

    public RestoreRequestProperties withSiteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    public RestoreRequestProperties withDatabases(List<DatabaseBackupSetting> databases) {
        this.databases = databases;
        return this;
    }

    public Boolean ignoreConflictingHostNames() {
        return this.ignoreConflictingHostNames;
    }

    public RestoreRequestProperties withIgnoreConflictingHostNames(Boolean ignoreConflictingHostNames) {
        this.ignoreConflictingHostNames = ignoreConflictingHostNames;
        return this;
    }

    public Boolean ignoreDatabases() {
        return this.ignoreDatabases;
    }

    public RestoreRequestProperties withIgnoreDatabases(Boolean ignoreDatabases) {
        this.ignoreDatabases = ignoreDatabases;
        return this;
    }

    public String appServicePlan() {
        return this.appServicePlan;
    }

    public RestoreRequestProperties withAppServicePlan(String appServicePlan) {
        this.appServicePlan = appServicePlan;
        return this;
    }

    public BackupRestoreOperationType operationType() {
        return this.operationType;
    }

    public RestoreRequestProperties withOperationType(BackupRestoreOperationType operationType) {
        this.operationType = operationType;
        return this;
    }

    public Boolean adjustConnectionStrings() {
        return this.adjustConnectionStrings;
    }

    public RestoreRequestProperties withAdjustConnectionStrings(Boolean adjustConnectionStrings) {
        this.adjustConnectionStrings = adjustConnectionStrings;
        return this;
    }

    public String hostingEnvironment() {
        return this.hostingEnvironment;
    }

    public RestoreRequestProperties withHostingEnvironment(String hostingEnvironment) {
        this.hostingEnvironment = hostingEnvironment;
        return this;
    }

    public void validate() {
        if (this.storageAccountUrl() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageAccountUrl in model RestoreRequestProperties"));
        }
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
    }
}

