/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.audit.operator.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.dolphinscheduler.api.audit.OperatorUtils;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.audit.operator.BaseAuditOperator;
import org.apache.dolphinscheduler.common.enums.AuditOperationType;
import org.apache.dolphinscheduler.dao.entity.AuditLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.mapper.WorkflowInstanceMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowInstanceAuditOperatorImpl
extends BaseAuditOperator {
    @Autowired
    private WorkflowInstanceMapper workflowInstanceMapper;

    @Override
    public void modifyAuditOperationType(AuditType auditType, Map<String, Object> paramsMap, List<AuditLog> auditLogList) {
        AuditOperationType auditOperationType = OperatorUtils.modifyReleaseOperationType(auditType, paramsMap);
        auditLogList.forEach(auditLog -> auditLog.setOperationType(auditOperationType.getName()));
    }

    @Override
    protected void setObjectByParam(String[] paramNameArr, Map<String, Object> paramsMap, List<AuditLog> auditLogList) {
        if (paramNameArr[0].equals("workflowInstanceIds")) {
            super.setObjectByParamArr(paramNameArr, paramsMap, auditLogList);
        } else {
            super.setObjectByParam(paramNameArr, paramsMap, auditLogList);
        }
    }

    @Override
    protected String getObjectNameFromIdentity(Object identity) {
        int objId = NumberUtils.toInt((String)identity.toString(), (int)-1);
        if (objId == -1) {
            return "";
        }
        WorkflowInstance obj = this.workflowInstanceMapper.queryDetailById(objId);
        return obj == null ? "" : obj.getName();
    }
}

