/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.schedule;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.dolphinscheduler.api.dto.schedule.ScheduleParam;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.Schedule;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ScheduleUpdateRequest {
    @Schema(example="schedule timezone", required=true)
    private String crontab;
    @Schema(example="2021-01-01 10:00:00", required=true)
    private String startTime;
    @Schema(example="2022-01-01 12:00:00", required=true)
    private String endTime;
    @Schema(example="Asia/Shanghai", required=true)
    private String timezoneId;
    @Schema(allowableValues={"CONTINUE / END"}, example="CONTINUE", description="default CONTINUE if value not provide.")
    private String failureStrategy;
    @Schema(allowableValues={"ONLINE / OFFLINE"}, example="OFFLINE", description="default OFFLINE if value not provide.")
    private String releaseState;
    @Schema(allowableValues={"NONE / SUCCESS / FAILURE / ALL"}, example="SUCCESS", description="default NONE if value not provide.")
    private String warningType;
    @Schema(example="2", description="default 0 if value not provide.")
    private int warningGroupId;
    @Schema(allowableValues={"HIGHEST / HIGH / MEDIUM / LOW / LOWEST"}, example="MEDIUM", description="default MEDIUM if value not provide.")
    private String workflowInstancePriority;
    @Schema(example="worker-group-name")
    private String workerGroup;
    @Schema(example="environment-code")
    private long environmentCode;

    public String updateScheduleParam(Schedule schedule) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        Schedule scheduleUpdate = this.mergeIntoSchedule(schedule);
        String startTimeUpdate = scheduleUpdate.getStartTime() == null ? null : DateUtils.format((Date)scheduleUpdate.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss", (String)schedule.getTimezoneId());
        String endTimeUpdate = scheduleUpdate.getEndTime() == null ? null : DateUtils.format((Date)scheduleUpdate.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss", (String)schedule.getTimezoneId());
        ScheduleParam scheduleParam = new ScheduleParam(startTimeUpdate, endTimeUpdate, scheduleUpdate.getCrontab(), scheduleUpdate.getTimezoneId());
        Gson gson = new GsonBuilder().serializeNulls().create();
        return gson.toJson((Object)scheduleParam);
    }

    public Schedule mergeIntoSchedule(Schedule schedule) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        Schedule scheduleDeepCopy = (Schedule)BeanUtils.cloneBean((Object)schedule);
        assert (scheduleDeepCopy != null);
        if (this.crontab != null) {
            scheduleDeepCopy.setCrontab(this.crontab);
        }
        if (this.startTime != null) {
            scheduleDeepCopy.setStartTime(DateUtils.stringToDate((String)this.startTime));
        }
        if (this.endTime != null) {
            scheduleDeepCopy.setEndTime(DateUtils.stringToDate((String)this.endTime));
        }
        if (this.timezoneId != null) {
            scheduleDeepCopy.setTimezoneId(this.timezoneId);
        }
        if (this.failureStrategy != null) {
            scheduleDeepCopy.setFailureStrategy(FailureStrategy.valueOf((String)this.failureStrategy));
        }
        if (this.releaseState != null) {
            scheduleDeepCopy.setReleaseState(ReleaseState.valueOf((String)this.releaseState));
        }
        if (this.warningType != null) {
            scheduleDeepCopy.setWarningType(WarningType.valueOf((String)this.warningType));
        }
        if (this.warningGroupId != 0) {
            scheduleDeepCopy.setWarningGroupId(this.warningGroupId);
        }
        if (this.workflowInstancePriority != null) {
            scheduleDeepCopy.setWorkflowInstancePriority(Priority.valueOf((String)this.workflowInstancePriority));
        }
        if (this.workerGroup != null) {
            scheduleDeepCopy.setWorkerGroup(this.workerGroup);
        }
        if (this.environmentCode != 0L) {
            scheduleDeepCopy.setEnvironmentCode(Long.valueOf(this.environmentCode));
        }
        scheduleDeepCopy.setUpdateTime(new Date());
        return scheduleDeepCopy;
    }

    @Generated
    public ScheduleUpdateRequest() {
    }

    @Generated
    public String getCrontab() {
        return this.crontab;
    }

    @Generated
    public String getStartTime() {
        return this.startTime;
    }

    @Generated
    public String getEndTime() {
        return this.endTime;
    }

    @Generated
    public String getTimezoneId() {
        return this.timezoneId;
    }

    @Generated
    public String getFailureStrategy() {
        return this.failureStrategy;
    }

    @Generated
    public String getReleaseState() {
        return this.releaseState;
    }

    @Generated
    public String getWarningType() {
        return this.warningType;
    }

    @Generated
    public int getWarningGroupId() {
        return this.warningGroupId;
    }

    @Generated
    public String getWorkflowInstancePriority() {
        return this.workflowInstancePriority;
    }

    @Generated
    public String getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public long getEnvironmentCode() {
        return this.environmentCode;
    }

    @Generated
    public void setCrontab(String crontab) {
        this.crontab = crontab;
    }

    @Generated
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
    }

    @Generated
    public void setFailureStrategy(String failureStrategy) {
        this.failureStrategy = failureStrategy;
    }

    @Generated
    public void setReleaseState(String releaseState) {
        this.releaseState = releaseState;
    }

    @Generated
    public void setWarningType(String warningType) {
        this.warningType = warningType;
    }

    @Generated
    public void setWarningGroupId(int warningGroupId) {
        this.warningGroupId = warningGroupId;
    }

    @Generated
    public void setWorkflowInstancePriority(String workflowInstancePriority) {
        this.workflowInstancePriority = workflowInstancePriority;
    }

    @Generated
    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    @Generated
    public void setEnvironmentCode(long environmentCode) {
        this.environmentCode = environmentCode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduleUpdateRequest)) {
            return false;
        }
        ScheduleUpdateRequest other = (ScheduleUpdateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWarningGroupId() != other.getWarningGroupId()) {
            return false;
        }
        if (this.getEnvironmentCode() != other.getEnvironmentCode()) {
            return false;
        }
        String this$crontab = this.getCrontab();
        String other$crontab = other.getCrontab();
        if (this$crontab == null ? other$crontab != null : !this$crontab.equals(other$crontab)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        String this$timezoneId = this.getTimezoneId();
        String other$timezoneId = other.getTimezoneId();
        if (this$timezoneId == null ? other$timezoneId != null : !this$timezoneId.equals(other$timezoneId)) {
            return false;
        }
        String this$failureStrategy = this.getFailureStrategy();
        String other$failureStrategy = other.getFailureStrategy();
        if (this$failureStrategy == null ? other$failureStrategy != null : !this$failureStrategy.equals(other$failureStrategy)) {
            return false;
        }
        String this$releaseState = this.getReleaseState();
        String other$releaseState = other.getReleaseState();
        if (this$releaseState == null ? other$releaseState != null : !this$releaseState.equals(other$releaseState)) {
            return false;
        }
        String this$warningType = this.getWarningType();
        String other$warningType = other.getWarningType();
        if (this$warningType == null ? other$warningType != null : !this$warningType.equals(other$warningType)) {
            return false;
        }
        String this$workflowInstancePriority = this.getWorkflowInstancePriority();
        String other$workflowInstancePriority = other.getWorkflowInstancePriority();
        if (this$workflowInstancePriority == null ? other$workflowInstancePriority != null : !this$workflowInstancePriority.equals(other$workflowInstancePriority)) {
            return false;
        }
        String this$workerGroup = this.getWorkerGroup();
        String other$workerGroup = other.getWorkerGroup();
        return !(this$workerGroup == null ? other$workerGroup != null : !this$workerGroup.equals(other$workerGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScheduleUpdateRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWarningGroupId();
        long $environmentCode = this.getEnvironmentCode();
        result = result * 59 + (int)($environmentCode >>> 32 ^ $environmentCode);
        String $crontab = this.getCrontab();
        result = result * 59 + ($crontab == null ? 43 : $crontab.hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        String $timezoneId = this.getTimezoneId();
        result = result * 59 + ($timezoneId == null ? 43 : $timezoneId.hashCode());
        String $failureStrategy = this.getFailureStrategy();
        result = result * 59 + ($failureStrategy == null ? 43 : $failureStrategy.hashCode());
        String $releaseState = this.getReleaseState();
        result = result * 59 + ($releaseState == null ? 43 : $releaseState.hashCode());
        String $warningType = this.getWarningType();
        result = result * 59 + ($warningType == null ? 43 : $warningType.hashCode());
        String $workflowInstancePriority = this.getWorkflowInstancePriority();
        result = result * 59 + ($workflowInstancePriority == null ? 43 : $workflowInstancePriority.hashCode());
        String $workerGroup = this.getWorkerGroup();
        result = result * 59 + ($workerGroup == null ? 43 : $workerGroup.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScheduleUpdateRequest(crontab=" + this.getCrontab() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", timezoneId=" + this.getTimezoneId() + ", failureStrategy=" + this.getFailureStrategy() + ", releaseState=" + this.getReleaseState() + ", warningType=" + this.getWarningType() + ", warningGroupId=" + this.getWarningGroupId() + ", workflowInstancePriority=" + this.getWorkflowInstancePriority() + ", workerGroup=" + this.getWorkerGroup() + ", environmentCode=" + this.getEnvironmentCode() + ")";
    }
}

