/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.taskRelation.TaskRelationCreateRequest;
import org.apache.dolphinscheduler.api.dto.taskRelation.TaskRelationFilterRequest;
import org.apache.dolphinscheduler.api.dto.taskRelation.TaskRelationUpdateUpstreamRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.WorkflowTaskRelationService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.common.enums.ConditionType;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelation;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelationLog;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskRelationMapper;
import org.apache.dolphinscheduler.plugin.task.api.utils.TaskTypeUtils;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkflowTaskRelationServiceImpl
extends BaseServiceImpl
implements WorkflowTaskRelationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowTaskRelationServiceImpl.class);
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private WorkflowTaskRelationMapper workflowTaskRelationMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;
    @Autowired
    private WorkflowDefinitionLogMapper workflowDefinitionLogMapper;
    @Autowired
    private ProcessService processService;
    @Autowired
    private WorkflowTaskRelationLogMapper workflowTaskRelationLogMapper;

    @Override
    @Transactional
    public Map<String, Object> createWorkflowTaskRelation(User loginUser, long projectCode, long workflowDefinitionCode, long preTaskCode, long postTaskCode) {
        Map<Long, WorkflowTaskRelation> preTaskCodeMap;
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode);
        if (workflowDefinition == null) {
            log.error("workflow definition does not exist, workflowDefinitionCode:{}.", (Object)workflowDefinitionCode);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(workflowDefinitionCode));
            return result;
        }
        if (workflowDefinition.getProjectCode() != projectCode) {
            log.error("workflow definition's project does not match project {}.", (Object)projectCode);
            this.putMsg(result, Status.PROJECT_WORKFLOW_NOT_MATCH, new Object[0]);
            return result;
        }
        this.updateWorkflowDefiniteVersion(loginUser, result, workflowDefinition);
        List workflowTaskRelationList = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode);
        ArrayList workflowTaskRelations = Lists.newArrayList((Iterable)workflowTaskRelationList);
        if (!workflowTaskRelations.isEmpty() && !(preTaskCodeMap = workflowTaskRelations.stream().filter(r -> r.getPostTaskCode() == postTaskCode).collect(Collectors.toMap(WorkflowTaskRelation::getPreTaskCode, workflowTaskRelation -> workflowTaskRelation))).isEmpty()) {
            if (preTaskCodeMap.containsKey(preTaskCode) || !preTaskCodeMap.containsKey(0L) && preTaskCode == 0L) {
                this.putMsg(result, Status.WORKFLOW_TASK_RELATION_EXIST, String.valueOf(workflowDefinitionCode));
                return result;
            }
            if (preTaskCodeMap.containsKey(0L) && preTaskCode != 0L) {
                workflowTaskRelations.remove(preTaskCodeMap.get(0L));
            }
        }
        TaskDefinition postTaskDefinition = this.taskDefinitionMapper.queryByCode(postTaskCode);
        WorkflowTaskRelation workflowTaskRelation2 = this.setRelation(workflowDefinition, postTaskDefinition);
        if (preTaskCode != 0L) {
            TaskDefinition preTaskDefinition = this.taskDefinitionMapper.queryByCode(preTaskCode);
            List upstreamTaskRelationList = workflowTaskRelations.stream().filter(r -> r.getPostTaskCode() == preTaskCode).collect(Collectors.toList());
            if (upstreamTaskRelationList.isEmpty()) {
                WorkflowTaskRelation preWorkflowTaskRelation = this.setRelation(workflowDefinition, preTaskDefinition);
                preWorkflowTaskRelation.setPreTaskCode(0L);
                preWorkflowTaskRelation.setPreTaskVersion(0);
                workflowTaskRelations.add(preWorkflowTaskRelation);
            }
            workflowTaskRelation2.setPreTaskCode(preTaskDefinition.getCode());
            workflowTaskRelation2.setPreTaskVersion(preTaskDefinition.getVersion());
        } else {
            workflowTaskRelation2.setPreTaskCode(0L);
            workflowTaskRelation2.setPreTaskVersion(0);
        }
        workflowTaskRelations.add(workflowTaskRelation2);
        this.updateRelation(loginUser, result, workflowDefinition, workflowTaskRelations);
        return result;
    }

    private WorkflowTaskRelationLog persist2WorkflowTaskRelationLog(User user, WorkflowTaskRelation workflowTaskRelation) {
        WorkflowTaskRelationLog workflowTaskRelationLog = new WorkflowTaskRelationLog(workflowTaskRelation);
        workflowTaskRelationLog.setOperator(user.getId().intValue());
        workflowTaskRelationLog.setOperateTime(new Date());
        int result = this.workflowTaskRelationLogMapper.insert((Object)workflowTaskRelationLog);
        if (result <= 0) {
            throw new ServiceException(Status.CREATE_WORKFLOW_TASK_RELATION_LOG_ERROR, workflowTaskRelationLog.getPreTaskCode(), workflowTaskRelationLog.getPostTaskCode());
        }
        return workflowTaskRelationLog;
    }

    private void updateVersions(WorkflowTaskRelation workflowTaskRelation) {
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowTaskRelation.getWorkflowDefinitionCode());
        workflowTaskRelation.setWorkflowDefinitionVersion(workflowDefinition.getVersion());
        TaskDefinition preTaskDefinition = this.taskDefinitionMapper.queryByCode(workflowTaskRelation.getPreTaskCode());
        workflowTaskRelation.setPreTaskVersion(preTaskDefinition.getVersion());
        TaskDefinition postTaskDefinition = this.taskDefinitionMapper.queryByCode(workflowTaskRelation.getPostTaskCode());
        workflowTaskRelation.setPostTaskVersion(postTaskDefinition.getVersion());
    }

    @Override
    @Transactional
    public WorkflowTaskRelation createWorkflowTaskRelationV2(User loginUser, TaskRelationCreateRequest taskRelationCreateRequest) {
        WorkflowTaskRelation workflowTaskRelation = taskRelationCreateRequest.convert2WorkflowTaskRelation();
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowTaskRelation.getWorkflowDefinitionCode());
        if (workflowDefinition == null) {
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(workflowTaskRelation.getWorkflowDefinitionCode()));
        }
        if (workflowTaskRelation.getProjectCode() == 0L) {
            workflowTaskRelation.setProjectCode(workflowDefinition.getProjectCode());
        }
        Project project = this.projectMapper.queryByCode(workflowTaskRelation.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, null);
        this.updateVersions(workflowTaskRelation);
        int insert = this.workflowTaskRelationMapper.insert((Object)workflowTaskRelation);
        if (insert <= 0) {
            throw new ServiceException(Status.CREATE_WORKFLOW_TASK_RELATION_ERROR, workflowTaskRelation.getPreTaskCode(), workflowTaskRelation.getPostTaskCode());
        }
        this.persist2WorkflowTaskRelationLog(loginUser, workflowTaskRelation);
        return workflowTaskRelation;
    }

    private WorkflowTaskRelation setRelation(WorkflowDefinition workflowDefinition, TaskDefinition taskDefinition) {
        Date now = new Date();
        WorkflowTaskRelation workflowTaskRelation = new WorkflowTaskRelation();
        workflowTaskRelation.setProjectCode(workflowDefinition.getProjectCode());
        workflowTaskRelation.setWorkflowDefinitionCode(workflowDefinition.getCode());
        workflowTaskRelation.setWorkflowDefinitionVersion(workflowDefinition.getVersion());
        workflowTaskRelation.setPostTaskCode(taskDefinition.getCode());
        workflowTaskRelation.setPostTaskVersion(taskDefinition.getVersion());
        workflowTaskRelation.setConditionType(ConditionType.NONE);
        workflowTaskRelation.setConditionParams("{}");
        workflowTaskRelation.setCreateTime(now);
        workflowTaskRelation.setUpdateTime(now);
        return workflowTaskRelation;
    }

    private void updateWorkflowDefiniteVersion(User loginUser, Map<String, Object> result, WorkflowDefinition workflowDefinition) {
        int insertVersion = this.processService.saveWorkflowDefine(loginUser, workflowDefinition, Boolean.TRUE, Boolean.TRUE);
        if (insertVersion <= 0) {
            log.error("Update workflow definition error, projectCode:{}, workflowDefinitionCode:{}.", (Object)workflowDefinition.getProjectCode(), (Object)workflowDefinition.getCode());
            this.putMsg(result, Status.UPDATE_WORKFLOW_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_WORKFLOW_DEFINITION_ERROR);
        }
        log.info("Update workflow definition complete, new version is {}, projectCode:{}, workflowDefinitionCode:{}.", new Object[]{insertVersion, workflowDefinition.getProjectCode(), workflowDefinition.getCode()});
        workflowDefinition.setVersion(insertVersion);
    }

    @Override
    @Transactional
    public Map<String, Object> deleteTaskWorkflowRelation(User loginUser, long projectCode, long workflowDefinitionCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (taskCode == 0L) {
            log.error("delete task workflow relation error due to parameter taskCode is 0, projectCode:{}, workflowDefinitionCode:{}.", (Object)projectCode, (Object)workflowDefinitionCode);
            this.putMsg(result, Status.DELETE_TASK_WORKFLOW_RELATION_ERROR, new Object[0]);
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode);
        if (workflowDefinition == null) {
            log.error("workflow definition does not exist, workflowDefinitionCode:{}.", (Object)workflowDefinitionCode);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(workflowDefinitionCode));
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (null == taskDefinition) {
            log.error("Task definition does not exist, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
            return result;
        }
        List workflowTaskRelations = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode);
        ArrayList workflowTaskRelationList = Lists.newArrayList((Iterable)workflowTaskRelations);
        if (CollectionUtils.isEmpty((Collection)workflowTaskRelationList)) {
            log.error("workflow task relations are empty, projectCode:{}, workflowDefinitionCode:{}.", (Object)projectCode, (Object)workflowDefinitionCode);
            this.putMsg(result, Status.DATA_IS_NULL, "workflowTaskRelationList");
            return result;
        }
        ArrayList downstreamList = Lists.newArrayList();
        for (WorkflowTaskRelation workflowTaskRelation : workflowTaskRelations) {
            if (workflowTaskRelation.getPreTaskCode() == taskCode) {
                downstreamList.add(workflowTaskRelation.getPostTaskCode());
            }
            if (workflowTaskRelation.getPostTaskCode() != taskCode) continue;
            workflowTaskRelationList.remove(workflowTaskRelation);
        }
        if (CollectionUtils.isNotEmpty((Collection)downstreamList)) {
            String downstream = StringUtils.join((Iterable)downstreamList, (String)",");
            log.warn("Relation can not be deleted because task has downstream tasks:[{}], projectCode:{}, workflowDefinitionCode:{}, taskDefinitionCode:{}.", new Object[]{downstream, projectCode, workflowDefinitionCode, taskCode});
            this.putMsg(result, Status.TASK_HAS_DOWNSTREAM, downstream);
            return result;
        }
        this.updateWorkflowDefiniteVersion(loginUser, result, workflowDefinition);
        this.updateRelation(loginUser, result, workflowDefinition, workflowTaskRelationList);
        if (TaskTypeUtils.isConditionTask((String)taskDefinition.getTaskType()) || TaskTypeUtils.isSubWorkflowTask((String)taskDefinition.getTaskType()) || TaskTypeUtils.isDependentTask((String)taskDefinition.getTaskType())) {
            int deleteTaskDefinition = this.taskDefinitionMapper.deleteByCode(taskCode);
            if (0 == deleteTaskDefinition) {
                log.error("Delete task definition error, taskDefinitionCode:{}.", (Object)taskCode);
                this.putMsg(result, Status.DELETE_TASK_DEFINE_BY_CODE_ERROR, new Object[0]);
                throw new ServiceException(Status.DELETE_TASK_DEFINE_BY_CODE_ERROR);
            }
            log.info("Delete {} type task definition complete, taskDefinitionCode:{}.", (Object)taskDefinition.getTaskType(), (Object)taskCode);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public void deleteTaskWorkflowRelationV2(User loginUser, long preTaskCode, long postTaskCode) {
        WorkflowTaskRelation workflowTaskRelation = new TaskRelationFilterRequest(preTaskCode, postTaskCode).convert2TaskDefinition();
        Page page = new Page((long)new TaskRelationFilterRequest(preTaskCode, postTaskCode).getPageNo().intValue(), (long)new TaskRelationFilterRequest(preTaskCode, postTaskCode).getPageSize().intValue());
        IPage workflowTaskRelationIPage = this.workflowTaskRelationMapper.filterWorkflowTaskRelation((IPage)page, workflowTaskRelation);
        List workflowTaskRelations = workflowTaskRelationIPage.getRecords();
        if (workflowTaskRelations.size() != 1) {
            throw new ServiceException(Status.WORKFLOW_TASK_RELATION_NOT_EXPECT, 1, workflowTaskRelations.size());
        }
        WorkflowTaskRelation workflowTaskRelationDb = (WorkflowTaskRelation)workflowTaskRelations.get(0);
        Project project = this.projectMapper.queryByCode(workflowTaskRelationDb.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, null);
        this.workflowTaskRelationMapper.deleteById((Serializable)workflowTaskRelationDb.getId());
    }

    @Override
    @Transactional
    public List<WorkflowTaskRelation> updateUpstreamTaskDefinitionWithSyncDag(User loginUser, long taskCode, Boolean needSyncDag, TaskRelationUpdateUpstreamRequest taskRelationUpdateUpstreamRequest) {
        int delete;
        TaskDefinition downstreamTask = this.taskDefinitionMapper.queryByCode(taskCode);
        if (downstreamTask == null) {
            throw new ServiceException(Status.TASK_DEFINE_NOT_EXIST, taskCode);
        }
        List<Long> upstreamTaskCodes = taskRelationUpdateUpstreamRequest.getUpstreams();
        WorkflowTaskRelation workflowTaskRelation = new WorkflowTaskRelation();
        workflowTaskRelation.setPostTaskCode(taskCode);
        Page page = new Page((long)taskRelationUpdateUpstreamRequest.getPageNo().intValue(), (long)taskRelationUpdateUpstreamRequest.getPageSize().intValue());
        IPage workflowTaskRelationExistsIPage = this.workflowTaskRelationMapper.filterWorkflowTaskRelation((IPage)page, workflowTaskRelation);
        List workflowTaskRelationExists = workflowTaskRelationExistsIPage.getRecords();
        WorkflowDefinition workflowDefinition = null;
        if (CollectionUtils.isNotEmpty((Collection)workflowTaskRelationExists)) {
            workflowDefinition = this.workflowDefinitionMapper.queryByCode(((WorkflowTaskRelation)workflowTaskRelationExists.get(0)).getWorkflowDefinitionCode());
        } else if (taskRelationUpdateUpstreamRequest.getWorkflowCode() != 0L) {
            workflowDefinition = this.workflowDefinitionMapper.queryByCode(taskRelationUpdateUpstreamRequest.getWorkflowCode());
        }
        if (workflowDefinition == null) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, taskRelationUpdateUpstreamRequest.toString());
        }
        workflowDefinition.setUpdateTime(new Date());
        int insertVersion = workflowDefinition.getVersion();
        if (needSyncDag.booleanValue() && (insertVersion = this.saveWorkflowDefinition(loginUser, workflowDefinition)) <= 0) {
            throw new ServiceException(Status.UPDATE_WORKFLOW_DEFINITION_ERROR);
        }
        List taskCodeCreates = upstreamTaskCodes.stream().filter(upstreamTaskCode -> workflowTaskRelationExists.stream().noneMatch(workflowTaskRelation1 -> workflowTaskRelation1.getPreTaskCode() == upstreamTaskCode.longValue())).collect(Collectors.toList());
        List taskCodeDeletes = workflowTaskRelationExists.stream().filter(ptr -> !upstreamTaskCodes.contains(ptr.getPreTaskCode())).map(WorkflowTaskRelation::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(taskCodeDeletes) && (delete = this.workflowTaskRelationMapper.deleteBatchIds(taskCodeDeletes)) != taskCodeDeletes.size()) {
            throw new ServiceException(Status.WORKFLOW_TASK_RELATION_BATCH_DELETE_ERROR, taskCodeDeletes);
        }
        ArrayList<WorkflowTaskRelation> workflowTaskRelations = new ArrayList<WorkflowTaskRelation>();
        Iterator iterator = taskCodeCreates.iterator();
        while (iterator.hasNext()) {
            long createCode = (Long)iterator.next();
            long upstreamCode = 0L;
            int version = 0;
            if (createCode != 0L) {
                TaskDefinition upstreamTask = this.taskDefinitionMapper.queryByCode(createCode);
                if (upstreamTask == null) {
                    throw new ServiceException(Status.TASK_DEFINE_NOT_EXIST, createCode);
                }
                upstreamCode = upstreamTask.getCode();
                version = upstreamTask.getVersion();
            }
            WorkflowTaskRelation workflowTaskRelationCreate = new WorkflowTaskRelation(null, workflowDefinition.getVersion(), downstreamTask.getProjectCode(), workflowDefinition.getCode(), upstreamCode, version, downstreamTask.getCode(), downstreamTask.getVersion(), null, null);
            workflowTaskRelations.add(workflowTaskRelationCreate);
        }
        int batchInsert = this.workflowTaskRelationMapper.batchInsert(workflowTaskRelations);
        if (batchInsert != workflowTaskRelations.size()) {
            throw new ServiceException(Status.WORKFLOW_TASK_RELATION_BATCH_CREATE_ERROR, taskCodeCreates);
        }
        int saveTaskRelationResult = this.saveTaskRelation(loginUser, workflowDefinition, insertVersion);
        if (saveTaskRelationResult != 0) {
            log.error("Save workflow task relations error, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion});
            throw new ServiceException(Status.CREATE_WORKFLOW_TASK_RELATION_ERROR);
        }
        log.info("Save workflow task relations complete, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion});
        ((WorkflowTaskRelation)workflowTaskRelations.get(0)).setWorkflowDefinitionVersion(insertVersion);
        return workflowTaskRelations;
    }

    public int saveTaskRelation(User loginUser, WorkflowDefinition workflowDefinition, int workflowDefinitionVersion) {
        int resultLog;
        List workflowTaskRelations;
        int insert;
        long projectCode = workflowDefinition.getProjectCode();
        long workflowDefinitionCode = workflowDefinition.getCode();
        List taskRelations = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode);
        List taskRelationList = taskRelations.stream().map(WorkflowTaskRelationLog::new).collect(Collectors.toList());
        List taskCodeList = taskRelations.stream().map(WorkflowTaskRelation::getPostTaskCode).collect(Collectors.toList());
        List taskDefinitions = this.taskDefinitionMapper.queryByCodeList(taskCodeList);
        List taskDefinitionLogs = taskDefinitions.stream().map(TaskDefinitionLog::new).collect(Collectors.toList());
        if (taskRelationList.isEmpty()) {
            return 0;
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(taskDefinitionLogs)) {
            taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        }
        Date now = new Date();
        for (WorkflowTaskRelationLog workflowTaskRelationLog : taskRelationList) {
            workflowTaskRelationLog.setProjectCode(projectCode);
            workflowTaskRelationLog.setWorkflowDefinitionCode(workflowDefinitionCode);
            workflowTaskRelationLog.setWorkflowDefinitionVersion(workflowDefinitionVersion);
            if (taskDefinitionLogMap != null) {
                TaskDefinitionLog postTaskDefinitionLog;
                TaskDefinitionLog preTaskDefinitionLog = taskDefinitionLogMap.get(workflowTaskRelationLog.getPreTaskCode());
                if (preTaskDefinitionLog != null) {
                    workflowTaskRelationLog.setPreTaskVersion(preTaskDefinitionLog.getVersion());
                }
                if ((postTaskDefinitionLog = taskDefinitionLogMap.get(workflowTaskRelationLog.getPostTaskCode())) != null) {
                    workflowTaskRelationLog.setPostTaskVersion(postTaskDefinitionLog.getVersion());
                }
            }
            workflowTaskRelationLog.setCreateTime(now);
            workflowTaskRelationLog.setUpdateTime(now);
            workflowTaskRelationLog.setOperator(loginUser.getId().intValue());
            workflowTaskRelationLog.setOperateTime(now);
        }
        if (CollectionUtils.isNotEmpty((Collection)taskRelations)) {
            Set taskRelationSet;
            Set workflowTaskRelationSet = taskRelations.stream().map(WorkflowTaskRelation::hashCode).collect(Collectors.toSet());
            boolean isSame = org.apache.commons.collections.CollectionUtils.isEqualCollection(workflowTaskRelationSet, taskRelationSet = taskRelationList.stream().map(WorkflowTaskRelationLog::hashCode).collect(Collectors.toSet()));
            if (isSame) {
                return 0;
            }
            this.workflowTaskRelationMapper.deleteByWorkflowDefinitionCode(projectCode, workflowDefinitionCode);
        }
        return ((insert = this.workflowTaskRelationMapper.batchInsert(workflowTaskRelations = taskRelationList.stream().map(WorkflowTaskRelation::new).collect(Collectors.toList()))) & (resultLog = this.workflowTaskRelationLogMapper.batchInsert(taskRelationList))) > 0 ? 0 : -1;
    }

    public int saveWorkflowDefinition(User loginUser, WorkflowDefinition workflowDefinition) {
        WorkflowDefinitionLog workflowDefinitionLog = new WorkflowDefinitionLog(workflowDefinition);
        Integer version = this.workflowDefinitionLogMapper.queryMaxVersionForDefinition(workflowDefinition.getCode());
        int insertVersion = version == null || version == 0 ? 1 : version + 1;
        workflowDefinitionLog.setVersion(insertVersion);
        workflowDefinitionLog.setOperator(loginUser.getId().intValue());
        workflowDefinitionLog.setOperateTime(workflowDefinition.getUpdateTime());
        workflowDefinitionLog.setId(null);
        int insertLog = this.workflowDefinitionLogMapper.insert((Object)workflowDefinitionLog);
        workflowDefinitionLog.setId(workflowDefinition.getId());
        int result = this.workflowDefinitionMapper.updateById((WorkflowDefinition)workflowDefinitionLog);
        return (insertLog & result) > 0 ? insertVersion : 0;
    }

    private void updateRelation(User loginUser, Map<String, Object> result, WorkflowDefinition workflowDefinition, List<WorkflowTaskRelation> workflowTaskRelationList) {
        List relationLogs = workflowTaskRelationList.stream().map(WorkflowTaskRelationLog::new).collect(Collectors.toList());
        int insertResult = this.processService.saveTaskRelation(loginUser, workflowDefinition.getProjectCode(), workflowDefinition.getCode(), workflowDefinition.getVersion(), relationLogs, (List)Lists.newArrayList(), Boolean.TRUE);
        if (insertResult != 0) {
            log.error("Update task relations error, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), workflowDefinition.getVersion()});
            this.putMsg(result, Status.UPDATE_WORKFLOW_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_WORKFLOW_DEFINITION_ERROR);
        }
        log.info("Update task relations complete, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), workflowDefinition.getVersion()});
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", workflowDefinition);
    }

    @Override
    @Transactional
    public Map<String, Object> deleteUpstreamRelation(User loginUser, long projectCode, String preTaskCodes, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)preTaskCodes)) {
            log.warn("Parameter preTaskCodes is empty.");
            this.putMsg(result, Status.DATA_IS_NULL, "preTaskCodes");
            return result;
        }
        List upstreamList = this.workflowTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        if (CollectionUtils.isEmpty((Collection)upstreamList)) {
            log.error("Upstream tasks based on the task do not exist, theTaskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.DATA_IS_NULL, "taskCode");
            return result;
        }
        List preTaskCodeList = Lists.newArrayList((Object[])preTaskCodes.split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
        if (preTaskCodeList.contains(0L)) {
            log.warn("Parameter preTaskCodes contain 0.");
            this.putMsg(result, Status.DATA_IS_NULL, "preTaskCodes");
            return result;
        }
        List currentUpstreamList = upstreamList.stream().map(WorkflowTaskRelation::getPreTaskCode).collect(Collectors.toList());
        if (currentUpstreamList.contains(0L)) {
            log.error("Upstream taskCodes based on the task contain, theTaskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.DATA_IS_NOT_VALID, "currentUpstreamList");
            return result;
        }
        ArrayList tmpCurrent = Lists.newArrayList(currentUpstreamList);
        tmpCurrent.removeAll(preTaskCodeList);
        preTaskCodeList.removeAll(currentUpstreamList);
        if (!preTaskCodeList.isEmpty()) {
            String invalidPreTaskCodes = StringUtils.join(preTaskCodeList, (String)",");
            log.error("Some upstream taskCodes are invalid, preTaskCodeList:{}.", (Object)invalidPreTaskCodes);
            this.putMsg(result, Status.DATA_IS_NOT_VALID, invalidPreTaskCodes);
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(((WorkflowTaskRelation)upstreamList.get(0)).getWorkflowDefinitionCode());
        if (workflowDefinition == null) {
            log.error("workflow definition does not exist, workflowDefinitionCode:{}.", (Object)((WorkflowTaskRelation)upstreamList.get(0)).getWorkflowDefinitionCode());
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(((WorkflowTaskRelation)upstreamList.get(0)).getWorkflowDefinitionCode()));
            return result;
        }
        List workflowTaskRelations = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinition.getCode());
        ArrayList workflowTaskRelationList = Lists.newArrayList((Iterable)workflowTaskRelations);
        ArrayList workflowTaskRelationWaitRemove = Lists.newArrayList();
        for (WorkflowTaskRelation workflowTaskRelation : workflowTaskRelationList) {
            if (currentUpstreamList.size() > 1) {
                if (!currentUpstreamList.contains(workflowTaskRelation.getPreTaskCode())) continue;
                currentUpstreamList.remove(workflowTaskRelation.getPreTaskCode());
                workflowTaskRelationWaitRemove.add(workflowTaskRelation);
                continue;
            }
            if (workflowTaskRelation.getPostTaskCode() != taskCode || !currentUpstreamList.isEmpty() && !tmpCurrent.isEmpty()) continue;
            workflowTaskRelation.setPreTaskVersion(0);
            workflowTaskRelation.setPreTaskCode(0L);
        }
        workflowTaskRelationList.removeAll(workflowTaskRelationWaitRemove);
        this.updateWorkflowDefiniteVersion(loginUser, result, workflowDefinition);
        this.updateRelation(loginUser, result, workflowDefinition, workflowTaskRelationList);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteDownstreamRelation(User loginUser, long projectCode, String postTaskCodes, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)postTaskCodes)) {
            log.warn("Parameter postTaskCodes is empty.");
            this.putMsg(result, Status.DATA_IS_NULL, "postTaskCodes");
            return result;
        }
        List downstreamList = this.workflowTaskRelationMapper.queryDownstreamByCode(projectCode, taskCode);
        if (CollectionUtils.isEmpty((Collection)downstreamList)) {
            log.error("Downstream tasks based on the task do not exist, theTaskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.DATA_IS_NULL, "taskCode");
            return result;
        }
        List postTaskCodeList = Lists.newArrayList((Object[])postTaskCodes.split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
        if (postTaskCodeList.contains(0L)) {
            log.warn("Parameter postTaskCodes contains 0.");
            this.putMsg(result, Status.DATA_IS_NULL, "postTaskCodes");
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(((WorkflowTaskRelation)downstreamList.get(0)).getWorkflowDefinitionCode());
        if (workflowDefinition == null) {
            log.error("workflow definition does not exist, workflowDefinitionCode:{}.", (Object)((WorkflowTaskRelation)downstreamList.get(0)).getWorkflowDefinitionCode());
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(((WorkflowTaskRelation)downstreamList.get(0)).getWorkflowDefinitionCode()));
            return result;
        }
        List workflowTaskRelations = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinition.getCode());
        ArrayList workflowTaskRelationList = Lists.newArrayList((Iterable)workflowTaskRelations);
        workflowTaskRelationList.removeIf(workflowTaskRelation -> postTaskCodeList.contains(workflowTaskRelation.getPostTaskCode()) && workflowTaskRelation.getPreTaskCode() == taskCode);
        this.updateWorkflowDefiniteVersion(loginUser, result, workflowDefinition);
        this.updateRelation(loginUser, result, workflowDefinition, workflowTaskRelationList);
        return result;
    }

    @Override
    public Map<String, Object> queryUpstreamRelation(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List workflowTaskRelationList = this.workflowTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        List taskDefinitionLogList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)workflowTaskRelationList)) {
            Set taskDefinitions = workflowTaskRelationList.stream().map(workflowTaskRelation -> {
                TaskDefinition taskDefinition = this.buildTaskDefinition();
                taskDefinition.setProjectCode(workflowTaskRelation.getProjectCode());
                taskDefinition.setCode(workflowTaskRelation.getPreTaskCode());
                taskDefinition.setVersion(workflowTaskRelation.getPreTaskVersion());
                return taskDefinition;
            }).collect(Collectors.toSet());
            taskDefinitionLogList = this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitions);
        }
        result.put("data", taskDefinitionLogList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryDownstreamRelation(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List workflowTaskRelationList = this.workflowTaskRelationMapper.queryDownstreamByCode(projectCode, taskCode);
        List taskDefinitionLogList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)workflowTaskRelationList)) {
            Set taskDefinitions = workflowTaskRelationList.stream().map(workflowTaskRelation -> {
                TaskDefinition taskDefinition = this.buildTaskDefinition();
                taskDefinition.setProjectCode(workflowTaskRelation.getProjectCode());
                taskDefinition.setCode(workflowTaskRelation.getPostTaskCode());
                taskDefinition.setVersion(workflowTaskRelation.getPostTaskVersion());
                return taskDefinition;
            }).collect(Collectors.toSet());
            taskDefinitionLogList = this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitions);
        }
        result.put("data", taskDefinitionLogList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteEdge(User loginUser, long projectCode, long workflowDefinitionCode, long preTaskCode, long postTaskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode);
        if (workflowDefinition == null) {
            log.error("workflow definition does not exist, projectCode\uff1a{}\uff0c workflowDefinitionCode:{}.", (Object)projectCode, (Object)workflowDefinitionCode);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(workflowDefinitionCode));
            return result;
        }
        List workflowTaskRelations = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode);
        ArrayList workflowTaskRelationList = Lists.newArrayList((Iterable)workflowTaskRelations);
        if (CollectionUtils.isEmpty((Collection)workflowTaskRelationList)) {
            log.error("workflow task relations are empty, projectCode:{}, workflowDefinitionCode:{}.", (Object)projectCode, (Object)workflowDefinitionCode);
            this.putMsg(result, Status.DATA_IS_NULL, "workflowTaskRelationList");
            return result;
        }
        HashMap<Long, List> taskRelationMap = new HashMap<Long, List>();
        for (WorkflowTaskRelation workflowTaskRelation : workflowTaskRelationList) {
            taskRelationMap.compute(workflowTaskRelation.getPostTaskCode(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<WorkflowTaskRelation>();
                }
                v.add(workflowTaskRelation);
                return v;
            });
        }
        if (!taskRelationMap.containsKey(postTaskCode)) {
            this.putMsg(result, Status.DATA_IS_NULL, "postTaskCode");
            return result;
        }
        if (((List)taskRelationMap.get(postTaskCode)).size() > 1) {
            for (WorkflowTaskRelation workflowTaskRelation : (List)taskRelationMap.get(postTaskCode)) {
                if (workflowTaskRelation.getPreTaskCode() != preTaskCode) continue;
                int delete = this.workflowTaskRelationMapper.deleteById((Serializable)workflowTaskRelation.getId());
                if (delete == 0) {
                    log.error("Delete task relation edge error, workflowTaskRelationId:{}, preTaskCode:{}, postTaskCode:{}", new Object[]{workflowTaskRelation.getId(), preTaskCode, postTaskCode});
                    this.putMsg(result, Status.DELETE_EDGE_ERROR, new Object[0]);
                    throw new ServiceException(Status.DELETE_EDGE_ERROR);
                }
                log.info("Delete task relation edge complete, workflowTaskRelationId:{}, preTaskCode:{}, postTaskCode:{}", new Object[]{workflowTaskRelation.getId(), preTaskCode, postTaskCode});
                workflowTaskRelationList.remove(workflowTaskRelation);
            }
        } else {
            WorkflowTaskRelation workflowTaskRelation = (WorkflowTaskRelation)((List)taskRelationMap.get(postTaskCode)).get(0);
            workflowTaskRelationList.remove(workflowTaskRelation);
            workflowTaskRelation.setPreTaskVersion(0);
            workflowTaskRelation.setPreTaskCode(0L);
            workflowTaskRelationList.add(workflowTaskRelation);
            log.info("Delete task relation through set invalid value for it: preTaskCode from {} to 0, workflowTaskRelationId:{}.", (Object)preTaskCode, (Object)workflowTaskRelation.getId());
        }
        this.updateWorkflowDefiniteVersion(loginUser, result, workflowDefinition);
        this.updateRelation(loginUser, result, workflowDefinition, workflowTaskRelationList);
        return result;
    }

    @Override
    public List<WorkflowTaskRelation> queryByWorkflowDefinitionCode(long workflowDefinitionCode, int workflowDefinitionVersion) {
        return this.workflowTaskRelationMapper.queryWorkflowTaskRelationsByWorkflowDefinitionCode(workflowDefinitionCode, Integer.valueOf(workflowDefinitionVersion));
    }

    @Override
    public void deleteByWorkflowDefinitionCode(long workflowDefinitionCode, int workflowDefinitionVersion) {
        this.workflowTaskRelationMapper.deleteByWorkflowDefinitionCodeAndVersion(workflowDefinitionCode, workflowDefinitionVersion);
    }

    private TaskDefinition buildTaskDefinition() {
        return new TaskDefinition(){

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof TaskDefinition)) {
                    return false;
                }
                TaskDefinition that = (TaskDefinition)o;
                return this.getCode() == that.getCode() && this.getVersion() == that.getVersion() && this.getProjectCode() == that.getProjectCode();
            }

            public int hashCode() {
                return Objects.hash(this.getCode(), this.getVersion(), this.getProjectCode());
            }
        };
    }
}

