/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import org.apache.dolphinscheduler.api.dto.resources.DownloadFileDto;
import org.apache.dolphinscheduler.api.validator.resource.AbstractResourceValidator;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.stereotype.Component;

@Component
public class DownloadFileDtoValidator
extends AbstractResourceValidator<DownloadFileDto> {
    public DownloadFileDtoValidator(StorageOperator storageOperator, TenantDao tenantDao) {
        super(storageOperator, tenantDao);
    }

    @Override
    public void validate(DownloadFileDto downloadFileDto) {
        String fileAbsolutePath = downloadFileDto.getFileAbsolutePath();
        User loginUser = downloadFileDto.getLoginUser();
        this.exceptionResourceNotExists(fileAbsolutePath);
        this.exceptionResourceAbsolutePathInvalidated(fileAbsolutePath);
        this.exceptionResourceIsNotFile(fileAbsolutePath);
        this.exceptionUserNoResourcePermission(loginUser, fileAbsolutePath);
    }
}

