/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MAPREDUCE"})
public final class RackResolver {
    private static DNSToSwitchMapping dnsToSwitchMapping;
    private static boolean initCalled;
    private static final Logger LOG;

    private RackResolver() {
    }

    public static synchronized void init(Configuration conf) {
        if (initCalled) {
            return;
        }
        initCalled = true;
        Class dnsToSwitchMappingClass = conf.getClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class);
        try {
            DNSToSwitchMapping newInstance = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)dnsToSwitchMappingClass, (Configuration)conf);
            dnsToSwitchMapping = newInstance instanceof CachedDNSToSwitchMapping ? newInstance : new CachedDNSToSwitchMapping(newInstance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Node resolve(Configuration conf, String hostName) {
        RackResolver.init(conf);
        return RackResolver.coreResolve(hostName);
    }

    public static List<Node> resolve(Configuration conf, List<String> hostNames) {
        RackResolver.init(conf);
        return RackResolver.coreResolve(hostNames);
    }

    public static Node resolve(String hostName) {
        if (!initCalled) {
            throw new IllegalStateException("RackResolver class not yet initialized");
        }
        return RackResolver.coreResolve(hostName);
    }

    public static List<Node> resolve(List<String> hostNames) {
        if (!initCalled) {
            throw new IllegalStateException("RackResolver class not yet initialized");
        }
        return RackResolver.coreResolve(hostNames);
    }

    private static Node coreResolve(String hostName) {
        List<String> tmpList = Collections.singletonList(hostName);
        return RackResolver.coreResolve(tmpList).get(0);
    }

    private static List<Node> coreResolve(List<String> hostNames) {
        ArrayList<Node> nodes = new ArrayList<Node>(hostNames.size());
        List rNameList = dnsToSwitchMapping.resolve(hostNames);
        if (rNameList == null || rNameList.isEmpty()) {
            for (String hostName : hostNames) {
                nodes.add((Node)new NodeBase(hostName, "/default-rack"));
            }
            LOG.info("Got an error when resolve hostNames. Falling back to /default-rack for all.");
        } else {
            for (int i = 0; i < hostNames.size(); ++i) {
                if (Strings.isNullOrEmpty((String)((String)rNameList.get(i)))) {
                    nodes.add((Node)new NodeBase(hostNames.get(i), "/default-rack"));
                    LOG.debug("Could not resolve {}. Falling back to {}", (Object)hostNames.get(i), (Object)"/default-rack");
                    continue;
                }
                nodes.add((Node)new NodeBase(hostNames.get(i), (String)rNameList.get(i)));
                LOG.debug("Resolved {} to {}", (Object)hostNames.get(i), rNameList.get(i));
            }
        }
        return nodes;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static DNSToSwitchMapping getDnsToSwitchMapping() {
        return dnsToSwitchMapping;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static void reset() {
        initCalled = false;
        dnsToSwitchMapping = null;
    }

    static {
        initCalled = false;
        LOG = LoggerFactory.getLogger(RackResolver.class);
    }
}

