/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.fluent.models.ManagedClusterUpgradeProfileProperties;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPoolUpgradeProfile;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ManagedClusterUpgradeProfileInner {
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="name", access=JsonProperty.Access.WRITE_ONLY)
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="properties", required=true)
    private ManagedClusterUpgradeProfileProperties innerProperties = new ManagedClusterUpgradeProfileProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterUpgradeProfileInner.class);

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    private ManagedClusterUpgradeProfileProperties innerProperties() {
        return this.innerProperties;
    }

    public ManagedClusterPoolUpgradeProfile controlPlaneProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().controlPlaneProfile();
    }

    public ManagedClusterUpgradeProfileInner withControlPlaneProfile(ManagedClusterPoolUpgradeProfile controlPlaneProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterUpgradeProfileProperties();
        }
        this.innerProperties().withControlPlaneProfile(controlPlaneProfile);
        return this;
    }

    public List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().agentPoolProfiles();
    }

    public ManagedClusterUpgradeProfileInner withAgentPoolProfiles(List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterUpgradeProfileProperties();
        }
        this.innerProperties().withAgentPoolProfiles(agentPoolProfiles);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ManagedClusterUpgradeProfileInner"));
        }
        this.innerProperties().validate();
    }
}

