/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.security.impl.ldap;

import java.util.Objects;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.LdapLoginResult;
import org.apache.dolphinscheduler.api.security.LdapUserNotExistActionType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class LdapService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LdapService.class);
    @Value(value="${security.authentication.ldap.user.admin-username:#{null}}")
    private String ldapAdminUserName;
    @Value(value="${security.authentication.ldap.user.admin-user-filter:#{null}}")
    private String ldapAdminUserFilter;
    @Value(value="${security.authentication.ldap.url:#{null}}")
    private String ldapUrl;
    @Value(value="${security.authentication.ldap.base-dn:#{null}}")
    private String ldapBaseDn;
    @Value(value="${security.authentication.ldap.username:#{null}}")
    private String ldapSecurityPrincipal;
    @Value(value="${security.authentication.ldap.password:#{null}}")
    private String ldapPrincipalPassword;
    @Value(value="${security.authentication.ldap.user.identity-attribute:#{null}}")
    private String ldapUserIdentifyingAttribute;
    @Value(value="${security.authentication.ldap.user.email-attribute:#{null}}")
    private String ldapEmailAttribute;
    @Value(value="${security.authentication.ldap.user.not-exist-action:DENY}")
    private String ldapUserNotExistAction;
    @Value(value="${security.authentication.ldap.ssl.enable:false}")
    private Boolean sslEnable;
    @Value(value="${security.authentication.ldap.ssl.trust-store:#{null}}")
    private String trustStore;
    @Value(value="${security.authentication.ldap.ssl.trust-store-password:#{null}}")
    private String trustStorePassword;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapLoginResult ldapLogin(String userName, String userPwd) {
        Properties searchEnv = this.getManagerLdapEnv();
        InitialLdapContext ctx = null;
        LdapLoginResult ldapLoginResult = new LdapLoginResult();
        ldapLoginResult.setSuccess(false);
        if (StringUtils.isEmpty((CharSequence)this.ldapEmailAttribute)) {
            log.warn("ldap email attribute is empty, skipping ldap authentication");
            return ldapLoginResult;
        }
        try {
            ctx = new InitialLdapContext(searchEnv, null);
            SearchControls sc = new SearchControls();
            sc.setReturningAttributes(new String[]{this.ldapEmailAttribute});
            sc.setSearchScope(2);
            EqualsFilter userFilter = new EqualsFilter(this.ldapUserIdentifyingAttribute, userName);
            String userSearchEmail = this.ldapSearch(ctx, null, userPwd, userFilter.toString(), sc, searchEnv);
            if (StringUtils.isNotEmpty((CharSequence)this.ldapAdminUserFilter)) {
                String adminFilterSearchEmail = this.ldapSearch(ctx, userName, userPwd, this.ldapAdminUserFilter, sc, searchEnv);
                if (adminFilterSearchEmail != null) {
                    ldapLoginResult.setLdapEmail(adminFilterSearchEmail);
                    ldapLoginResult.setUserType(UserType.ADMIN_USER);
                    ldapLoginResult.setUserName(userName);
                    ldapLoginResult.setSuccess(true);
                    LdapLoginResult ldapLoginResult2 = ldapLoginResult;
                    return ldapLoginResult2;
                }
            } else {
                log.debug("ldap admin user filter is empty, skipping admin user filter search");
            }
            if (userSearchEmail != null) {
                if (Objects.equals(this.ldapAdminUserName, userName)) {
                    ldapLoginResult.setUserType(UserType.ADMIN_USER);
                } else {
                    ldapLoginResult.setUserType(UserType.GENERAL_USER);
                }
                ldapLoginResult.setLdapEmail(userSearchEmail);
                ldapLoginResult.setUserName(userName);
                ldapLoginResult.setSuccess(true);
                LdapLoginResult ldapLoginResult3 = ldapLoginResult;
                return ldapLoginResult3;
            }
            log.debug("user email attribute {} not found in ldap", (Object)this.ldapEmailAttribute);
        }
        catch (NamingException e) {
            log.error("ldap search error", (Throwable)e);
            LdapLoginResult ldapLoginResult4 = ldapLoginResult;
            return ldapLoginResult4;
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                log.error("ldap context close error", (Throwable)e);
            }
        }
        return ldapLoginResult;
    }

    Properties getManagerLdapEnv() {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.ldapSecurityPrincipal);
        env.put("java.naming.security.credentials", this.ldapPrincipalPassword);
        env.put("java.naming.provider.url", this.ldapUrl);
        if (this.sslEnable.booleanValue()) {
            env.put("java.naming.security.protocol", "ssl");
            System.setProperty("javax.net.ssl.trustStore", this.trustStore);
            if (StringUtils.isNotEmpty((CharSequence)this.trustStorePassword)) {
                System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
            }
        }
        return env;
    }

    private String ldapSearch(LdapContext ctx, String userName, String userPwd, String filter, SearchControls sc, Properties searchEnv) throws NamingException {
        NamingEnumeration<SearchResult> results = userName == null ? ctx.search(this.ldapBaseDn, filter, sc) : ctx.search(this.ldapBaseDn, filter, new Object[]{userName}, sc);
        if (results.hasMore()) {
            SearchResult result = results.next();
            NamingEnumeration<? extends Attribute> attrs = result.getAttributes().getAll();
            while (attrs.hasMore()) {
                searchEnv.put("java.naming.security.principal", result.getNameInNamespace());
                searchEnv.put("java.naming.security.credentials", userPwd);
                try {
                    new InitialDirContext(searchEnv);
                }
                catch (Exception e) {
                    log.warn("invalid ldap credentials or ldap search error", (Throwable)e);
                    return null;
                }
                Attribute attr = attrs.next();
                if (!attr.getID().equals(this.ldapEmailAttribute)) continue;
                return (String)attr.get();
            }
        }
        return null;
    }

    public LdapUserNotExistActionType getLdapUserNotExistAction() {
        if (StringUtils.isBlank((CharSequence)this.ldapUserNotExistAction)) {
            log.info("security.authentication.ldap.user.not.exist.action configuration is empty, the default value 'CREATE'");
            return LdapUserNotExistActionType.CREATE;
        }
        return LdapUserNotExistActionType.valueOf(this.ldapUserNotExistAction);
    }

    public boolean createIfUserNotExists() {
        return this.getLdapUserNotExistAction() == LdapUserNotExistActionType.CREATE;
    }
}

