/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import com.google.common.base.Preconditions;
import org.apache.dolphinscheduler.api.dto.resources.CreateFileDto;
import org.apache.dolphinscheduler.api.dto.resources.CreateFileRequest;
import org.apache.dolphinscheduler.api.validator.resource.AbstractResourceTransformer;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.stereotype.Component;

@Component
public class FileRequestTransformer
extends AbstractResourceTransformer<CreateFileRequest, CreateFileDto> {
    public FileRequestTransformer(TenantDao tenantDao, StorageOperator storageOperator) {
        super(tenantDao, storageOperator);
    }

    @Override
    public CreateFileDto transform(CreateFileRequest createFileRequest) {
        this.validateCreateFileRequest(createFileRequest);
        return this.doTransform(createFileRequest);
    }

    private void validateCreateFileRequest(CreateFileRequest createFileRequest) {
        Preconditions.checkNotNull((Object)createFileRequest.getLoginUser(), (Object)"loginUser is null");
        Preconditions.checkNotNull((Object)createFileRequest.getType(), (Object)"resource type is null");
        Preconditions.checkNotNull((Object)createFileRequest.getFileName(), (Object)"file name is null");
        Preconditions.checkNotNull((Object)createFileRequest.getParentAbsoluteDirectory(), (Object)"parent directory is null");
        Preconditions.checkNotNull((Object)createFileRequest.getFile(), (Object)"file is null");
    }

    private CreateFileDto doTransform(CreateFileRequest createFileRequest) {
        String fileAbsolutePath = this.getFileAbsolutePath(createFileRequest);
        return CreateFileDto.builder().loginUser(createFileRequest.getLoginUser()).file(createFileRequest.getFile()).fileAbsolutePath(fileAbsolutePath).build();
    }

    private String getFileAbsolutePath(CreateFileRequest createFileRequest) {
        String parentDirectoryAbsolutePath = this.getParentDirectoryAbsolutePath(createFileRequest.getLoginUser(), createFileRequest.getParentAbsoluteDirectory(), createFileRequest.getType());
        return FileUtils.concatFilePath((String[])new String[]{parentDirectoryAbsolutePath, createFileRequest.getFileName()});
    }
}

