/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsV2Request;
import com.aliyun.oss.model.ListObjectsV2Result;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.AbstractStorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.ResourceMetadata;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.storage.oss.OssClientFactory;
import org.apache.dolphinscheduler.plugin.storage.oss.OssConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssStorageOperator
extends AbstractStorageOperator
implements Closeable,
StorageOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OssStorageOperator.class);
    private String accessKeyId;
    private String accessKeySecret;
    private String region;
    private String bucketName;
    private String endPoint;
    private OssConnection ossConnection;
    private OSS ossClient;

    public OssStorageOperator(String resourceBaseAbsolutePath) {
        super(resourceBaseAbsolutePath);
        this.init();
    }

    private void init() {
        this.accessKeyId = this.readOssAccessKeyID();
        this.accessKeySecret = this.readOssAccessKeySecret();
        this.endPoint = this.readOssEndPoint();
        this.region = this.readOssRegion();
        this.bucketName = this.readOssBucketName();
        this.ossConnection = this.buildOssConnection();
        this.ossClient = this.buildOssClient();
        this.ensureBucketSuccessfullyCreated(this.bucketName);
    }

    public void init(OssConnection ossConnection) {
        this.accessKeyId = this.readOssAccessKeyID();
        this.accessKeySecret = this.readOssAccessKeySecret();
        this.endPoint = this.readOssEndPoint();
        this.region = this.readOssRegion();
        this.bucketName = this.readOssBucketName();
        this.ossConnection = ossConnection;
        this.ossClient = this.buildOssClient();
        this.ensureBucketSuccessfullyCreated(this.bucketName);
    }

    protected String readOssAccessKeyID() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.access.key.id");
    }

    protected String readOssAccessKeySecret() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.access.key.secret");
    }

    protected String readOssRegion() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.region");
    }

    protected String readOssBucketName() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.oss.bucket.name");
    }

    protected String readOssEndPoint() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.oss.endpoint");
    }

    protected OssConnection buildOssConnection() {
        return new OssConnection(this.accessKeyId, this.accessKeySecret, this.endPoint);
    }

    public String getStorageBaseDirectory() {
        if (this.resourceBaseAbsolutePath.startsWith("/")) {
            log.warn("{} -> {} should not start with / in Oss", (Object)"resource.storage.upload.base.path", (Object)this.resourceBaseAbsolutePath);
            return this.resourceBaseAbsolutePath.substring(1);
        }
        return this.resourceBaseAbsolutePath;
    }

    @Override
    public void close() throws IOException {
        this.ossClient.shutdown();
    }

    public void createStorageDir(String directory) {
        directory = this.transformAbsolutePathToOssKey(directory);
        if (this.ossClient.doesObjectExist(this.bucketName, directory)) {
            throw new FileAlreadyExistsException("directory: " + directory + " already exists");
        }
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, directory, (InputStream)emptyContent, metadata);
        this.ossClient.putObject(putObjectRequest);
    }

    public void download(String srcFilePath, String dstFilePath, boolean overwrite) {
        srcFilePath = this.transformAbsolutePathToOssKey(srcFilePath);
        File dstFile = new File(dstFilePath);
        if (dstFile.isDirectory()) {
            Files.delete(dstFile.toPath());
        } else {
            FileUtils.createDirectoryWithPermission((Path)dstFile.getParentFile().toPath(), (Set)FileUtils.PERMISSION_755);
        }
        OSSObject ossObject = this.ossClient.getObject(this.bucketName, srcFilePath);
        try (InputStream ossInputStream = ossObject.getObjectContent();
             FileOutputStream fos = new FileOutputStream(dstFilePath);){
            int readLen;
            byte[] readBuf = new byte[1024];
            while ((readLen = ossInputStream.read(readBuf)) > 0) {
                fos.write(readBuf, 0, readLen);
            }
        }
        catch (OSSException e) {
            throw new IOException(e);
        }
        catch (FileNotFoundException e) {
            log.error("cannot find the destination file {}", (Object)dstFilePath);
            throw e;
        }
    }

    public boolean exists(String fileName) {
        fileName = this.transformAbsolutePathToOssKey(fileName);
        return this.ossClient.doesObjectExist(this.bucketName, fileName);
    }

    public void delete(String filePath, boolean recursive) {
        filePath = this.transformAbsolutePathToOssKey(filePath);
        this.ossClient.deleteObject(this.bucketName, filePath);
    }

    public void copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) {
        srcPath = this.transformAbsolutePathToOssKey(srcPath);
        dstPath = this.transformAbsolutePathToOssKey(dstPath);
        this.ossClient.copyObject(this.bucketName, srcPath, this.bucketName, dstPath);
        if (deleteSource) {
            this.ossClient.deleteObject(this.bucketName, srcPath);
        }
    }

    public void upload(String srcFile, String dstPath, boolean deleteSource, boolean overwrite) {
        dstPath = this.transformAbsolutePathToOssKey(dstPath);
        if (this.ossClient.doesObjectExist(this.bucketName, dstPath)) {
            if (!overwrite) {
                throw new FileAlreadyExistsException("file: " + dstPath + " already exists");
            }
            this.ossClient.deleteObject(this.bucketName, dstPath);
        }
        this.ossClient.putObject(this.bucketName, dstPath, new File(srcFile));
        if (deleteSource) {
            Files.delete(Paths.get(srcFile, new String[0]));
        }
    }

    /*
     * Exception decompiling
     */
    public List<String> fetchFileContent(String filePath, int skipLineNums, int limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<StorageEntity> listStorageEntity(String resourceAbsolutePath) {
        String ossResourceAbsolutePath = this.transformAbsolutePathToOssKey(resourceAbsolutePath);
        ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request().withBucketName(this.bucketName).withDelimiter("/").withPrefix(ossResourceAbsolutePath);
        ListObjectsV2Result listObjectsV2Result = this.ossClient.listObjectsV2(listObjectsV2Request);
        HashSet commonPrefixSet = new HashSet(listObjectsV2Result.getCommonPrefixes());
        ArrayList<StorageEntity> storageEntities = new ArrayList<StorageEntity>();
        storageEntities.addAll(listObjectsV2Result.getCommonPrefixes().stream().map(this::transformCommonPrefixToStorageEntity).collect(Collectors.toList()));
        storageEntities.addAll(listObjectsV2Result.getObjectSummaries().stream().filter(ossObjectSummary -> !ossObjectSummary.getKey().equals(ossResourceAbsolutePath)).filter(ossObjectSummary -> !commonPrefixSet.contains(ossObjectSummary.getKey())).map(this::transformOSSObjectToStorageEntity).collect(Collectors.toList()));
        return storageEntities;
    }

    public List<StorageEntity> listFileStorageEntityRecursively(String resourceAbsolutePath) {
        resourceAbsolutePath = this.transformOssKeyToAbsolutePath(resourceAbsolutePath);
        HashSet<String> visited = new HashSet<String>();
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        LinkedList<String> foldersToFetch = new LinkedList<String>();
        foldersToFetch.addLast(resourceAbsolutePath);
        while (!foldersToFetch.isEmpty()) {
            String pathToExplore = (String)foldersToFetch.pop();
            visited.add(pathToExplore);
            List<StorageEntity> tempList = this.listStorageEntity(pathToExplore);
            for (StorageEntity temp : tempList) {
                if (!temp.isDirectory() || visited.contains(temp.getFullName())) continue;
                foldersToFetch.add(temp.getFullName());
            }
            storageEntityList.addAll(tempList);
        }
        return storageEntityList;
    }

    public StorageEntity getStorageEntity(String resourceAbsolutePath) {
        resourceAbsolutePath = this.transformAbsolutePathToOssKey(resourceAbsolutePath);
        OSSObject object = this.ossClient.getObject(new GetObjectRequest(this.bucketName, resourceAbsolutePath));
        return this.transformOSSObjectToStorageEntity(object);
    }

    public void ensureBucketSuccessfullyCreated(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("resource.alibaba.cloud.oss.bucket.name is empty");
        }
        boolean existsBucket = this.ossClient.doesBucketExist(bucketName);
        if (!existsBucket) {
            throw new IllegalArgumentException("bucketName: " + bucketName + " is not exists, you need to create them by yourself");
        }
        log.info("bucketName: {} has been found, the current regionName is {}", (Object)bucketName, (Object)this.region);
    }

    protected OSS buildOssClient() {
        return OssClientFactory.buildOssClient(this.ossConnection);
    }

    protected StorageEntity transformOSSObjectToStorageEntity(OSSObject ossObject) {
        ResourceMetadata resourceMetaData = this.getResourceMetaData(ossObject.getKey());
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setFileName(new File(ossObject.getKey()).getName());
        storageEntity.setFullName(ossObject.getKey());
        storageEntity.setPfullName(resourceMetaData.getResourceParentAbsolutePath());
        storageEntity.setType(resourceMetaData.getResourceType());
        storageEntity.setDirectory(resourceMetaData.isDirectory());
        storageEntity.setSize(ossObject.getObjectMetadata().getContentLength());
        storageEntity.setRelativePath(resourceMetaData.getResourceRelativePath());
        storageEntity.setCreateTime(ossObject.getObjectMetadata().getLastModified());
        storageEntity.setUpdateTime(ossObject.getObjectMetadata().getLastModified());
        return storageEntity;
    }

    private StorageEntity transformOSSObjectToStorageEntity(OSSObjectSummary ossObjectSummary) {
        String absolutePath = this.transformOssKeyToAbsolutePath(ossObjectSummary.getKey());
        ResourceMetadata resourceMetaData = this.getResourceMetaData(absolutePath);
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setFileName(new File(absolutePath).getName());
        storageEntity.setFullName(absolutePath);
        storageEntity.setPfullName(resourceMetaData.getResourceParentAbsolutePath());
        storageEntity.setType(resourceMetaData.getResourceType());
        storageEntity.setDirectory(resourceMetaData.isDirectory());
        storageEntity.setSize(ossObjectSummary.getSize());
        storageEntity.setCreateTime(ossObjectSummary.getLastModified());
        storageEntity.setUpdateTime(ossObjectSummary.getLastModified());
        return storageEntity;
    }

    private StorageEntity transformCommonPrefixToStorageEntity(String commonPrefix) {
        String absolutePath = this.transformOssKeyToAbsolutePath(commonPrefix);
        ResourceMetadata resourceMetaData = this.getResourceMetaData(absolutePath);
        StorageEntity entity = new StorageEntity();
        entity.setFileName(new File(absolutePath).getName());
        entity.setFullName(absolutePath);
        entity.setPfullName(resourceMetaData.getResourceParentAbsolutePath());
        entity.setDirectory(resourceMetaData.isDirectory());
        entity.setType(resourceMetaData.getResourceType());
        entity.setSize(0L);
        entity.setCreateTime(null);
        entity.setUpdateTime(null);
        entity.setRelativePath(resourceMetaData.getResourceRelativePath());
        return entity;
    }

    private String transformAbsolutePathToOssKey(String absolutePath) {
        ResourceMetadata resourceMetaData = this.getResourceMetaData(absolutePath);
        if (resourceMetaData.isDirectory()) {
            return FileUtils.concatFilePath((String[])new String[]{absolutePath, "/"});
        }
        return absolutePath;
    }

    private String transformOssKeyToAbsolutePath(String s3Key) {
        if (s3Key.endsWith("/")) {
            return s3Key.substring(0, s3Key.length() - 1);
        }
        return s3Key;
    }
}

