/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.HDInsightMapReduceActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="HDInsightMapReduce")
public final class HDInsightMapReduceActivity
extends ExecutionActivity {
    @JsonProperty(value="typeProperties", required=true)
    private HDInsightMapReduceActivityTypeProperties innerTypeProperties = new HDInsightMapReduceActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightMapReduceActivity.class);

    private HDInsightMapReduceActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public HDInsightMapReduceActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public HDInsightMapReduceActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public HDInsightMapReduceActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public HDInsightMapReduceActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public HDInsightMapReduceActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public HDInsightMapReduceActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public List<LinkedServiceReference> storageLinkedServices() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().storageLinkedServices();
    }

    public HDInsightMapReduceActivity withStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightMapReduceActivityTypeProperties();
        }
        this.innerTypeProperties().withStorageLinkedServices(storageLinkedServices);
        return this;
    }

    public List<Object> arguments() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().arguments();
    }

    public HDInsightMapReduceActivity withArguments(List<Object> arguments) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightMapReduceActivityTypeProperties();
        }
        this.innerTypeProperties().withArguments(arguments);
        return this;
    }

    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().getDebugInfo();
    }

    public HDInsightMapReduceActivity withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightMapReduceActivityTypeProperties();
        }
        this.innerTypeProperties().withGetDebugInfo(getDebugInfo);
        return this;
    }

    public Object className() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().className();
    }

    public HDInsightMapReduceActivity withClassName(Object className) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightMapReduceActivityTypeProperties();
        }
        this.innerTypeProperties().withClassName(className);
        return this;
    }

    public Object jarFilePath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().jarFilePath();
    }

    public HDInsightMapReduceActivity withJarFilePath(Object jarFilePath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightMapReduceActivityTypeProperties();
        }
        this.innerTypeProperties().withJarFilePath(jarFilePath);
        return this;
    }

    public LinkedServiceReference jarLinkedService() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().jarLinkedService();
    }

    public HDInsightMapReduceActivity withJarLinkedService(LinkedServiceReference jarLinkedService) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightMapReduceActivityTypeProperties();
        }
        this.innerTypeProperties().withJarLinkedService(jarLinkedService);
        return this;
    }

    public List<Object> jarLibs() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().jarLibs();
    }

    public HDInsightMapReduceActivity withJarLibs(List<Object> jarLibs) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightMapReduceActivityTypeProperties();
        }
        this.innerTypeProperties().withJarLibs(jarLibs);
        return this;
    }

    public Map<String, Object> defines() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().defines();
    }

    public HDInsightMapReduceActivity withDefines(Map<String, Object> defines) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightMapReduceActivityTypeProperties();
        }
        this.innerTypeProperties().withDefines(defines);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model HDInsightMapReduceActivity"));
        }
        this.innerTypeProperties().validate();
    }
}

