/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.CustomImage;

@SdkInternalApi
public class CustomImageMarshaller {
    private static final MarshallingInfo<String> IMAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageName").build();
    private static final MarshallingInfo<Integer> IMAGEVERSIONNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageVersionNumber").build();
    private static final MarshallingInfo<String> APPIMAGECONFIGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppImageConfigName").build();
    private static final CustomImageMarshaller instance = new CustomImageMarshaller();

    public static CustomImageMarshaller getInstance() {
        return instance;
    }

    public void marshall(CustomImage customImage, ProtocolMarshaller protocolMarshaller) {
        if (customImage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)customImage.getImageName(), IMAGENAME_BINDING);
            protocolMarshaller.marshall((Object)customImage.getImageVersionNumber(), IMAGEVERSIONNUMBER_BINDING);
            protocolMarshaller.marshall((Object)customImage.getAppImageConfigName(), APPIMAGECONFIGNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

