/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin.switchtask;

import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.engine.IWorkflowRepository;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.ILogicTaskPluginFactory;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.switchtask.SwitchLogicTask;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.exception.LogicTaskInitializeException;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SwitchLogicTaskPluginFactory
implements ILogicTaskPluginFactory<SwitchLogicTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchLogicTaskPluginFactory.class);
    @Autowired
    private IWorkflowRepository IWorkflowRepository;

    @Override
    public SwitchLogicTask createLogicTask(ITaskExecutor taskExecutor) throws LogicTaskInitializeException {
        TaskExecutionContext taskExecutionContext = taskExecutor.getTaskExecutionContext();
        int workflowInstanceId = taskExecutionContext.getWorkflowInstanceId();
        IWorkflowExecutionRunnable workflowExecutionRunnable = this.IWorkflowRepository.get(workflowInstanceId);
        if (workflowExecutionRunnable == null) {
            throw new LogicTaskInitializeException("Cannot find the WorkflowExecuteRunnable by : " + workflowInstanceId);
        }
        return new SwitchLogicTask(workflowExecutionRunnable, taskExecutionContext);
    }

    @Override
    public String getTaskType() {
        return "SWITCH";
    }
}

