/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.serial;

import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.model.SerialCommandDto;
import org.apache.dolphinscheduler.server.master.engine.workflow.serial.AbstractSerialCommandHandler;
import org.apache.dolphinscheduler.server.master.engine.workflow.serial.SerialCommandsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SerialCommandPriorityHandler
extends AbstractSerialCommandHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SerialCommandPriorityHandler.class);

    @Override
    public void handle(SerialCommandsGroup serialCommandsGroup) {
        List<SerialCommandDto> serialCommands = serialCommandsGroup.getSerialCommands();
        for (int i = 0; i < serialCommands.size(); ++i) {
            SerialCommandDto serialCommand = serialCommands.get(i);
            if (i == serialCommands.size() - 1) {
                if (serialCommand.getState() != SerialCommandDto.State.WAITING) continue;
                this.launchSerialCommand(serialCommand);
                log.info("Launched SerialCommand: {}", (Object)serialCommand);
                continue;
            }
            if (serialCommand.getState() == SerialCommandDto.State.WAITING) {
                this.discardSerialCommandAndStopWorkflowInstanceInDB(serialCommand);
                log.info("Discard SerialCommand: {}", (Object)serialCommand);
                continue;
            }
            this.stopWorkflowInstanceInMaster(serialCommand);
            log.info("Stop the pre WorkflowInstance: {} due to the workflow using SERIAL_PRIORITY strategy", (Object)serialCommand.getWorkflowInstanceId());
        }
    }
}

