/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.serial;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.model.SerialCommandDto;
import org.apache.dolphinscheduler.dao.repository.SerialCommandDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionLogDao;
import org.apache.dolphinscheduler.server.master.engine.IWorkflowSerialCoordinator;
import org.apache.dolphinscheduler.server.master.engine.workflow.serial.SerialCommandDiscardHandler;
import org.apache.dolphinscheduler.server.master.engine.workflow.serial.SerialCommandPriorityHandler;
import org.apache.dolphinscheduler.server.master.engine.workflow.serial.SerialCommandWaitHandler;
import org.apache.dolphinscheduler.server.master.engine.workflow.serial.SerialCommandsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowSerialCoordinator
implements IWorkflowSerialCoordinator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowSerialCoordinator.class);
    @Autowired
    private SerialCommandDao serialCommandDao;
    @Autowired
    private WorkflowDefinitionLogDao workflowDefinitionLogDao;
    @Autowired
    private SerialCommandWaitHandler serialCommandWaitHandler;
    @Autowired
    private SerialCommandDiscardHandler serialCommandDiscardHandler;
    @Autowired
    private SerialCommandPriorityHandler serialCommandPriorityHandler;
    private volatile boolean flag = false;
    private Thread internalThread;
    private static final int DEFAULT_FETCH_SIZE = 1000;
    private static final int DEFAULT_FETCH_INTERVAL_SECONDS = 5;

    @Override
    public synchronized void start() {
        log.info("WorkflowSerialCoordinator starting...");
        if (this.flag) {
            throw new IllegalStateException("WorkflowSerialCoordinator is already started");
        }
        if (this.internalThread != null) {
            throw new IllegalStateException("InternalThread is already started");
        }
        this.flag = true;
        this.internalThread = new BaseDaemonThread(this::doStart){};
        this.internalThread.setName("WorkflowSerialCoordinator-Thread");
        this.internalThread.start();
        log.info("WorkflowSerialCoordinator started...");
    }

    private void doStart() {
        while (this.flag) {
            try {
                StopWatch workflowSerialCoordinatorRoundCost = StopWatch.createStarted();
                List<SerialCommandsGroup> serialCommandsGroups = this.fetchSerialCommands();
                serialCommandsGroups.forEach(this::handleSerialCommand);
                log.debug("WorkflowSerialCoordinator handled SerialCommandsGroup size: {}, cost: {}/ms ", (Object)serialCommandsGroups.size(), (Object)workflowSerialCoordinatorRoundCost.getDuration().toMillis());
            }
            catch (Throwable e) {
                log.error("WorkflowSerialCoordinator error", e);
            }
            finally {
                ThreadUtils.sleep((long)TimeUnit.SECONDS.toMillis(5L));
            }
        }
    }

    private void handleSerialCommand(SerialCommandsGroup serialCommandsGroup) {
        try {
            if (serialCommandsGroup.getExecutionType() == null) {
                log.error("Cannot find the ExecutionType for workflow: {}-{}", (Object)serialCommandsGroup.getWorkflowDefinitionCode(), (Object)serialCommandsGroup.getWorkflowDefinitionVersion());
                return;
            }
            switch (serialCommandsGroup.getExecutionType()) {
                case PARALLEL: {
                    throw new IllegalStateException("SerialCommand with ExecutionType=PARALLEL is not supported, this shouldn't happen");
                }
                case SERIAL_WAIT: {
                    this.serialCommandWaitHandler.handle(serialCommandsGroup);
                    break;
                }
                case SERIAL_DISCARD: {
                    this.serialCommandDiscardHandler.handle(serialCommandsGroup);
                    break;
                }
                case SERIAL_PRIORITY: {
                    this.serialCommandPriorityHandler.handle(serialCommandsGroup);
                    break;
                }
            }
        }
        catch (Exception ex) {
            log.error("Handle SerialCommandsGroup: {} error", (Object)serialCommandsGroup, (Object)ex);
        }
    }

    private List<SerialCommandsGroup> fetchSerialCommands() {
        List serialCommands = this.serialCommandDao.fetchSerialCommands(1000);
        if (CollectionUtils.isEmpty((Collection)serialCommands)) {
            return Collections.emptyList();
        }
        HashMap<Long, Map> serialCommandsGroupMap = new HashMap<Long, Map>();
        for (SerialCommandDto serialCommand : serialCommands) {
            serialCommandsGroupMap.computeIfAbsent(serialCommand.getWorkflowDefinitionCode(), k -> new HashMap()).computeIfAbsent(serialCommand.getWorkflowDefinitionVersion(), v -> this.createSerialCommandsGroup(serialCommand)).getSerialCommands().add(serialCommand);
        }
        return serialCommandsGroupMap.values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toList());
    }

    private SerialCommandsGroup createSerialCommandsGroup(SerialCommandDto serialCommand) {
        Long workflowDefinitionCode = serialCommand.getWorkflowDefinitionCode();
        Integer workflowDefinitionVersion = serialCommand.getWorkflowDefinitionVersion();
        WorkflowDefinitionLog workflowDefinitionLog = this.workflowDefinitionLogDao.queryByDefinitionCodeAndVersion(workflowDefinitionCode.longValue(), workflowDefinitionVersion.intValue());
        return SerialCommandsGroup.builder().workflowDefinitionCode(workflowDefinitionCode).workflowDefinitionVersion(workflowDefinitionVersion).executionType(workflowDefinitionLog.getExecutionType()).serialCommands(new ArrayList<SerialCommandDto>()).build();
    }

    @Override
    public void close() {
        this.flag = false;
    }
}

