/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.master.ITaskExecutorEventListener;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.engine.IWorkflowRepository;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskDispatchedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskFailedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskKilledLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskPausedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskRunningLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskRuntimeContextChangedEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskSuccessLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.task.executor.events.IReportableTaskExecutorLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorDispatchedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorFailedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorKilledLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorPausedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorRuntimeContextChangedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorStartedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorSuccessLifecycleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskExecutorEventListenerImpl
implements ITaskExecutorEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutorEventListenerImpl.class);
    @Autowired
    private IWorkflowRepository workflowRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTaskExecutorDispatched(TaskExecutorDispatchedLifecycleEvent taskExecutorDispatchedLifecycleEvent) {
        LogUtils.setWorkflowInstanceIdMDC((Integer)taskExecutorDispatchedLifecycleEvent.getWorkflowInstanceId());
        try {
            ITaskExecutionRunnable taskExecutionRunnable = this.getTaskExecutionRunnable((IReportableTaskExecutorLifecycleEvent)taskExecutorDispatchedLifecycleEvent);
            TaskDispatchedLifecycleEvent taskDispatchedLifecycleEvent = TaskDispatchedLifecycleEvent.builder().taskExecutionRunnable(taskExecutionRunnable).executorHost(taskExecutorDispatchedLifecycleEvent.getTaskInstanceHost()).build();
            taskExecutionRunnable.getWorkflowEventBus().publish(taskDispatchedLifecycleEvent);
        }
        finally {
            LogUtils.removeWorkflowInstanceIdMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTaskExecutorRunning(TaskExecutorStartedLifecycleEvent taskExecutorStartedLifecycleEvent) {
        LogUtils.setWorkflowInstanceIdMDC((Integer)taskExecutorStartedLifecycleEvent.getWorkflowInstanceId());
        try {
            ITaskExecutionRunnable taskExecutionRunnable = this.getTaskExecutionRunnable((IReportableTaskExecutorLifecycleEvent)taskExecutorStartedLifecycleEvent);
            TaskRunningLifecycleEvent taskRunningEvent = TaskRunningLifecycleEvent.builder().taskExecutionRunnable(taskExecutionRunnable).startTime(new Date(taskExecutorStartedLifecycleEvent.getStartTime())).logPath(taskExecutorStartedLifecycleEvent.getLogPath()).build();
            taskExecutionRunnable.getWorkflowEventBus().publish(taskRunningEvent);
        }
        finally {
            LogUtils.removeWorkflowInstanceIdMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTaskExecutorRuntimeContextChanged(TaskExecutorRuntimeContextChangedLifecycleEvent taskExecutorRuntimeContextChangedLifecycleEventr) {
        LogUtils.setWorkflowInstanceIdMDC((Integer)taskExecutorRuntimeContextChangedLifecycleEventr.getWorkflowInstanceId());
        try {
            ITaskExecutionRunnable taskExecutionRunnable = this.getTaskExecutionRunnable((IReportableTaskExecutorLifecycleEvent)taskExecutorRuntimeContextChangedLifecycleEventr);
            TaskRuntimeContextChangedEvent taskRuntimeContextChangedEvent = TaskRuntimeContextChangedEvent.builder().taskExecutionRunnable(taskExecutionRunnable).runtimeContext(taskExecutorRuntimeContextChangedLifecycleEventr.getAppIds()).build();
            taskExecutionRunnable.getWorkflowEventBus().publish(taskRuntimeContextChangedEvent);
        }
        finally {
            LogUtils.removeWorkflowInstanceIdMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTaskExecutorSuccess(TaskExecutorSuccessLifecycleEvent taskExecutorSuccessLifecycleEvent) {
        LogUtils.setWorkflowInstanceIdMDC((Integer)taskExecutorSuccessLifecycleEvent.getWorkflowInstanceId());
        try {
            ITaskExecutionRunnable taskExecutionRunnable = this.getTaskExecutionRunnable((IReportableTaskExecutorLifecycleEvent)taskExecutorSuccessLifecycleEvent);
            TaskSuccessLifecycleEvent taskSuccessEvent = TaskSuccessLifecycleEvent.builder().taskExecutionRunnable(taskExecutionRunnable).endTime(new Date(taskExecutorSuccessLifecycleEvent.getEndTime())).varPool(taskExecutorSuccessLifecycleEvent.getVarPool()).build();
            taskExecutionRunnable.getWorkflowEventBus().publish(taskSuccessEvent);
        }
        finally {
            LogUtils.removeWorkflowInstanceIdMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTaskExecutorFailed(TaskExecutorFailedLifecycleEvent taskExecutorFailedLifecycleEvent) {
        LogUtils.setWorkflowInstanceIdMDC((Integer)taskExecutorFailedLifecycleEvent.getWorkflowInstanceId());
        try {
            ITaskExecutionRunnable taskExecutionRunnable = this.getTaskExecutionRunnable((IReportableTaskExecutorLifecycleEvent)taskExecutorFailedLifecycleEvent);
            TaskFailedLifecycleEvent taskFailedEvent = TaskFailedLifecycleEvent.builder().taskExecutionRunnable(taskExecutionRunnable).endTime(new Date(taskExecutorFailedLifecycleEvent.getEndTime())).build();
            taskExecutionRunnable.getWorkflowEventBus().publish(taskFailedEvent);
        }
        finally {
            LogUtils.removeWorkflowInstanceIdMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTaskExecutorKilled(TaskExecutorKilledLifecycleEvent taskExecutorKilledLifecycleEvent) {
        LogUtils.setWorkflowInstanceIdMDC((Integer)taskExecutorKilledLifecycleEvent.getWorkflowInstanceId());
        try {
            ITaskExecutionRunnable taskExecutionRunnable = this.getTaskExecutionRunnable((IReportableTaskExecutorLifecycleEvent)taskExecutorKilledLifecycleEvent);
            TaskKilledLifecycleEvent taskKilledEvent = TaskKilledLifecycleEvent.builder().taskExecutionRunnable(taskExecutionRunnable).endTime(new Date(taskExecutorKilledLifecycleEvent.getEndTime())).build();
            taskExecutionRunnable.getWorkflowEventBus().publish(taskKilledEvent);
        }
        finally {
            LogUtils.removeWorkflowInstanceIdMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTaskExecutorPaused(TaskExecutorPausedLifecycleEvent taskExecutorPausedLifecycleEvent) {
        LogUtils.setWorkflowInstanceIdMDC((Integer)taskExecutorPausedLifecycleEvent.getWorkflowInstanceId());
        try {
            ITaskExecutionRunnable taskExecutionRunnable = this.getTaskExecutionRunnable((IReportableTaskExecutorLifecycleEvent)taskExecutorPausedLifecycleEvent);
            TaskPausedLifecycleEvent taskPausedEvent = TaskPausedLifecycleEvent.of(taskExecutionRunnable);
            taskExecutionRunnable.getWorkflowEventBus().publish(taskPausedEvent);
        }
        finally {
            LogUtils.removeWorkflowInstanceIdMDC();
        }
    }

    private ITaskExecutionRunnable getTaskExecutionRunnable(IReportableTaskExecutorLifecycleEvent reportableTaskExecutorLifecycleEvent) {
        int workflowInstanceId = reportableTaskExecutorLifecycleEvent.getWorkflowInstanceId();
        int taskInstanceId = reportableTaskExecutorLifecycleEvent.getTaskInstanceId();
        IWorkflowExecutionRunnable workflowExecutionRunnable = this.workflowRepository.get(workflowInstanceId);
        if (workflowExecutionRunnable == null) {
            throw new IllegalArgumentException("Cannot find the WorkflowExecuteRunnable: " + workflowInstanceId);
        }
        ITaskExecutionRunnable taskExecutionRunnable = workflowExecutionRunnable.getWorkflowExecuteContext().getWorkflowExecutionGraph().getTaskExecutionRunnableById(taskInstanceId);
        if (taskExecutionRunnable == null) {
            throw new IllegalArgumentException("Cannot find the TaskExecuteRunnable: " + taskInstanceId);
        }
        return taskExecutionRunnable;
    }
}

