/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.implementation.GeoObjectHelper;
import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoCollection;
import com.azure.core.models.GeoLineString;
import com.azure.core.models.GeoLineStringCollection;
import com.azure.core.models.GeoObjectType;
import com.azure.core.models.GeoPoint;
import com.azure.core.models.GeoPointCollection;
import com.azure.core.models.GeoPolygon;
import com.azure.core.models.GeoPolygonCollection;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonSubTypes(value={@JsonSubTypes.Type(name="Point", value=GeoPoint.class), @JsonSubTypes.Type(name="LineString", value=GeoLineString.class), @JsonSubTypes.Type(name="Polygon", value=GeoPolygon.class), @JsonSubTypes.Type(name="MultiPoint", value=GeoPointCollection.class), @JsonSubTypes.Type(name="MultiLineString", value=GeoLineStringCollection.class), @JsonSubTypes.Type(name="MultiPolygon", value=GeoPolygonCollection.class), @JsonSubTypes.Type(name="GeometryCollection", value=GeoCollection.class)})
public abstract class GeoObject {
    private final GeoBoundingBox boundingBox;
    private final Map<String, Object> customProperties;

    protected GeoObject(GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        this.boundingBox = boundingBox;
        this.customProperties = customProperties == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(customProperties));
    }

    @JsonProperty(value="type")
    public abstract GeoObjectType getType();

    public final GeoBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public final Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public int hashCode() {
        return Objects.hash(this.boundingBox, this.customProperties);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoObject)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoObject other = (GeoObject)obj;
        return Objects.equals(this.boundingBox, other.boundingBox) && Objects.equals(this.customProperties, other.customProperties);
    }

    static {
        GeoObjectHelper.setAccessor(GeoObject::getCustomProperties);
    }
}

