/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.CdnCertificateSourceParameters;
import com.azure.resourcemanager.cdn.models.CustomDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.MinimumTlsVersion;
import com.azure.resourcemanager.cdn.models.ProtocolType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="certificateSource")
@JsonTypeName(value="Cdn")
public final class CdnManagedHttpsParameters
extends CustomDomainHttpsParameters {
    @JsonProperty(value="certificateSourceParameters", required=true)
    private CdnCertificateSourceParameters certificateSourceParameters;
    private static final ClientLogger LOGGER = new ClientLogger(CdnManagedHttpsParameters.class);

    public CdnCertificateSourceParameters certificateSourceParameters() {
        return this.certificateSourceParameters;
    }

    public CdnManagedHttpsParameters withCertificateSourceParameters(CdnCertificateSourceParameters certificateSourceParameters) {
        this.certificateSourceParameters = certificateSourceParameters;
        return this;
    }

    @Override
    public CdnManagedHttpsParameters withProtocolType(ProtocolType protocolType) {
        super.withProtocolType(protocolType);
        return this;
    }

    @Override
    public CdnManagedHttpsParameters withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.certificateSourceParameters() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property certificateSourceParameters in model CdnManagedHttpsParameters"));
        }
        this.certificateSourceParameters().validate();
    }
}

