/*
 * Decompiled with CFR 0.152.
 */
package grails.web.mapping;

import grails.web.http.HttpHeaders;
import grails.web.mapping.LinkGenerator;
import grails.web.mapping.mvc.RedirectEventListener;
import grails.web.mapping.mvc.exceptions.CannotRedirectException;
import grails.web.servlet.mvc.GrailsParameterMap;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.RequestDataValueProcessor;

public class ResponseRedirector
implements GroovyObject {
    public static final String ARGUMENT_PERMANENT = "permanent";
    public static final String ARGUMENT_ABSOLUTE = "absolute";
    public static final String ARGUMENT_MOVED = "moved";
    public static final String GRAILS_REDIRECT_ISSUED = "org.grails.REDIRECT_ISSUED";
    private static final String BLANK = "";
    private static final String KEEP_PARAMS_WHEN_REDIRECT = "keepParamsWhenRedirect";
    private LinkGenerator linkGenerator;
    private Collection<RedirectEventListener> redirectListeners;
    private RequestDataValueProcessor requestDataValueProcessor;
    private boolean useJessionId;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ResponseRedirector(LinkGenerator linkGenerator) {
        LinkGenerator linkGenerator2;
        MetaClass metaClass;
        boolean bl;
        List list;
        this.redirectListeners = list = ScriptBytecodeAdapter.createList(new Object[0]);
        this.useJessionId = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Assert.notNull((Object)linkGenerator, "Argument [linkGenerator] cannot be null");
        this.linkGenerator = linkGenerator2 = linkGenerator;
    }

    public void redirect(Map arguments) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        HttpServletRequest request = webRequest.getCurrentRequest();
        HttpServletResponse response = webRequest.getCurrentResponse();
        this.redirect(request, response, arguments);
    }

    private static boolean getBooleanArgument(String argumentName, Map arguments, Boolean defaultValue) {
        Object argument = arguments.get(argumentName);
        if (argument instanceof String) {
            return DefaultTypeTransformation.booleanUnbox(Boolean.valueOf((String)((Object)IndyInterface.bootstrap("cast", "()", 0, argument))));
        }
        if (argument == null && defaultValue != null) {
            return DefaultTypeTransformation.booleanUnbox(defaultValue);
        }
        return ScriptBytecodeAdapter.compareEqual(Boolean.TRUE, argument);
    }

    public void redirect(HttpServletRequest request, HttpServletResponse response, Map arguments) {
        Object object = request.getAttribute(GRAILS_REDIRECT_ISSUED);
        if ((object == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, object)) != false) {
            throw (Throwable)new CannotRedirectException("Cannot issue a redirect(..) here. A previous call to redirect(..) has already redirected the response.");
        }
        if (response.isCommitted()) {
            throw (Throwable)new CannotRedirectException("Cannot issue a redirect(..) here. The response has already been committed either by another redirect or by directly writing to the response.");
        }
        boolean permanent = ResponseRedirector.getBooleanArgument(ARGUMENT_PERMANENT, arguments);
        boolean moved = ResponseRedirector.getBooleanArgument(ARGUMENT_MOVED, arguments, true);
        boolean absolute = ResponseRedirector.getBooleanArgument(ARGUMENT_ABSOLUTE, arguments, true);
        LinkedHashMap<String, Object> namedParameters = new LinkedHashMap<String, Object>(arguments);
        if (absolute) {
            namedParameters.put(LinkGenerator.ATTRIBUTE_CONTEXT_PATH, BLANK);
        }
        Boolean bl = Boolean.valueOf(DefaultGroovyMethods.toString(arguments.get(KEEP_PARAMS_WHEN_REDIRECT)));
        if (bl == null ? false : bl) {
            GrailsWebRequest webRequest = GrailsWebRequest.lookup(request);
            GrailsParameterMap grailsParameterMap = webRequest.getOriginalParams();
            if ((grailsParameterMap == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, grailsParameterMap)) != false) {
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, arguments.get(LinkGenerator.ATTRIBUTE_PARAMS));
                CallSite configuredParams = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createMap(new Object[0]);
                namedParameters.put(LinkGenerator.ATTRIBUTE_PARAMS, DefaultGroovyMethods.plus(configuredParams, webRequest.getOriginalParams()));
            }
        }
        this.redirectResponse(this.linkGenerator.getServerBaseURL(), this.linkGenerator.link(namedParameters), request, response, permanent, moved, absolute);
    }

    private void redirectResponse(String serverBaseURL, String actualUri, HttpServletRequest request, HttpServletResponse response, boolean permanent, boolean moved, boolean absolute) {
        log.debug("Method [redirect] forwarding request to [{}]", (Object)actualUri);
        log.debug("Executing redirect with response [{}]", (Object)response);
        String processedActualUri = this.processedUrl(actualUri, request);
        String redirectURI = null;
        redirectURI = absolute ? (processedActualUri.contains("://") ? processedActualUri : StringGroovyMethods.plus(serverBaseURL, (CharSequence)processedActualUri)) : processedActualUri;
        String redirectUrl = this.useJessionId ? response.encodeRedirectURL(redirectURI) : redirectURI;
        int status = 0;
        status = permanent ? (moved ? HttpStatus.MOVED_PERMANENTLY.value() : HttpStatus.PERMANENT_REDIRECT.value()) : (moved ? HttpStatus.MOVED_TEMPORARILY.value() : HttpStatus.TEMPORARY_REDIRECT.value());
        int n = status;
        response.setStatus(n);
        response.setHeader(HttpHeaders.LOCATION, redirectUrl);
        Collection<RedirectEventListener> collection = this.redirectListeners;
        if ((collection == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, collection)) != false) {
            Collection<RedirectEventListener> collection2 = this.redirectListeners;
            Iterator<RedirectEventListener> iterator = collection2 != null ? collection2.iterator() : null;
            RedirectEventListener redirectEventListener = null;
            Iterator<RedirectEventListener> iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    redirectEventListener = iterator2.next();
                    redirectEventListener.responseRedirected(redirectUrl);
                }
            }
        }
        request.setAttribute(GRAILS_REDIRECT_ISSUED, (Object)processedActualUri);
    }

    private String processedUrl(String link, HttpServletRequest request) {
        RequestDataValueProcessor requestDataValueProcessor = this.requestDataValueProcessor;
        if ((requestDataValueProcessor == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, requestDataValueProcessor)) != false) {
            link = this.requestDataValueProcessor.processUrl(request, link);
        }
        return link;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ResponseRedirector.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public void redirect() {
        this.redirect((Map)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "emptyMap", 0, Collections.class))));
    }

    @Generated
    private static boolean getBooleanArgument(String argumentName, Map arguments) {
        return ResponseRedirector.getBooleanArgument(argumentName, arguments, null);
    }

    @Override
    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger("grails.web.mapping.ResponseRedirector");
    }

    @Generated
    public LinkGenerator getLinkGenerator() {
        return this.linkGenerator;
    }

    @Generated
    public void setLinkGenerator(LinkGenerator linkGenerator) {
        this.linkGenerator = linkGenerator;
    }

    @Generated
    public Collection<RedirectEventListener> getRedirectListeners() {
        return this.redirectListeners;
    }

    @Generated
    public void setRedirectListeners(Collection<RedirectEventListener> collection) {
        this.redirectListeners = collection;
    }

    @Generated
    public RequestDataValueProcessor getRequestDataValueProcessor() {
        return this.requestDataValueProcessor;
    }

    @Generated
    public void setRequestDataValueProcessor(RequestDataValueProcessor requestDataValueProcessor) {
        this.requestDataValueProcessor = requestDataValueProcessor;
    }

    @Generated
    public boolean getUseJessionId() {
        return this.useJessionId;
    }

    @Generated
    public boolean isUseJessionId() {
        return this.useJessionId;
    }

    @Generated
    public void setUseJessionId(boolean bl) {
        this.useJessionId = bl;
    }
}

