/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.bind.binders;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.RequestAttribute;
import io.micronaut.http.client.bind.AnnotatedClientRequestBinder;
import io.micronaut.http.client.bind.ClientRequestUriContext;
import java.util.List;

public class AttributeClientRequestBinder
implements AnnotatedClientRequestBinder<RequestAttribute> {
    @Override
    public void bind(@NonNull MethodInvocationContext<Object, Object> context, @NonNull ClientRequestUriContext uriContext, @NonNull MutableHttpRequest<?> request) {
        List<AnnotationValue<RequestAttribute>> attributeAnnotations = context.getAnnotationValuesByType(RequestAttribute.class);
        for (AnnotationValue<RequestAttribute> attributeAnnotation : attributeAnnotations) {
            String attributeName = attributeAnnotation.stringValue("name").orElse(null);
            Object attributeValue = attributeAnnotation.getValue(Object.class).orElse(null);
            if (!StringUtils.isNotEmpty(attributeName) || attributeValue == null) continue;
            request.setAttribute(attributeName, attributeValue);
        }
    }

    @Override
    @NonNull
    public Class<RequestAttribute> getAnnotationType() {
        return RequestAttribute.class;
    }
}

