/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.FragmentsRendering;

final class DefaultFragmentsRendering
implements FragmentsRendering {
    @Nullable
    private final HttpStatusCode status;
    private final HttpHeaders headers;
    private final Collection<ModelAndView> modelAndViews;

    DefaultFragmentsRendering(@Nullable HttpStatusCode status, HttpHeaders headers, Collection<ModelAndView> fragments) {
        this.status = status;
        this.headers = headers;
        this.modelAndViews = Collections.unmodifiableCollection(new ArrayList<ModelAndView>(fragments));
    }

    @Override
    @Nullable
    public HttpStatusCode status() {
        return this.status;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public boolean isRedirectView() {
        return false;
    }

    @Override
    public Collection<ModelAndView> fragments() {
        return this.modelAndViews;
    }

    @Override
    public void resolveNestedViews(ViewResolver resolver, Locale locale) throws Exception {
        for (ModelAndView mv : this.modelAndViews) {
            View view = DefaultFragmentsRendering.resolveView(resolver, locale, mv);
            mv.setView(view);
        }
    }

    private static View resolveView(ViewResolver viewResolver, Locale locale, ModelAndView mv) throws Exception {
        View view;
        String viewName = mv.getViewName();
        View view2 = view = viewName != null ? viewResolver.resolveViewName(viewName, locale) : mv.getView();
        if (view == null) {
            throw new ServletException("Could not resolve view in " + String.valueOf(mv));
        }
        return view;
    }

    @Override
    public void render(@Nullable Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.status != null) {
            response.setStatus(this.status.value());
        }
        if (!this.headers.isEmpty()) {
            this.headers.forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(name, values) -> values.forEach(value -> response.addHeader(name, value))));
        }
        if (model != null) {
            model.forEach((key, value) -> this.modelAndViews.forEach(mv -> mv.getModel().putIfAbsent((String)key, value)));
        }
        NonClosingHttpServletResponse nonClosingResponse = new NonClosingHttpServletResponse(response);
        for (ModelAndView mv : this.modelAndViews) {
            Assert.state(mv.getView() != null, "Expected View");
            mv.getView().render(mv.getModel(), request, (HttpServletResponse)nonClosingResponse);
            response.flushBuffer();
        }
    }

    public String toString() {
        return "DefaultFragmentsRendering " + String.valueOf(this.modelAndViews);
    }

    private static final class NonClosingHttpServletResponse
    extends HttpServletResponseWrapper {
        @Nullable
        private ServletOutputStream os;

        public NonClosingHttpServletResponse(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.os == null) {
                this.os = new NonClosingServletOutputStream(this.getResponse().getOutputStream());
            }
            return this.os;
        }
    }

    private static final class NonClosingServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream os;

        public NonClosingServletOutputStream(ServletOutputStream os) {
            this.os = os;
        }

        public void write(int b) throws IOException {
            this.os.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
        }

        public boolean isReady() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }

        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException();
        }
    }
}

