/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.util.Tuple;

public abstract class MergeUtils {
    public abstract MappingNode asMappingNode(Node var1);

    public List<NodeTuple> flatten(MappingNode node) {
        List<NodeTuple> toProcess;
        List<NodeTuple> result = toProcess = node.getValue();
        boolean process = true;
        while (process) {
            process = false;
            ArrayList<NodeTuple> updated = new ArrayList<NodeTuple>(toProcess.size());
            HashSet<String> keys = new HashSet<String>(toProcess.size());
            ArrayList<NodeTuple> merges = new ArrayList<NodeTuple>(2);
            for (NodeTuple tuple : toProcess) {
                Node keyNode = tuple.getKeyNode();
                if (keyNode.getTag().equals(Tag.MERGE)) {
                    merges.add(tuple);
                    continue;
                }
                updated.add(tuple);
                if (!(keyNode instanceof ScalarNode)) continue;
                ScalarNode sNode = (ScalarNode)keyNode;
                keys.add(sNode.getValue());
            }
            for (NodeTuple tuple : merges) {
                Node valueNode = tuple.getValueNode();
                if (valueNode instanceof SequenceNode) {
                    SequenceNode seqNode = (SequenceNode)valueNode;
                    for (Node ref : seqNode.getValue()) {
                        MappingNode mergable = this.asMappingNode(ref);
                        process = process || mergable.isMerged();
                        Tuple<List<NodeTuple>, Set<String>> filtered = this.filter(mergable.getValue(), keys);
                        updated.addAll((Collection<NodeTuple>)filtered._1());
                        keys.addAll((Collection<String>)filtered._2());
                    }
                    continue;
                }
                MappingNode mergable = this.asMappingNode(valueNode);
                process = process || mergable.isMerged();
                Tuple<List<NodeTuple>, Set<String>> filtered = this.filter(mergable.getValue(), keys);
                updated.addAll((Collection<NodeTuple>)filtered._1());
                keys.addAll((Collection<String>)filtered._2());
            }
            result = updated;
            if (!process) continue;
            toProcess = updated;
        }
        return result;
    }

    private Tuple<List<NodeTuple>, Set<String>> filter(List<NodeTuple> mergables, Set<String> filter2) {
        int size = mergables.size();
        HashSet<String> keys = new HashSet<String>(size);
        ArrayList<NodeTuple> result = new ArrayList<NodeTuple>(size);
        for (NodeTuple tuple : mergables) {
            Node key = tuple.getKeyNode();
            if (key instanceof ScalarNode) {
                ScalarNode sNode = (ScalarNode)key;
                String nodeValue = sNode.getValue();
                if (filter2.contains(nodeValue)) continue;
                result.add(tuple);
                keys.add(nodeValue);
                continue;
            }
            result.add(tuple);
        }
        return new Tuple<List<NodeTuple>, Set<String>>(result, keys);
    }
}

