/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.graph.Shard;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.structure.graph.Vertices;
import org.apache.hugegraph.util.E;

public class VerticesAPI
extends TraversersAPI {
    public VerticesAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "vertices";
    }

    public List<Vertex> list(List<Object> ids) {
        E.checkArgument(ids != null && !ids.isEmpty(), "Ids can't be null or empty", new Object[0]);
        ArrayList<String> stringIds = new ArrayList<String>(ids.size());
        for (Object id : ids) {
            stringIds.add(GraphAPI.formatVertexId(id, false));
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("ids", stringIds);
        RestResult result = this.client.get(this.path(), params);
        return result.readList(this.type(), Vertex.class);
    }

    public List<Shard> shards(long splitSize) {
        String path = String.join((CharSequence)"/", this.path(), "shards");
        ImmutableMap<String, Object> params = ImmutableMap.of("split_size", splitSize);
        RestResult result = this.client.get(path, params);
        return result.readList("shards", Shard.class);
    }

    public Vertices scan(Shard shard, String page, long pageLimit) {
        E.checkArgument(shard != null, "Shard can't be null", new Object[0]);
        String path = String.join((CharSequence)"/", this.path(), "scan");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("start", shard.start());
        params.put("end", shard.end());
        params.put("page", page);
        params.put("page_limit", pageLimit);
        RestResult result = this.client.get(path, params);
        return result.readObject(Vertices.class);
    }
}

