/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.dist;

import java.net.URL;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.backend.serializer.SerializerFactory;
import org.apache.hugegraph.backend.store.BackendProviderFactory;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.OptionHolder;
import org.apache.hugegraph.config.OptionSpace;
import org.apache.hugegraph.dist.DistOptions;
import org.apache.hugegraph.plugin.HugeGraphPlugin;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.VersionUtil;
import org.apache.hugegraph.version.CoreVersion;
import org.slf4j.Logger;

public class RegisterUtil {
    private static final Logger LOG = Log.logger(RegisterUtil.class);

    public static void registerBackends() {
        String confFile = "/backend.properties";
        URL input = RegisterUtil.class.getResource(confFile);
        E.checkState((input != null ? 1 : 0) != 0, (String)"Can't read file '%s' as stream", (Object[])new Object[]{confFile});
        PropertiesConfiguration props = null;
        try {
            props = new Configurations().properties(input);
        }
        catch (ConfigurationException e) {
            throw new HugeException("Can't load config file: %s", (Throwable)e, new Object[]{confFile});
        }
        HugeConfig config = new HugeConfig((Configuration)props);
        List backends = (List)config.get(DistOptions.BACKENDS);
        for (String backend : backends) {
            RegisterUtil.registerBackend(backend);
        }
    }

    private static void registerBackend(String backend) {
        switch (backend) {
            case "cassandra": {
                RegisterUtil.registerCassandra();
                break;
            }
            case "scylladb": {
                RegisterUtil.registerScyllaDB();
                break;
            }
            case "hbase": {
                RegisterUtil.registerHBase();
                break;
            }
            case "rocksdb": {
                RegisterUtil.registerRocksDB();
                break;
            }
            case "mysql": {
                RegisterUtil.registerMysql();
                break;
            }
            case "palo": {
                RegisterUtil.registerPalo();
                break;
            }
            case "postgresql": {
                RegisterUtil.registerPostgresql();
                break;
            }
            default: {
                throw new HugeException("Unsupported backend type '%s'", new Object[]{backend});
            }
        }
    }

    public static void registerCassandra() {
        OptionSpace.register((String)"cassandra", (String)"org.apache.hugegraph.backend.store.cassandra.CassandraOptions");
        SerializerFactory.register((String)"cassandra", (String)"org.apache.hugegraph.backend.store.cassandra.CassandraSerializer");
        BackendProviderFactory.register((String)"cassandra", (String)"org.apache.hugegraph.backend.store.cassandra.CassandraStoreProvider");
    }

    public static void registerScyllaDB() {
        OptionSpace.register((String)"scylladb", (String)"org.apache.hugegraph.backend.store.cassandra.CassandraOptions");
        SerializerFactory.register((String)"scylladb", (String)"org.apache.hugegraph.backend.store.cassandra.CassandraSerializer");
        BackendProviderFactory.register((String)"scylladb", (String)"org.apache.hugegraph.backend.store.scylladb.ScyllaDBStoreProvider");
    }

    public static void registerHBase() {
        OptionSpace.register((String)"hbase", (String)"org.apache.hugegraph.backend.store.hbase.HbaseOptions");
        SerializerFactory.register((String)"hbase", (String)"org.apache.hugegraph.backend.store.hbase.HbaseSerializer");
        BackendProviderFactory.register((String)"hbase", (String)"org.apache.hugegraph.backend.store.hbase.HbaseStoreProvider");
    }

    public static void registerRocksDB() {
        OptionSpace.register((String)"rocksdb", (String)"org.apache.hugegraph.backend.store.rocksdb.RocksDBOptions");
        BackendProviderFactory.register((String)"rocksdb", (String)"org.apache.hugegraph.backend.store.rocksdb.RocksDBStoreProvider");
        BackendProviderFactory.register((String)"rocksdbsst", (String)"org.apache.hugegraph.backend.store.rocksdbsst.RocksDBSstStoreProvider");
    }

    public static void registerMysql() {
        OptionSpace.register((String)"mysql", (String)"org.apache.hugegraph.backend.store.mysql.MysqlOptions");
        SerializerFactory.register((String)"mysql", (String)"org.apache.hugegraph.backend.store.mysql.MysqlSerializer");
        BackendProviderFactory.register((String)"mysql", (String)"org.apache.hugegraph.backend.store.mysql.MysqlStoreProvider");
    }

    public static void registerPalo() {
        OptionSpace.register((String)"palo", (String)"org.apache.hugegraph.backend.store.palo.PaloOptions");
        SerializerFactory.register((String)"palo", (String)"org.apache.hugegraph.backend.store.palo.PaloSerializer");
        BackendProviderFactory.register((String)"palo", (String)"org.apache.hugegraph.backend.store.palo.PaloStoreProvider");
    }

    public static void registerPostgresql() {
        OptionSpace.register((String)"postgresql", (String)"org.apache.hugegraph.backend.store.postgresql.PostgresqlOptions");
        SerializerFactory.register((String)"postgresql", (String)"org.apache.hugegraph.backend.store.postgresql.PostgresqlSerializer");
        BackendProviderFactory.register((String)"postgresql", (String)"org.apache.hugegraph.backend.store.postgresql.PostgresqlStoreProvider");
    }

    public static void registerServer() {
        OptionSpace.register((String)"server", (String)"org.apache.hugegraph.config.ServerOptions");
        OptionSpace.register((String)"rpc", (String)"org.apache.hugegraph.config.RpcOptions");
        OptionSpace.register((String)"auth", (String)"org.apache.hugegraph.config.AuthOptions");
    }

    public static void registerPlugins() {
        ServiceLoader<HugeGraphPlugin> plugins = ServiceLoader.load(HugeGraphPlugin.class);
        for (HugeGraphPlugin plugin : plugins) {
            LOG.info("Loading plugin {}({})", (Object)plugin.name(), (Object)plugin.getClass().getCanonicalName());
            String minVersion = plugin.supportsMinVersion();
            String maxVersion = plugin.supportsMaxVersion();
            if (!VersionUtil.match((VersionUtil.Version)CoreVersion.VERSION, (String)minVersion, (String)maxVersion)) {
                LOG.warn("Skip loading plugin '{}' due to the version range '[{}, {})' that it's supported doesn't cover current core version '{}'", new Object[]{plugin.name(), minVersion, maxVersion, CoreVersion.VERSION.get()});
                continue;
            }
            try {
                plugin.register();
                LOG.info("Loaded plugin '{}'", (Object)plugin.name());
            }
            catch (Exception e) {
                throw new HugeException("Failed to load plugin '%s'", new Object[]{plugin.name(), e});
            }
        }
    }

    static {
        OptionSpace.register((String)"core", (OptionHolder)CoreOptions.instance());
        OptionSpace.register((String)"dist", (OptionHolder)DistOptions.instance());
    }
}

