/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.gremlin;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.rest.AbstractRestClient;
import org.apache.hugegraph.testutil.Whitebox;
import org.apache.hugegraph.util.E;

public class GremlinClient
extends AbstractRestClient {
    private final WebTarget webTarget = (WebTarget)Whitebox.getInternalState((Object)((Object)this), (String)"target");

    public GremlinClient(String url, int timeout, int maxTotal, int maxPerRoute) {
        super(url, timeout, maxTotal, maxPerRoute);
        E.checkNotNull((Object)this.webTarget, (String)"target");
    }

    protected void checkStatus(Response response, Response.Status ... statuses) {
    }

    public Response doPostRequest(String auth, String req) {
        Entity body = Entity.entity((Object)req, (String)"application/json");
        return this.webTarget.request().header("Authorization", (Object)auth).accept(new String[]{"application/json"}).acceptEncoding(new String[]{"gzip"}).post(body);
    }

    public Response doGetRequest(String auth, MultivaluedMap<String, String> params) {
        WebTarget target = this.webTarget;
        for (Map.Entry entry : params.entrySet()) {
            E.checkArgument((((List)entry.getValue()).size() == 1 ? 1 : 0) != 0, (String)"Invalid query param '%s', can only accept one value, but got %s", (Object[])new Object[]{entry.getKey(), entry.getValue()});
            target = target.queryParam((String)entry.getKey(), new Object[]{((List)entry.getValue()).get(0)});
        }
        return target.request().header("Authorization", (Object)auth).accept(new String[]{"application/json"}).acceptEncoding(new String[]{"gzip"}).get();
    }
}

